/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.provider.db.log.entity;

import org.apache.sentry.provider.db.log.entity.AuditMetadataLogEntity;
import org.apache.sentry.provider.db.log.entity.DBAuditMetadataLogEntity;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.node.ContainerNode;
import org.junit.Assert;
import org.junit.Test;

public class TestDbAuditMetadataLogEntity {
    @Test
    public void testToJsonFormatLog() throws Throwable {
        DBAuditMetadataLogEntity amle = new DBAuditMetadataLogEntity("serviceName", "userName", "impersonator", "ipAddress", "operation", "eventTime", "operationText", "allowed", "objectType", "component", "databaseName", "tableName", "columnName", "resourcePath");
        String jsonAuditLog = amle.toJsonFormatLog();
        ContainerNode rootNode = AuditMetadataLogEntity.parse((String)jsonAuditLog);
        this.assertEntryEquals(rootNode, "serviceName", "serviceName");
        this.assertEntryEquals(rootNode, "userName", "userName");
        this.assertEntryEquals(rootNode, "impersonator", "impersonator");
        this.assertEntryEquals(rootNode, "ipAddress", "ipAddress");
        this.assertEntryEquals(rootNode, "operation", "operation");
        this.assertEntryEquals(rootNode, "eventTime", "eventTime");
        this.assertEntryEquals(rootNode, "operationText", "operationText");
        this.assertEntryEquals(rootNode, "allowed", "allowed");
        this.assertEntryEquals(rootNode, "databaseName", "databaseName");
        this.assertEntryEquals(rootNode, "tableName", "tableName");
        this.assertEntryEquals(rootNode, "column", "columnName");
        this.assertEntryEquals(rootNode, "resourcePath", "resourcePath");
        this.assertEntryEquals(rootNode, "objectType", "objectType");
    }

    void assertEntryEquals(ContainerNode rootNode, String key, String value) {
        JsonNode node = this.assertNodeContains(rootNode, key);
        Assert.assertEquals((Object)value, (Object)node.getTextValue());
    }

    private JsonNode assertNodeContains(ContainerNode rootNode, String key) {
        JsonNode node = rootNode.get(key);
        if (node == null) {
            Assert.fail((String)("No entry of name \"" + key + "\" found in " + rootNode.toString()));
        }
        return node;
    }
}

