/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.provider.db.log.appender;

import com.google.common.io.Files;
import java.io.File;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.sentry.provider.db.log.appender.RollingFileWithoutDeleteAppender;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestRollingFileWithoutDeleteAppender {
    private Logger sentryLogger = Logger.getRootLogger();
    private File dataDir;

    @Before
    public void init() {
        this.dataDir = Files.createTempDir();
    }

    @Test
    public void testRollOver() throws Throwable {
        if (this.dataDir == null) {
            Assert.fail((String)"Excepted temp folder for audit log is created.");
        }
        RollingFileWithoutDeleteAppender appender = new RollingFileWithoutDeleteAppender((Layout)new PatternLayout("%m%n"), this.dataDir.getPath() + "/auditLog.log");
        appender.setMaximumFileSize(100L);
        this.sentryLogger.addAppender((Appender)appender);
        for (int i = 0; i < 99; ++i) {
            if (i < 10) {
                this.sentryLogger.debug((Object)("Hello---" + i));
                continue;
            }
            if (i >= 100) continue;
            this.sentryLogger.debug((Object)("Hello--" + i));
        }
        if (this.dataDir != null) {
            File[] files = this.dataDir.listFiles();
            if (files != null) {
                Assert.assertEquals((long)files.length, (long)10L);
            } else {
                Assert.fail((String)"Excepted 10 log files.");
            }
        } else {
            Assert.fail((String)"Excepted 10 log files.");
        }
    }

    @Test
    public void testFileNamePattern() throws Throwable {
        if (this.dataDir == null) {
            Assert.fail((String)"Excepted temp folder for audit log is created.");
        }
        RollingFileWithoutDeleteAppender appender = new RollingFileWithoutDeleteAppender((Layout)new PatternLayout("%m%n"), this.dataDir.getPath() + "/auditLog.log");
        appender.setMaximumFileSize(10L);
        this.sentryLogger.addAppender((Appender)appender);
        this.sentryLogger.debug((Object)"123456789012345");
        File[] files = this.dataDir.listFiles();
        if (files != null) {
            Assert.assertEquals((long)files.length, (long)2L);
            Assert.assertTrue((boolean)files[0].getName().contains("auditLog.log."));
            Assert.assertTrue((boolean)files[1].getName().contains("auditLog.log."));
        } else {
            Assert.fail((String)"Excepted 2 log files.");
        }
    }

    @After
    public void destroy() {
        if (this.dataDir != null) {
            FileUtils.deleteQuietly((File)this.dataDir);
        }
    }
}

