/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.provider.db.generic.tools;

import com.google.common.collect.Sets;
import com.google.common.io.Files;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.sentry.core.common.exception.SentryUserException;
import org.apache.sentry.provider.db.generic.service.thrift.SentryGenericServiceIntegrationBase;
import org.apache.sentry.provider.db.generic.tools.SentryShellGeneric;
import org.apache.sentry.service.thrift.SentryServiceIntegrationBase;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestSentryShellSqoop
extends SentryGenericServiceIntegrationBase {
    private File confDir;
    private File confPath;
    private static String TEST_ROLE_NAME_1 = "testRole1";
    private static String TEST_ROLE_NAME_2 = "testRole2";
    private String requestorName = "";
    private String service = "sqoopServer1";

    @Before
    public void prepareForTest() throws Exception {
        this.confDir = Files.createTempDir();
        this.confPath = new File(this.confDir, "sentry-site.xml");
        if (this.confPath.createNewFile()) {
            FileOutputStream to = new FileOutputStream(this.confPath);
            conf.writeXml((OutputStream)to);
            to.close();
        }
        this.requestorName = clientUgi.getShortUserName();
        HashSet requestorUserGroupNames = Sets.newHashSet((Object[])new String[]{"admin_group"});
        this.setLocalGroupMapping(this.requestorName, requestorUserGroupNames);
        this.setLocalGroupMapping("admin_user", requestorUserGroupNames);
        this.writePolicyFile();
    }

    @After
    public void clearTestData() throws Exception {
        FileUtils.deleteQuietly((File)this.confDir);
    }

    @Test
    public void testCreateDropRole() throws Exception {
        this.runTestAsSubject(new SentryServiceIntegrationBase.TestOperation(){

            @Override
            public void runTestAsSubject() throws Exception {
                String[] args = new String[]{"-cr", "-r", TEST_ROLE_NAME_1, "-conf", TestSentryShellSqoop.this.confPath.getAbsolutePath(), "-t", "sqoop"};
                SentryShellGeneric.main((String[])args);
                args = new String[]{"--create_role", "-r", TEST_ROLE_NAME_2, "-conf", TestSentryShellSqoop.this.confPath.getAbsolutePath(), "-t", "sqoop"};
                SentryShellGeneric.main((String[])args);
                args = new String[]{"-lr", "-conf", TestSentryShellSqoop.this.confPath.getAbsolutePath(), "-t", "sqoop"};
                SentryShellGeneric sentryShell = new SentryShellGeneric();
                Set roleNames = TestSentryShellSqoop.this.getShellResultWithOSRedirect(sentryShell, args, true);
                TestSentryShellSqoop.this.validateRoleNames(roleNames, new String[]{TEST_ROLE_NAME_1, TEST_ROLE_NAME_2});
                args = new String[]{"--list_role", "-conf", TestSentryShellSqoop.this.confPath.getAbsolutePath(), "-t", "sqoop"};
                sentryShell = new SentryShellGeneric();
                roleNames = TestSentryShellSqoop.this.getShellResultWithOSRedirect(sentryShell, args, true);
                TestSentryShellSqoop.this.validateRoleNames(roleNames, new String[]{TEST_ROLE_NAME_1, TEST_ROLE_NAME_2});
                args = new String[]{"-dr", "-r", TEST_ROLE_NAME_1, "-conf", TestSentryShellSqoop.this.confPath.getAbsolutePath(), "-t", "sqoop"};
                SentryShellGeneric.main((String[])args);
                args = new String[]{"--drop_role", "-r", TEST_ROLE_NAME_2, "-conf", TestSentryShellSqoop.this.confPath.getAbsolutePath(), "-t", "sqoop"};
                SentryShellGeneric.main((String[])args);
                Set roles = TestSentryShellSqoop.this.client.listAllRoles(TestSentryShellSqoop.this.requestorName, "sqoop");
                Assert.assertEquals((String)"Incorrect number of roles", (long)0L, (long)roles.size());
            }
        });
    }

    @Test
    public void testAddDeleteRoleForGroup() throws Exception {
        this.runTestAsSubject(new SentryServiceIntegrationBase.TestOperation(){

            @Override
            public void runTestAsSubject() throws Exception {
                String TEST_GROUP_1 = "testGroup1";
                String TEST_GROUP_2 = "testGroup2";
                String TEST_GROUP_3 = "testGroup3";
                TestSentryShellSqoop.this.client.createRole(TestSentryShellSqoop.this.requestorName, TEST_ROLE_NAME_1, "sqoop");
                TestSentryShellSqoop.this.client.createRole(TestSentryShellSqoop.this.requestorName, TEST_ROLE_NAME_2, "sqoop");
                String[] args = new String[]{"-arg", "-r", TEST_ROLE_NAME_1, "-g", TEST_GROUP_1, "-conf", TestSentryShellSqoop.this.confPath.getAbsolutePath(), "-t", "sqoop"};
                SentryShellGeneric.main((String[])args);
                args = new String[]{"-arg", "-r", TEST_ROLE_NAME_1, "-g", TEST_GROUP_2 + "," + TEST_GROUP_3, "-conf", TestSentryShellSqoop.this.confPath.getAbsolutePath(), "-t", "sqoop"};
                SentryShellGeneric.main((String[])args);
                args = new String[]{"--add_role_group", "-r", TEST_ROLE_NAME_2, "-g", TEST_GROUP_1, "-conf", TestSentryShellSqoop.this.confPath.getAbsolutePath(), "-t", "sqoop"};
                SentryShellGeneric.main((String[])args);
                args = new String[]{"-lr", "-g", TEST_GROUP_1, "-conf", TestSentryShellSqoop.this.confPath.getAbsolutePath(), "-t", "sqoop"};
                SentryShellGeneric sentryShell = new SentryShellGeneric();
                Set roleNames = TestSentryShellSqoop.this.getShellResultWithOSRedirect(sentryShell, args, true);
                TestSentryShellSqoop.this.validateRoleNames(roleNames, new String[]{TEST_ROLE_NAME_1, TEST_ROLE_NAME_2});
                args = new String[]{"--list_role", "-g", TEST_GROUP_2, "-conf", TestSentryShellSqoop.this.confPath.getAbsolutePath(), "-t", "sqoop"};
                sentryShell = new SentryShellGeneric();
                roleNames = TestSentryShellSqoop.this.getShellResultWithOSRedirect(sentryShell, args, true);
                TestSentryShellSqoop.this.validateRoleNames(roleNames, new String[]{TEST_ROLE_NAME_1});
                args = new String[]{"--list_role", "-g", TEST_GROUP_3, "-conf", TestSentryShellSqoop.this.confPath.getAbsolutePath(), "-t", "sqoop"};
                sentryShell = new SentryShellGeneric();
                roleNames = TestSentryShellSqoop.this.getShellResultWithOSRedirect(sentryShell, args, true);
                TestSentryShellSqoop.this.validateRoleNames(roleNames, new String[]{TEST_ROLE_NAME_1});
                args = new String[]{"--list_group", "-conf", TestSentryShellSqoop.this.confPath.getAbsolutePath(), "-t", "sqoop"};
                sentryShell = new SentryShellGeneric();
                Set groups = TestSentryShellSqoop.this.getShellResultWithOSRedirect(sentryShell, args, true);
                Assert.assertEquals((long)3L, (long)groups.size());
                Assert.assertTrue((boolean)groups.contains("testGroup3 = testrole1"));
                Assert.assertTrue((boolean)groups.contains("testGroup2 = testrole1"));
                Assert.assertTrue((boolean)groups.contains("testGroup1 = testrole2, testrole1"));
                args = new String[]{"-drg", "-r", TEST_ROLE_NAME_1, "-g", TEST_GROUP_1, "-conf", TestSentryShellSqoop.this.confPath.getAbsolutePath(), "-t", "sqoop"};
                SentryShellGeneric.main((String[])args);
                args = new String[]{"-drg", "-r", TEST_ROLE_NAME_1, "-g", TEST_GROUP_2 + "," + TEST_GROUP_3, "-conf", TestSentryShellSqoop.this.confPath.getAbsolutePath(), "-t", "sqoop"};
                SentryShellGeneric.main((String[])args);
                args = new String[]{"--delete_role_group", "-r", TEST_ROLE_NAME_2, "-g", TEST_GROUP_1, "-conf", TestSentryShellSqoop.this.confPath.getAbsolutePath(), "-t", "sqoop"};
                SentryShellGeneric.main((String[])args);
                Set roles = TestSentryShellSqoop.this.client.listRolesByGroupName(TestSentryShellSqoop.this.requestorName, TEST_GROUP_1, "sqoop");
                Assert.assertEquals((String)"Incorrect number of roles", (long)0L, (long)roles.size());
                roles = TestSentryShellSqoop.this.client.listRolesByGroupName(TestSentryShellSqoop.this.requestorName, TEST_GROUP_2, "sqoop");
                Assert.assertEquals((String)"Incorrect number of roles", (long)0L, (long)roles.size());
                roles = TestSentryShellSqoop.this.client.listRolesByGroupName(TestSentryShellSqoop.this.requestorName, TEST_GROUP_3, "sqoop");
                Assert.assertEquals((String)"Incorrect number of roles", (long)0L, (long)roles.size());
                TestSentryShellSqoop.this.client.dropRole(TestSentryShellSqoop.this.requestorName, TEST_ROLE_NAME_1, "sqoop");
                TestSentryShellSqoop.this.client.dropRole(TestSentryShellSqoop.this.requestorName, TEST_ROLE_NAME_2, "sqoop");
            }
        });
    }

    @Test
    public void testCaseSensitiveGroupName() throws Exception {
        this.runTestAsSubject(new SentryServiceIntegrationBase.TestOperation(){

            @Override
            public void runTestAsSubject() throws Exception {
                TestSentryShellSqoop.this.client.createRole(TestSentryShellSqoop.this.requestorName, TEST_ROLE_NAME_1, "sqoop");
                String[] args = new String[]{"-arg", "-r", TEST_ROLE_NAME_1, "-g", "group1", "-conf", TestSentryShellSqoop.this.confPath.getAbsolutePath(), "-t", "sqoop"};
                SentryShellGeneric.main((String[])args);
                args = new String[]{"-lr", "-g", "group1", "-conf", TestSentryShellSqoop.this.confPath.getAbsolutePath(), "-t", "sqoop"};
                SentryShellGeneric sentryShell = new SentryShellGeneric();
                Set roleNames = TestSentryShellSqoop.this.getShellResultWithOSRedirect(sentryShell, args, true);
                TestSentryShellSqoop.this.validateRoleNames(roleNames, new String[]{TEST_ROLE_NAME_1});
                args = new String[]{"-lr", "-g", "GROUP1", "-conf", TestSentryShellSqoop.this.confPath.getAbsolutePath(), "-t", "sqoop"};
                roleNames = TestSentryShellSqoop.this.getShellResultWithOSRedirect(sentryShell, args, true);
                TestSentryShellSqoop.this.validateRoleNames(roleNames, new String[0]);
            }
        });
    }

    public static String grant(boolean shortOption) {
        return shortOption ? "-gpr" : "--grant_privilege_role";
    }

    public static String revoke(boolean shortOption) {
        return shortOption ? "-rpr" : "--revoke_privilege_role";
    }

    public static String list(boolean shortOption) {
        return shortOption ? "-lp" : "--list_privilege";
    }

    private void assertGrantRevokePrivilege(final boolean shortOption) throws Exception {
        this.runTestAsSubject(new SentryServiceIntegrationBase.TestOperation(){

            @Override
            public void runTestAsSubject() throws Exception {
                int i;
                TestSentryShellSqoop.this.client.createRole(TestSentryShellSqoop.this.requestorName, TEST_ROLE_NAME_1, "sqoop");
                TestSentryShellSqoop.this.client.createRole(TestSentryShellSqoop.this.requestorName, TEST_ROLE_NAME_2, "sqoop");
                String[] privs = new String[]{"SERVER=sqoopserver1->CONNECTOR=c1->action=read", "SERVER=sqoopserver1->JOB=j1->action=write", "SERVER=sqoopserver1->LINK=l1->action=read"};
                for (int i2 = 0; i2 < privs.length; ++i2) {
                    String[] args = new String[]{TestSentryShellSqoop.grant(shortOption), "-r", TEST_ROLE_NAME_1, "-p", privs[i2], "-conf", TestSentryShellSqoop.this.confPath.getAbsolutePath(), "-t", "sqoop"};
                    SentryShellGeneric.main((String[])args);
                }
                String[] args = new String[]{TestSentryShellSqoop.list(shortOption), "-r", TEST_ROLE_NAME_1, "-conf", TestSentryShellSqoop.this.confPath.getAbsolutePath(), "-t", "sqoop"};
                SentryShellGeneric sentryShell = new SentryShellGeneric();
                Set privilegeStrs = TestSentryShellSqoop.this.getShellResultWithOSRedirect(sentryShell, args, true);
                Assert.assertEquals((String)"Incorrect number of privileges", (long)privs.length, (long)privilegeStrs.size());
                for (i = 0; i < privs.length; ++i) {
                    Assert.assertTrue((String)("Expected privilege: " + privs[i] + " in " + Arrays.toString(privilegeStrs.toArray())), (boolean)privilegeStrs.contains(privs[i]));
                }
                for (i = 0; i < privs.length; ++i) {
                    args = new String[]{TestSentryShellSqoop.revoke(shortOption), "-r", TEST_ROLE_NAME_1, "-p", privs[i], "-conf", TestSentryShellSqoop.this.confPath.getAbsolutePath(), "-t", "sqoop"};
                    SentryShellGeneric.main((String[])args);
                    Set privileges = TestSentryShellSqoop.this.client.listAllPrivilegesByRoleName(TestSentryShellSqoop.this.requestorName, TEST_ROLE_NAME_1, "sqoop", TestSentryShellSqoop.this.service);
                    Assert.assertEquals((String)("Incorrect number of privileges. Received privileges: " + Arrays.toString(privileges.toArray())), (long)(privs.length - (i + 1)), (long)privileges.size());
                }
                TestSentryShellSqoop.this.client.dropRole(TestSentryShellSqoop.this.requestorName, TEST_ROLE_NAME_1, "sqoop");
                TestSentryShellSqoop.this.client.dropRole(TestSentryShellSqoop.this.requestorName, TEST_ROLE_NAME_2, "sqoop");
            }
        });
    }

    @Test
    public void testGrantRevokePrivilegeWithShortOption() throws Exception {
        this.assertGrantRevokePrivilege(true);
    }

    @Test
    public void testGrantRevokePrivilegeWithLongOption() throws Exception {
        this.assertGrantRevokePrivilege(false);
    }

    @Test
    public void testNegativeCaseWithInvalidArgument() throws Exception {
        this.runTestAsSubject(new SentryServiceIntegrationBase.TestOperation(){

            @Override
            public void runTestAsSubject() throws Exception {
                TestSentryShellSqoop.this.client.createRole(TestSentryShellSqoop.this.requestorName, TEST_ROLE_NAME_1, "sqoop");
                String[] args = new String[]{"-cr", "-r", TEST_ROLE_NAME_1, "-conf", TestSentryShellSqoop.this.confPath.getAbsolutePath(), "-t", "sqoop"};
                SentryShellGeneric sentryShell = new SentryShellGeneric();
                try {
                    sentryShell.executeShell(args);
                    Assert.fail((String)"Exception should be thrown for creating duplicate role");
                }
                catch (SentryUserException sentryUserException) {
                }
                catch (Exception e) {
                    Assert.fail((String)("Unexpected exception received. " + e));
                }
                args = new String[]{"-dr", "-r", TEST_ROLE_NAME_2, "-conf", TestSentryShellSqoop.this.confPath.getAbsolutePath(), "-t", "sqoop"};
                sentryShell = new SentryShellGeneric();
                try {
                    sentryShell.executeShell(args);
                    Assert.fail((String)"Exception should be thrown for dropping non-exist role");
                }
                catch (SentryUserException e) {
                }
                catch (Exception e) {
                    Assert.fail((String)("Unexpected exception received. " + e));
                }
                args = new String[]{"-arg", "-r", TEST_ROLE_NAME_2, "-g", "testGroup1", "-conf", TestSentryShellSqoop.this.confPath.getAbsolutePath(), "-t", "sqoop"};
                sentryShell = new SentryShellGeneric();
                try {
                    sentryShell.executeShell(args);
                    Assert.fail((String)"Exception should be thrown for granting non-exist role to group");
                }
                catch (SentryUserException e) {
                }
                catch (Exception e) {
                    Assert.fail((String)("Unexpected exception received. " + e));
                }
                args = new String[]{"-drg", "-r", TEST_ROLE_NAME_2, "-g", "testGroup1", "-conf", TestSentryShellSqoop.this.confPath.getAbsolutePath(), "-t", "sqoop"};
                sentryShell = new SentryShellGeneric();
                try {
                    sentryShell.executeShell(args);
                    Assert.fail((String)"Exception should be thrown for drop group from non-exist role");
                }
                catch (SentryUserException e) {
                }
                catch (Exception e) {
                    Assert.fail((String)("Unexpected exception received. " + e));
                }
                args = new String[]{"-gpr", "-r", TEST_ROLE_NAME_1, "-p", "serverserver1->action=all", "-conf", TestSentryShellSqoop.this.confPath.getAbsolutePath(), "-t", "sqoop"};
                sentryShell = new SentryShellGeneric();
                try {
                    sentryShell.executeShell(args);
                    Assert.fail((String)"Exception should be thrown for the error privilege format, invalid key value.");
                }
                catch (IllegalArgumentException e) {
                }
                catch (Exception e) {
                    Assert.fail((String)("Unexpected exception received. " + e));
                }
                TestSentryShellSqoop.this.client.dropRole(TestSentryShellSqoop.this.requestorName, TEST_ROLE_NAME_1, "sqoop");
            }
        });
    }

    @Test
    public void testNegativeCaseWithoutRequiredArgument() throws Exception {
        this.runTestAsSubject(new SentryServiceIntegrationBase.TestOperation(){

            @Override
            public void runTestAsSubject() throws Exception {
                String strOptionConf = "conf";
                TestSentryShellSqoop.this.client.createRole(TestSentryShellSqoop.this.requestorName, TEST_ROLE_NAME_1, "sqoop");
                String[] args = new String[]{"-cr", "-r", TEST_ROLE_NAME_1, "-t", "sqoop"};
                SentryShellGeneric sentryShell = new SentryShellGeneric();
                TestSentryShellSqoop.this.validateMissingParameterMsg(sentryShell, args, "Missing required option: " + strOptionConf);
                args = new String[]{"-cr", "-conf", TestSentryShellSqoop.this.confPath.getAbsolutePath(), "-t", "sqoop"};
                sentryShell = new SentryShellGeneric();
                TestSentryShellSqoop.this.validateMissingParameterMsg(sentryShell, args, "Missing required option: Role name");
                args = new String[]{"-dr", "-conf", TestSentryShellSqoop.this.confPath.getAbsolutePath(), "-t", "sqoop"};
                sentryShell = new SentryShellGeneric();
                TestSentryShellSqoop.this.validateMissingParameterMsg(sentryShell, args, "Missing required option: Role name");
                args = new String[]{"-arg", "-g", "testGroup1", "-conf", TestSentryShellSqoop.this.confPath.getAbsolutePath(), "-t", "sqoop"};
                sentryShell = new SentryShellGeneric();
                TestSentryShellSqoop.this.validateMissingParameterMsg(sentryShell, args, "Missing required option: Role name");
                args = new String[]{"-arg", "-r", TEST_ROLE_NAME_2, "-conf", TestSentryShellSqoop.this.confPath.getAbsolutePath(), "-t", "sqoop"};
                sentryShell = new SentryShellGeneric();
                TestSentryShellSqoop.this.validateMissingParameterMsg(sentryShell, args, "Missing required option: Group name");
                args = new String[]{"-drg", "-g", "testGroup1", "-conf", TestSentryShellSqoop.this.confPath.getAbsolutePath(), "-t", "sqoop"};
                sentryShell = new SentryShellGeneric();
                TestSentryShellSqoop.this.validateMissingParameterMsg(sentryShell, args, "Missing required option: Role name");
                args = new String[]{"-drg", "-r", TEST_ROLE_NAME_2, "-conf", TestSentryShellSqoop.this.confPath.getAbsolutePath(), "-t", "sqoop"};
                sentryShell = new SentryShellGeneric();
                TestSentryShellSqoop.this.validateMissingParameterMsg(sentryShell, args, "Missing required option: Group name");
                args = new String[]{"-gpr", "-p", "server=server1", "-conf", TestSentryShellSqoop.this.confPath.getAbsolutePath(), "-t", "sqoop"};
                sentryShell = new SentryShellGeneric();
                TestSentryShellSqoop.this.validateMissingParameterMsg(sentryShell, args, "Missing required option: Role name");
                args = new String[]{"-gpr", "-r", TEST_ROLE_NAME_1, "-conf", TestSentryShellSqoop.this.confPath.getAbsolutePath(), "-t", "sqoop"};
                sentryShell = new SentryShellGeneric();
                TestSentryShellSqoop.this.validateMissingParameterMsg(sentryShell, args, "Missing required option: Privilege string");
                args = new String[]{"-gpr", "-r", TEST_ROLE_NAME_1, "-conf", TestSentryShellSqoop.this.confPath.getAbsolutePath(), "-p", "Server=sqoopServer1->Connector", "-t", "sqoop"};
                sentryShell = new SentryShellGeneric();
                try {
                    TestSentryShellSqoop.this.getShellResultWithOSRedirect(sentryShell, args, false);
                    Assert.fail((String)"Expected IllegalArgumentException");
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
                catch (Exception e) {
                    Assert.fail((String)("Unexpected exception received. " + e));
                }
                args = new String[]{"-rpr", "-p", "Server=sqoopServer1->Connector->action=*", "-conf", TestSentryShellSqoop.this.confPath.getAbsolutePath(), "-t", "sqoop"};
                sentryShell = new SentryShellGeneric();
                TestSentryShellSqoop.this.validateMissingParameterMsg(sentryShell, args, "Missing required option: Role name");
                args = new String[]{"-rpr", "-r", TEST_ROLE_NAME_1, "-conf", TestSentryShellSqoop.this.confPath.getAbsolutePath(), "-t", "sqoop"};
                sentryShell = new SentryShellGeneric();
                TestSentryShellSqoop.this.validateMissingParameterMsg(sentryShell, args, "Missing required option: Privilege string");
                args = new String[]{"-conf", TestSentryShellSqoop.this.confPath.getAbsolutePath(), "-t", "sqoop"};
                sentryShell = new SentryShellGeneric();
                TestSentryShellSqoop.this.validateMissingParameterMsgsContains(sentryShell, args, new String[]{"Missing required option: [", "-arg Add role to group", "-cr Create role", "-rpr Revoke privilege from role", "-drg Delete role from group", "-lr List role", "-lp List privilege", "-gpr Grant privilege to role", "-dr Drop role"});
                TestSentryShellSqoop.this.client.dropRole(TestSentryShellSqoop.this.requestorName, TEST_ROLE_NAME_1, "sqoop");
            }
        });
    }

    private Set<String> getShellResultWithOSRedirect(SentryShellGeneric sentryShell, String[] args, boolean expectedExecuteResult) throws Exception {
        PrintStream oldOut = System.out;
        ByteArrayOutputStream outContent = new ByteArrayOutputStream();
        System.setOut(new PrintStream(outContent));
        Assert.assertEquals((Object)expectedExecuteResult, (Object)sentryShell.executeShell(args));
        HashSet resultSet = Sets.newHashSet((Object[])outContent.toString().split("\n"));
        System.setOut(oldOut);
        return resultSet;
    }

    private void validateRoleNames(Set<String> roleNames, String ... expectedRoleNames) {
        if (expectedRoleNames != null && expectedRoleNames.length > 0) {
            Assert.assertEquals((String)("Found: " + roleNames.size() + " roles, expected: " + expectedRoleNames.length), (long)expectedRoleNames.length, (long)roleNames.size());
            HashSet<String> lowerCaseRoles = new HashSet<String>();
            for (String role : roleNames) {
                lowerCaseRoles.add(role.toLowerCase());
            }
            for (String expectedRole : expectedRoleNames) {
                Assert.assertTrue((String)("Expected role: " + expectedRole), (boolean)lowerCaseRoles.contains(expectedRole.toLowerCase()));
            }
        }
    }

    private void validateMissingParameterMsg(SentryShellGeneric sentryShell, String[] args, String expectedErrorMsg) throws Exception {
        Set<String> errorMsgs = this.getShellResultWithOSRedirect(sentryShell, args, false);
        Assert.assertTrue((String)("Expected error message: " + expectedErrorMsg), (boolean)errorMsgs.contains(expectedErrorMsg));
    }

    private void validateMissingParameterMsgsContains(SentryShellGeneric sentryShell, String[] args, String ... expectedErrorMsgsContains) throws Exception {
        Set<String> errorMsgs = this.getShellResultWithOSRedirect(sentryShell, args, false);
        boolean foundAllMessages = false;
        for (String errorMessage : errorMsgs) {
            boolean missingExpected = false;
            for (String expectedContains : expectedErrorMsgsContains) {
                if (errorMessage.contains(expectedContains)) continue;
                missingExpected = true;
                break;
            }
            if (missingExpected) continue;
            foundAllMessages = true;
            break;
        }
        Assert.assertTrue((boolean)foundAllMessages);
    }
}

