/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.provider.db.generic.tools;

import com.google.common.collect.Sets;
import com.google.common.io.Files;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.sentry.core.common.exception.SentryUserException;
import org.apache.sentry.provider.db.generic.service.thrift.SentryGenericServiceIntegrationBase;
import org.apache.sentry.provider.db.generic.tools.SentryShellGeneric;
import org.apache.sentry.service.thrift.SentryServiceIntegrationBase;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestSentryShellSolr
extends SentryGenericServiceIntegrationBase {
    private File confDir;
    private File confPath;
    private static String TEST_ROLE_NAME_1 = "testRole1";
    private static String TEST_ROLE_NAME_2 = "testRole2";
    private String requestorName = "";
    private String service = "service1";

    @Before
    public void prepareForTest() throws Exception {
        this.confDir = Files.createTempDir();
        this.confPath = new File(this.confDir, "sentry-site.xml");
        if (this.confPath.createNewFile()) {
            FileOutputStream to = new FileOutputStream(this.confPath);
            conf.writeXml((OutputStream)to);
            to.close();
        }
        this.requestorName = clientUgi.getShortUserName();
        HashSet requestorUserGroupNames = Sets.newHashSet((Object[])new String[]{"admin_group"});
        this.setLocalGroupMapping(this.requestorName, requestorUserGroupNames);
        this.setLocalGroupMapping("admin_user", requestorUserGroupNames);
        this.writePolicyFile();
    }

    @After
    public void clearTestData() throws Exception {
        FileUtils.deleteQuietly((File)this.confDir);
    }

    @Test
    public void testCreateDropRole() throws Exception {
        this.runTestAsSubject(new SentryServiceIntegrationBase.TestOperation(){

            @Override
            public void runTestAsSubject() throws Exception {
                String[] args = new String[]{"-cr", "-r", TEST_ROLE_NAME_1, "-conf", TestSentryShellSolr.this.confPath.getAbsolutePath(), "-t", "solr"};
                SentryShellGeneric.main((String[])args);
                args = new String[]{"--create_role", "-r", TEST_ROLE_NAME_2, "-conf", TestSentryShellSolr.this.confPath.getAbsolutePath(), "-t", "solr"};
                SentryShellGeneric.main((String[])args);
                args = new String[]{"-lr", "-conf", TestSentryShellSolr.this.confPath.getAbsolutePath(), "-t", "solr"};
                SentryShellGeneric sentryShell = new SentryShellGeneric();
                Set roleNames = TestSentryShellSolr.this.getShellResultWithOSRedirect(sentryShell, args, true);
                TestSentryShellSolr.this.validateRoleNames(roleNames, new String[]{TEST_ROLE_NAME_1, TEST_ROLE_NAME_2});
                args = new String[]{"--list_role", "-conf", TestSentryShellSolr.this.confPath.getAbsolutePath(), "-t", "solr"};
                sentryShell = new SentryShellGeneric();
                roleNames = TestSentryShellSolr.this.getShellResultWithOSRedirect(sentryShell, args, true);
                TestSentryShellSolr.this.validateRoleNames(roleNames, new String[]{TEST_ROLE_NAME_1, TEST_ROLE_NAME_2});
                args = new String[]{"-dr", "-r", TEST_ROLE_NAME_1, "-conf", TestSentryShellSolr.this.confPath.getAbsolutePath(), "-t", "solr"};
                SentryShellGeneric.main((String[])args);
                args = new String[]{"--drop_role", "-r", TEST_ROLE_NAME_2, "-conf", TestSentryShellSolr.this.confPath.getAbsolutePath(), "-t", "solr"};
                SentryShellGeneric.main((String[])args);
                Set roles = TestSentryShellSolr.this.client.listAllRoles(TestSentryShellSolr.this.requestorName, "SOLR");
                Assert.assertEquals((String)"Incorrect number of roles", (long)0L, (long)roles.size());
            }
        });
    }

    @Test
    public void testAddDeleteRoleForGroup() throws Exception {
        this.runTestAsSubject(new SentryServiceIntegrationBase.TestOperation(){

            @Override
            public void runTestAsSubject() throws Exception {
                String TEST_GROUP_1 = "testGroup1";
                String TEST_GROUP_2 = "testGroup2";
                String TEST_GROUP_3 = "testGroup3";
                TestSentryShellSolr.this.client.createRole(TestSentryShellSolr.this.requestorName, TEST_ROLE_NAME_1, "SOLR");
                TestSentryShellSolr.this.client.createRole(TestSentryShellSolr.this.requestorName, TEST_ROLE_NAME_2, "SOLR");
                String[] args = new String[]{"-arg", "-r", TEST_ROLE_NAME_1, "-g", TEST_GROUP_1, "-conf", TestSentryShellSolr.this.confPath.getAbsolutePath(), "-t", "solr"};
                SentryShellGeneric.main((String[])args);
                args = new String[]{"-arg", "-r", TEST_ROLE_NAME_1, "-g", TEST_GROUP_2 + "," + TEST_GROUP_3, "-conf", TestSentryShellSolr.this.confPath.getAbsolutePath(), "-t", "solr"};
                SentryShellGeneric.main((String[])args);
                args = new String[]{"--add_role_group", "-r", TEST_ROLE_NAME_2, "-g", TEST_GROUP_1, "-conf", TestSentryShellSolr.this.confPath.getAbsolutePath(), "-t", "solr"};
                SentryShellGeneric.main((String[])args);
                args = new String[]{"-lr", "-g", TEST_GROUP_1, "-conf", TestSentryShellSolr.this.confPath.getAbsolutePath(), "-t", "solr"};
                SentryShellGeneric sentryShell = new SentryShellGeneric();
                Set roleNames = TestSentryShellSolr.this.getShellResultWithOSRedirect(sentryShell, args, true);
                TestSentryShellSolr.this.validateRoleNames(roleNames, new String[]{TEST_ROLE_NAME_1, TEST_ROLE_NAME_2});
                args = new String[]{"--list_role", "-g", TEST_GROUP_2, "-conf", TestSentryShellSolr.this.confPath.getAbsolutePath(), "-t", "solr"};
                sentryShell = new SentryShellGeneric();
                roleNames = TestSentryShellSolr.this.getShellResultWithOSRedirect(sentryShell, args, true);
                TestSentryShellSolr.this.validateRoleNames(roleNames, new String[]{TEST_ROLE_NAME_1});
                args = new String[]{"--list_role", "-g", TEST_GROUP_3, "-conf", TestSentryShellSolr.this.confPath.getAbsolutePath(), "-t", "solr"};
                sentryShell = new SentryShellGeneric();
                roleNames = TestSentryShellSolr.this.getShellResultWithOSRedirect(sentryShell, args, true);
                TestSentryShellSolr.this.validateRoleNames(roleNames, new String[]{TEST_ROLE_NAME_1});
                args = new String[]{"--list_group", "-conf", TestSentryShellSolr.this.confPath.getAbsolutePath(), "-t", "solr"};
                sentryShell = new SentryShellGeneric();
                Set groups = TestSentryShellSolr.this.getShellResultWithOSRedirect(sentryShell, args, true);
                Assert.assertEquals((long)3L, (long)groups.size());
                Assert.assertTrue((boolean)groups.contains("testGroup3 = testrole1"));
                Assert.assertTrue((boolean)groups.contains("testGroup2 = testrole1"));
                Assert.assertTrue((boolean)groups.contains("testGroup1 = testrole2, testrole1"));
                args = new String[]{"-drg", "-r", TEST_ROLE_NAME_1, "-g", TEST_GROUP_1, "-conf", TestSentryShellSolr.this.confPath.getAbsolutePath(), "-t", "solr"};
                SentryShellGeneric.main((String[])args);
                args = new String[]{"-drg", "-r", TEST_ROLE_NAME_1, "-g", TEST_GROUP_2 + "," + TEST_GROUP_3, "-conf", TestSentryShellSolr.this.confPath.getAbsolutePath(), "-t", "solr"};
                SentryShellGeneric.main((String[])args);
                args = new String[]{"--delete_role_group", "-r", TEST_ROLE_NAME_2, "-g", TEST_GROUP_1, "-conf", TestSentryShellSolr.this.confPath.getAbsolutePath(), "-t", "solr"};
                SentryShellGeneric.main((String[])args);
                Set roles = TestSentryShellSolr.this.client.listRolesByGroupName(TestSentryShellSolr.this.requestorName, TEST_GROUP_1, "SOLR");
                Assert.assertEquals((String)"Incorrect number of roles", (long)0L, (long)roles.size());
                roles = TestSentryShellSolr.this.client.listRolesByGroupName(TestSentryShellSolr.this.requestorName, TEST_GROUP_2, "SOLR");
                Assert.assertEquals((String)"Incorrect number of roles", (long)0L, (long)roles.size());
                roles = TestSentryShellSolr.this.client.listRolesByGroupName(TestSentryShellSolr.this.requestorName, TEST_GROUP_3, "SOLR");
                Assert.assertEquals((String)"Incorrect number of roles", (long)0L, (long)roles.size());
                TestSentryShellSolr.this.client.dropRole(TestSentryShellSolr.this.requestorName, TEST_ROLE_NAME_1, "SOLR");
                TestSentryShellSolr.this.client.dropRole(TestSentryShellSolr.this.requestorName, TEST_ROLE_NAME_2, "SOLR");
            }
        });
    }

    @Test
    public void testCaseSensitiveGroupName() throws Exception {
        this.runTestAsSubject(new SentryServiceIntegrationBase.TestOperation(){

            @Override
            public void runTestAsSubject() throws Exception {
                TestSentryShellSolr.this.client.createRole(TestSentryShellSolr.this.requestorName, TEST_ROLE_NAME_1, "SOLR");
                String[] args = new String[]{"-arg", "-r", TEST_ROLE_NAME_1, "-g", "group1", "-conf", TestSentryShellSolr.this.confPath.getAbsolutePath(), "-t", "solr"};
                SentryShellGeneric.main((String[])args);
                args = new String[]{"-lr", "-g", "group1", "-conf", TestSentryShellSolr.this.confPath.getAbsolutePath(), "-t", "solr"};
                SentryShellGeneric sentryShell = new SentryShellGeneric();
                Set roleNames = TestSentryShellSolr.this.getShellResultWithOSRedirect(sentryShell, args, true);
                TestSentryShellSolr.this.validateRoleNames(roleNames, new String[]{TEST_ROLE_NAME_1});
                args = new String[]{"-lr", "-g", "GROUP1", "-conf", TestSentryShellSolr.this.confPath.getAbsolutePath(), "-t", "solr"};
                roleNames = TestSentryShellSolr.this.getShellResultWithOSRedirect(sentryShell, args, true);
                TestSentryShellSolr.this.validateRoleNames(roleNames, new String[0]);
            }
        });
    }

    public static String grant(boolean shortOption) {
        return shortOption ? "-gpr" : "--grant_privilege_role";
    }

    public static String revoke(boolean shortOption) {
        return shortOption ? "-rpr" : "--revoke_privilege_role";
    }

    public static String list(boolean shortOption) {
        return shortOption ? "-lp" : "--list_privilege";
    }

    private void assertGrantRevokePrivilege(final boolean shortOption) throws Exception {
        this.runTestAsSubject(new SentryServiceIntegrationBase.TestOperation(){

            @Override
            public void runTestAsSubject() throws Exception {
                int i;
                TestSentryShellSolr.this.client.createRole(TestSentryShellSolr.this.requestorName, TEST_ROLE_NAME_1, "SOLR");
                TestSentryShellSolr.this.client.createRole(TestSentryShellSolr.this.requestorName, TEST_ROLE_NAME_2, "SOLR");
                String[] privs = new String[]{"Collection=*->action=*", "Collection=collection2->action=update", "Collection=collection3->action=query"};
                for (int i2 = 0; i2 < privs.length; ++i2) {
                    String[] args = new String[]{TestSentryShellSolr.grant(shortOption), "-r", TEST_ROLE_NAME_1, "-p", privs[i2], "-conf", TestSentryShellSolr.this.confPath.getAbsolutePath(), "-t", "solr"};
                    SentryShellGeneric.main((String[])args);
                }
                String[] args = new String[]{TestSentryShellSolr.list(shortOption), "-r", TEST_ROLE_NAME_1, "-conf", TestSentryShellSolr.this.confPath.getAbsolutePath(), "-t", "solr"};
                SentryShellGeneric sentryShell = new SentryShellGeneric();
                Set privilegeStrs = TestSentryShellSolr.this.getShellResultWithOSRedirect(sentryShell, args, true);
                Assert.assertEquals((String)"Incorrect number of privileges", (long)privs.length, (long)privilegeStrs.size());
                for (i = 0; i < privs.length; ++i) {
                    Assert.assertTrue((String)("Expected privilege: " + privs[i]), (boolean)privilegeStrs.contains(privs[i]));
                }
                for (i = 0; i < privs.length; ++i) {
                    args = new String[]{TestSentryShellSolr.revoke(shortOption), "-r", TEST_ROLE_NAME_1, "-p", privs[i], "-conf", TestSentryShellSolr.this.confPath.getAbsolutePath(), "-t", "solr"};
                    SentryShellGeneric.main((String[])args);
                    Set privileges = TestSentryShellSolr.this.client.listAllPrivilegesByRoleName(TestSentryShellSolr.this.requestorName, TEST_ROLE_NAME_1, "SOLR", TestSentryShellSolr.this.service);
                    Assert.assertEquals((String)"Incorrect number of privileges", (long)(privs.length - (i + 1)), (long)privileges.size());
                }
                TestSentryShellSolr.this.client.dropRole(TestSentryShellSolr.this.requestorName, TEST_ROLE_NAME_1, "SOLR");
                TestSentryShellSolr.this.client.dropRole(TestSentryShellSolr.this.requestorName, TEST_ROLE_NAME_2, "SOLR");
            }
        });
    }

    @Test
    public void testGrantRevokePrivilegeWithShortOption() throws Exception {
        this.assertGrantRevokePrivilege(true);
    }

    @Test
    public void testGrantRevokePrivilegeWithLongOption() throws Exception {
        this.assertGrantRevokePrivilege(false);
    }

    @Test
    public void testNegativeCaseWithInvalidArgument() throws Exception {
        this.runTestAsSubject(new SentryServiceIntegrationBase.TestOperation(){

            @Override
            public void runTestAsSubject() throws Exception {
                TestSentryShellSolr.this.client.createRole(TestSentryShellSolr.this.requestorName, TEST_ROLE_NAME_1, "SOLR");
                String[] args = new String[]{"-cr", "-r", TEST_ROLE_NAME_1, "-conf", TestSentryShellSolr.this.confPath.getAbsolutePath(), "-t", "solr"};
                SentryShellGeneric sentryShell = new SentryShellGeneric();
                try {
                    sentryShell.executeShell(args);
                    Assert.fail((String)"Exception should be thrown for creating duplicate role");
                }
                catch (SentryUserException sentryUserException) {
                    // empty catch block
                }
                args = new String[]{"-dr", "-r", TEST_ROLE_NAME_2, "-conf", TestSentryShellSolr.this.confPath.getAbsolutePath(), "-t", "solr"};
                sentryShell = new SentryShellGeneric();
                try {
                    sentryShell.executeShell(args);
                    Assert.fail((String)"Exception should be thrown for dropping non-exist role");
                }
                catch (SentryUserException sentryUserException) {
                    // empty catch block
                }
                args = new String[]{"-arg", "-r", TEST_ROLE_NAME_2, "-g", "testGroup1", "-conf", TestSentryShellSolr.this.confPath.getAbsolutePath(), "-t", "solr"};
                sentryShell = new SentryShellGeneric();
                try {
                    sentryShell.executeShell(args);
                    Assert.fail((String)"Exception should be thrown for granting non-exist role to group");
                }
                catch (SentryUserException sentryUserException) {
                    // empty catch block
                }
                args = new String[]{"-drg", "-r", TEST_ROLE_NAME_2, "-g", "testGroup1", "-conf", TestSentryShellSolr.this.confPath.getAbsolutePath(), "-t", "solr"};
                sentryShell = new SentryShellGeneric();
                try {
                    sentryShell.executeShell(args);
                    Assert.fail((String)"Exception should be thrown for drop group from non-exist role");
                }
                catch (SentryUserException sentryUserException) {
                    // empty catch block
                }
                args = new String[]{"-gpr", "-r", TEST_ROLE_NAME_1, "-p", "serverserver1->action=*", "-conf", TestSentryShellSolr.this.confPath.getAbsolutePath(), "-t", "solr"};
                sentryShell = new SentryShellGeneric();
                try {
                    sentryShell.executeShell(args);
                    Assert.fail((String)"Exception should be thrown for the error privilege format, invalid key value.");
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                args = new String[]{"-gpr", "-r", TEST_ROLE_NAME_1, "-p", "server=server1->table=tbl1->column=col2->action=insert", "-conf", TestSentryShellSolr.this.confPath.getAbsolutePath(), "-t", "solr"};
                sentryShell = new SentryShellGeneric();
                try {
                    sentryShell.executeShell(args);
                    Assert.fail((String)"Exception should be thrown for the error privilege format, invalid key value.");
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                TestSentryShellSolr.this.client.dropRole(TestSentryShellSolr.this.requestorName, TEST_ROLE_NAME_1, "SOLR");
            }
        });
    }

    @Test
    public void testNegativeCaseWithoutRequiredArgument() throws Exception {
        this.runTestAsSubject(new SentryServiceIntegrationBase.TestOperation(){

            @Override
            public void runTestAsSubject() throws Exception {
                String strOptionConf = "conf";
                TestSentryShellSolr.this.client.createRole(TestSentryShellSolr.this.requestorName, TEST_ROLE_NAME_1, "SOLR");
                String[] args = new String[]{"-cr", "-r", TEST_ROLE_NAME_1, "-t", "solr"};
                SentryShellGeneric sentryShell = new SentryShellGeneric();
                TestSentryShellSolr.this.validateMissingParameterMsg(sentryShell, args, "Missing required option: " + strOptionConf);
                args = new String[]{"-cr", "-conf", TestSentryShellSolr.this.confPath.getAbsolutePath(), "-t", "solr"};
                sentryShell = new SentryShellGeneric();
                TestSentryShellSolr.this.validateMissingParameterMsg(sentryShell, args, "Missing required option: Role name");
                args = new String[]{"-dr", "-conf", TestSentryShellSolr.this.confPath.getAbsolutePath(), "-t", "solr"};
                sentryShell = new SentryShellGeneric();
                TestSentryShellSolr.this.validateMissingParameterMsg(sentryShell, args, "Missing required option: Role name");
                args = new String[]{"-arg", "-g", "testGroup1", "-conf", TestSentryShellSolr.this.confPath.getAbsolutePath(), "-t", "solr"};
                sentryShell = new SentryShellGeneric();
                TestSentryShellSolr.this.validateMissingParameterMsg(sentryShell, args, "Missing required option: Role name");
                args = new String[]{"-arg", "-r", TEST_ROLE_NAME_2, "-conf", TestSentryShellSolr.this.confPath.getAbsolutePath(), "-t", "solr"};
                sentryShell = new SentryShellGeneric();
                TestSentryShellSolr.this.validateMissingParameterMsg(sentryShell, args, "Missing required option: Group name");
                args = new String[]{"-drg", "-g", "testGroup1", "-conf", TestSentryShellSolr.this.confPath.getAbsolutePath(), "-t", "solr"};
                sentryShell = new SentryShellGeneric();
                TestSentryShellSolr.this.validateMissingParameterMsg(sentryShell, args, "Missing required option: Role name");
                args = new String[]{"-drg", "-r", TEST_ROLE_NAME_2, "-conf", TestSentryShellSolr.this.confPath.getAbsolutePath(), "-t", "solr"};
                sentryShell = new SentryShellGeneric();
                TestSentryShellSolr.this.validateMissingParameterMsg(sentryShell, args, "Missing required option: Group name");
                args = new String[]{"-gpr", "-p", "server=server1", "-conf", TestSentryShellSolr.this.confPath.getAbsolutePath(), "-t", "solr"};
                sentryShell = new SentryShellGeneric();
                TestSentryShellSolr.this.validateMissingParameterMsg(sentryShell, args, "Missing required option: Role name");
                args = new String[]{"-gpr", "-r", TEST_ROLE_NAME_1, "-conf", TestSentryShellSolr.this.confPath.getAbsolutePath(), "-t", "solr"};
                sentryShell = new SentryShellGeneric();
                TestSentryShellSolr.this.validateMissingParameterMsg(sentryShell, args, "Missing required option: Privilege string");
                args = new String[]{"-gpr", "-r", TEST_ROLE_NAME_1, "-conf", TestSentryShellSolr.this.confPath.getAbsolutePath(), "-p", "collection=collection1", "-t", "solr"};
                sentryShell = new SentryShellGeneric();
                try {
                    TestSentryShellSolr.this.getShellResultWithOSRedirect(sentryShell, args, false);
                    Assert.fail((String)"Expected IllegalArgumentException");
                }
                catch (IllegalArgumentException e) {
                    Assert.assertEquals((Object)"Privilege is invalid: action required but not specified.", (Object)e.getMessage());
                }
                args = new String[]{"-rpr", "-p", "server=server1", "-conf", TestSentryShellSolr.this.confPath.getAbsolutePath(), "-t", "solr"};
                sentryShell = new SentryShellGeneric();
                TestSentryShellSolr.this.validateMissingParameterMsg(sentryShell, args, "Missing required option: Role name");
                args = new String[]{"-rpr", "-r", TEST_ROLE_NAME_1, "-conf", TestSentryShellSolr.this.confPath.getAbsolutePath(), "-t", "solr"};
                sentryShell = new SentryShellGeneric();
                TestSentryShellSolr.this.validateMissingParameterMsg(sentryShell, args, "Missing required option: Privilege string");
                args = new String[]{"-conf", TestSentryShellSolr.this.confPath.getAbsolutePath()};
                sentryShell = new SentryShellGeneric();
                TestSentryShellSolr.this.validateMissingParameterMsgsContains(sentryShell, args, new String[]{"Missing required option: [", "-arg Add role to group", "-cr Create role", "-rpr Revoke privilege from role", "-drg Delete role from group", "-lr List role", "-lp List privilege", "-gpr Grant privilege to role", "-dr Drop role"});
                TestSentryShellSolr.this.client.dropRole(TestSentryShellSolr.this.requestorName, TEST_ROLE_NAME_1, "SOLR");
            }
        });
    }

    private Set<String> getShellResultWithOSRedirect(SentryShellGeneric sentryShell, String[] args, boolean expectedExecuteResult) throws Exception {
        PrintStream oldOut = System.out;
        ByteArrayOutputStream outContent = new ByteArrayOutputStream();
        System.setOut(new PrintStream(outContent));
        Assert.assertEquals((Object)expectedExecuteResult, (Object)sentryShell.executeShell(args));
        HashSet resultSet = Sets.newHashSet((Object[])outContent.toString().split("\n"));
        System.setOut(oldOut);
        return resultSet;
    }

    private void validateRoleNames(Set<String> roleNames, String ... expectedRoleNames) {
        if (expectedRoleNames != null && expectedRoleNames.length > 0) {
            Assert.assertEquals((String)("Found: " + roleNames.size() + " roles, expected: " + expectedRoleNames.length), (long)expectedRoleNames.length, (long)roleNames.size());
            HashSet<String> lowerCaseRoles = new HashSet<String>();
            for (String role : roleNames) {
                lowerCaseRoles.add(role.toLowerCase());
            }
            for (String expectedRole : expectedRoleNames) {
                Assert.assertTrue((String)("Expected role: " + expectedRole), (boolean)lowerCaseRoles.contains(expectedRole.toLowerCase()));
            }
        }
    }

    private void validateMissingParameterMsg(SentryShellGeneric sentryShell, String[] args, String expectedErrorMsg) throws Exception {
        Set<String> errorMsgs = this.getShellResultWithOSRedirect(sentryShell, args, false);
        Assert.assertTrue((String)("Expected error message: " + expectedErrorMsg), (boolean)errorMsgs.contains(expectedErrorMsg));
    }

    private void validateMissingParameterMsgsContains(SentryShellGeneric sentryShell, String[] args, String ... expectedErrorMsgsContains) throws Exception {
        Set<String> errorMsgs = this.getShellResultWithOSRedirect(sentryShell, args, false);
        boolean foundAllMessages = false;
        for (String errorMessage : errorMsgs) {
            boolean missingExpected = false;
            for (String expectedContains : expectedErrorMsgsContains) {
                if (errorMessage.contains(expectedContains)) continue;
                missingExpected = true;
                break;
            }
            if (missingExpected) continue;
            foundAllMessages = true;
            break;
        }
        Assert.assertTrue((boolean)foundAllMessages);
    }
}

