/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.provider.db.generic.tools;

import com.google.common.collect.Sets;
import com.google.common.io.Files;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.sentry.core.common.exception.SentryConfigurationException;
import org.apache.sentry.provider.db.generic.service.thrift.SentryGenericServiceIntegrationBase;
import org.apache.sentry.provider.db.generic.service.thrift.TSentryPrivilege;
import org.apache.sentry.provider.db.generic.service.thrift.TSentryRole;
import org.apache.sentry.provider.db.generic.tools.GenericPrivilegeConverter;
import org.apache.sentry.provider.db.generic.tools.SentryConfigToolSolr;
import org.apache.sentry.service.thrift.SentryServiceIntegrationBase;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestSentryConfigToolSolr
extends SentryGenericServiceIntegrationBase {
    private static String RESOURCES_DIR = "target" + File.separator + "test-classes" + File.separator;
    private static String VALID_POLICY_INI = RESOURCES_DIR + "solr_config_import_tool.ini";
    private static String INVALID_POLICY_INI = RESOURCES_DIR + "solr_invalid.ini";
    private static String CASE_POLICY_INI = RESOURCES_DIR + "solr_case.ini";
    private File confDir;
    private File confPath;
    private String requestorName = "";
    private String service = "service1";

    @Before
    public void prepareForTest() throws Exception {
        this.confDir = Files.createTempDir();
        this.confPath = new File(this.confDir, "sentry-site.xml");
        if (this.confPath.createNewFile()) {
            FileOutputStream to = new FileOutputStream(this.confPath);
            conf.writeXml((OutputStream)to);
            to.close();
        }
        this.requestorName = clientUgi.getShortUserName();
        HashSet requestorUserGroupNames = Sets.newHashSet((Object[])new String[]{"admin_group"});
        this.setLocalGroupMapping(this.requestorName, requestorUserGroupNames);
        this.setLocalGroupMapping("admin_user", requestorUserGroupNames);
        this.writePolicyFile();
    }

    @After
    public void clearTestData() throws Exception {
        FileUtils.deleteQuietly((File)this.confDir);
        Set tRoles = this.client.listAllRoles(this.requestorName, "SOLR");
        for (TSentryRole tRole : tRoles) {
            String role = tRole.getRoleName();
            Set privileges = this.client.listAllPrivilegesByRoleName(this.requestorName, role, "SOLR", this.service);
            for (TSentryPrivilege privilege : privileges) {
                this.client.revokePrivilege(this.requestorName, role, "SOLR", privilege);
            }
            this.client.dropRole(this.requestorName, role, "SOLR");
        }
    }

    @Test
    public void testConvertIni() throws Exception {
        this.runTestAsSubject(new SentryServiceIntegrationBase.TestOperation(){

            @Override
            public void runTestAsSubject() throws Exception {
                String[] args = new String[]{"-p", VALID_POLICY_INI, "-conf", TestSentryConfigToolSolr.this.confPath.getAbsolutePath(), "-v", "-i"};
                SentryConfigToolSolr sentryTool = new SentryConfigToolSolr();
                sentryTool.executeConfigTool(args);
                HashMap<String, HashSet> groupMapping = new HashMap<String, HashSet>();
                groupMapping.put("corporal_role", Sets.newHashSet((Object[])new String[]{"corporal", "sergeant", "general", "commander_in_chief"}));
                groupMapping.put("sergeant_role", Sets.newHashSet((Object[])new String[]{"sergeant", "general", "commander_in_chief"}));
                groupMapping.put("general_role", Sets.newHashSet((Object[])new String[]{"general", "commander_in_chief"}));
                groupMapping.put("commander_in_chief_role", Sets.newHashSet((Object[])new String[]{"commander_in_chief"}));
                HashMap<String, HashSet> privilegeMapping = new HashMap<String, HashSet>();
                privilegeMapping.put("corporal_role", Sets.newHashSet((Object[])new String[]{"Collection=info->action=query", "Collection=info->action=update"}));
                privilegeMapping.put("sergeant_role", Sets.newHashSet((Object[])new String[]{"Collection=info->action=update"}));
                privilegeMapping.put("general_role", Sets.newHashSet((Object[])new String[]{"Collection=info->action=*"}));
                privilegeMapping.put("commander_in_chief_role", Sets.newHashSet((Object[])new String[]{"Collection=*->action=*"}));
                Set tRoles = TestSentryConfigToolSolr.this.client.listAllRoles(TestSentryConfigToolSolr.this.requestorName, "SOLR");
                Assert.assertEquals((String)"Unexpected number of roles", (long)groupMapping.keySet().size(), (long)tRoles.size());
                HashSet<String> roles = new HashSet<String>();
                for (TSentryRole tRole : tRoles) {
                    roles.add(tRole.getRoleName());
                }
                for (String expectedRole : groupMapping.keySet()) {
                    Assert.assertTrue((String)("Didn't find expected role: " + expectedRole), (boolean)roles.contains(expectedRole));
                }
                for (TSentryRole tRole : tRoles) {
                    Set expectedGroups = (Set)groupMapping.get(tRole.getRoleName());
                    Assert.assertEquals((String)("Group size doesn't match for role: " + tRole.getRoleName()), (long)expectedGroups.size(), (long)tRole.getGroups().size());
                    Assert.assertTrue((String)("Group does not contain all expected members for role: " + tRole.getRoleName()), (boolean)tRole.getGroups().containsAll(expectedGroups));
                }
                GenericPrivilegeConverter convert = new GenericPrivilegeConverter("SOLR", TestSentryConfigToolSolr.this.service);
                for (String role : roles) {
                    Set privileges = TestSentryConfigToolSolr.this.client.listAllPrivilegesByRoleName(TestSentryConfigToolSolr.this.requestorName, role, "SOLR", TestSentryConfigToolSolr.this.service);
                    Set expectedPrivileges = (Set)privilegeMapping.get(role);
                    Assert.assertEquals((String)("Privilege set size doesn't match for role: " + role), (long)expectedPrivileges.size(), (long)privileges.size());
                    HashSet<String> privilegeStrs = new HashSet<String>();
                    for (TSentryPrivilege privilege : privileges) {
                        privilegeStrs.add(convert.toString(privilege));
                    }
                    for (String expectedPrivilege : expectedPrivileges) {
                        Assert.assertTrue((String)("Did not find expected privilege: " + expectedPrivilege + " in " + privilegeStrs), (boolean)privilegeStrs.contains(expectedPrivilege));
                    }
                }
            }
        });
    }

    @Test
    public void testNoPolicyFile() throws Exception {
        this.runTestAsSubject(new SentryServiceIntegrationBase.TestOperation(){

            @Override
            public void runTestAsSubject() throws Exception {
                String[] args = new String[]{"-p", INVALID_POLICY_INI + "Foobar", "-conf", TestSentryConfigToolSolr.this.confPath.getAbsolutePath(), "-v", "-i"};
                SentryConfigToolSolr sentryTool = new SentryConfigToolSolr();
                try {
                    sentryTool.executeConfigTool(args);
                    Assert.fail((String)"Exception should be thrown for nonexistant ini");
                }
                catch (SentryConfigurationException sentryConfigurationException) {
                    // empty catch block
                }
            }
        });
    }

    @Test
    public void testNoValidateNorImport() throws Exception {
        this.runTestAsSubject(new SentryServiceIntegrationBase.TestOperation(){

            @Override
            public void runTestAsSubject() throws Exception {
                String[] args = new String[]{"-p", INVALID_POLICY_INI, "-conf", TestSentryConfigToolSolr.this.confPath.getAbsolutePath()};
                SentryConfigToolSolr sentryTool = new SentryConfigToolSolr();
                try {
                    sentryTool.executeConfigTool(args);
                    Assert.fail((String)"Exception should be thrown for validating invalid ini");
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        });
    }

    @Test
    public void testConvertInvalidIni() throws Exception {
        this.runTestAsSubject(new SentryServiceIntegrationBase.TestOperation(){

            @Override
            public void runTestAsSubject() throws Exception {
                String[] args = new String[]{"-p", INVALID_POLICY_INI, "-conf", TestSentryConfigToolSolr.this.confPath.getAbsolutePath(), "-v", "-i"};
                SentryConfigToolSolr sentryTool = new SentryConfigToolSolr();
                try {
                    sentryTool.executeConfigTool(args);
                    Assert.fail((String)"Exception should be thrown for validating invalid ini");
                }
                catch (SentryConfigurationException sentryConfigurationException) {
                    // empty catch block
                }
                args = new String[]{"-p", INVALID_POLICY_INI, "-conf", TestSentryConfigToolSolr.this.confPath.getAbsolutePath(), "-i"};
                sentryTool = new SentryConfigToolSolr();
                sentryTool.executeConfigTool(args);
            }
        });
    }

    @Test
    public void testCompatCheck() throws Exception {
        this.runTestAsSubject(new SentryServiceIntegrationBase.TestOperation(){

            @Override
            public void runTestAsSubject() throws Exception {
                String[] args = new String[]{"-p", CASE_POLICY_INI, "-conf", TestSentryConfigToolSolr.this.confPath.getAbsolutePath(), "-v", "-i", "-c"};
                SentryConfigToolSolr sentryTool = new SentryConfigToolSolr();
                try {
                    sentryTool.executeConfigTool(args);
                    Assert.fail((String)"Exception should be thrown for validating invalid ini");
                }
                catch (SentryConfigurationException e) {
                    Assert.assertEquals((String)"Expected error", (long)1L, (long)e.getConfigErrors().size());
                    String error = (String)e.getConfigErrors().get(0);
                    TestSentryConfigToolSolr.this.assertCasedRoleNamesInMessage(error, new String[]{"RoLe1", "rOlE1"});
                    String warning = (String)e.getConfigWarnings().get(0);
                    TestSentryConfigToolSolr.this.assertCasedRoleNamesInMessage(warning, new String[]{"ROLE2", "RoLe1", "rOlE1"});
                    Assert.assertEquals((String)"Expected warning", (long)1L, (long)e.getConfigWarnings().size());
                }
                args = new String[]{"-p", CASE_POLICY_INI, "-conf", TestSentryConfigToolSolr.this.confPath.getAbsolutePath(), "-i", "-v"};
                sentryTool = new SentryConfigToolSolr();
                sentryTool.executeConfigTool(args);
            }
        });
    }

    @Test
    public void testCompatCheckValid() throws Exception {
        this.runTestAsSubject(new SentryServiceIntegrationBase.TestOperation(){

            @Override
            public void runTestAsSubject() throws Exception {
                String[] args = new String[]{"-p", VALID_POLICY_INI, "-conf", TestSentryConfigToolSolr.this.confPath.getAbsolutePath(), "-v", "-i", "-c"};
                SentryConfigToolSolr sentryTool = new SentryConfigToolSolr();
                sentryTool.executeConfigTool(args);
            }
        });
    }

    private void assertCasedRoleNamesInMessage(String message, String ... casedRoleNames) {
        for (String casedRoleName : casedRoleNames) {
            Assert.assertTrue((String)("Expected cased role name: " + casedRoleName), (boolean)message.contains(casedRoleName));
        }
    }
}

