/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.provider.db.generic.tools;

import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import com.google.common.io.Files;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.fs.Path;
import org.apache.sentry.core.common.exception.SentryUserException;
import org.apache.sentry.provider.common.ProviderBackendContext;
import org.apache.sentry.provider.db.generic.service.thrift.SentryGenericServiceIntegrationBase;
import org.apache.sentry.provider.db.generic.service.thrift.TAuthorizable;
import org.apache.sentry.provider.db.generic.service.thrift.TSentryPrivilege;
import org.apache.sentry.provider.db.generic.service.thrift.TSentryRole;
import org.apache.sentry.provider.db.generic.tools.GenericPrivilegeConverter;
import org.apache.sentry.provider.db.generic.tools.PermissionsMigrationToolSolr;
import org.apache.sentry.provider.file.PolicyFile;
import org.apache.sentry.provider.file.SimpleFileProviderBackend;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestPermissionsMigrationToolSolr
extends SentryGenericServiceIntegrationBase {
    private File confDir;
    private File confPath;
    private String requestorName = "";
    private String service = "service1";

    @Before
    public void prepareForTest() throws Exception {
        this.confDir = Files.createTempDir();
        this.confPath = new File(this.confDir, "sentry-site.xml");
        if (this.confPath.createNewFile()) {
            FileOutputStream to = new FileOutputStream(this.confPath);
            conf.writeXml((OutputStream)to);
            to.close();
        }
        this.requestorName = clientUgi.getShortUserName();
        HashSet requestorUserGroupNames = Sets.newHashSet((Object[])new String[]{"admin_group"});
        this.setLocalGroupMapping(this.requestorName, requestorUserGroupNames);
        this.setLocalGroupMapping("admin_user", requestorUserGroupNames);
        this.setLocalGroupMapping("dev", Sets.newHashSet((Object[])new String[]{"dev_group"}));
        this.setLocalGroupMapping("user", Sets.newHashSet((Object[])new String[]{"user_group"}));
        this.writePolicyFile();
    }

    @After
    public void clearTestData() throws Exception {
        FileUtils.deleteQuietly((File)this.confDir);
        Set tRoles = this.client.listAllRoles(this.requestorName, "SOLR");
        for (TSentryRole tRole : tRoles) {
            String role = tRole.getRoleName();
            Set privileges = this.client.listAllPrivilegesByRoleName(this.requestorName, role, "SOLR", this.service);
            for (TSentryPrivilege privilege : privileges) {
                this.client.revokePrivilege(this.requestorName, role, "SOLR", privilege);
            }
            this.client.dropRole(this.requestorName, role, "SOLR");
        }
    }

    @Test
    public void testPermissionsMigrationFromSentrySvc_v1() throws Exception {
        this.initializeSentryService();
        String[] args = new String[]{"-s", "1.8.0", "-c", this.confPath.getAbsolutePath()};
        PermissionsMigrationToolSolr sentryTool = new PermissionsMigrationToolSolr();
        sentryTool.executeConfigTool(args);
        HashMap<String, Set<String>> groupMapping = new HashMap<String, Set<String>>();
        groupMapping.put("admin_role", Sets.newHashSet((Object[])new String[]{"admin_group"}));
        groupMapping.put("dev_role", Sets.newHashSet((Object[])new String[]{"dev_group"}));
        groupMapping.put("user_role", Sets.newHashSet((Object[])new String[]{"user_group"}));
        HashMap<String, Set<String>> privilegeMapping = new HashMap<String, Set<String>>();
        privilegeMapping.put("admin_role", Sets.newHashSet((Object[])new String[]{"admin=collections->action=*", "admin=cores->action=*"}));
        privilegeMapping.put("dev_role", Sets.newHashSet((Object[])new String[]{"collection=*->action=*", "admin=collections->action=*", "admin=cores->action=*"}));
        privilegeMapping.put("user_role", Sets.newHashSet((Object[])new String[]{"collection=foo->action=*"}));
        this.verifySentryServiceState(groupMapping, privilegeMapping);
    }

    @Test
    public void testPermissionsMigrationFromSentryPolicyFile_v1() throws Exception {
        java.nio.file.Path policyFilePath = this.initializeSentryPolicyFile();
        java.nio.file.Path outputFilePath = Paths.get(this.confDir.getAbsolutePath(), "sentry-provider_migrated.ini");
        String[] args = new String[]{"-s", "1.8.0", "-p", policyFilePath.toFile().getAbsolutePath(), "-o", outputFilePath.toFile().getAbsolutePath()};
        PermissionsMigrationToolSolr sentryTool = new PermissionsMigrationToolSolr();
        Assert.assertTrue((boolean)sentryTool.executeConfigTool(args));
        HashSet<String> groups = new HashSet<String>();
        groups.add("admin_group");
        groups.add("dev_group");
        groups.add("user_group");
        HashMap<String, Set<String>> privilegeMapping = new HashMap<String, Set<String>>();
        privilegeMapping.put("admin_role", Sets.newHashSet((Object[])new String[]{"admin=collections->action=*", "admin=cores->action=*"}));
        privilegeMapping.put("dev_role", Sets.newHashSet((Object[])new String[]{"collection=*->action=*", "admin=collections->action=*", "admin=cores->action=*"}));
        privilegeMapping.put("user_role", Sets.newHashSet((Object[])new String[]{"collection=foo->action=*"}));
        this.verifySentryPolicyFile(groups, privilegeMapping, outputFilePath);
    }

    @Test
    public void testPermissionsMigrationFromSentrySvc_v2() throws Exception {
        this.initializeSentryService();
        String[] args = new String[]{"-s", "2.0.0", "-c", this.confPath.getAbsolutePath()};
        PermissionsMigrationToolSolr sentryTool = new PermissionsMigrationToolSolr();
        sentryTool.executeConfigTool(args);
        HashMap<String, Set<String>> groupMapping = new HashMap<String, Set<String>>();
        groupMapping.put("admin_role", Sets.newHashSet((Object[])new String[]{"admin_group"}));
        groupMapping.put("dev_role", Sets.newHashSet((Object[])new String[]{"dev_group"}));
        groupMapping.put("user_role", Sets.newHashSet((Object[])new String[]{"user_group"}));
        HashMap<String, Set<String>> privilegeMapping = new HashMap<String, Set<String>>();
        privilegeMapping.put("admin_role", Sets.newHashSet((Object[])new String[]{"collection=admin->action=*"}));
        privilegeMapping.put("dev_role", Sets.newHashSet((Object[])new String[]{"collection=*->action=*"}));
        privilegeMapping.put("user_role", Sets.newHashSet((Object[])new String[]{"collection=foo->action=*"}));
        this.verifySentryServiceState(groupMapping, privilegeMapping);
    }

    @Test
    public void testPermissionsMigrationFromSentryPolicyFile_v2() throws Exception {
        java.nio.file.Path policyFilePath = this.initializeSentryPolicyFile();
        java.nio.file.Path outputFilePath = Paths.get(this.confDir.getAbsolutePath(), "sentry-provider_migrated.ini");
        String[] args = new String[]{"-s", "2.0.0", "-p", policyFilePath.toFile().getAbsolutePath(), "-o", outputFilePath.toFile().getAbsolutePath()};
        PermissionsMigrationToolSolr sentryTool = new PermissionsMigrationToolSolr();
        Assert.assertTrue((boolean)sentryTool.executeConfigTool(args));
        HashSet<String> groups = new HashSet<String>();
        groups.add("admin_group");
        groups.add("dev_group");
        groups.add("user_group");
        HashMap<String, Set<String>> privilegeMapping = new HashMap<String, Set<String>>();
        privilegeMapping.put("admin_role", Sets.newHashSet((Object[])new String[]{"collection=admin->action=*"}));
        privilegeMapping.put("dev_role", Sets.newHashSet((Object[])new String[]{"collection=*->action=*"}));
        privilegeMapping.put("user_role", Sets.newHashSet((Object[])new String[]{"collection=foo->action=*"}));
        this.verifySentryPolicyFile(groups, privilegeMapping, outputFilePath);
    }

    @Test
    public void testDryRunOption() throws Exception {
        this.initializeSentryService();
        String[] args = new String[]{"-s", "1.8.0", "-c", this.confPath.getAbsolutePath(), "--dry_run"};
        PermissionsMigrationToolSolr sentryTool = new PermissionsMigrationToolSolr();
        sentryTool.executeConfigTool(args);
        HashMap<String, Set<String>> groupMapping = new HashMap<String, Set<String>>();
        groupMapping.put("admin_role", Sets.newHashSet((Object[])new String[]{"admin_group"}));
        groupMapping.put("dev_role", Sets.newHashSet((Object[])new String[]{"dev_group"}));
        groupMapping.put("user_role", Sets.newHashSet((Object[])new String[]{"user_group"}));
        HashMap<String, Set<String>> privilegeMapping = new HashMap<String, Set<String>>();
        privilegeMapping.put("admin_role", Sets.newHashSet((Object[])new String[]{"collection=admin->action=*"}));
        privilegeMapping.put("dev_role", Sets.newHashSet((Object[])new String[]{"collection=*->action=*"}));
        privilegeMapping.put("user_role", Sets.newHashSet((Object[])new String[]{"collection=foo->action=*"}));
        this.verifySentryServiceState(groupMapping, privilegeMapping);
    }

    @Test
    public void testInvalidToolArguments() throws Exception {
        PermissionsMigrationToolSolr sentryTool = new PermissionsMigrationToolSolr();
        String[] args = new String[]{"-c", this.confPath.getAbsolutePath()};
        Assert.assertFalse((String)"The execution should have failed due to missing source version", (boolean)sentryTool.executeConfigTool(args));
        args = new String[]{"-s", "1.8.0"};
        sentryTool.executeConfigTool(args);
        Assert.assertFalse((String)"The execution should have failed due to missing Sentry config file (or policy file) path", (boolean)sentryTool.executeConfigTool(args));
        args = new String[]{"-s", "1.8.0", "-p", "/test/path"};
        sentryTool.executeConfigTool(args);
        Assert.assertFalse((String)"The execution should have failed due to missing Sentry config output file path", (boolean)sentryTool.executeConfigTool(args));
        args = new String[]{"-s", "1.8.0", "-c", "/test/path1", "-p", "/test/path2"};
        sentryTool.executeConfigTool(args);
        Assert.assertFalse((String)"The execution should have failed due to providing both Sentry config file as well as policy file params", (boolean)sentryTool.executeConfigTool(args));
    }

    private void initializeSentryService() throws SentryUserException {
        this.client.createRoleIfNotExist(this.requestorName, "admin_role", "SOLR");
        this.client.grantRoleToGroups(this.requestorName, "admin_role", "SOLR", (Set)Sets.newHashSet((Object[])new String[]{"admin_group"}));
        this.client.createRoleIfNotExist(this.requestorName, "dev_role", "SOLR");
        this.client.grantRoleToGroups(this.requestorName, "dev_role", "SOLR", (Set)Sets.newHashSet((Object[])new String[]{"dev_group"}));
        this.client.createRoleIfNotExist(this.requestorName, "user_role", "SOLR");
        this.client.grantRoleToGroups(this.requestorName, "user_role", "SOLR", (Set)Sets.newHashSet((Object[])new String[]{"user_group"}));
        this.client.grantPrivilege(this.requestorName, "admin_role", "SOLR", new TSentryPrivilege("SOLR", "service1", Arrays.asList(new TAuthorizable("collection", "admin")), "*"));
        this.client.grantPrivilege(this.requestorName, "dev_role", "SOLR", new TSentryPrivilege("SOLR", "service1", Arrays.asList(new TAuthorizable("collection", "*")), "*"));
        this.client.grantPrivilege(this.requestorName, "user_role", "SOLR", new TSentryPrivilege("SOLR", "service1", Arrays.asList(new TAuthorizable("collection", "foo")), "*"));
    }

    private void verifySentryServiceState(Map<String, Set<String>> groupMapping, Map<String, Set<String>> privilegeMapping) throws SentryUserException {
        Set tRoles = this.client.listAllRoles(this.requestorName, "SOLR");
        Assert.assertEquals((String)"Unexpected number of roles", (long)groupMapping.keySet().size(), (long)tRoles.size());
        HashSet<String> roles = new HashSet<String>();
        for (TSentryRole tRole : tRoles) {
            roles.add(tRole.getRoleName());
        }
        for (String expectedRole : groupMapping.keySet()) {
            Assert.assertTrue((String)("Didn't find expected role: " + expectedRole), (boolean)roles.contains(expectedRole));
        }
        for (TSentryRole tRole : tRoles) {
            Set<String> expectedGroups = groupMapping.get(tRole.getRoleName());
            Assert.assertEquals((String)("Group size doesn't match for role: " + tRole.getRoleName()), (long)expectedGroups.size(), (long)tRole.getGroups().size());
            Assert.assertTrue((String)("Group does not contain all expected members for role: " + tRole.getRoleName()), (boolean)tRole.getGroups().containsAll(expectedGroups));
        }
        GenericPrivilegeConverter convert = new GenericPrivilegeConverter("SOLR", this.service);
        for (String role : roles) {
            Set privileges = this.client.listAllPrivilegesByRoleName(this.requestorName, role, "SOLR", this.service);
            Set<String> expectedPrivileges = privilegeMapping.get(role);
            Assert.assertEquals((String)("Privilege set size doesn't match for role: " + role + " Actual permissions : " + privileges), (long)expectedPrivileges.size(), (long)privileges.size());
            HashSet<String> privilegeStrs = new HashSet<String>();
            for (TSentryPrivilege privilege : privileges) {
                privilegeStrs.add(convert.toString(privilege).toLowerCase());
            }
            for (String expectedPrivilege : expectedPrivileges) {
                Assert.assertTrue((String)("Did not find expected privilege: " + expectedPrivilege + " in " + privilegeStrs), (boolean)privilegeStrs.contains(expectedPrivilege));
            }
        }
    }

    private java.nio.file.Path initializeSentryPolicyFile() throws Exception {
        PolicyFile file = new PolicyFile();
        file.addRolesToGroup("admin_group", new String[]{"admin_role"});
        file.addRolesToGroup("dev_group", new String[]{"dev_role"});
        file.addRolesToGroup("user_group", new String[]{"user_role"});
        file.addPermissionsToRole("admin_role", new String[]{"collection=admin->action=*"});
        file.addPermissionsToRole("dev_role", new String[]{"collection=*->action=*"});
        file.addPermissionsToRole("user_role", new String[]{"collection=foo->action=*"});
        java.nio.file.Path policyFilePath = Paths.get(this.confDir.getAbsolutePath(), "sentry-provider.ini");
        file.write(policyFilePath.toFile());
        return policyFilePath;
    }

    private void verifySentryPolicyFile(Set<String> groups, Map<String, Set<String>> privilegeMapping, java.nio.file.Path policyFilePath) throws IOException {
        SimpleFileProviderBackend policyFileBackend = new SimpleFileProviderBackend(conf, new Path(policyFilePath.toUri()));
        policyFileBackend.initialize(new ProviderBackendContext());
        Table groupRolePrivilegeTable = policyFileBackend.getGroupRolePrivilegeTable();
        Assert.assertEquals(groups, (Object)groupRolePrivilegeTable.rowKeySet());
        Assert.assertEquals(privilegeMapping.keySet(), (Object)groupRolePrivilegeTable.columnKeySet());
        for (String groupName : groupRolePrivilegeTable.rowKeySet()) {
            for (String roleName : groupRolePrivilegeTable.columnKeySet()) {
                if (!groupRolePrivilegeTable.contains((Object)groupName, (Object)roleName)) continue;
                Set privileges = (Set)groupRolePrivilegeTable.get((Object)groupName, (Object)roleName);
                Assert.assertEquals(privilegeMapping.get(roleName), (Object)privileges);
            }
        }
    }
}

