/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.provider.db.generic.service.thrift;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.sentry.core.common.ActiveRoleSet;
import org.apache.sentry.core.common.Authorizable;
import org.apache.sentry.core.common.exception.SentryUserException;
import org.apache.sentry.core.model.solr.Collection;
import org.apache.sentry.core.model.solr.Field;
import org.apache.sentry.provider.db.generic.service.thrift.SentryGenericServiceIntegrationBase;
import org.apache.sentry.provider.db.generic.service.thrift.TAuthorizable;
import org.apache.sentry.provider.db.generic.service.thrift.TSentryGrantOption;
import org.apache.sentry.provider.db.generic.service.thrift.TSentryPrivilege;
import org.apache.sentry.provider.db.generic.service.thrift.TSentryPrivilegeMap;
import org.apache.sentry.provider.db.generic.service.thrift.TSentryRole;
import org.apache.sentry.service.thrift.SentryServiceIntegrationBase;
import org.junit.Assert;
import org.junit.Test;

public class TestSentryGenericServiceIntegration
extends SentryGenericServiceIntegrationBase {
    @Test
    public void testCreateDropShowRole() throws Exception {
        this.runTestAsSubject(new SentryServiceIntegrationBase.TestOperation(){

            @Override
            public void runTestAsSubject() throws Exception {
                String requestorUserName = "admin_user";
                HashSet requestorUserGroupNames = Sets.newHashSet((Object[])new String[]{"admin_group"});
                String roleName = "admin_r";
                TestSentryGenericServiceIntegration.this.setLocalGroupMapping(requestorUserName, requestorUserGroupNames);
                TestSentryGenericServiceIntegration.this.writePolicyFile();
                TestSentryGenericServiceIntegration.this.client.dropRoleIfExists(requestorUserName, roleName, "SOLR");
                TestSentryGenericServiceIntegration.this.client.createRole(requestorUserName, roleName, "SOLR");
                TestSentryGenericServiceIntegration.this.client.grantRoleToGroups(requestorUserName, roleName, "SOLR", (Set)Sets.newHashSet((Iterable)requestorUserGroupNames));
                Set roles = TestSentryGenericServiceIntegration.this.client.listUserRoles(requestorUserName, "SOLR");
                Assert.assertEquals((String)"Incorrect number of roles", (long)1L, (long)roles.size());
                for (TSentryRole role : roles) {
                    Assert.assertTrue((String)role.getRoleName(), (boolean)role.getRoleName().equalsIgnoreCase(roleName));
                }
                TestSentryGenericServiceIntegration.this.client.dropRole(requestorUserName, roleName, "SOLR");
            }
        });
    }

    @Test
    public void testAddDeleteRoleToGroup() throws Exception {
        this.runTestAsSubject(new SentryServiceIntegrationBase.TestOperation(){

            @Override
            public void runTestAsSubject() throws Exception {
                String requestorUserName = "admin_user";
                HashSet requestorUserGroupNames = Sets.newHashSet((Object[])new String[]{"admin_group"});
                String testGroupName = "g1";
                String roleName = "admin_r";
                TestSentryGenericServiceIntegration.this.setLocalGroupMapping(requestorUserName, requestorUserGroupNames);
                TestSentryGenericServiceIntegration.this.setLocalGroupMapping(requestorUserName, Sets.newHashSet((Object[])new String[]{testGroupName}));
                TestSentryGenericServiceIntegration.this.writePolicyFile();
                TestSentryGenericServiceIntegration.this.client.dropRoleIfExists(requestorUserName, roleName, "SOLR");
                TestSentryGenericServiceIntegration.this.client.createRole(requestorUserName, roleName, "SOLR");
                TestSentryGenericServiceIntegration.this.client.grantRoleToGroups(requestorUserName, roleName, "SOLR", (Set)Sets.newHashSet((Object[])new String[]{testGroupName}));
                Set roles = TestSentryGenericServiceIntegration.this.client.listUserRoles(requestorUserName, "SOLR");
                Assert.assertEquals((String)"Incorrect number of roles", (long)1L, (long)roles.size());
                for (TSentryRole role : roles) {
                    Assert.assertTrue((String)role.getRoleName(), (boolean)role.getRoleName().equalsIgnoreCase(roleName));
                    Assert.assertTrue((role.getGroups().size() == 1 ? 1 : 0) != 0);
                    for (String group : role.getGroups()) {
                        Assert.assertEquals((Object)testGroupName, (Object)group);
                    }
                }
                TestSentryGenericServiceIntegration.this.client.revokeRoleFromGroups(requestorUserName, roleName, "SOLR", (Set)Sets.newHashSet((Object[])new String[]{testGroupName}));
                roles = TestSentryGenericServiceIntegration.this.client.listUserRoles(requestorUserName, "SOLR");
                Assert.assertEquals((String)"Incorrect number of roles", (long)0L, (long)roles.size());
                TestSentryGenericServiceIntegration.this.client.dropRole(requestorUserName, roleName, "SOLR");
            }
        });
    }

    @Test
    public void testGranRevokePrivilege() throws Exception {
        this.runTestAsSubject(new SentryServiceIntegrationBase.TestOperation(){

            @Override
            public void runTestAsSubject() throws Exception {
                String requestorUserName = "admin_user";
                HashSet requestorUserGroupNames = Sets.newHashSet((Object[])new String[]{"admin_group"});
                TestSentryGenericServiceIntegration.this.setLocalGroupMapping(requestorUserName, requestorUserGroupNames);
                TestSentryGenericServiceIntegration.this.writePolicyFile();
                String roleName1 = "admin_r1";
                String roleName2 = "admin_r2";
                TestSentryGenericServiceIntegration.this.client.dropRoleIfExists(requestorUserName, roleName1, "SOLR");
                TestSentryGenericServiceIntegration.this.client.createRole(requestorUserName, roleName1, "SOLR");
                TestSentryGenericServiceIntegration.this.client.dropRoleIfExists(requestorUserName, roleName2, "SOLR");
                TestSentryGenericServiceIntegration.this.client.createRole(requestorUserName, roleName2, "SOLR");
                TSentryPrivilege queryPrivilege = new TSentryPrivilege("SOLR", "service1", TestSentryGenericServiceIntegration.this.fromAuthorizable(Arrays.asList(new Collection("c1"), new Field("f1"))), "query");
                TSentryPrivilege updatePrivilege = new TSentryPrivilege("SOLR", "service1", TestSentryGenericServiceIntegration.this.fromAuthorizable(Arrays.asList(new Collection("c1"), new Field("f1"))), "update");
                TestSentryGenericServiceIntegration.this.client.grantPrivilege(requestorUserName, roleName1, "SOLR", queryPrivilege);
                TestSentryGenericServiceIntegration.this.client.grantPrivilege(requestorUserName, roleName2, "SOLR", updatePrivilege);
                TestSentryGenericServiceIntegration.this.client.revokePrivilege(requestorUserName, roleName1, "SOLR", queryPrivilege);
                TestSentryGenericServiceIntegration.this.client.revokePrivilege(requestorUserName, roleName2, "SOLR", updatePrivilege);
            }
        });
    }

    @Test
    public void testMultipleRolesSamePrivilege() throws Exception {
        this.runTestAsSubject(new SentryServiceIntegrationBase.TestOperation(){

            @Override
            public void runTestAsSubject() throws Exception {
                String requestorUserName = "admin_user";
                HashSet requestorUserGroupNames = Sets.newHashSet((Object[])new String[]{"admin_group"});
                TestSentryGenericServiceIntegration.this.setLocalGroupMapping(requestorUserName, requestorUserGroupNames);
                TestSentryGenericServiceIntegration.this.writePolicyFile();
                String roleName1 = "admin_r1";
                String roleName2 = "admin_r2";
                TestSentryGenericServiceIntegration.this.client.dropRoleIfExists(requestorUserName, roleName1, "SOLR");
                TestSentryGenericServiceIntegration.this.client.createRole(requestorUserName, roleName1, "SOLR");
                TestSentryGenericServiceIntegration.this.client.dropRoleIfExists(requestorUserName, roleName2, "SOLR");
                TestSentryGenericServiceIntegration.this.client.createRole(requestorUserName, roleName2, "SOLR");
                TSentryPrivilege queryPrivilege = new TSentryPrivilege("SOLR", "service1", TestSentryGenericServiceIntegration.this.fromAuthorizable(Arrays.asList(new Collection("c1"), new Field("f1"))), "query");
                TestSentryGenericServiceIntegration.this.client.grantPrivilege(requestorUserName, roleName1, "SOLR", queryPrivilege);
                Set listPrivilegesByRoleName = TestSentryGenericServiceIntegration.this.client.listAllPrivilegesByRoleName(requestorUserName, roleName1, "SOLR", "service1");
                Assert.assertTrue((String)"Privilege not assigned to role1 !!", (listPrivilegesByRoleName.size() == 1 ? 1 : 0) != 0);
                TestSentryGenericServiceIntegration.this.client.grantPrivilege(requestorUserName, roleName2, "SOLR", queryPrivilege);
                listPrivilegesByRoleName = TestSentryGenericServiceIntegration.this.client.listAllPrivilegesByRoleName(requestorUserName, roleName2, "SOLR", "service1");
                Assert.assertTrue((String)"Privilege not assigned to role2 !!", (listPrivilegesByRoleName.size() == 1 ? 1 : 0) != 0);
            }
        });
    }

    @Test
    public void testShowRoleGrant() throws Exception {
        this.runTestAsSubject(new SentryServiceIntegrationBase.TestOperation(){

            @Override
            public void runTestAsSubject() throws Exception {
                String requestorUserName = "admin_user";
                HashSet requestorUserGroupNames = Sets.newHashSet((Object[])new String[]{"admin_group"});
                String roleName = "admin_r1";
                String groupName = "group1";
                TestSentryGenericServiceIntegration.this.setLocalGroupMapping(requestorUserName, requestorUserGroupNames);
                TestSentryGenericServiceIntegration.this.setLocalGroupMapping(requestorUserName, Sets.newHashSet((Object[])new String[]{groupName}));
                TestSentryGenericServiceIntegration.this.writePolicyFile();
                TestSentryGenericServiceIntegration.this.client.dropRoleIfExists(requestorUserName, roleName, "SOLR");
                TestSentryGenericServiceIntegration.this.client.createRole(requestorUserName, roleName, "SOLR");
                TestSentryGenericServiceIntegration.this.client.grantRoleToGroups(requestorUserName, roleName, "SOLR", (Set)Sets.newHashSet((Object[])new String[]{groupName}));
                Set groupRoles = TestSentryGenericServiceIntegration.this.client.listRolesByGroupName(requestorUserName, groupName, "SOLR");
                Assert.assertTrue((groupRoles.size() == 1 ? 1 : 0) != 0);
                for (TSentryRole role : groupRoles) {
                    Assert.assertTrue((String)role.getRoleName(), (boolean)role.getRoleName().equalsIgnoreCase(roleName));
                    Assert.assertTrue((role.getGroups().size() == 1 ? 1 : 0) != 0);
                    for (String group : role.getGroups()) {
                        Assert.assertEquals((Object)groupName, (Object)group);
                    }
                }
                TestSentryGenericServiceIntegration.this.client.dropRole(requestorUserName, roleName, "SOLR");
            }
        });
    }

    @Test
    public void testShowGrant() throws Exception {
        this.runTestAsSubject(new SentryServiceIntegrationBase.TestOperation(){

            @Override
            public void runTestAsSubject() throws Exception {
                String requestorUserName = "admin_user";
                HashSet requestorUserGroupNames = Sets.newHashSet((Object[])new String[]{"admin_group"});
                String roleName = "admin_r1";
                TestSentryGenericServiceIntegration.this.setLocalGroupMapping(requestorUserName, requestorUserGroupNames);
                TestSentryGenericServiceIntegration.this.writePolicyFile();
                TestSentryGenericServiceIntegration.this.client.dropRoleIfExists(requestorUserName, roleName, "SOLR");
                TestSentryGenericServiceIntegration.this.client.createRole(requestorUserName, roleName, "SOLR");
                TSentryPrivilege queryPrivilege = new TSentryPrivilege("SOLR", "service1", TestSentryGenericServiceIntegration.this.fromAuthorizable(Arrays.asList(new Collection("c1"), new Field("f1"))), "query");
                TSentryPrivilege updatePrivilege = new TSentryPrivilege("SOLR", "service1", TestSentryGenericServiceIntegration.this.fromAuthorizable(Arrays.asList(new Collection("c1"), new Field("f1"))), "update");
                TestSentryGenericServiceIntegration.this.client.grantPrivilege(requestorUserName, roleName, "SOLR", updatePrivilege);
                TestSentryGenericServiceIntegration.this.client.grantPrivilege(requestorUserName, roleName, "SOLR", queryPrivilege);
                Set privileges = TestSentryGenericServiceIntegration.this.client.listAllPrivilegesByRoleName(requestorUserName, roleName, "SOLR", "service1");
                Assert.assertTrue((privileges.size() == 2 ? 1 : 0) != 0);
                TestSentryGenericServiceIntegration.this.client.revokePrivilege(requestorUserName, roleName, "SOLR", updatePrivilege);
                privileges = TestSentryGenericServiceIntegration.this.client.listAllPrivilegesByRoleName(requestorUserName, roleName, "SOLR", "service1");
                Assert.assertTrue((privileges.size() == 1 ? 1 : 0) != 0);
            }
        });
    }

    @Test
    public void testSameGrantTwice() throws Exception {
        this.runTestAsSubject(new SentryServiceIntegrationBase.TestOperation(){

            @Override
            public void runTestAsSubject() throws Exception {
                String requestorUserName = "admin_user";
                HashSet requestorUserGroupNames = Sets.newHashSet((Object[])new String[]{"admin_group"});
                TestSentryGenericServiceIntegration.this.setLocalGroupMapping(requestorUserName, requestorUserGroupNames);
                TestSentryGenericServiceIntegration.this.writePolicyFile();
                String roleName = "admin_r1";
                TestSentryGenericServiceIntegration.this.client.createRole(requestorUserName, roleName, "SOLR");
                TSentryPrivilege queryPrivilege = new TSentryPrivilege("SOLR", "service1", TestSentryGenericServiceIntegration.this.fromAuthorizable(Arrays.asList(new Collection("c1"), new Field("f1"))), "query");
                TestSentryGenericServiceIntegration.this.client.grantPrivilege(requestorUserName, roleName, "SOLR", queryPrivilege);
                Assert.assertEquals((long)1L, (long)TestSentryGenericServiceIntegration.this.client.listAllPrivilegesByRoleName(requestorUserName, roleName, "SOLR", "service1").size());
            }
        });
    }

    @Test
    public void testGrantRevokeWithGrantOption() throws Exception {
        this.runTestAsSubject(new SentryServiceIntegrationBase.TestOperation(){

            @Override
            public void runTestAsSubject() throws Exception {
                String adminUser = "admin_user";
                HashSet adminGroup = Sets.newHashSet((Object[])new String[]{"admin_group"});
                String grantOptionUser = "user1";
                HashSet grantOptionGroup = Sets.newHashSet((Object[])new String[]{"group1"});
                String noGrantOptionUser = "user2";
                HashSet noGrantOptionGroup = Sets.newHashSet((Object[])new String[]{"group2"});
                TestSentryGenericServiceIntegration.this.setLocalGroupMapping(adminUser, adminGroup);
                TestSentryGenericServiceIntegration.this.setLocalGroupMapping(grantOptionUser, grantOptionGroup);
                TestSentryGenericServiceIntegration.this.setLocalGroupMapping(noGrantOptionUser, noGrantOptionGroup);
                TestSentryGenericServiceIntegration.this.writePolicyFile();
                String grantRole = "grant_r";
                String noGrantRole = "no_grant_r";
                String testRole = "test_role";
                TestSentryGenericServiceIntegration.this.client.createRole(adminUser, grantRole, "SOLR");
                TestSentryGenericServiceIntegration.this.client.createRole(adminUser, noGrantRole, "SOLR");
                TestSentryGenericServiceIntegration.this.client.createRole(adminUser, testRole, "SOLR");
                TSentryPrivilege grantPrivilege = new TSentryPrivilege("SOLR", "service1", TestSentryGenericServiceIntegration.this.fromAuthorizable(Arrays.asList(new Collection("c1"))), "query");
                grantPrivilege.setGrantOption(TSentryGrantOption.TRUE);
                TSentryPrivilege noGrantPrivilege = new TSentryPrivilege("SOLR", "service1", TestSentryGenericServiceIntegration.this.fromAuthorizable(Arrays.asList(new Collection("c1"))), "query");
                noGrantPrivilege.setGrantOption(TSentryGrantOption.FALSE);
                TSentryPrivilege testPrivilege = new TSentryPrivilege("SOLR", "service1", TestSentryGenericServiceIntegration.this.fromAuthorizable(Arrays.asList(new Collection("c1"), new Field("f1"))), "query");
                testPrivilege.setGrantOption(TSentryGrantOption.FALSE);
                TestSentryGenericServiceIntegration.this.client.grantPrivilege(adminUser, grantRole, "SOLR", grantPrivilege);
                TestSentryGenericServiceIntegration.this.client.grantPrivilege(adminUser, noGrantRole, "SOLR", noGrantPrivilege);
                TestSentryGenericServiceIntegration.this.client.grantRoleToGroups(adminUser, grantRole, "SOLR", (Set)grantOptionGroup);
                TestSentryGenericServiceIntegration.this.client.grantRoleToGroups(adminUser, noGrantRole, "SOLR", (Set)noGrantOptionGroup);
                try {
                    TestSentryGenericServiceIntegration.this.client.grantPrivilege(grantOptionUser, testRole, "SOLR", testPrivilege);
                }
                catch (SentryUserException e) {
                    Assert.fail((String)"grantOptionUser failed grant privilege to user");
                }
                try {
                    TestSentryGenericServiceIntegration.this.client.grantPrivilege(noGrantOptionUser, testRole, "SOLR", testPrivilege);
                    Assert.fail((String)"noGrantOptionUser can't grant privilege to user");
                }
                catch (SentryUserException e) {
                    // empty catch block
                }
                try {
                    TestSentryGenericServiceIntegration.this.client.revokePrivilege(grantOptionUser, testRole, "SOLR", testPrivilege);
                }
                catch (SentryUserException e) {
                    Assert.fail((String)"grantOptionUser failed revoke privilege to user");
                }
                try {
                    TestSentryGenericServiceIntegration.this.client.revokePrivilege(noGrantOptionUser, testRole, "SOLR", testPrivilege);
                    Assert.fail((String)"noGrantOptionUser can't revoke privilege to user");
                }
                catch (SentryUserException sentryUserException) {
                    // empty catch block
                }
            }
        });
    }

    @Test
    public void testGetPrivilegeByHierarchy() throws Exception {
        this.runTestAsSubject(new SentryServiceIntegrationBase.TestOperation(){

            @Override
            public void runTestAsSubject() throws Exception {
                String adminUser = "admin_user";
                HashSet adminGroup = Sets.newHashSet((Object[])new String[]{"admin_group"});
                String testRole = "role1";
                HashSet testGroup = Sets.newHashSet((Object[])new String[]{"group1"});
                String testUser = "user1";
                TestSentryGenericServiceIntegration.this.setLocalGroupMapping(adminUser, adminGroup);
                TestSentryGenericServiceIntegration.this.setLocalGroupMapping(testUser, testGroup);
                TestSentryGenericServiceIntegration.this.writePolicyFile();
                TestSentryGenericServiceIntegration.this.client.createRole(adminUser, testRole, "SOLR");
                TestSentryGenericServiceIntegration.this.client.grantRoleToGroups(adminUser, testRole, "SOLR", (Set)testGroup);
                TSentryPrivilege queryPrivilege = new TSentryPrivilege("SOLR", "service1", TestSentryGenericServiceIntegration.this.fromAuthorizable(Arrays.asList(new Collection("c1"), new Field("f1"))), "query");
                TSentryPrivilege updatePrivilege = new TSentryPrivilege("SOLR", "service1", TestSentryGenericServiceIntegration.this.fromAuthorizable(Arrays.asList(new Collection("c2"), new Field("f2"))), "update");
                TestSentryGenericServiceIntegration.this.client.grantPrivilege(adminUser, testRole, "SOLR", queryPrivilege);
                TestSentryGenericServiceIntegration.this.client.grantPrivilege(adminUser, testRole, "SOLR", updatePrivilege);
                Assert.assertEquals((long)2L, (long)TestSentryGenericServiceIntegration.this.client.listAllPrivilegesByRoleName(testUser, testRole, "SOLR", "service1").size());
                Assert.assertEquals((long)1L, (long)TestSentryGenericServiceIntegration.this.client.listPrivilegesByRoleName(testUser, testRole, "SOLR", "service1", Arrays.asList(new Collection("c1"))).size());
                Assert.assertEquals((long)1L, (long)TestSentryGenericServiceIntegration.this.client.listPrivilegesByRoleName(testUser, testRole, "SOLR", "service1", Arrays.asList(new Collection("c2"))).size());
                Assert.assertEquals((long)1L, (long)TestSentryGenericServiceIntegration.this.client.listPrivilegesByRoleName(testUser, testRole, "SOLR", "service1", Arrays.asList(new Collection("c1"), new Field("f1"))).size());
                Assert.assertEquals((long)1L, (long)TestSentryGenericServiceIntegration.this.client.listPrivilegesByRoleName(testUser, testRole, "SOLR", "service1", Arrays.asList(new Collection("c2"), new Field("f2"))).size());
                ActiveRoleSet roleSet = ActiveRoleSet.ALL;
                Assert.assertEquals((long)1L, (long)TestSentryGenericServiceIntegration.this.client.listPrivilegesForProvider("SOLR", "service1", roleSet, (Set)testGroup, Arrays.asList(new Collection("c1"))).size());
                Assert.assertEquals((long)1L, (long)TestSentryGenericServiceIntegration.this.client.listPrivilegesForProvider("SOLR", "service1", roleSet, (Set)testGroup, Arrays.asList(new Collection("c2"))).size());
                Assert.assertEquals((long)1L, (long)TestSentryGenericServiceIntegration.this.client.listPrivilegesForProvider("SOLR", "service1", roleSet, (Set)testGroup, Arrays.asList(new Collection("c1"), new Field("f1"))).size());
                Assert.assertEquals((long)1L, (long)TestSentryGenericServiceIntegration.this.client.listPrivilegesForProvider("SOLR", "service1", roleSet, (Set)testGroup, Arrays.asList(new Collection("c2"), new Field("f2"))).size());
            }
        });
    }

    @Test
    public void testGetPrivilegeByAuthorizable() throws Exception {
        this.runTestAsSubject(new SentryServiceIntegrationBase.TestOperation(){

            @Override
            public void runTestAsSubject() throws Exception {
                String adminUser = "admin_user";
                HashSet adminGroup = Sets.newHashSet((Object[])new String[]{"admin_group"});
                String testRole = "role1";
                HashSet testGroup = Sets.newHashSet((Object[])new String[]{"group1"});
                String testUser = "user1";
                TestSentryGenericServiceIntegration.this.setLocalGroupMapping(adminUser, adminGroup);
                TestSentryGenericServiceIntegration.this.setLocalGroupMapping(testUser, testGroup);
                TestSentryGenericServiceIntegration.this.writePolicyFile();
                TestSentryGenericServiceIntegration.this.client.createRole(adminUser, testRole, "SOLR");
                TestSentryGenericServiceIntegration.this.client.grantRoleToGroups(adminUser, testRole, "SOLR", (Set)adminGroup);
                TSentryPrivilege queryPrivilege = new TSentryPrivilege("SOLR", "service1", TestSentryGenericServiceIntegration.this.fromAuthorizable(Arrays.asList(new Collection("c1"), new Field("f1"))), "query");
                TSentryPrivilege updatePrivilege = new TSentryPrivilege("SOLR", "service1", TestSentryGenericServiceIntegration.this.fromAuthorizable(Arrays.asList(new Collection("c1"), new Field("f2"))), "update");
                TestSentryGenericServiceIntegration.this.client.grantPrivilege(adminUser, testRole, "SOLR", queryPrivilege);
                TestSentryGenericServiceIntegration.this.client.grantPrivilege(adminUser, testRole, "SOLR", updatePrivilege);
                Assert.assertEquals((long)1L, (long)TestSentryGenericServiceIntegration.this.client.listPrivilegesbyAuthorizable("SOLR", "service1", adminUser, (Set)Sets.newHashSet((Object[])new String[]{new String("Collection=c1->Field=f1")}), null, null).size());
                Map privilegeMap = TestSentryGenericServiceIntegration.this.client.listPrivilegesbyAuthorizable("SOLR", "service1", adminUser, (Set)Sets.newHashSet((Object[])new String[]{new String("Collection=c1->Field=f1")}), (Set)testGroup, null);
                TSentryPrivilegeMap actualMap = (TSentryPrivilegeMap)privilegeMap.get(new String("Collection=c1->Field=f1"));
                Assert.assertEquals((long)0L, (long)actualMap.getPrivilegeMap().size());
                ActiveRoleSet roleSet = ActiveRoleSet.ALL;
                Assert.assertEquals((long)1L, (long)TestSentryGenericServiceIntegration.this.client.listPrivilegesbyAuthorizable("SOLR", "service1", adminUser, (Set)Sets.newHashSet((Object[])new String[]{new String("Collection=c1->Field=f1")}), null, roleSet).size());
                privilegeMap = TestSentryGenericServiceIntegration.this.client.listPrivilegesbyAuthorizable("SOLR", "service1", adminUser, (Set)Sets.newHashSet((Object[])new String[]{new String("Collection=c1->Field=f1")}), null, roleSet);
                actualMap = (TSentryPrivilegeMap)privilegeMap.get(new String("Collection=c1->Field=f1"));
                Assert.assertEquals((long)1L, (long)actualMap.getPrivilegeMap().size());
                privilegeMap = TestSentryGenericServiceIntegration.this.client.listPrivilegesbyAuthorizable("SOLR", "service1", testUser, (Set)Sets.newHashSet((Object[])new String[]{new String("Collection=c1->Field=f1")}), null, roleSet);
                actualMap = (TSentryPrivilegeMap)privilegeMap.get(new String("Collection=c1->Field=f1"));
                Assert.assertEquals((long)0L, (long)actualMap.getPrivilegeMap().size());
                TestSentryGenericServiceIntegration.this.client.grantRoleToGroups(adminUser, testRole, "SOLR", (Set)testGroup);
                privilegeMap = TestSentryGenericServiceIntegration.this.client.listPrivilegesbyAuthorizable("SOLR", "service1", testUser, (Set)Sets.newHashSet((Object[])new String[]{new String("Collection=c1")}), null, roleSet);
                actualMap = (TSentryPrivilegeMap)privilegeMap.get(new String("Collection=c1"));
                Assert.assertEquals((long)1L, (long)actualMap.getPrivilegeMap().size());
                Assert.assertEquals((long)2L, (long)((Set)actualMap.getPrivilegeMap().get(testRole)).size());
            }
        });
    }

    @Test
    public void testDropAndRenamePrivilege() throws Exception {
        this.runTestAsSubject(new SentryServiceIntegrationBase.TestOperation(){

            @Override
            public void runTestAsSubject() throws Exception {
                String requestorUserName = "admin_user";
                HashSet requestorUserGroupNames = Sets.newHashSet((Object[])new String[]{"admin_group"});
                TestSentryGenericServiceIntegration.this.setLocalGroupMapping(requestorUserName, requestorUserGroupNames);
                TestSentryGenericServiceIntegration.this.writePolicyFile();
                String roleName = "admin_r1";
                TestSentryGenericServiceIntegration.this.client.createRole(requestorUserName, roleName, "SOLR");
                TSentryPrivilege queryPrivilege = new TSentryPrivilege("SOLR", "service1", TestSentryGenericServiceIntegration.this.fromAuthorizable(Arrays.asList(new Collection("c1"), new Field("f1"))), "query");
                TestSentryGenericServiceIntegration.this.client.grantPrivilege(requestorUserName, roleName, "SOLR", queryPrivilege);
                Assert.assertEquals((long)1L, (long)TestSentryGenericServiceIntegration.this.client.listPrivilegesByRoleName(requestorUserName, roleName, "SOLR", "service1", Arrays.asList(new Collection("c1"), new Field("f1"))).size());
                Assert.assertEquals((long)0L, (long)TestSentryGenericServiceIntegration.this.client.listPrivilegesByRoleName(requestorUserName, roleName, "SOLR", "service1", Arrays.asList(new Collection("c2"), new Field("f2"))).size());
                TestSentryGenericServiceIntegration.this.client.renamePrivilege(requestorUserName, "SOLR", "service1", Arrays.asList(new Collection("c1"), new Field("f1")), Arrays.asList(new Collection("c2"), new Field("f2")));
                Assert.assertEquals((long)0L, (long)TestSentryGenericServiceIntegration.this.client.listPrivilegesByRoleName(requestorUserName, roleName, "SOLR", "service1", Arrays.asList(new Collection("c1"), new Field("f1"))).size());
                Assert.assertEquals((long)1L, (long)TestSentryGenericServiceIntegration.this.client.listPrivilegesByRoleName(requestorUserName, roleName, "SOLR", "service1", Arrays.asList(new Collection("c2"), new Field("f2"))).size());
                TSentryPrivilege dropPrivilege = new TSentryPrivilege("SOLR", "service1", TestSentryGenericServiceIntegration.this.fromAuthorizable(Arrays.asList(new Collection("c2"), new Field("f2"))), "query");
                TestSentryGenericServiceIntegration.this.client.dropPrivilege(requestorUserName, "SOLR", dropPrivilege);
                Assert.assertEquals((long)0L, (long)TestSentryGenericServiceIntegration.this.client.listPrivilegesByRoleName(requestorUserName, roleName, "SOLR", "service1", Arrays.asList(new Collection("c2"), new Field("f2"))).size());
            }
        });
    }

    private List<TAuthorizable> fromAuthorizable(List<? extends Authorizable> authorizables) {
        ArrayList tAuthorizables = Lists.newArrayList();
        for (Authorizable authorizable : authorizables) {
            tAuthorizables.add(new TAuthorizable(authorizable.getTypeName(), authorizable.getName()));
        }
        return tAuthorizables;
    }
}

