/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.provider.db.generic.service.thrift;

import com.google.common.collect.Sets;
import java.util.HashSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.sentry.provider.db.generic.service.thrift.SentryGenericServiceIntegrationBase;
import org.apache.sentry.service.thrift.SentryServiceFactory;
import org.apache.sentry.service.thrift.SentryServiceIntegrationBase;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestSentryGenericServiceClient
extends SentryGenericServiceIntegrationBase {
    @BeforeClass
    public static void setup() throws Exception {
        TestSentryGenericServiceClient.beforeSetup();
        TestSentryGenericServiceClient.setupConf();
        TestSentryGenericServiceClient.startSentryService();
        TestSentryGenericServiceClient.afterSetup();
        kerberos = false;
    }

    @Test
    public void testConnectionWhenReconnect() throws Exception {
        this.runTestAsSubject(new SentryServiceIntegrationBase.TestOperation(){

            @Override
            public void runTestAsSubject() throws Exception {
                String requestorUserName = "admin_user";
                HashSet requestorUserGroupNames = Sets.newHashSet((Object[])new String[]{"admin_group"});
                String roleName = "admin_r";
                TestSentryGenericServiceClient.this.setLocalGroupMapping(requestorUserName, requestorUserGroupNames);
                TestSentryGenericServiceClient.this.writePolicyFile();
                TestSentryGenericServiceClient.this.client.dropRoleIfExists(requestorUserName, roleName, "solr");
                TestSentryGenericServiceClient.this.client.createRole(requestorUserName, roleName, "solr");
                TestSentryGenericServiceClient.this.stopSentryService();
                server = SentryServiceFactory.create((Configuration)conf);
                SentryServiceIntegrationBase.startSentryService();
                TestSentryGenericServiceClient.this.client.dropRole(requestorUserName, roleName, "solr");
            }
        });
    }
}

