/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.provider.db.generic.service.thrift;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.sentry.core.common.Authorizable;
import org.apache.sentry.core.common.exception.SentryAlreadyExistsException;
import org.apache.sentry.core.common.exception.SentryGrantDeniedException;
import org.apache.sentry.core.common.exception.SentryInvalidInputException;
import org.apache.sentry.core.common.exception.SentryNoSuchObjectException;
import org.apache.sentry.core.common.exception.SentrySiteConfigurationException;
import org.apache.sentry.core.model.solr.Collection;
import org.apache.sentry.core.model.solr.Field;
import org.apache.sentry.provider.common.GroupMappingService;
import org.apache.sentry.provider.db.generic.service.persistent.PrivilegeObject;
import org.apache.sentry.provider.db.generic.service.persistent.SentryStoreLayer;
import org.apache.sentry.provider.db.generic.service.thrift.SentryGenericPolicyProcessor;
import org.apache.sentry.provider.db.generic.service.thrift.TAlterSentryRoleAddGroupsRequest;
import org.apache.sentry.provider.db.generic.service.thrift.TAlterSentryRoleDeleteGroupsRequest;
import org.apache.sentry.provider.db.generic.service.thrift.TAlterSentryRoleGrantPrivilegeRequest;
import org.apache.sentry.provider.db.generic.service.thrift.TAlterSentryRoleRevokePrivilegeRequest;
import org.apache.sentry.provider.db.generic.service.thrift.TCreateSentryRoleRequest;
import org.apache.sentry.provider.db.generic.service.thrift.TDropPrivilegesRequest;
import org.apache.sentry.provider.db.generic.service.thrift.TDropSentryRoleRequest;
import org.apache.sentry.provider.db.generic.service.thrift.TListSentryPrivilegesByAuthRequest;
import org.apache.sentry.provider.db.generic.service.thrift.TListSentryPrivilegesByAuthResponse;
import org.apache.sentry.provider.db.generic.service.thrift.TListSentryPrivilegesForProviderRequest;
import org.apache.sentry.provider.db.generic.service.thrift.TListSentryPrivilegesForProviderResponse;
import org.apache.sentry.provider.db.generic.service.thrift.TListSentryPrivilegesRequest;
import org.apache.sentry.provider.db.generic.service.thrift.TListSentryPrivilegesResponse;
import org.apache.sentry.provider.db.generic.service.thrift.TListSentryRolesRequest;
import org.apache.sentry.provider.db.generic.service.thrift.TListSentryRolesResponse;
import org.apache.sentry.provider.db.generic.service.thrift.TRenamePrivilegesRequest;
import org.apache.sentry.provider.db.generic.service.thrift.TSentryActiveRoleSet;
import org.apache.sentry.provider.db.generic.service.thrift.TSentryGrantOption;
import org.apache.sentry.provider.db.generic.service.thrift.TSentryPrivilege;
import org.apache.sentry.provider.db.service.model.MSentryGMPrivilege;
import org.apache.sentry.provider.db.service.model.MSentryRole;
import org.apache.sentry.service.thrift.Status;
import org.apache.sentry.service.thrift.TSentryResponseStatus;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class TestSentryGenericPolicyProcessor
extends Assert {
    private static final String ADMIN_GROUP = "admin_group";
    private static final String ADMIN_USER = "admin_user";
    private SentryStoreLayer mockStore = (SentryStoreLayer)Mockito.mock(SentryStoreLayer.class);
    private SentryGenericPolicyProcessor processor;

    @Before
    public void setup() throws Exception {
        Configuration conf = new Configuration();
        conf.set("sentry.service.admin.group", ADMIN_GROUP);
        conf.set("sentry.store.group.mapping", MockGroupMapping.class.getName());
        this.processor = new SentryGenericPolicyProcessor(conf, this.mockStore);
    }

    @Test
    public void testNotAdminOperation() throws Exception {
        String requestUser = "not_admin_user";
        Status validateStatus = Status.ACCESS_DENIED;
        this.testOperation(requestUser, validateStatus);
    }

    private void testOperation(String requestUser, Status validateStatus) throws Exception {
        TCreateSentryRoleRequest createrequest = new TCreateSentryRoleRequest();
        createrequest.setRequestorUserName(requestUser);
        createrequest.setRoleName("r1");
        TestSentryGenericPolicyProcessor.assertEquals((Object)validateStatus, (Object)this.fromTSentryStatus(this.processor.create_sentry_role(createrequest).getStatus()));
        TDropSentryRoleRequest dropRequest = new TDropSentryRoleRequest();
        dropRequest.setRequestorUserName(requestUser);
        dropRequest.setRoleName("r1");
        TestSentryGenericPolicyProcessor.assertEquals((Object)validateStatus, (Object)this.fromTSentryStatus(this.processor.drop_sentry_role(dropRequest).getStatus()));
        TAlterSentryRoleAddGroupsRequest addRequest = new TAlterSentryRoleAddGroupsRequest();
        addRequest.setRequestorUserName(requestUser);
        addRequest.setRoleName("r1");
        addRequest.setGroups((Set)Sets.newHashSet((Object[])new String[]{"g1"}));
        TestSentryGenericPolicyProcessor.assertEquals((Object)validateStatus, (Object)this.fromTSentryStatus(this.processor.alter_sentry_role_add_groups(addRequest).getStatus()));
        TAlterSentryRoleDeleteGroupsRequest delRequest = new TAlterSentryRoleDeleteGroupsRequest();
        delRequest.setRequestorUserName(requestUser);
        delRequest.setRoleName("r1");
        delRequest.setGroups((Set)Sets.newHashSet((Object[])new String[]{"g1"}));
        TestSentryGenericPolicyProcessor.assertEquals((Object)validateStatus, (Object)this.fromTSentryStatus(this.processor.alter_sentry_role_delete_groups(delRequest).getStatus()));
        TDropPrivilegesRequest dropPrivRequest = new TDropPrivilegesRequest();
        dropPrivRequest.setRequestorUserName(requestUser);
        dropPrivRequest.setPrivilege(new TSentryPrivilege("test", "test", new ArrayList(), "test"));
        TestSentryGenericPolicyProcessor.assertEquals((Object)validateStatus, (Object)this.fromTSentryStatus(this.processor.drop_sentry_privilege(dropPrivRequest).getStatus()));
        TRenamePrivilegesRequest renameRequest = new TRenamePrivilegesRequest();
        renameRequest.setRequestorUserName(requestUser);
        TestSentryGenericPolicyProcessor.assertEquals((Object)validateStatus, (Object)this.fromTSentryStatus(this.processor.rename_sentry_privilege(renameRequest).getStatus()));
    }

    private Status fromTSentryStatus(TSentryResponseStatus status) {
        return Status.fromCode((int)status.getValue());
    }

    @Test
    public void testAdminOperation() throws Exception {
        this.testOperation(ADMIN_USER, Status.OK);
    }

    @Test
    public void testGrantAndRevokePrivilege() throws Exception {
        this.setup();
        TSentryPrivilege tprivilege = new TSentryPrivilege("test", "test", new ArrayList(), "test");
        tprivilege.setGrantOption(TSentryGrantOption.UNSET);
        TAlterSentryRoleGrantPrivilegeRequest grantRequest = new TAlterSentryRoleGrantPrivilegeRequest();
        grantRequest.setRequestorUserName(ADMIN_USER);
        grantRequest.setRoleName("r1");
        grantRequest.setPrivilege(tprivilege);
        TestSentryGenericPolicyProcessor.assertEquals((Object)Status.OK, (Object)this.fromTSentryStatus(this.processor.alter_sentry_role_grant_privilege(grantRequest).getStatus()));
        TAlterSentryRoleRevokePrivilegeRequest revokeRequest = new TAlterSentryRoleRevokePrivilegeRequest();
        revokeRequest.setRequestorUserName(ADMIN_USER);
        revokeRequest.setRoleName("r1");
        revokeRequest.setPrivilege(tprivilege);
        TestSentryGenericPolicyProcessor.assertEquals((Object)Status.OK, (Object)this.fromTSentryStatus(this.processor.alter_sentry_role_revoke_privilege(revokeRequest).getStatus()));
    }

    @Test
    public void testOperationWithException() throws Exception {
        String roleName = Matchers.anyString();
        Mockito.when((Object)this.mockStore.createRole(Matchers.anyString(), roleName, Matchers.anyString())).thenThrow(new Throwable[]{new SentryAlreadyExistsException("Role: " + roleName)});
        roleName = Matchers.anyString();
        Mockito.when((Object)this.mockStore.dropRole(Matchers.anyString(), roleName, Matchers.anyString())).thenThrow(new Throwable[]{new SentryNoSuchObjectException("Role: " + roleName)});
        roleName = Matchers.anyString();
        Mockito.when((Object)this.mockStore.alterRoleAddGroups(Matchers.anyString(), roleName, Matchers.anySetOf(String.class), Matchers.anyString())).thenThrow(new Throwable[]{new SentryNoSuchObjectException("Role: " + roleName)});
        roleName = Matchers.anyString();
        Mockito.when((Object)this.mockStore.alterRoleDeleteGroups(Matchers.anyString(), roleName, Matchers.anySetOf(String.class), Matchers.anyString())).thenThrow(new Throwable[]{new SentryNoSuchObjectException("Role: " + roleName)});
        roleName = Matchers.anyString();
        Mockito.when((Object)this.mockStore.alterRoleGrantPrivilege(Matchers.anyString(), roleName, (PrivilegeObject)Matchers.any(PrivilegeObject.class), Matchers.anyString())).thenThrow(new Throwable[]{new SentryGrantDeniedException("Role: " + roleName + " is not allowed to do grant")});
        roleName = Matchers.anyString();
        Mockito.when((Object)this.mockStore.alterRoleRevokePrivilege(Matchers.anyString(), roleName, (PrivilegeObject)Matchers.any(PrivilegeObject.class), Matchers.anyString())).thenThrow(new Throwable[]{new SentryGrantDeniedException("Role: " + roleName + " is not allowed to do grant")});
        Mockito.when((Object)this.mockStore.dropPrivilege(Matchers.anyString(), (PrivilegeObject)Matchers.any(PrivilegeObject.class), Matchers.anyString())).thenThrow(new Throwable[]{new SentryInvalidInputException("Invalid input privilege object")});
        Mockito.when((Object)this.mockStore.renamePrivilege(Matchers.anyString(), Matchers.anyString(), Matchers.anyListOf(Authorizable.class), Matchers.anyListOf(Authorizable.class), Matchers.anyString())).thenThrow(new Throwable[]{new RuntimeException("Unknown error")});
        this.setup();
        TCreateSentryRoleRequest createrequest = new TCreateSentryRoleRequest();
        createrequest.setRequestorUserName(ADMIN_USER);
        createrequest.setRoleName("r1");
        TestSentryGenericPolicyProcessor.assertEquals((Object)Status.ALREADY_EXISTS, (Object)this.fromTSentryStatus(this.processor.create_sentry_role(createrequest).getStatus()));
        TDropSentryRoleRequest dropRequest = new TDropSentryRoleRequest();
        dropRequest.setRequestorUserName(ADMIN_USER);
        dropRequest.setRoleName("r1");
        TestSentryGenericPolicyProcessor.assertEquals((Object)Status.NO_SUCH_OBJECT, (Object)this.fromTSentryStatus(this.processor.drop_sentry_role(dropRequest).getStatus()));
        TAlterSentryRoleAddGroupsRequest addRequest = new TAlterSentryRoleAddGroupsRequest();
        addRequest.setRequestorUserName(ADMIN_USER);
        addRequest.setRoleName("r1");
        addRequest.setGroups((Set)Sets.newHashSet((Object[])new String[]{"g1"}));
        TestSentryGenericPolicyProcessor.assertEquals((Object)Status.NO_SUCH_OBJECT, (Object)this.fromTSentryStatus(this.processor.alter_sentry_role_add_groups(addRequest).getStatus()));
        TAlterSentryRoleDeleteGroupsRequest delRequest = new TAlterSentryRoleDeleteGroupsRequest();
        delRequest.setRequestorUserName(ADMIN_USER);
        delRequest.setRoleName("r1");
        delRequest.setGroups((Set)Sets.newHashSet((Object[])new String[]{"g1"}));
        TestSentryGenericPolicyProcessor.assertEquals((Object)Status.NO_SUCH_OBJECT, (Object)this.fromTSentryStatus(this.processor.alter_sentry_role_delete_groups(delRequest).getStatus()));
        TDropPrivilegesRequest dropPrivRequest = new TDropPrivilegesRequest();
        dropPrivRequest.setRequestorUserName(ADMIN_USER);
        dropPrivRequest.setPrivilege(new TSentryPrivilege("test", "test", new ArrayList(), "test"));
        TestSentryGenericPolicyProcessor.assertEquals((Object)Status.INVALID_INPUT, (Object)this.fromTSentryStatus(this.processor.drop_sentry_privilege(dropPrivRequest).getStatus()));
        TRenamePrivilegesRequest renameRequest = new TRenamePrivilegesRequest();
        renameRequest.setRequestorUserName(ADMIN_USER);
        TestSentryGenericPolicyProcessor.assertEquals((Object)Status.RUNTIME_ERROR, (Object)this.fromTSentryStatus(this.processor.rename_sentry_privilege(renameRequest).getStatus()));
        TSentryPrivilege tprivilege = new TSentryPrivilege("test", "test", new ArrayList(), "test");
        tprivilege.setGrantOption(TSentryGrantOption.UNSET);
        TAlterSentryRoleGrantPrivilegeRequest grantRequest = new TAlterSentryRoleGrantPrivilegeRequest();
        grantRequest.setRequestorUserName(ADMIN_USER);
        grantRequest.setRoleName("r1");
        grantRequest.setPrivilege(tprivilege);
        TestSentryGenericPolicyProcessor.assertEquals((Object)Status.ACCESS_DENIED, (Object)this.fromTSentryStatus(this.processor.alter_sentry_role_grant_privilege(grantRequest).getStatus()));
        TAlterSentryRoleRevokePrivilegeRequest revokeRequest = new TAlterSentryRoleRevokePrivilegeRequest();
        revokeRequest.setRequestorUserName(ADMIN_USER);
        revokeRequest.setRoleName("r1");
        revokeRequest.setPrivilege(tprivilege);
        TestSentryGenericPolicyProcessor.assertEquals((Object)Status.ACCESS_DENIED, (Object)this.fromTSentryStatus(this.processor.alter_sentry_role_revoke_privilege(revokeRequest).getStatus()));
    }

    @Test
    public void testGetRolesAndPrivileges() throws Exception {
        String roleName = "r1";
        String groupName = "g1";
        PrivilegeObject queryPrivilege = new PrivilegeObject.Builder().setComponent("SOLR").setAction("query").setService("service1").setAuthorizables(Arrays.asList(new Collection("c1"), new Field("f1"))).build();
        PrivilegeObject updatePrivilege = new PrivilegeObject.Builder(queryPrivilege).setAction("update").build();
        MSentryGMPrivilege mSentryGMPrivilege = new MSentryGMPrivilege("SOLR", "service1", Arrays.asList(new Collection("c1"), new Field("f1")), "query", Boolean.valueOf(true));
        MSentryRole role = new MSentryRole("r1", 290L);
        mSentryGMPrivilege.setRoles((Set)Sets.newHashSet((Object[])new MSentryRole[]{role}));
        Mockito.when((Object)this.mockStore.getRolesByGroups(Matchers.anyString(), Matchers.anySetOf(String.class))).thenReturn((Object)Sets.newHashSet((Object[])new String[]{roleName}));
        Mockito.when((Object)this.mockStore.getPrivilegesByProvider(Matchers.anyString(), Matchers.anyString(), Matchers.anySetOf(String.class), Matchers.anySetOf(String.class), Matchers.anyListOf(Authorizable.class))).thenReturn((Object)Sets.newHashSet((Object[])new PrivilegeObject[]{queryPrivilege, updatePrivilege}));
        Mockito.when((Object)this.mockStore.getGroupsByRoles(Matchers.anyString(), Matchers.anySetOf(String.class))).thenReturn((Object)Sets.newHashSet((Object[])new String[]{groupName}));
        Mockito.when((Object)this.mockStore.getPrivilegesByAuthorizable(Matchers.anyString(), Matchers.anyString(), Matchers.anySetOf(String.class), Matchers.anyListOf(Authorizable.class))).thenReturn((Object)Sets.newHashSet((Object[])new MSentryGMPrivilege[]{mSentryGMPrivilege}));
        Mockito.when((Object)this.mockStore.getAllRoleNames()).thenReturn((Object)Sets.newHashSet((Object[])new String[]{roleName}));
        TListSentryPrivilegesRequest request1 = new TListSentryPrivilegesRequest();
        request1.setRoleName(roleName);
        request1.setRequestorUserName(ADMIN_USER);
        TListSentryPrivilegesResponse response1 = this.processor.list_sentry_privileges_by_role(request1);
        TestSentryGenericPolicyProcessor.assertEquals((Object)Status.OK, (Object)this.fromTSentryStatus(response1.getStatus()));
        TestSentryGenericPolicyProcessor.assertEquals((long)2L, (long)response1.getPrivileges().size());
        TListSentryRolesRequest request2 = new TListSentryRolesRequest();
        request2.setRequestorUserName(ADMIN_USER);
        request2.setGroupName(groupName);
        TListSentryRolesResponse response2 = this.processor.list_sentry_roles_by_group(request2);
        TestSentryGenericPolicyProcessor.assertEquals((Object)Status.OK, (Object)this.fromTSentryStatus(response2.getStatus()));
        TestSentryGenericPolicyProcessor.assertEquals((long)1L, (long)response2.getRoles().size());
        TListSentryPrivilegesForProviderRequest request3 = new TListSentryPrivilegesForProviderRequest();
        request3.setGroups((Set)Sets.newHashSet((Object[])new String[]{groupName}));
        request3.setRoleSet(new TSentryActiveRoleSet(true, null));
        TListSentryPrivilegesForProviderResponse response3 = this.processor.list_sentry_privileges_for_provider(request3);
        TestSentryGenericPolicyProcessor.assertEquals((Object)Status.OK, (Object)this.fromTSentryStatus(response3.getStatus()));
        TestSentryGenericPolicyProcessor.assertEquals((long)2L, (long)response3.getPrivileges().size());
        TListSentryPrivilegesByAuthRequest request4 = new TListSentryPrivilegesByAuthRequest();
        request4.setGroups((Set)Sets.newHashSet((Object[])new String[]{groupName}));
        request4.setRoleSet(new TSentryActiveRoleSet(true, null));
        request4.setRequestorUserName(ADMIN_USER);
        HashSet authorizablesSet = Sets.newHashSet((Object[])new String[]{"Collection=c1->Field=f1"});
        request4.setAuthorizablesSet((Set)authorizablesSet);
        TListSentryPrivilegesByAuthResponse response4 = this.processor.list_sentry_privileges_by_authorizable(request4);
        TestSentryGenericPolicyProcessor.assertEquals((Object)Status.OK, (Object)this.fromTSentryStatus(response4.getStatus()));
        TestSentryGenericPolicyProcessor.assertEquals((long)1L, (long)response4.getPrivilegesMapByAuth().size());
        TListSentryPrivilegesByAuthRequest request5 = new TListSentryPrivilegesByAuthRequest();
        request5.setRequestorUserName("not_admin_user");
        authorizablesSet = Sets.newHashSet((Object[])new String[]{"Collection=c1->Field=f2"});
        request5.setAuthorizablesSet((Set)authorizablesSet);
        TListSentryPrivilegesByAuthResponse response5 = this.processor.list_sentry_privileges_by_authorizable(request5);
        TestSentryGenericPolicyProcessor.assertEquals((Object)Status.OK, (Object)this.fromTSentryStatus(response5.getStatus()));
        TestSentryGenericPolicyProcessor.assertEquals((long)1L, (long)response5.getPrivilegesMapByAuth().size());
    }

    @Test(expected=SentrySiteConfigurationException.class)
    public void testConfigCannotCreateNotificationHandler() throws Exception {
        Configuration conf = new Configuration();
        conf.set("sentry.generic.policy.notification", "junk");
        SentryGenericPolicyProcessor.createHandlers((Configuration)conf);
    }

    public static class MockGroupMapping
    implements GroupMappingService {
        public MockGroupMapping(Configuration conf, String resource) {
        }

        public Set<String> getGroups(String user) {
            if (user.equalsIgnoreCase(TestSentryGenericPolicyProcessor.ADMIN_USER)) {
                return Sets.newHashSet((Object[])new String[]{TestSentryGenericPolicyProcessor.ADMIN_GROUP});
            }
            return Sets.newHashSet((Object[])new String[]{"notadmin_group"});
        }
    }
}

