/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.provider.db.generic.service.thrift;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.log4j.Appender;
import org.apache.log4j.Level;
import org.apache.sentry.provider.db.generic.service.thrift.SentryGenericServiceClient;
import org.apache.sentry.provider.db.generic.service.thrift.SentryGenericServiceClientFactory;
import org.apache.sentry.provider.db.generic.service.thrift.TAuthorizable;
import org.apache.sentry.provider.db.generic.service.thrift.TSentryPrivilege;
import org.apache.sentry.provider.db.generic.service.thrift.TSentryRole;
import org.apache.sentry.provider.db.log.appender.AuditLoggerTestAppender;
import org.apache.sentry.provider.db.log.util.CommandUtil;
import org.apache.sentry.service.thrift.SentryServiceIntegrationBase;
import org.codehaus.jettison.json.JSONObject;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.After;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestAuditLogForSentryGenericService
extends SentryServiceIntegrationBase {
    private SentryGenericServiceClient client;
    private static final String COMPONENT = "SQOOP";
    private static final Logger LOGGER = LoggerFactory.getLogger(TestAuditLogForSentryGenericService.class);

    @BeforeClass
    public static void setup() throws Exception {
        SentryServiceIntegrationBase.setup();
        org.apache.log4j.Logger logger = org.apache.log4j.Logger.getLogger((String)"sentry.generic.authorization.ddl.logger");
        AuditLoggerTestAppender testAppender = new AuditLoggerTestAppender();
        logger.addAppender((Appender)testAppender);
        logger.setLevel(Level.INFO);
    }

    @Override
    @After
    public void after() {
        try {
            this.runTestAsSubject(new SentryServiceIntegrationBase.TestOperation(){

                @Override
                public void runTestAsSubject() throws Exception {
                    Set tRoles = TestAuditLogForSentryGenericService.this.client.listAllRoles("admin_user", TestAuditLogForSentryGenericService.COMPONENT);
                    for (TSentryRole tRole : tRoles) {
                        TestAuditLogForSentryGenericService.this.client.dropRole("admin_user", tRole.getRoleName(), TestAuditLogForSentryGenericService.COMPONENT);
                    }
                    if (TestAuditLogForSentryGenericService.this.client != null) {
                        TestAuditLogForSentryGenericService.this.client.close();
                    }
                }
            });
        }
        catch (Exception e) {
            LOGGER.warn("Exception happened after test case.", (Throwable)e);
        }
        finally {
            this.policyFilePath.delete();
        }
    }

    @Override
    public void connectToSentryService() throws Exception {
        this.client = kerberos ? (SentryGenericServiceClient)clientUgi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<SentryGenericServiceClient>(){

            @Override
            public SentryGenericServiceClient run() throws Exception {
                return SentryGenericServiceClientFactory.create((Configuration)conf);
            }
        }) : SentryGenericServiceClientFactory.create((Configuration)conf);
    }

    @Test
    public void testAuditLogForGenericModel() throws Exception {
        this.runTestAsSubject(new SentryServiceIntegrationBase.TestOperation(){

            @Override
            public void runTestAsSubject() throws Exception {
                String requestorUserName = "admin_user";
                HashSet requestorUserGroupNames = Sets.newHashSet((Object[])new String[]{"admin_group"});
                String roleName = "admin_r";
                String testGroupName = "g1";
                String action = "all";
                String service = "sentryService";
                TestAuditLogForSentryGenericService.this.setLocalGroupMapping(requestorUserName, requestorUserGroupNames);
                TestAuditLogForSentryGenericService.this.writePolicyFile();
                TestAuditLogForSentryGenericService.this.client.createRole(requestorUserName, roleName, TestAuditLogForSentryGenericService.COMPONENT);
                HashMap<String, String> fieldValueMap = new HashMap<String, String>();
                fieldValueMap.put("operation", "CREATE_ROLE");
                fieldValueMap.put("component", TestAuditLogForSentryGenericService.COMPONENT);
                fieldValueMap.put("operationText", "CREATE ROLE " + roleName);
                fieldValueMap.put("allowed", "true");
                fieldValueMap.put("ipAddress", null);
                TestAuditLogForSentryGenericService.this.assertAuditLog(fieldValueMap);
                try {
                    TestAuditLogForSentryGenericService.this.client.createRole(requestorUserName, roleName, TestAuditLogForSentryGenericService.COMPONENT);
                    Assert.fail((String)"Exception should have been thrown");
                }
                catch (Exception e) {
                    fieldValueMap.clear();
                    fieldValueMap.put("operation", "CREATE_ROLE");
                    fieldValueMap.put("component", TestAuditLogForSentryGenericService.COMPONENT);
                    fieldValueMap.put("operationText", "CREATE ROLE " + roleName);
                    fieldValueMap.put("allowed", "false");
                    fieldValueMap.put("ipAddress", null);
                    TestAuditLogForSentryGenericService.this.assertAuditLog(fieldValueMap);
                }
                TestAuditLogForSentryGenericService.this.client.grantRoleToGroups(requestorUserName, roleName, TestAuditLogForSentryGenericService.COMPONENT, (Set)Sets.newHashSet((Object[])new String[]{testGroupName}));
                fieldValueMap.clear();
                fieldValueMap.put("operation", "ADD_ROLE_TO_GROUP");
                fieldValueMap.put("component", TestAuditLogForSentryGenericService.COMPONENT);
                fieldValueMap.put("operationText", "GRANT ROLE " + roleName + " TO GROUP " + testGroupName);
                fieldValueMap.put("allowed", "true");
                fieldValueMap.put("ipAddress", null);
                TestAuditLogForSentryGenericService.this.assertAuditLog(fieldValueMap);
                try {
                    TestAuditLogForSentryGenericService.this.client.grantRoleToGroups(requestorUserName, "invalidRole", TestAuditLogForSentryGenericService.COMPONENT, (Set)Sets.newHashSet((Object[])new String[]{testGroupName}));
                    Assert.fail((String)"Exception should have been thrown");
                }
                catch (Exception e) {
                    fieldValueMap.clear();
                    fieldValueMap.put("operation", "ADD_ROLE_TO_GROUP");
                    fieldValueMap.put("component", TestAuditLogForSentryGenericService.COMPONENT);
                    fieldValueMap.put("operationText", "GRANT ROLE invalidRole TO GROUP " + testGroupName);
                    fieldValueMap.put("allowed", "false");
                    fieldValueMap.put("ipAddress", null);
                    TestAuditLogForSentryGenericService.this.assertAuditLog(fieldValueMap);
                }
                TSentryPrivilege privilege = new TSentryPrivilege(TestAuditLogForSentryGenericService.COMPONENT, service, (List)Lists.newArrayList((Object[])new TAuthorizable[]{new TAuthorizable("resourceType1", "resourceName1"), new TAuthorizable("resourceType2", "resourceName2")}), action);
                TestAuditLogForSentryGenericService.this.client.grantPrivilege(requestorUserName, roleName, TestAuditLogForSentryGenericService.COMPONENT, privilege);
                fieldValueMap.clear();
                fieldValueMap.put("operation", "GRANT_PRIVILEGE");
                fieldValueMap.put("component", TestAuditLogForSentryGenericService.COMPONENT);
                fieldValueMap.put("operationText", "GRANT ALL ON resourceType1 resourceName1 resourceType2 resourceName2 TO ROLE " + roleName);
                fieldValueMap.put("allowed", "true");
                fieldValueMap.put("ipAddress", null);
                TestAuditLogForSentryGenericService.this.assertAuditLog(fieldValueMap);
                TSentryPrivilege invalidPrivilege = new TSentryPrivilege(TestAuditLogForSentryGenericService.COMPONENT, service, (List)Lists.newArrayList((Object[])new TAuthorizable[]{new TAuthorizable("resourceType1", "resourceName1")}), "invalidAction");
                try {
                    TestAuditLogForSentryGenericService.this.client.grantPrivilege(requestorUserName, roleName, TestAuditLogForSentryGenericService.COMPONENT, invalidPrivilege);
                    Assert.fail((String)"Exception should have been thrown");
                }
                catch (Exception e) {
                    fieldValueMap.clear();
                    fieldValueMap.put("operation", "GRANT_PRIVILEGE");
                    fieldValueMap.put("component", TestAuditLogForSentryGenericService.COMPONENT);
                    fieldValueMap.put("operationText", "GRANT INVALIDACTION ON resourceType1 resourceName1 TO ROLE " + roleName);
                    fieldValueMap.put("allowed", "false");
                    fieldValueMap.put("ipAddress", null);
                    TestAuditLogForSentryGenericService.this.assertAuditLog(fieldValueMap);
                }
                TestAuditLogForSentryGenericService.this.client.revokePrivilege(requestorUserName, roleName, TestAuditLogForSentryGenericService.COMPONENT, privilege);
                fieldValueMap.clear();
                fieldValueMap.put("operation", "REVOKE_PRIVILEGE");
                fieldValueMap.put("component", TestAuditLogForSentryGenericService.COMPONENT);
                fieldValueMap.put("operationText", "REVOKE ALL ON resourceType1 resourceName1 resourceType2 resourceName2 FROM ROLE " + roleName);
                fieldValueMap.put("allowed", "true");
                fieldValueMap.put("ipAddress", null);
                TestAuditLogForSentryGenericService.this.assertAuditLog(fieldValueMap);
                try {
                    TestAuditLogForSentryGenericService.this.client.revokePrivilege(requestorUserName, "invalidRole", TestAuditLogForSentryGenericService.COMPONENT, invalidPrivilege);
                    Assert.fail((String)"Exception should have been thrown");
                }
                catch (Exception e) {
                    fieldValueMap.clear();
                    fieldValueMap.put("operation", "REVOKE_PRIVILEGE");
                    fieldValueMap.put("component", TestAuditLogForSentryGenericService.COMPONENT);
                    fieldValueMap.put("operationText", "REVOKE INVALIDACTION ON resourceType1 resourceName1 FROM ROLE invalidRole");
                    fieldValueMap.put("allowed", "false");
                    fieldValueMap.put("ipAddress", null);
                    TestAuditLogForSentryGenericService.this.assertAuditLog(fieldValueMap);
                }
                TestAuditLogForSentryGenericService.this.client.revokeRoleFromGroups(requestorUserName, roleName, TestAuditLogForSentryGenericService.COMPONENT, (Set)Sets.newHashSet((Object[])new String[]{testGroupName}));
                fieldValueMap.clear();
                fieldValueMap.put("operation", "DELETE_ROLE_FROM_GROUP");
                fieldValueMap.put("component", TestAuditLogForSentryGenericService.COMPONENT);
                fieldValueMap.put("operationText", "REVOKE ROLE " + roleName + " FROM GROUP " + testGroupName);
                fieldValueMap.put("allowed", "true");
                fieldValueMap.put("ipAddress", null);
                TestAuditLogForSentryGenericService.this.assertAuditLog(fieldValueMap);
                try {
                    TestAuditLogForSentryGenericService.this.client.revokeRoleFromGroups(requestorUserName, "invalidRole", TestAuditLogForSentryGenericService.COMPONENT, (Set)Sets.newHashSet((Object[])new String[]{testGroupName}));
                    Assert.fail((String)"Exception should have been thrown");
                }
                catch (Exception e) {
                    fieldValueMap.clear();
                    fieldValueMap.put("operation", "DELETE_ROLE_FROM_GROUP");
                    fieldValueMap.put("component", TestAuditLogForSentryGenericService.COMPONENT);
                    fieldValueMap.put("operationText", "REVOKE ROLE invalidRole FROM GROUP " + testGroupName);
                    fieldValueMap.put("allowed", "false");
                    fieldValueMap.put("ipAddress", null);
                    TestAuditLogForSentryGenericService.this.assertAuditLog(fieldValueMap);
                }
                TestAuditLogForSentryGenericService.this.client.dropRole(requestorUserName, roleName, TestAuditLogForSentryGenericService.COMPONENT);
                fieldValueMap.clear();
                fieldValueMap.put("operation", "DROP_ROLE");
                fieldValueMap.put("component", TestAuditLogForSentryGenericService.COMPONENT);
                fieldValueMap.put("operationText", "DROP ROLE " + roleName);
                fieldValueMap.put("allowed", "true");
                fieldValueMap.put("ipAddress", null);
                TestAuditLogForSentryGenericService.this.assertAuditLog(fieldValueMap);
                try {
                    TestAuditLogForSentryGenericService.this.client.dropRole(requestorUserName, roleName, TestAuditLogForSentryGenericService.COMPONENT);
                    Assert.fail((String)"Exception should have been thrown");
                }
                catch (Exception e) {
                    fieldValueMap.clear();
                    fieldValueMap.put("operation", "DROP_ROLE");
                    fieldValueMap.put("component", TestAuditLogForSentryGenericService.COMPONENT);
                    fieldValueMap.put("operationText", "DROP ROLE " + roleName);
                    fieldValueMap.put("allowed", "false");
                    fieldValueMap.put("ipAddress", null);
                    TestAuditLogForSentryGenericService.this.assertAuditLog(fieldValueMap);
                }
            }
        });
    }

    private void assertAuditLog(Map<String, String> fieldValueMap) throws Exception {
        Assert.assertThat((Object)AuditLoggerTestAppender.getLastLogLevel(), (Matcher)Is.is((Object)Level.INFO));
        JSONObject jsonObject = new JSONObject(AuditLoggerTestAppender.getLastLogEvent());
        if (fieldValueMap != null) {
            for (Map.Entry<String, String> entry : fieldValueMap.entrySet()) {
                String entryKey = entry.getKey();
                if ("ipAddress".equals(entryKey)) {
                    Assert.assertTrue((boolean)CommandUtil.assertIPInAuditLog((String)jsonObject.get(entryKey).toString()));
                    continue;
                }
                Assert.assertTrue((boolean)entry.getValue().equalsIgnoreCase(jsonObject.get(entryKey).toString()));
            }
        }
    }
}

