/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.provider.db.generic.service.thrift;

import java.security.PrivilegedExceptionAction;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.sentry.provider.db.generic.service.thrift.SentryGenericServiceClient;
import org.apache.sentry.provider.db.generic.service.thrift.SentryGenericServiceClientFactory;
import org.apache.sentry.provider.db.generic.service.thrift.TSentryRole;
import org.apache.sentry.service.thrift.SentryServiceIntegrationBase;
import org.junit.After;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SentryGenericServiceIntegrationBase
extends SentryServiceIntegrationBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(SentryGenericServiceIntegrationBase.class);
    protected static final String SOLR = "SOLR";
    protected SentryGenericServiceClient client;

    @Override
    public void connectToSentryService() throws Exception {
        this.client = kerberos ? (SentryGenericServiceClient)clientUgi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<SentryGenericServiceClient>(){

            @Override
            public SentryGenericServiceClient run() throws Exception {
                return SentryGenericServiceClientFactory.create((Configuration)conf);
            }
        }) : SentryGenericServiceClientFactory.create((Configuration)conf);
    }

    @Override
    @After
    public void after() {
        try {
            this.runTestAsSubject(new SentryServiceIntegrationBase.TestOperation(){

                @Override
                public void runTestAsSubject() throws Exception {
                    Set tRoles = SentryGenericServiceIntegrationBase.this.client.listAllRoles("admin_user", SentryGenericServiceIntegrationBase.SOLR);
                    for (TSentryRole tRole : tRoles) {
                        SentryGenericServiceIntegrationBase.this.client.dropRole("admin_user", tRole.getRoleName(), SentryGenericServiceIntegrationBase.SOLR);
                    }
                    if (SentryGenericServiceIntegrationBase.this.client != null) {
                        SentryGenericServiceIntegrationBase.this.client.close();
                    }
                }
            });
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        finally {
            this.policyFilePath.delete();
        }
    }
}

