/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.provider.db.generic.service.persistent;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import org.apache.sentry.core.common.exception.SentryAlreadyExistsException;
import org.apache.sentry.core.common.exception.SentryNoSuchObjectException;
import org.apache.sentry.provider.db.generic.service.persistent.SentryStoreIntegrationBase;
import org.apache.sentry.provider.file.PolicyFile;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestDelegateSentryStore
extends SentryStoreIntegrationBase {
    private static final String SEARCH = "solr";

    @Before
    public void configure() throws Exception {
        policyFile = new PolicyFile();
        TestDelegateSentryStore.addGroupsToUser("admin", this.getAdminGroups());
        TestDelegateSentryStore.writePolicyFile();
    }

    @Test
    public void testCreateDropRole() throws Exception {
        String roleName = "test-drop-role";
        String grantor = "grantor";
        sentryStore.createRole(SEARCH, roleName, grantor);
        sentryStore.dropRole(SEARCH, roleName, grantor);
    }

    @Test
    public void testCaseInsensitiveCreateDropRole() throws Exception {
        String roleName1 = "test";
        String roleName2 = "TeSt";
        String grantor = "grantor";
        sentryStore.createRole(SEARCH, roleName1, grantor);
        try {
            sentryStore.createRole(SEARCH, roleName2, grantor);
            Assert.fail((String)"Fail to throw Exception");
        }
        catch (SentryAlreadyExistsException sentryAlreadyExistsException) {
            // empty catch block
        }
        try {
            sentryStore.dropRole(SEARCH, roleName2, grantor);
        }
        catch (SentryNoSuchObjectException e) {
            Assert.fail((String)"Shouldn't throw SentryNoSuchObjectException");
        }
    }

    @Test(expected=Exception.class)
    public void testCreateDuplicateRole() throws Exception {
        String roleName = "test-dup-role";
        String grantor = "grantor";
        sentryStore.createRole(SEARCH, roleName, grantor);
        sentryStore.createRole(SEARCH, roleName, grantor);
    }

    @Test(expected=SentryNoSuchObjectException.class)
    public void testDropNotExistRole() throws Exception {
        String roleName = "not-exist";
        String grantor = "grantor";
        sentryStore.dropRole(SEARCH, roleName, grantor);
    }

    @Test(expected=SentryNoSuchObjectException.class)
    public void testAddGroupsNonExistantRole() throws Exception {
        String roleName = "non-existant-role";
        String grantor = "grantor";
        sentryStore.alterRoleAddGroups(SEARCH, roleName, (Set)Sets.newHashSet((Object[])new String[]{"g1"}), grantor);
    }

    @Test(expected=SentryNoSuchObjectException.class)
    public void testDeleteGroupsNonExistantRole() throws Exception {
        String roleName = "non-existant-role";
        String grantor = "grantor";
        sentryStore.alterRoleDeleteGroups(SEARCH, roleName, (Set)Sets.newHashSet((Object[])new String[]{"g1"}), grantor);
    }

    @Test
    public void testAddDeleteRoleToGroups() throws Exception {
        String role1 = "r1";
        String role2 = "r2";
        HashSet twoGroups = Sets.newHashSet((Object[])new String[]{"g1", "g2"});
        HashSet oneGroup = Sets.newHashSet((Object[])new String[]{"g3"});
        String grantor = "grantor";
        sentryStore.createRole(SEARCH, role1, grantor);
        sentryStore.createRole(SEARCH, role2, grantor);
        sentryStore.alterRoleAddGroups(SEARCH, role1, (Set)twoGroups, grantor);
        Assert.assertEquals((Object)twoGroups, (Object)sentryStore.getGroupsByRoles(SEARCH, (Set)Sets.newHashSet((Object[])new String[]{role1})));
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new String[]{role1}), (Object)sentryStore.getRolesByGroups(SEARCH, (Set)twoGroups));
        sentryStore.alterRoleAddGroups(SEARCH, role2, (Set)oneGroup, grantor);
        Assert.assertEquals((Object)oneGroup, (Object)sentryStore.getGroupsByRoles(SEARCH, (Set)Sets.newHashSet((Object[])new String[]{role2})));
        sentryStore.alterRoleDeleteGroups(SEARCH, role1, (Set)Sets.newHashSet((Object[])new String[]{"g1"}), grantor);
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new String[]{"g2"}), (Object)sentryStore.getGroupsByRoles(SEARCH, (Set)Sets.newHashSet((Object[])new String[]{role1})));
        sentryStore.alterRoleDeleteGroups(SEARCH, role2, (Set)oneGroup, grantor);
        Assert.assertEquals((Object)Sets.newHashSet(), (Object)sentryStore.getGroupsByRoles(SEARCH, (Set)Sets.newHashSet((Object[])new String[]{role2})));
    }

    @Test
    public void testGetRolesByGroupNames() throws Exception {
        String role1 = "r1";
        String role2 = "r2";
        HashSet twoGroups = Sets.newHashSet((Object[])new String[]{"g1", "g2"});
        String grantor = "grantor";
        sentryStore.createRole(SEARCH, role1, grantor);
        sentryStore.createRole(SEARCH, role2, grantor);
        sentryStore.alterRoleAddGroups(SEARCH, role1, (Set)twoGroups, grantor);
        sentryStore.alterRoleAddGroups(SEARCH, role2, (Set)twoGroups, grantor);
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new String[]{role1, role2}), (Object)sentryStore.getRolesByGroups(SEARCH, (Set)twoGroups));
    }

    @Test
    public void testGetGroupsByRoleNames() throws Exception {
        String role1 = "r1";
        String role2 = "r2";
        HashSet twoGroups = Sets.newHashSet((Object[])new String[]{"g1", "g2"});
        String grantor = "grantor";
        sentryStore.createRole(SEARCH, role1, grantor);
        sentryStore.createRole(SEARCH, role2, grantor);
        sentryStore.alterRoleAddGroups(SEARCH, role1, (Set)twoGroups, grantor);
        sentryStore.alterRoleAddGroups(SEARCH, role2, (Set)twoGroups, grantor);
        Assert.assertEquals((Object)twoGroups, (Object)sentryStore.getGroupsByRoles(SEARCH, (Set)Sets.newHashSet((Object[])new String[]{role1})));
        Assert.assertEquals((Object)twoGroups, (Object)sentryStore.getGroupsByRoles(SEARCH, (Set)Sets.newHashSet((Object[])new String[]{role2})));
        Assert.assertEquals((Object)twoGroups, (Object)sentryStore.getGroupsByRoles(SEARCH, (Set)Sets.newHashSet((Object[])new String[]{role1, role2})));
    }

    @Test
    public void testGetAllRoles() throws Exception {
        String role1 = "r1";
        String role2 = "r2";
        HashSet twoGroups = Sets.newHashSet((Object[])new String[]{"g1", "g2"});
        String grantor = "grantor";
        sentryStore.createRole(SEARCH, role1, grantor);
        sentryStore.createRole(SEARCH, role2, grantor);
        sentryStore.alterRoleAddGroups(SEARCH, role1, (Set)twoGroups, grantor);
        sentryStore.alterRoleAddGroups(SEARCH, role2, (Set)twoGroups, grantor);
        Object groupName = null;
        HashSet groups = Sets.newHashSet((Object[])new String[]{groupName});
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new String[]{role1, role2}), (Object)sentryStore.getRolesByGroups(SEARCH, (Set)groups));
        groups.clear();
        Assert.assertEquals((long)0L, (long)sentryStore.getRolesByGroups(SEARCH, (Set)groups).size());
    }
}

