/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.provider.db.generic;

import org.apache.hadoop.conf.Configuration;
import org.apache.sentry.provider.common.ProviderBackendContext;
import org.apache.sentry.provider.db.generic.SentryGenericProviderBackend;
import org.junit.Assert;
import org.junit.Test;

public class TestSentryGenericProviderBackend {
    @Test
    public void testScopeParamsGrabbedFromConf() throws Exception {
        Configuration conf = new Configuration();
        String sampleServiceName = "sampleServiceName123";
        String sampleComponentType = "sampleComponentType123";
        conf.set("sentry.provider.backend.generic.service-name", sampleServiceName);
        conf.set("sentry.provider.backend.generic.component-type", sampleComponentType);
        SentryGenericProviderBackend providerBackend = new SentryGenericProviderBackend(conf, "resource");
        Assert.assertEquals((Object)sampleComponentType, (Object)providerBackend.getComponentType());
        Assert.assertEquals((Object)sampleServiceName, (Object)providerBackend.getServiceName());
    }

    @Test(expected=NullPointerException.class)
    public void testScopeParamsValidated() throws Exception {
        Configuration conf = new Configuration();
        SentryGenericProviderBackend providerBackend = new SentryGenericProviderBackend(conf, "resource");
        providerBackend.initialize(new ProviderBackendContext());
    }
}

