/*
 * Decompiled with CFR 0.152.
 */
package sentry.org.apache.curator.x.discovery.details;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.type.JavaType;
import sentry.org.apache.curator.x.discovery.ServiceInstance;
import sentry.org.apache.curator.x.discovery.details.InstanceSerializer;

public class JsonInstanceSerializer<T>
implements InstanceSerializer<T> {
    private final ObjectMapper mapper;
    private final Class<T> payloadClass;
    private final JavaType type;

    public JsonInstanceSerializer(Class<T> payloadClass) {
        this.payloadClass = payloadClass;
        this.mapper = new ObjectMapper();
        this.type = this.mapper.getTypeFactory().constructType(ServiceInstance.class);
    }

    @Override
    public ServiceInstance<T> deserialize(byte[] bytes) throws Exception {
        ServiceInstance rawServiceInstance = (ServiceInstance)this.mapper.readValue(bytes, this.type);
        this.payloadClass.cast(rawServiceInstance.getPayload());
        return rawServiceInstance;
    }

    @Override
    public byte[] serialize(ServiceInstance<T> instance) throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.mapper.writeValue((OutputStream)out, instance);
        return out.toByteArray();
    }
}

