/*
 * Decompiled with CFR 0.152.
 */
package sentry.org.apache.curator.x.discovery;

import sentry.org.apache.curator.framework.CuratorFramework;
import sentry.org.apache.curator.x.discovery.ServiceDiscovery;
import sentry.org.apache.curator.x.discovery.ServiceInstance;
import sentry.org.apache.curator.x.discovery.details.InstanceSerializer;
import sentry.org.apache.curator.x.discovery.details.JsonInstanceSerializer;
import sentry.org.apache.curator.x.discovery.details.ServiceDiscoveryImpl;

public class ServiceDiscoveryBuilder<T> {
    private CuratorFramework client;
    private String basePath;
    private InstanceSerializer<T> serializer;
    private ServiceInstance<T> thisInstance;
    private Class<T> payloadClass;
    private boolean watchInstances = false;

    public static <T> ServiceDiscoveryBuilder<T> builder(Class<T> payloadClass) {
        return new ServiceDiscoveryBuilder<T>(payloadClass);
    }

    public ServiceDiscovery<T> build() {
        if (this.serializer == null) {
            this.serializer(new JsonInstanceSerializer<T>(this.payloadClass));
        }
        return new ServiceDiscoveryImpl<T>(this.client, this.basePath, this.serializer, this.thisInstance, this.watchInstances);
    }

    public ServiceDiscoveryBuilder<T> client(CuratorFramework client) {
        this.client = client;
        return this;
    }

    public ServiceDiscoveryBuilder<T> basePath(String basePath) {
        this.basePath = basePath;
        return this;
    }

    public ServiceDiscoveryBuilder<T> serializer(InstanceSerializer<T> serializer) {
        this.serializer = serializer;
        return this;
    }

    public ServiceDiscoveryBuilder<T> thisInstance(ServiceInstance<T> thisInstance) {
        this.thisInstance = thisInstance;
        return this;
    }

    public ServiceDiscoveryBuilder<T> watchInstances(boolean watchInstances) {
        this.watchInstances = watchInstances;
        return this;
    }

    ServiceDiscoveryBuilder(Class<T> payloadClass) {
        this.payloadClass = payloadClass;
    }
}

