/*
 * Decompiled with CFR 0.152.
 */
package sentry.org.apache.curator;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Closeable;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import sentry.org.apache.curator.CuratorZookeeperClient;
import sentry.org.apache.curator.RetryLoop;
import sentry.org.apache.curator.utils.ThreadUtils;

public class SessionFailRetryLoop
implements Closeable {
    private final CuratorZookeeperClient client;
    private final Mode mode;
    private final Thread ourThread = Thread.currentThread();
    private final AtomicBoolean sessionHasFailed = new AtomicBoolean(false);
    private final AtomicBoolean isDone = new AtomicBoolean(false);
    private final RetryLoop retryLoop;
    private final Watcher watcher = new Watcher(){

        public void process(WatchedEvent event) {
            if (event.getState() == Watcher.Event.KeeperState.Expired) {
                SessionFailRetryLoop.this.sessionHasFailed.set(true);
                failedSessionThreads.add(SessionFailRetryLoop.this.ourThread);
            }
        }
    };
    private static final Set<Thread> failedSessionThreads = Sets.newSetFromMap((Map)Maps.newConcurrentMap());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T callWithRetry(CuratorZookeeperClient client, Mode mode, Callable<T> proc) throws Exception {
        T result = null;
        SessionFailRetryLoop retryLoop = client.newSessionFailRetryLoop(mode);
        retryLoop.start();
        try {
            while (retryLoop.shouldContinue()) {
                try {
                    result = proc.call();
                }
                catch (Exception e) {
                    ThreadUtils.checkInterrupted(e);
                    retryLoop.takeException(e);
                }
            }
        }
        finally {
            retryLoop.close();
        }
        return result;
    }

    SessionFailRetryLoop(CuratorZookeeperClient client, Mode mode) {
        this.client = client;
        this.mode = mode;
        this.retryLoop = client.newRetryLoop();
    }

    static boolean sessionForThreadHasFailed() {
        return failedSessionThreads.size() > 0 && failedSessionThreads.contains(Thread.currentThread());
    }

    public void start() {
        Preconditions.checkState((boolean)Thread.currentThread().equals(this.ourThread), (Object)"Not in the correct thread");
        this.client.addParentWatcher(this.watcher);
    }

    public boolean shouldContinue() {
        boolean localIsDone = this.isDone.getAndSet(true);
        return !localIsDone;
    }

    @Override
    public void close() {
        Preconditions.checkState((boolean)Thread.currentThread().equals(this.ourThread), (Object)"Not in the correct thread");
        failedSessionThreads.remove(this.ourThread);
        this.client.removeParentWatcher(this.watcher);
    }

    public void takeException(Exception exception) throws Exception {
        Preconditions.checkState((boolean)Thread.currentThread().equals(this.ourThread), (Object)"Not in the correct thread");
        boolean passUp = true;
        if (this.sessionHasFailed.get()) {
            switch (this.mode) {
                case RETRY: {
                    this.sessionHasFailed.set(false);
                    failedSessionThreads.remove(this.ourThread);
                    if (!(exception instanceof SessionFailedException)) break;
                    this.isDone.set(false);
                    passUp = false;
                    break;
                }
            }
        }
        if (passUp) {
            this.retryLoop.takeException(exception);
        }
    }

    public static enum Mode {
        RETRY,
        FAIL;

    }

    public static class SessionFailedException
    extends Exception {
        private static final long serialVersionUID = 1L;
    }
}

