/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.service.thrift;

import java.io.PrintWriter;
import java.io.StringWriter;
import javax.annotation.Nullable;
import org.apache.sentry.core.common.exception.SentryAccessDeniedException;
import org.apache.sentry.core.common.exception.SentryAlreadyExistsException;
import org.apache.sentry.core.common.exception.SentryInvalidInputException;
import org.apache.sentry.core.common.exception.SentryNoSuchObjectException;
import org.apache.sentry.core.common.exception.SentryThriftAPIMismatchException;
import org.apache.sentry.core.common.exception.SentryUserException;
import org.apache.sentry.service.thrift.TSentryResponseStatus;

public enum Status {
    OK(0),
    ALREADY_EXISTS(1),
    NO_SUCH_OBJECT(2),
    RUNTIME_ERROR(3),
    INVALID_INPUT(4),
    ACCESS_DENIED(5),
    THRIFT_VERSION_MISMATCH(6),
    UNKNOWN(-1);

    private int code;

    private Status(int code) {
        this.code = code;
    }

    public int getCode() {
        return this.code;
    }

    public static Status fromCode(int code) {
        for (Status status : Status.values()) {
            if (status.getCode() != code) continue;
            return status;
        }
        return UNKNOWN;
    }

    public static TSentryResponseStatus OK() {
        return Status.Create(OK, "");
    }

    public static TSentryResponseStatus AccessDenied(String message, Throwable t) {
        return Status.Create(ACCESS_DENIED, message, t);
    }

    public static TSentryResponseStatus AlreadyExists(String message, Throwable t) {
        return Status.Create(ALREADY_EXISTS, message, t);
    }

    public static TSentryResponseStatus NoSuchObject(String message, Throwable t) {
        return Status.Create(NO_SUCH_OBJECT, message, t);
    }

    public static TSentryResponseStatus RuntimeError(String message, Throwable t) {
        return Status.Create(RUNTIME_ERROR, message, t);
    }

    public static TSentryResponseStatus Create(Status value, String message) {
        return Status.Create(value, message, null);
    }

    public static TSentryResponseStatus InvalidInput(String message, Throwable t) {
        return Status.Create(INVALID_INPUT, message, t);
    }

    public static TSentryResponseStatus THRIFT_VERSION_MISMATCH(String message, Throwable t) {
        return Status.Create(THRIFT_VERSION_MISMATCH, message, t);
    }

    public static TSentryResponseStatus Create(Status value, String message, @Nullable Throwable t) {
        TSentryResponseStatus status = new TSentryResponseStatus();
        status.setValue(value.getCode());
        status.setMessage(message);
        if (t != null) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            t.printStackTrace(printWriter);
            printWriter.close();
            status.setStack(stringWriter.toString());
        }
        return status;
    }

    public static void throwIfNotOk(TSentryResponseStatus thriftStatus) throws SentryUserException {
        Status status = Status.fromCode(thriftStatus.getValue());
        switch (status) {
            case OK: {
                break;
            }
            case ALREADY_EXISTS: {
                throw new SentryAlreadyExistsException(Status.serverErrorToString(thriftStatus), thriftStatus.getMessage());
            }
            case NO_SUCH_OBJECT: {
                throw new SentryNoSuchObjectException(Status.serverErrorToString(thriftStatus), thriftStatus.getMessage());
            }
            case RUNTIME_ERROR: {
                throw new RuntimeException(Status.serverErrorToString(thriftStatus));
            }
            case INVALID_INPUT: {
                throw new SentryInvalidInputException(Status.serverErrorToString(thriftStatus), thriftStatus.getMessage());
            }
            case ACCESS_DENIED: {
                throw new SentryAccessDeniedException(Status.serverErrorToString(thriftStatus), thriftStatus.getMessage());
            }
            case THRIFT_VERSION_MISMATCH: {
                throw new SentryThriftAPIMismatchException(Status.serverErrorToString(thriftStatus), thriftStatus.getMessage());
            }
            case UNKNOWN: {
                throw new AssertionError((Object)Status.serverErrorToString(thriftStatus));
            }
            default: {
                throw new AssertionError((Object)("Unknown status code: " + (Object)((Object)status) + ". Msg: " + Status.serverErrorToString(thriftStatus)));
            }
        }
    }

    private static String serverErrorToString(TSentryResponseStatus thriftStatus) {
        String msg = thriftStatus.getMessage();
        String stack = thriftStatus.getStack();
        if (stack == null) {
            return msg;
        }
        return msg + ". Server Stacktrace: " + stack;
    }
}

