/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.service.thrift;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.AtomicLongMap;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.sentry.service.thrift.SentryState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class SentryStateBank {
    private static final Logger LOGGER = LoggerFactory.getLogger(SentryStateBank.class);
    private static final AtomicLongMap<String> states = AtomicLongMap.create();
    private static final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

    protected SentryStateBank() {
    }

    @VisibleForTesting
    static void clearAllStates() {
        states.clear();
        LOGGER.debug("All states have been cleared.");
    }

    @VisibleForTesting
    static void resetComponentState(String component) {
        states.remove((Object)component);
        LOGGER.debug("All states have been cleared for component {}", (Object)component);
    }

    public static void enableState(String component, SentryState state) {
        lock.writeLock().lock();
        try {
            states.put((Object)component, states.get((Object)component) | state.getValue());
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("{} entered state {}", (Object)component, (Object)state.toString());
            }
        }
        finally {
            lock.writeLock().unlock();
        }
    }

    public static void disableState(String component, SentryState state) {
        lock.writeLock().lock();
        try {
            states.put((Object)component, states.get((Object)component) & (state.getValue() ^ 0xFFFFFFFFFFFFFFFFL));
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("{} exited state {}", (Object)component, (Object)state.toString());
            }
        }
        finally {
            lock.writeLock().unlock();
        }
    }

    public static boolean isEnabled(String component, SentryState state) {
        lock.readLock().lock();
        try {
            boolean bl = (states.get((Object)component) & state.getValue()) == state.getValue();
            return bl;
        }
        finally {
            lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasStatesEnabled(String component, Set<SentryState> passedStates) {
        lock.readLock().lock();
        try {
            long value = 0L;
            for (SentryState state : passedStates) {
                value += state.getValue();
            }
            boolean bl = (states.get((Object)component) & value) == value;
            return bl;
        }
        finally {
            lock.readLock().unlock();
        }
    }
}

