/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.service.thrift;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.hadoop.conf.Configuration;
import org.apache.sentry.core.common.transport.RetryClientInvocationHandler;
import org.apache.sentry.core.common.transport.SentryClientTransportConfigInterface;
import org.apache.sentry.core.common.transport.SentryConnection;
import org.apache.sentry.core.common.transport.SentryPolicyClientTransportConfig;
import org.apache.sentry.core.common.transport.SentryTransportFactory;
import org.apache.sentry.core.common.transport.SentryTransportPool;
import org.apache.sentry.core.common.transport.TransportFactory;
import org.apache.sentry.provider.db.service.thrift.SentryPolicyServiceClient;
import org.apache.sentry.provider.db.service.thrift.SentryPolicyServiceClientDefaultImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class SentryServiceClientFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(SentryServiceClientFactory.class);
    private static final SentryPolicyClientTransportConfig transportConfig = new SentryPolicyClientTransportConfig();
    private final Configuration conf;
    private final SentryTransportPool transportPool;
    private static final AtomicReference<SentryServiceClientFactory> clientFactory = new AtomicReference();

    public static SentryPolicyServiceClient create(Configuration conf) throws Exception {
        SentryServiceClientFactory factory = clientFactory.get();
        if (factory != null) {
            return factory.create();
        }
        factory = new SentryServiceClientFactory(conf);
        boolean ok = clientFactory.compareAndSet(null, factory);
        if (ok) {
            return factory.create();
        }
        factory.close();
        return clientFactory.get().create();
    }

    private SentryServiceClientFactory(Configuration conf) {
        this.conf = conf;
        this.transportPool = new SentryTransportPool(conf, (SentryClientTransportConfigInterface)transportConfig, (TransportFactory)new SentryTransportFactory(conf, (SentryClientTransportConfigInterface)transportConfig));
    }

    private SentryPolicyServiceClient create() throws Exception {
        return (SentryPolicyServiceClient)Proxy.newProxyInstance(SentryPolicyServiceClientDefaultImpl.class.getClassLoader(), SentryPolicyServiceClientDefaultImpl.class.getInterfaces(), (InvocationHandler)new RetryClientInvocationHandler(this.conf, (SentryConnection)new SentryPolicyServiceClientDefaultImpl(this.conf, this.transportPool), (SentryClientTransportConfigInterface)transportConfig));
    }

    public static SentryServiceClientFactory factoryReset(SentryServiceClientFactory factory) {
        LOGGER.debug("factory reset");
        return clientFactory.getAndSet(factory);
    }

    public void close() {
        try {
            this.transportPool.close();
        }
        catch (Exception e) {
            LOGGER.error("failed to close transport pool", (Throwable)e);
        }
    }
}

