/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.service.thrift;

import com.google.common.collect.Sets;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.File;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ThreadFactory;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.kerberos.KerberosTicket;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.sentry.service.thrift.KerberosConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SentryKerberosContext
implements Runnable {
    private static final String KERBEROS_RENEWER_THREAD_NAME = "kerberos-renewer-%d";
    private static final float TICKET_RENEW_WINDOW = 0.8f;
    private static final Logger LOGGER = LoggerFactory.getLogger(SentryKerberosContext.class);
    private LoginContext loginContext;
    private Subject subject;
    private final Configuration kerberosConfig;
    private Thread renewerThread;
    private boolean shutDownRenewer = false;

    public SentryKerberosContext(String principal, String keyTab, boolean server) throws LoginException {
        this.subject = new Subject(false, Sets.newHashSet((Object[])new KerberosPrincipal[]{new KerberosPrincipal(principal)}), new HashSet(), new HashSet());
        this.kerberosConfig = server ? KerberosConfiguration.createServerConfig(principal, new File(keyTab)) : KerberosConfiguration.createClientConfig(principal, new File(keyTab));
        this.loginWithNewContext();
        if (!server) {
            this.startRenewerThread();
        }
    }

    private void loginWithNewContext() throws LoginException {
        LOGGER.info("Logging in with new Context");
        this.logoutSubject();
        this.loginContext = new LoginContext("", this.subject, null, this.kerberosConfig);
        this.loginContext.login();
        this.subject = this.loginContext.getSubject();
    }

    private void logoutSubject() {
        if (this.loginContext != null) {
            try {
                this.loginContext.logout();
            }
            catch (LoginException e) {
                LOGGER.warn("Error logging out the subject", (Throwable)e);
            }
        }
        this.loginContext = null;
    }

    public Subject getSubject() {
        return this.subject;
    }

    @Deprecated
    private KerberosTicket getTGT() {
        Set<KerberosTicket> tickets = this.subject.getPrivateCredentials(KerberosTicket.class);
        for (KerberosTicket ticket : tickets) {
            KerberosPrincipal server = ticket.getServer();
            if (!server.getName().equals("krbtgt/" + server.getRealm() + "@" + server.getRealm())) continue;
            return ticket;
        }
        return null;
    }

    private long getRefreshTime(KerberosTicket tgt) {
        long start = tgt.getStartTime().getTime();
        long end = tgt.getEndTime().getTime();
        LOGGER.debug("Ticket start time: {}, end time: {}", (Object)start, (Object)end);
        return start + (long)((float)(end - start) * 0.8f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            LOGGER.info("Sentry Ticket renewer thread started");
            while (!this.shutDownRenewer) {
                KerberosTicket tgt = this.getTGT();
                if (tgt == null) {
                    LOGGER.warn("No ticket found in the cache");
                    return;
                }
                long nextRefresh = this.getRefreshTime(tgt);
                while (System.currentTimeMillis() < nextRefresh) {
                    Thread.sleep(1000L);
                    if (!this.shutDownRenewer) continue;
                    return;
                }
                this.loginWithNewContext();
                LOGGER.debug("Renewed ticket");
            }
        }
        catch (InterruptedException e1) {
            LOGGER.warn("Sentry Ticket renewer thread interrupted", (Throwable)e1);
            return;
        }
        catch (LoginException e) {
            LOGGER.warn("Failed to renew ticket", (Throwable)e);
        }
        finally {
            this.logoutSubject();
            LOGGER.info("Sentry Ticket renewer thread finished");
        }
    }

    public void startRenewerThread() {
        ThreadFactory renewerThreadFactory = new ThreadFactoryBuilder().setNameFormat(KERBEROS_RENEWER_THREAD_NAME).build();
        this.renewerThread = renewerThreadFactory.newThread(this);
        this.renewerThread.start();
    }

    public void shutDown() throws LoginException {
        if (this.renewerThread != null) {
            this.shutDownRenewer = true;
        } else {
            this.logoutSubject();
        }
    }
}

