/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.service.thrift;

import com.codahale.metrics.Counter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.CurrentNotificationEventId;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NotificationEvent;
import org.apache.hadoop.hive.metastore.api.NotificationEventResponse;
import org.apache.hadoop.hive.metastore.messaging.MessageDeserializer;
import org.apache.sentry.binding.metastore.messaging.json.SentryJSONMessageDeserializer;
import org.apache.sentry.provider.db.service.persistent.PathsImage;
import org.apache.sentry.provider.db.service.thrift.SentryMetrics;
import org.apache.sentry.service.thrift.FullUpdateInitializer;
import org.apache.sentry.service.thrift.FullUpdateModifier;
import org.apache.sentry.service.thrift.HiveConnectionFactory;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SentryHMSClient
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(SentryHMSClient.class);
    private static final String NOT_CONNECTED_MSG = "Client is not connected to HMS";
    private final Configuration conf;
    private HiveMetaStoreClient client = null;
    private HiveConnectionFactory hiveConnectionFactory;
    private static final String SNAPSHOT = "snapshot";
    private final Timer updateTimer = SentryMetrics.getInstance().getTimer(MetricRegistry.name(FullUpdateInitializer.class, (String[])new String[]{"snapshot"}));
    private final Counter failedSnapshotsCount = SentryMetrics.getInstance().getCounter(MetricRegistry.name(FullUpdateInitializer.class, (String[])new String[]{"failed"}));

    SentryHMSClient(Configuration conf, HiveConnectionFactory hiveConnectionFactory) {
        this.conf = conf;
        this.hiveConnectionFactory = hiveConnectionFactory;
    }

    @VisibleForTesting
    void setClient(HiveMetaStoreClient client) {
        this.client = client;
    }

    boolean isConnected() {
        return this.client != null;
    }

    void connect() throws IOException, InterruptedException, MetaException {
        if (this.client != null) {
            return;
        }
        this.client = this.hiveConnectionFactory.connect().getClient();
    }

    public void disconnect() throws Exception {
        try {
            if (this.client != null) {
                LOGGER.info("Closing the HMS client connection");
                this.client.close();
            }
        }
        catch (Exception e) {
            LOGGER.error("failed to close Hive Connection Factory", (Throwable)e);
        }
        finally {
            this.client = null;
        }
    }

    @Override
    public void close() throws Exception {
        this.disconnect();
    }

    PathsImage getFullSnapshot() {
        if (this.client == null) {
            LOGGER.error(NOT_CONNECTED_MSG);
            return new PathsImage(Collections.emptyMap(), 0L, 0L);
        }
        try {
            CurrentNotificationEventId eventIdBefore = this.client.getCurrentNotificationEventId();
            Map<String, Collection<String>> pathsFullSnapshot = this.fetchFullUpdate();
            if (pathsFullSnapshot.isEmpty()) {
                return new PathsImage(pathsFullSnapshot, 0L, 0L);
            }
            CurrentNotificationEventId eventIdAfter = this.client.getCurrentNotificationEventId();
            LOGGER.info("NotificationID, Before Snapshot: {}, After Snapshot {}", (Object)eventIdBefore.getEventId(), (Object)eventIdAfter.getEventId());
            if (eventIdAfter.equals(eventIdBefore)) {
                LOGGER.info("Successfully fetched hive full snapshot, Current NotificationID: {}.", (Object)eventIdAfter);
                return new PathsImage(pathsFullSnapshot, eventIdAfter.getEventId(), 0L);
            }
            LOGGER.info("Reconciling full snapshot - applying {} changes", (Object)(eventIdAfter.getEventId() - eventIdBefore.getEventId()));
            long currentEventId = eventIdBefore.getEventId();
            SentryJSONMessageDeserializer deserializer = new SentryJSONMessageDeserializer();
            block4: while (currentEventId < eventIdAfter.getEventId()) {
                NotificationEventResponse response = this.client.getNextNotification(currentEventId, Integer.MAX_VALUE, null);
                if (response == null || !response.isSetEvents() || response.getEvents().isEmpty()) {
                    LOGGER.error("Snapshot discarded, updates to HMS data while shapshot is being taken.ID Before: {}. ID After: {}", (Object)eventIdBefore.getEventId(), (Object)eventIdAfter.getEventId());
                    return new PathsImage(Collections.emptyMap(), 0L, 0L);
                }
                for (NotificationEvent event : response.getEvents()) {
                    if (event.getEventId() <= eventIdBefore.getEventId()) {
                        LOGGER.error("Received stray event with eventId {} which is less then {}", (Object)event.getEventId(), (Object)eventIdBefore);
                        continue;
                    }
                    if (event.getEventId() > eventIdAfter.getEventId()) continue block4;
                    try {
                        FullUpdateModifier.applyEvent(pathsFullSnapshot, event, (MessageDeserializer)deserializer);
                    }
                    catch (Exception e) {
                        LOGGER.warn("Failed to apply operation", (Throwable)e);
                    }
                    currentEventId = event.getEventId();
                }
            }
            LOGGER.info("Successfully fetched hive full snapshot, Current NotificationID: {}.", (Object)currentEventId);
            return new PathsImage(pathsFullSnapshot, currentEventId, 0L);
        }
        catch (TException failure) {
            LOGGER.error("Fetching a new HMS snapshot cannot continue because an error occurred during the HMS communication: ", (Object)failure.getMessage());
            return new PathsImage(Collections.emptyMap(), 0L, 0L);
        }
    }

    /*
     * Exception decompiling
     */
    private Map<String, Collection<String>> fetchFullUpdate() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

