/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.service.thrift;

import com.google.common.annotations.VisibleForTesting;
import java.lang.management.ManagementFactory;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.sentry.provider.db.service.persistent.HAContext;
import sentry.org.apache.curator.framework.CuratorFramework;
import sentry.org.apache.curator.framework.recipes.leader.LeaderSelector;
import sentry.org.apache.curator.framework.recipes.leader.LeaderSelectorListenerAdapter;

@ThreadSafe
final class LeaderStatusMonitor
extends LeaderSelectorListenerAdapter
implements AutoCloseable {
    private static final Log LOG = LogFactory.getLog(LeaderStatusMonitor.class);
    private static final String LEADER_SELECTOR_SUFFIX = "leader";
    private static LeaderStatusMonitor leaderStatusMonitor = null;
    private final HAContext haContext;
    private final String defaultIncarnationId = LeaderStatusMonitor.generateIncarnationId();
    private String incarnationId;
    private final boolean isSingleNodeMode;
    private final Lock lock = new ReentrantLock();
    private final Condition cond = this.lock.newCondition();
    private boolean isLeader = false;
    private LeaderSelector leaderSelector = null;
    private final AtomicLong leaderCount = new AtomicLong(0L);

    @VisibleForTesting
    protected LeaderStatusMonitor(Configuration conf) throws Exception {
        String zkServers = conf.get("sentry.ha.zookeeper.quorum", "");
        if (zkServers.isEmpty()) {
            this.isSingleNodeMode = true;
            this.haContext = null;
            this.isLeader = true;
            this.incarnationId = "";
            LOG.info((Object)"Leader election protocol disabled, assuming single active server");
            return;
        }
        this.isSingleNodeMode = false;
        this.incarnationId = this.defaultIncarnationId;
        this.haContext = HAContext.getHAServerContext(conf);
        LOG.info((Object)("Created LeaderStatusMonitor(incarnationId=" + this.incarnationId + ", zkServers='" + zkServers + "')"));
    }

    @VisibleForTesting
    protected LeaderStatusMonitor(Configuration conf, String incarnationId) throws Exception {
        this(conf);
        this.incarnationId = incarnationId;
    }

    @VisibleForTesting
    protected void init() {
        if (this.isSingleNodeMode) {
            return;
        }
        this.leaderSelector = this.haContext.newLeaderSelector("/leader", this);
        this.leaderSelector.setId(this.incarnationId);
        this.leaderSelector.autoRequeue();
        this.leaderSelector.start();
    }

    static synchronized LeaderStatusMonitor getLeaderStatusMonitor(Configuration conf) throws Exception {
        if (leaderStatusMonitor == null) {
            leaderStatusMonitor = new LeaderStatusMonitor(conf);
            leaderStatusMonitor.init();
        }
        return leaderStatusMonitor;
    }

    long getLeaderCount() {
        return this.leaderCount.get();
    }

    @Override
    public void close() {
        if (this.leaderSelector != null) {
            this.leaderSelector.close();
        }
    }

    void deactivate() {
        if (this.isSingleNodeMode) {
            return;
        }
        this.lock.lock();
        try {
            this.cond.signal();
        }
        finally {
            this.lock.unlock();
        }
    }

    boolean isLeader() {
        if (this.isSingleNodeMode) {
            return true;
        }
        this.lock.lock();
        boolean leader = this.isLeader;
        this.lock.unlock();
        return leader;
    }

    @Override
    public void takeLeadership(CuratorFramework client) throws Exception {
        this.leaderCount.incrementAndGet();
        LOG.info((Object)("LeaderStatusMonitor: becoming active. leaderCount=" + this.leaderCount));
        this.lock.lock();
        try {
            this.isLeader = true;
            this.cond.await();
        }
        catch (InterruptedException ignored) {
            Thread.currentThread().interrupt();
            LOG.info((Object)"LeaderStatusMonitor: interrupted");
        }
        finally {
            this.isLeader = false;
            this.lock.unlock();
            LOG.info((Object)"LeaderStatusMonitor: becoming standby");
        }
    }

    private static String generateIncarnationId() {
        return ManagementFactory.getRuntimeMXBean().getName();
    }
}

