/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.service.thrift;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.CurrentNotificationEventId;
import org.apache.hadoop.hive.metastore.api.NotificationEvent;
import org.apache.hadoop.hive.metastore.api.NotificationEventResponse;
import org.apache.sentry.hdfs.UniquePathsUpdate;
import org.apache.sentry.provider.db.service.persistent.SentryStore;
import org.apache.sentry.service.thrift.HiveConnectionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HiveNotificationFetcher
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(HiveNotificationFetcher.class);
    private final SentryStore sentryStore;
    private final HiveConnectionFactory hmsConnectionFactory;
    private HiveMetaStoreClient hmsClient;
    private long lastIdFiltered = 0L;
    private Set<String> cache = new HashSet<String>();

    HiveNotificationFetcher(SentryStore sentryStore, HiveConnectionFactory hmsConnectionFactory) {
        this.sentryStore = sentryStore;
        this.hmsConnectionFactory = hmsConnectionFactory;
    }

    List<NotificationEvent> fetchNotifications(long lastEventId) throws Exception {
        return this.fetchNotifications(lastEventId, Integer.MAX_VALUE);
    }

    List<NotificationEvent> fetchNotifications(long lastEventId, int maxEvents) throws Exception {
        NotificationEventResponse response;
        IMetaStoreClient.NotificationFilter filter = null;
        if (lastEventId > 0L) {
            filter = this.createNotificationFilterFor(lastEventId);
            --lastEventId;
        }
        LOGGER.debug("Requesting HMS notifications since ID = {}", (Object)lastEventId);
        try {
            response = this.getHmsClient().getNextNotification(lastEventId, maxEvents, filter);
        }
        catch (Exception e) {
            this.close();
            throw e;
        }
        if (response != null && response.isSetEvents()) {
            LOGGER.debug("Fetched {} new HMS notification(s)", (Object)response.getEventsSize());
            return response.getEvents();
        }
        return Collections.emptyList();
    }

    private IMetaStoreClient.NotificationFilter createNotificationFilterFor(final long id) {
        if (this.lastIdFiltered != id) {
            this.lastIdFiltered = id;
            this.cache.clear();
        }
        return new IMetaStoreClient.NotificationFilter(){

            public boolean accept(NotificationEvent notificationEvent) {
                if (notificationEvent.getEventId() == id) {
                    String hash = UniquePathsUpdate.sha1((NotificationEvent)notificationEvent);
                    try {
                        if (HiveNotificationFetcher.this.cache.contains(hash) || HiveNotificationFetcher.this.sentryStore.isNotificationProcessed(hash)) {
                            HiveNotificationFetcher.this.cache.add(hash);
                            LOGGER.debug("Ignoring HMS notification already processed: ID = {}", (Object)id);
                            return false;
                        }
                    }
                    catch (Exception e) {
                        LOGGER.error("An error occurred while checking if notification {} is already processed: {}", (Object)id, (Object)e.getMessage());
                        return false;
                    }
                }
                return true;
            }
        };
    }

    private HiveMetaStoreClient getHmsClient() throws Exception {
        if (this.hmsClient == null) {
            try {
                this.hmsClient = this.hmsConnectionFactory.connect().getClient();
            }
            catch (Exception e) {
                LOGGER.error("Fail to connect to the HMS service: {}", (Object)e.getMessage());
                throw e;
            }
        }
        return this.hmsClient;
    }

    long getCurrentNotificationId() throws Exception {
        CurrentNotificationEventId eventId;
        try {
            eventId = this.getHmsClient().getCurrentNotificationEventId();
        }
        catch (Exception e) {
            this.close();
            throw e;
        }
        if (eventId != null && eventId.isSetEventId()) {
            return eventId.getEventId();
        }
        return 0L;
    }

    @Override
    public void close() {
        try {
            if (this.hmsClient != null) {
                this.hmsClient.close();
            }
            this.cache.clear();
        }
        finally {
            this.hmsClient = null;
        }
    }
}

