/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.provider.db.tools.command.hive;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.sentry.core.common.exception.SentryUserException;
import org.apache.sentry.provider.db.service.thrift.SentryPolicyServiceClient;
import org.apache.sentry.provider.db.service.thrift.TSentryGroup;
import org.apache.sentry.provider.db.service.thrift.TSentryPrivilege;
import org.apache.sentry.provider.db.service.thrift.TSentryRole;
import org.apache.sentry.provider.db.tools.ShellCommand;
import org.apache.sentry.provider.db.tools.command.hive.CommandUtil;
import org.apache.sentry.service.thrift.SentryServiceUtil;

public class HiveShellCommand
implements ShellCommand {
    private final SentryPolicyServiceClient client;

    public HiveShellCommand(SentryPolicyServiceClient client) {
        this.client = client;
    }

    @Override
    public void createRole(String requestorName, String roleName) throws SentryUserException {
        this.client.createRole(requestorName, roleName);
    }

    @Override
    public void dropRole(String requestorName, String roleName) throws SentryUserException {
        this.client.dropRole(requestorName, roleName);
    }

    @Override
    public void grantPrivilegeToRole(String requestorName, String roleName, String privilege) throws SentryUserException {
        TSentryPrivilege tSentryPrivilege = SentryServiceUtil.convertToTSentryPrivilege(privilege);
        CommandUtil.validatePrivilegeHierarchy(tSentryPrivilege);
        this.client.grantPrivilege(requestorName, roleName, tSentryPrivilege);
    }

    @Override
    public void grantRoleToGroups(String requestorName, String roleName, Set<String> groups) throws SentryUserException {
        this.client.grantRoleToGroups(requestorName, roleName, groups);
    }

    @Override
    public void revokePrivilegeFromRole(String requestorName, String roleName, String privilege) throws SentryUserException {
        TSentryPrivilege tSentryPrivilege = SentryServiceUtil.convertToTSentryPrivilege(privilege);
        CommandUtil.validatePrivilegeHierarchy(tSentryPrivilege);
        this.client.revokePrivilege(requestorName, roleName, tSentryPrivilege);
    }

    @Override
    public void revokeRoleFromGroups(String requestorName, String roleName, Set<String> groups) throws SentryUserException {
        this.client.revokeRoleFromGroups(requestorName, roleName, groups);
    }

    @Override
    public List<String> listRoles(String requestorName, String group) throws SentryUserException {
        Set<TSentryRole> roles = StringUtils.isEmpty((String)group) ? this.client.listAllRoles(requestorName) : this.client.listRolesByGroupName(requestorName, group);
        ArrayList<String> result = new ArrayList<String>();
        if (roles != null) {
            for (TSentryRole role : roles) {
                result.add(role.getRoleName());
            }
        }
        return result;
    }

    @Override
    public List<String> listPrivileges(String requestorName, String roleName) throws SentryUserException {
        Set<TSentryPrivilege> privileges = this.client.listAllPrivilegesByRoleName(requestorName, roleName);
        ArrayList<String> result = new ArrayList<String>();
        if (privileges != null) {
            for (TSentryPrivilege privilege : privileges) {
                String privilegeStr = SentryServiceUtil.convertTSentryPrivilegeToStr(privilege);
                result.add(privilegeStr);
            }
        }
        return result;
    }

    @Override
    public List<String> listGroupRoles(String requestorName) throws SentryUserException {
        Set<TSentryRole> roles = this.client.listAllRoles(requestorName);
        if (roles == null || roles.isEmpty()) {
            return Collections.emptyList();
        }
        HashSet<String> groupNames = new HashSet<String>();
        HashMap<String, HashSet<String>> groupInfo = new HashMap<String, HashSet<String>>();
        for (TSentryRole role : roles) {
            for (TSentryGroup group : role.getGroups()) {
                String groupName = group.getGroupName();
                groupNames.add(groupName);
                HashSet<String> groupRoles = (HashSet<String>)groupInfo.get(groupName);
                if (groupRoles != null) {
                    groupRoles.add(role.getRoleName());
                    continue;
                }
                groupRoles = new HashSet<String>();
                groupRoles.add(role.getRoleName());
                groupInfo.put(groupName, groupRoles);
            }
        }
        ArrayList groups = new ArrayList(groupNames);
        LinkedList<String> result = new LinkedList<String>();
        for (String groupName : groups) {
            result.add(groupName + " = " + StringUtils.join((Collection)((Collection)groupInfo.get(groupName)), (String)", "));
        }
        return result;
    }
}

