/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.provider.db.tools.command.hive;

import org.apache.commons.lang.StringUtils;
import org.apache.sentry.provider.db.service.thrift.TSentryPrivilege;
import org.apache.sentry.service.thrift.ServiceConstants;

public final class CommandUtil {
    public static final String SPLIT_CHAR = ",";

    private CommandUtil() {
    }

    public static void validatePrivilegeHierarchy(TSentryPrivilege tSentryPrivilege) throws IllegalArgumentException {
        String serverName = tSentryPrivilege.getServerName();
        String dbName = tSentryPrivilege.getDbName();
        String tableName = tSentryPrivilege.getTableName();
        String columnName = tSentryPrivilege.getColumnName();
        String uri = tSentryPrivilege.getURI();
        if (ServiceConstants.PrivilegeScope.SERVER.toString().equals(tSentryPrivilege.getPrivilegeScope()) ? StringUtils.isEmpty((String)serverName) : (ServiceConstants.PrivilegeScope.URI.toString().equals(tSentryPrivilege.getPrivilegeScope()) ? StringUtils.isEmpty((String)serverName) || StringUtils.isEmpty((String)uri) : (ServiceConstants.PrivilegeScope.DATABASE.toString().equals(tSentryPrivilege.getPrivilegeScope()) ? StringUtils.isEmpty((String)serverName) || StringUtils.isEmpty((String)dbName) : (ServiceConstants.PrivilegeScope.TABLE.toString().equals(tSentryPrivilege.getPrivilegeScope()) ? StringUtils.isEmpty((String)serverName) || StringUtils.isEmpty((String)dbName) || StringUtils.isEmpty((String)tableName) : ServiceConstants.PrivilegeScope.COLUMN.toString().equals(tSentryPrivilege.getPrivilegeScope()) && (StringUtils.isEmpty((String)serverName) || StringUtils.isEmpty((String)dbName) || StringUtils.isEmpty((String)tableName) || StringUtils.isEmpty((String)columnName)))))) {
            throw new IllegalArgumentException("The hierarchy of privilege is not correct.");
        }
    }
}

