/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.provider.db.tools;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.sentry.provider.db.service.thrift.SentryPolicyServiceClient;
import org.apache.sentry.provider.db.tools.SentryShellCommon;
import org.apache.sentry.provider.db.tools.command.hive.HiveShellCommand;
import org.apache.sentry.service.thrift.SentryServiceClientFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SentryShellHive
extends SentryShellCommon {
    private static final Logger LOGGER = LoggerFactory.getLogger(SentryShellHive.class);

    @Override
    public void run() throws Exception {
        try (SentryPolicyServiceClient client = SentryServiceClientFactory.create(this.getSentryConf());){
            UserGroupInformation ugi = UserGroupInformation.getLoginUser();
            String requestorName = ugi.getShortUserName();
            HiveShellCommand command = new HiveShellCommand(client);
            if (StringUtils.isEmpty((String)requestorName)) {
                throw new Exception("The requestor name is empty.");
            }
            if (this.isCreateRole) {
                command.createRole(requestorName, this.roleName);
            } else if (this.isDropRole) {
                command.dropRole(requestorName, this.roleName);
            } else if (this.isAddRoleGroup) {
                HashSet groups = Sets.newHashSet((Object[])this.groupName.split(","));
                command.grantRoleToGroups(requestorName, this.roleName, groups);
            } else if (this.isDeleteRoleGroup) {
                HashSet groups = Sets.newHashSet((Object[])this.groupName.split(","));
                command.revokeRoleFromGroups(requestorName, this.roleName, groups);
            } else if (this.isGrantPrivilegeRole) {
                command.grantPrivilegeToRole(requestorName, this.roleName, this.privilegeStr);
            } else if (this.isRevokePrivilegeRole) {
                command.revokePrivilegeFromRole(requestorName, this.roleName, this.privilegeStr);
            } else if (this.isListRole) {
                List<String> roles = command.listRoles(requestorName, this.groupName);
                for (String role : roles) {
                    System.out.println(role);
                }
            } else if (this.isListPrivilege) {
                List<String> privileges = command.listPrivileges(requestorName, this.roleName);
                for (String privilege : privileges) {
                    System.out.println(privilege);
                }
            } else if (this.isListGroup) {
                List<String> groups = command.listGroupRoles(requestorName);
                for (String group : groups) {
                    System.out.println(group);
                }
            }
        }
    }

    private Configuration getSentryConf() {
        Configuration conf = new Configuration();
        conf.addResource(new Path(this.confPath));
        return conf;
    }

    public static void main(String[] args) throws Exception {
        block3: {
            SentryShellHive sentryShell = new SentryShellHive();
            try {
                sentryShell.executeShell(args);
            }
            catch (Exception e) {
                Throwable current;
                LOGGER.error(e.getMessage(), (Throwable)e);
                for (current = e; current != null && current.getMessage() == null; current = current.getCause()) {
                }
                if (current == null) break block3;
                System.out.println("The operation failed." + (current.getMessage() == null ? "" : "  Message: " + current.getMessage()));
            }
        }
    }
}

