/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.provider.db.tools;

import com.google.common.annotations.VisibleForTesting;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang.StringUtils;

public abstract class SentryShellCommon {
    public static final String OPTION_DESC_HELP = "Shell usage";
    public static final String OPTION_DESC_CONF = "sentry-site file path";
    public static final String OPTION_DESC_ROLE_NAME = "Role name";
    public static final String OPTION_DESC_GROUP_NAME = "Group name";
    public static final String OPTION_DESC_PRIVILEGE = "Privilege string";
    public static final String PREFIX_MESSAGE_MISSING_OPTION = "Missing required option: ";
    public static final String GROUP_SPLIT_CHAR = ",";
    protected String roleName;
    protected String groupName;
    protected String privilegeStr;
    protected String confPath;
    protected boolean isCreateRole;
    protected boolean isDropRole;
    protected boolean isAddRoleGroup;
    protected boolean isDeleteRoleGroup;
    protected boolean isGrantPrivilegeRole;
    protected boolean isRevokePrivilegeRole;
    protected boolean isListRole;
    protected boolean isListPrivilege;
    protected boolean isListGroup;
    protected boolean isPrintHelp;
    protected boolean roleNameRequired;
    protected boolean groupNameRequired;
    protected boolean privilegeStrRequired;
    protected TYPE type;

    protected boolean parseArgs(String[] args) {
        Options simpleShellOptions = new Options();
        Option crOpt = new Option("cr", "create_role", false, "Create role");
        crOpt.setRequired(false);
        Option drOpt = new Option("dr", "drop_role", false, "Drop role");
        drOpt.setRequired(false);
        Option argOpt = new Option("arg", "add_role_group", false, "Add role to group");
        argOpt.setRequired(false);
        Option drgOpt = new Option("drg", "delete_role_group", false, "Delete role from group");
        drgOpt.setRequired(false);
        Option gprOpt = new Option("gpr", "grant_privilege_role", false, "Grant privilege to role");
        gprOpt.setRequired(false);
        Option rprOpt = new Option("rpr", "revoke_privilege_role", false, "Revoke privilege from role");
        rprOpt.setRequired(false);
        Option lrOpt = new Option("lr", "list_role", false, "List role");
        lrOpt.setRequired(false);
        Option lpOpt = new Option("lp", "list_privilege", false, "List privilege");
        lpOpt.setRequired(false);
        Option lgOpt = new Option("lg", "list_group", false, "List groups");
        lgOpt.setRequired(false);
        OptionGroup simpleShellOptGroup = new OptionGroup();
        simpleShellOptGroup.addOption(crOpt);
        simpleShellOptGroup.addOption(drOpt);
        simpleShellOptGroup.addOption(argOpt);
        simpleShellOptGroup.addOption(drgOpt);
        simpleShellOptGroup.addOption(gprOpt);
        simpleShellOptGroup.addOption(rprOpt);
        simpleShellOptGroup.addOption(lrOpt);
        simpleShellOptGroup.addOption(lpOpt);
        simpleShellOptGroup.addOption(lgOpt);
        simpleShellOptGroup.setRequired(true);
        simpleShellOptions.addOptionGroup(simpleShellOptGroup);
        Option pOpt = new Option("p", "privilege", true, OPTION_DESC_PRIVILEGE);
        pOpt.setRequired(false);
        simpleShellOptions.addOption(pOpt);
        Option gOpt = new Option("g", "groupname", true, OPTION_DESC_GROUP_NAME);
        gOpt.setRequired(false);
        simpleShellOptions.addOption(gOpt);
        Option rOpt = new Option("r", "rolename", true, OPTION_DESC_ROLE_NAME);
        rOpt.setRequired(false);
        simpleShellOptions.addOption(rOpt);
        Option tOpt = new Option("t", "type", true, "[hive|solr|sqoop|.....]");
        tOpt.setRequired(false);
        simpleShellOptions.addOption(tOpt);
        Option sentrySitePathOpt = new Option("conf", "sentry_conf", true, OPTION_DESC_CONF);
        sentrySitePathOpt.setRequired(true);
        simpleShellOptions.addOption(sentrySitePathOpt);
        Option helpOpt = new Option("h", "help", false, OPTION_DESC_HELP);
        helpOpt.setRequired(false);
        simpleShellOptions.addOption(helpOpt);
        Options helpOptions = new Options();
        helpOptions.addOption(helpOpt);
        try {
            GnuParser parser = new GnuParser();
            CommandLine cmd = parser.parse(helpOptions, args, true);
            for (Option opt : cmd.getOptions()) {
                if (!opt.getOpt().equals("h")) continue;
                this.usage(simpleShellOptions);
                return false;
            }
            cmd = parser.parse(simpleShellOptions, args);
            for (Option opt : cmd.getOptions()) {
                if (opt.getOpt().equals("p")) {
                    this.privilegeStr = opt.getValue();
                    continue;
                }
                if (opt.getOpt().equals("g")) {
                    this.groupName = opt.getValue();
                    continue;
                }
                if (opt.getOpt().equals("r")) {
                    this.roleName = opt.getValue();
                    continue;
                }
                if (opt.getOpt().equals("cr")) {
                    this.isCreateRole = true;
                    this.roleNameRequired = true;
                    continue;
                }
                if (opt.getOpt().equals("dr")) {
                    this.isDropRole = true;
                    this.roleNameRequired = true;
                    continue;
                }
                if (opt.getOpt().equals("arg")) {
                    this.isAddRoleGroup = true;
                    this.roleNameRequired = true;
                    this.groupNameRequired = true;
                    continue;
                }
                if (opt.getOpt().equals("drg")) {
                    this.isDeleteRoleGroup = true;
                    this.roleNameRequired = true;
                    this.groupNameRequired = true;
                    continue;
                }
                if (opt.getOpt().equals("gpr")) {
                    this.isGrantPrivilegeRole = true;
                    this.roleNameRequired = true;
                    this.privilegeStrRequired = true;
                    continue;
                }
                if (opt.getOpt().equals("rpr")) {
                    this.isRevokePrivilegeRole = true;
                    this.roleNameRequired = true;
                    this.privilegeStrRequired = true;
                    continue;
                }
                if (opt.getOpt().equals("lr")) {
                    this.isListRole = true;
                    continue;
                }
                if (opt.getOpt().equals("lp")) {
                    this.isListPrivilege = true;
                    this.roleNameRequired = true;
                    continue;
                }
                if (opt.getOpt().equals("lg")) {
                    this.isListGroup = true;
                    continue;
                }
                if (opt.getOpt().equals("conf")) {
                    this.confPath = opt.getValue();
                    continue;
                }
                if (!opt.getOpt().equals("t")) continue;
                this.type = TYPE.valueOf(opt.getValue());
            }
            this.checkRequiredParameter(this.roleNameRequired, this.roleName, OPTION_DESC_ROLE_NAME);
            this.checkRequiredParameter(this.groupNameRequired, this.groupName, OPTION_DESC_GROUP_NAME);
            this.checkRequiredParameter(this.privilegeStrRequired, this.privilegeStr, OPTION_DESC_PRIVILEGE);
        }
        catch (ParseException pe) {
            System.out.println(pe.getMessage());
            this.usage(simpleShellOptions);
            return false;
        }
        return true;
    }

    private void checkRequiredParameter(boolean isRequired, String paramValue, String paramName) throws ParseException {
        if (isRequired && StringUtils.isEmpty((String)paramValue)) {
            throw new ParseException(PREFIX_MESSAGE_MISSING_OPTION + paramName);
        }
    }

    private void usage(Options sentryOptions) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("sentryShell", sentryOptions);
    }

    public abstract void run() throws Exception;

    @VisibleForTesting
    public boolean executeShell(String[] args) throws Exception {
        boolean result = true;
        if (this.parseArgs(args)) {
            this.run();
        } else {
            result = false;
        }
        return result;
    }

    public static enum TYPE {
        kafka,
        hive,
        solr,
        sqoop;

    }
}

