/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.provider.db.tools;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.IllegalFormatException;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.io.output.NullOutputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hive.beeline.BeeLine;
import org.apache.sentry.Command;
import org.apache.sentry.core.common.exception.SentrySiteConfigurationException;
import org.apache.sentry.core.common.exception.SentryUserException;
import org.apache.sentry.provider.db.service.persistent.SentryStoreSchemaInfo;
import org.apache.sentry.provider.db.tools.SentrySchemaHelper;
import org.apache.sentry.service.thrift.SentryService;

public class SentrySchemaTool {
    private static final String SENTRY_SCRIP_DIR = File.separatorChar + "scripts" + File.separatorChar + "sentrystore" + File.separatorChar + "upgrade";
    private String userName = null;
    private String passWord = null;
    private String connectionURL = null;
    private String driver = null;
    private boolean dryRun = false;
    private String dbOpts = null;
    private boolean verbose = false;
    private final Configuration sentryConf;
    private final String dbType;
    private final SentryStoreSchemaInfo sentryStoreSchemaInfo;

    public SentrySchemaTool(Configuration sentryConf, String dbType) throws SentryUserException, IOException {
        this(System.getenv("SENTRY_HOME") + SENTRY_SCRIP_DIR, sentryConf, dbType);
    }

    public SentrySchemaTool(String sentryScripPath, Configuration sentryConf, String dbType) throws SentryUserException, IOException {
        if (sentryScripPath == null || sentryScripPath.isEmpty()) {
            throw new SentryUserException("No Sentry script dir provided");
        }
        this.sentryConf = sentryConf;
        this.dbType = dbType;
        this.sentryStoreSchemaInfo = new SentryStoreSchemaInfo(sentryScripPath, dbType);
        this.userName = sentryConf.get("sentry.store.jdbc.user", "Sentry");
        char[] passTmp = sentryConf.getPassword("sentry.store.jdbc.password");
        if (passTmp == null) {
            throw new SentrySiteConfigurationException("Error reading sentry.store.jdbc.password");
        }
        this.passWord = new String(passTmp);
        try {
            this.connectionURL = this.getValidConfVar("sentry.store.jdbc.url");
            this.driver = dbType.equalsIgnoreCase("derby") ? sentryConf.get("sentry.store.jdbc.driver", "org.apache.derby.jdbc.EmbeddedDriver") : this.getValidConfVar("sentry.store.jdbc.driver");
            Class.forName(this.driver);
        }
        catch (IOException e) {
            throw new SentryUserException("Missing property: " + e.getMessage());
        }
        catch (ClassNotFoundException e) {
            throw new SentryUserException("Failed to load driver", (Throwable)e);
        }
    }

    public Configuration getConfiguration() {
        return this.sentryConf;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setPassWord(String passWord) {
        this.passWord = passWord;
    }

    public void setDryRun(boolean dryRun) {
        this.dryRun = dryRun;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public String getDbOpts() {
        return this.dbOpts;
    }

    public void setDbOpts(String dbOpts) {
        this.dbOpts = dbOpts;
    }

    private static void printAndExit(Options cmdLineOptions) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("schemaTool", cmdLineOptions);
        System.exit(1);
    }

    public void showInfo() throws SentryUserException {
        Connection sentryStoreConn = this.getConnectionToMetastore(true);
        System.out.println("Sentry distribution version:\t " + SentryStoreSchemaInfo.getSentryVersion());
        System.out.println("SentryStore schema version:\t " + this.getMetaStoreSchemaVersion(sentryStoreConn));
    }

    /*
     * Exception decompiling
     */
    private String getMetaStoreSchemaVersion(Connection sentryStoreConn) throws SentryUserException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void testConnectionToMetastore() throws SentryUserException {
        try (Connection conn = this.getConnectionToMetastore(true);){
            conn.close();
        }
        catch (SQLException e) {
            throw new SentryUserException("Failed to close sentry store connection", (Throwable)e);
        }
    }

    private Connection getConnectionToMetastore(boolean printInfo) throws SentryUserException {
        if (printInfo) {
            System.out.println("Sentry store connection URL:\t " + this.connectionURL);
            System.out.println("Sentry store Connection Driver :\t " + this.driver);
            System.out.println("Sentry store connection User:\t " + this.userName);
        }
        if (this.userName == null || this.userName.isEmpty()) {
            throw new SentryUserException("UserName empty ");
        }
        try {
            return DriverManager.getConnection(this.connectionURL, this.userName, this.passWord);
        }
        catch (SQLException e) {
            throw new SentryUserException("Failed to make connection to Sentry store.", (Throwable)e);
        }
    }

    public void verifySchemaVersion() throws SentryUserException {
        if (this.dryRun) {
            return;
        }
        String newSchemaVersion = this.getMetaStoreSchemaVersion(this.getConnectionToMetastore(false));
        if (!this.sentryStoreSchemaInfo.getSentrySchemaVersion().equalsIgnoreCase(newSchemaVersion)) {
            throw new SentryUserException("Found unexpected schema version " + newSchemaVersion);
        }
    }

    public void doUpgrade() throws SentryUserException {
        String fromVersion = this.getMetaStoreSchemaVersion(this.getConnectionToMetastore(false));
        if (fromVersion == null || fromVersion.isEmpty()) {
            throw new SentryUserException("Schema version not stored in the sentry store. Metastore schema is too old or corrupt. Try specifying the version manually");
        }
        this.doUpgrade(fromVersion);
    }

    public void doUpgrade(String fromSchemaVer) throws SentryUserException {
        if (this.sentryStoreSchemaInfo.getSentrySchemaVersion().equals(fromSchemaVer)) {
            System.out.println("No schema upgrade required from version " + fromSchemaVer);
            return;
        }
        List<String> upgradeScripts = this.sentryStoreSchemaInfo.getUpgradeScripts(fromSchemaVer);
        this.testConnectionToMetastore();
        System.out.println("Starting upgrade sentry store schema from version " + fromSchemaVer + " to " + this.sentryStoreSchemaInfo.getSentrySchemaVersion());
        String scriptDir = this.sentryStoreSchemaInfo.getSentryStoreScriptDir();
        try {
            for (String scriptFile : upgradeScripts) {
                System.out.println("Upgrade script " + scriptFile);
                if (this.dryRun) continue;
                this.runBeeLine(scriptDir, scriptFile);
                System.out.println("Completed " + scriptFile);
            }
        }
        catch (IOException eIO) {
            throw new SentryUserException("Upgrade FAILED! Metastore state would be inconsistent !!", (Throwable)eIO);
        }
        this.verifySchemaVersion();
    }

    public void doInit() throws SentryUserException {
        this.doInit(this.sentryStoreSchemaInfo.getSentrySchemaVersion());
        this.verifySchemaVersion();
    }

    public void doInit(String toVersion) throws SentryUserException {
        this.testConnectionToMetastore();
        System.out.println("Starting sentry store schema initialization to " + toVersion);
        String initScriptDir = this.sentryStoreSchemaInfo.getSentryStoreScriptDir();
        String initScriptFile = this.sentryStoreSchemaInfo.generateInitFileName(toVersion);
        try {
            System.out.println("Initialization script " + initScriptFile);
            if (!this.dryRun) {
                this.runBeeLine(initScriptDir, initScriptFile);
                System.out.println("Initialization script completed");
            }
        }
        catch (IOException e) {
            throw new SentryUserException("Schema initialization FAILED! Metastore state would be inconsistent !!", (Throwable)e);
        }
    }

    public static String buildCommand(SentrySchemaHelper.NestedScriptParser dbCommandParser, String scriptDir, String scriptFile) throws IllegalFormatException, IOException {
        String currLine;
        BufferedReader bfReader = new BufferedReader(new FileReader(scriptDir + File.separatorChar + scriptFile));
        StringBuilder sb = new StringBuilder();
        String currentCommand = null;
        while ((currLine = bfReader.readLine()) != null) {
            if ((currLine = currLine.trim()).isEmpty()) continue;
            currentCommand = currentCommand == null ? currLine : currentCommand + " " + currLine;
            if (dbCommandParser.isPartialCommand(currLine)) continue;
            if (!dbCommandParser.isNonExecCommand(currentCommand)) {
                if (dbCommandParser.isNestedScript(currentCommand = dbCommandParser.cleanseCommand(currentCommand))) {
                    String currScript = dbCommandParser.getScriptName(currentCommand);
                    sb.append(SentrySchemaTool.buildCommand(dbCommandParser, scriptDir, currScript));
                } else {
                    sb.append(currentCommand);
                    sb.append(System.getProperty("line.separator"));
                }
            }
            currentCommand = null;
        }
        bfReader.close();
        return sb.toString();
    }

    private void runBeeLine(String scriptDir, String scriptFile) throws IOException {
        SentrySchemaHelper.NestedScriptParser dbCommandParser = SentrySchemaHelper.getDbCommandParser(this.dbType);
        dbCommandParser.setDbOpts(this.getDbOpts());
        String sqlCommands = SentrySchemaTool.buildCommand(dbCommandParser, scriptDir, scriptFile);
        File tmpFile = File.createTempFile("schematool", ".sql");
        tmpFile.deleteOnExit();
        try (FileWriter fstream = new FileWriter(tmpFile.getPath());
             BufferedWriter out = new BufferedWriter(fstream);){
            out.write("!set Silent " + this.verbose + System.getProperty("line.separator"));
            out.write("!autocommit on" + System.getProperty("line.separator"));
            out.write("!set Isolation TRANSACTION_READ_COMMITTED" + System.getProperty("line.separator"));
            out.write("!set AllowMultiLineCommand false" + System.getProperty("line.separator"));
            out.write(sqlCommands);
            out.write("!closeall" + System.getProperty("line.separator"));
            out.close();
        }
        this.runBeeLine(tmpFile.getPath());
    }

    public void runBeeLine(String sqlScriptFile) throws IOException {
        int status;
        ArrayList<String> argList = new ArrayList<String>();
        argList.add("-u");
        argList.add(this.connectionURL);
        argList.add("-d");
        argList.add(this.driver);
        argList.add("-n");
        argList.add(this.userName);
        argList.add("-p");
        argList.add(this.passWord);
        argList.add("-f");
        argList.add(sqlScriptFile);
        BeeLine beeLine = new BeeLine();
        if (!this.verbose) {
            beeLine.setOutputStream(new PrintStream((OutputStream)new NullOutputStream()));
        }
        if ((status = beeLine.begin(argList.toArray(new String[0]), null)) != 0) {
            throw new IOException("Schema script failed, errorcode " + status);
        }
    }

    private String getValidConfVar(String confVar) throws IOException {
        String confVarKey = confVar;
        String confVarValue = this.sentryConf.get(confVarKey);
        if (confVarValue == null || confVarValue.isEmpty()) {
            throw new IOException("Empty " + confVar);
        }
        return confVarValue;
    }

    private static void initOptions(Options cmdLineOptions) {
        Option help = new Option("help", "print this message");
        Option upgradeOpt = new Option("upgradeSchema", "Schema upgrade");
        OptionBuilder.withArgName((String)"upgradeFrom");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Schema upgrade from a version");
        Option upgradeFromOpt = OptionBuilder.create((String)"upgradeSchemaFrom");
        Option initOpt = new Option("initSchema", "Schema initialization");
        OptionBuilder.withArgName((String)"initTo");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Schema initialization to a version");
        Option initToOpt = OptionBuilder.create((String)"initSchemaTo");
        Option infoOpt = new Option("info", "Show config and schema details");
        OptionGroup optGroup = new OptionGroup();
        optGroup.addOption(upgradeOpt).addOption(initOpt).addOption(help).addOption(upgradeFromOpt).addOption(initToOpt).addOption(infoOpt);
        optGroup.setRequired(true);
        OptionBuilder.withArgName((String)"user");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Override config file user name");
        Option userNameOpt = OptionBuilder.create((String)"userName");
        OptionBuilder.withArgName((String)"password");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Override config file password");
        Option passwdOpt = OptionBuilder.create((String)"passWord");
        OptionBuilder.withArgName((String)"databaseType");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Metastore database type [derby,mysql,oracle,postgres,db2]");
        Option dbTypeOpt = OptionBuilder.create((String)"dbType");
        OptionBuilder.withArgName((String)"databaseOpts");
        OptionBuilder.hasArgs();
        OptionBuilder.withDescription((String)"Backend DB specific options");
        Option dbOpts = OptionBuilder.create((String)"dbOpts");
        Option dryRunOpt = new Option("dryRun", "list SQL scripts (no execute)");
        Option verboseOpt = new Option("verbose", "only print SQL statements");
        OptionBuilder.withArgName((String)"confName");
        OptionBuilder.hasArgs();
        OptionBuilder.withDescription((String)"Sentry Service configuration file");
        OptionBuilder.isRequired((boolean)true);
        Option configOpt = OptionBuilder.create((String)"conffile");
        cmdLineOptions.addOption(help);
        cmdLineOptions.addOption(dryRunOpt);
        cmdLineOptions.addOption(userNameOpt);
        cmdLineOptions.addOption(passwdOpt);
        cmdLineOptions.addOption(dbTypeOpt);
        cmdLineOptions.addOption(verboseOpt);
        cmdLineOptions.addOption(dbOpts);
        cmdLineOptions.addOption(configOpt);
        cmdLineOptions.addOptionGroup(optGroup);
    }

    public static class CommandImpl
    implements Command {
        public void run(String[] args) throws Exception {
            GnuParser parser = new GnuParser();
            CommandLine line = null;
            String dbType = null;
            String schemaVer = null;
            Options cmdLineOptions = new Options();
            String configFileName = null;
            SentrySchemaTool.initOptions(cmdLineOptions);
            try {
                line = parser.parse(cmdLineOptions, args);
            }
            catch (ParseException e) {
                System.err.println("SentrySchemaTool:Parsing failed.  Reason: " + e.getLocalizedMessage());
                SentrySchemaTool.printAndExit(cmdLineOptions);
            }
            if (line.hasOption("help")) {
                HelpFormatter formatter = new HelpFormatter();
                formatter.printHelp("schemaTool", cmdLineOptions);
                return;
            }
            if (line.hasOption("dbType")) {
                dbType = line.getOptionValue("dbType");
                if (!(dbType.equalsIgnoreCase("derby") || dbType.equalsIgnoreCase("mysql") || dbType.equalsIgnoreCase("postgres") || dbType.equalsIgnoreCase("oracle") || dbType.equalsIgnoreCase("db2"))) {
                    System.err.println("Unsupported dbType " + dbType);
                    SentrySchemaTool.printAndExit(cmdLineOptions);
                }
            } else {
                System.err.println("no dbType supplied");
                SentrySchemaTool.printAndExit(cmdLineOptions);
            }
            if (line.hasOption("conffile")) {
                configFileName = line.getOptionValue("conffile");
            } else {
                System.err.println("no config file specified");
                SentrySchemaTool.printAndExit(cmdLineOptions);
            }
            try {
                SentrySchemaTool schemaTool = new SentrySchemaTool(SentryService.loadConfig(configFileName), dbType);
                if (line.hasOption("userName")) {
                    schemaTool.setUserName(line.getOptionValue("userName"));
                }
                if (line.hasOption("passWord")) {
                    schemaTool.setPassWord(line.getOptionValue("passWord"));
                }
                if (line.hasOption("dryRun")) {
                    schemaTool.setDryRun(true);
                }
                if (line.hasOption("verbose")) {
                    schemaTool.setVerbose(true);
                }
                if (line.hasOption("dbOpts")) {
                    schemaTool.setDbOpts(line.getOptionValue("dbOpts"));
                }
                if (line.hasOption("info")) {
                    schemaTool.showInfo();
                } else if (line.hasOption("upgradeSchema")) {
                    schemaTool.doUpgrade();
                } else if (line.hasOption("upgradeSchemaFrom")) {
                    schemaVer = line.getOptionValue("upgradeSchemaFrom");
                    schemaTool.doUpgrade(schemaVer);
                } else if (line.hasOption("initSchema")) {
                    schemaTool.doInit();
                } else if (line.hasOption("initSchemaTo")) {
                    schemaVer = line.getOptionValue("initSchemaTo");
                    schemaTool.doInit(schemaVer);
                } else {
                    System.err.println("no valid option supplied");
                    SentrySchemaTool.printAndExit(cmdLineOptions);
                }
            }
            catch (SentryUserException e) {
                System.err.println((Object)e);
                if (line.hasOption("verbose")) {
                    e.printStackTrace();
                }
                System.err.println("*** Sentry schemaTool failed ***");
                System.exit(1);
            }
            catch (MalformedURLException e) {
                System.err.println(e);
                if (line.hasOption("verbose")) {
                    e.printStackTrace();
                }
                System.err.println("*** Sentry schemaTool failed ***");
                System.exit(1);
            }
            System.out.println("Sentry schemaTool completed");
        }
    }
}

