/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.provider.db.service.thrift.validator;

import java.util.Set;
import org.apache.sentry.core.common.exception.SentryInvalidInputException;
import org.apache.sentry.provider.db.service.thrift.TAlterSentryRoleGrantPrivilegeRequest;
import org.apache.sentry.provider.db.service.thrift.TSentryGrantOption;
import org.apache.sentry.provider.db.service.thrift.TSentryPrivilege;

public final class GrantPrivilegeRequestValidator {
    private GrantPrivilegeRequestValidator() {
    }

    public static void validate(TAlterSentryRoleGrantPrivilegeRequest request) throws SentryInvalidInputException {
        if (request.isSetPrivileges() && !request.getPrivileges().isEmpty()) {
            GrantPrivilegeRequestValidator.checkForMandatoryFieldsInPrivileges(request.getPrivileges());
            GrantPrivilegeRequestValidator.validateGrantOptionInprivileges(request.getPrivileges());
        }
    }

    static void checkForMandatoryFieldsInPrivileges(Set<TSentryPrivilege> privileges) throws SentryInvalidInputException {
        for (TSentryPrivilege privilege : privileges) {
            if (privilege.getServerName() == null || privilege.getServerName().trim().isEmpty()) {
                throw new SentryInvalidInputException("Invalid Privilege input: Server Name is missing");
            }
            if (privilege.getAction() != null && !privilege.getAction().trim().isEmpty()) continue;
            throw new SentryInvalidInputException("Invalid Privilege input: Action is missing");
        }
    }

    private static void validateGrantOptionInprivileges(Set<TSentryPrivilege> privileges) throws SentryInvalidInputException {
        for (TSentryPrivilege privilege : privileges) {
            if (privilege.getGrantOption() != TSentryGrantOption.UNSET) continue;
            throw new SentryInvalidInputException("Invalid Privilege input, UNSET option for GRANT <PRIVILEGE> is not valid");
        }
    }
}

