/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.provider.db.service.thrift;

import com.codahale.metrics.servlets.AdminServlet;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.net.URL;
import java.util.EnumSet;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.servlet.DispatcherType;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.sentry.provider.db.service.thrift.ConfServlet;
import org.apache.sentry.provider.db.service.thrift.LogLevelServlet;
import org.apache.sentry.provider.db.service.thrift.PubSubServlet;
import org.apache.sentry.provider.db.service.thrift.SentryAdminServlet;
import org.apache.sentry.provider.db.service.thrift.SentryAuthFilter;
import org.apache.sentry.service.thrift.ServiceConstants;
import org.eclipse.jetty.security.ConstraintMapping;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.ResourceHandler;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.security.Constraint;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SentryWebServer {
    private static final Logger LOGGER = LoggerFactory.getLogger(SentryWebServer.class);
    private static final String RESOURCE_DIR = "/webapp";
    private static final String WELCOME_PAGE = "SentryService.html";
    private Server server = new Server();

    public SentryWebServer(List<EventListener> listeners, int port, Configuration conf) {
        ServerConnector connector;
        if (conf.getBoolean("sentry.web.use.ssl", false)) {
            SslContextFactory sslContextFactory = new SslContextFactory();
            sslContextFactory.setKeyStorePath(conf.get("sentry.web.ssl.keystore.path", ""));
            sslContextFactory.setKeyStorePassword(conf.get("sentry.web.ssl.keystore.password", ""));
            sslContextFactory.setExcludeProtocols(ServiceConstants.ServerConfig.SENTRY_SSL_PROTOCOL_BLACKLIST_DEFAULT);
            HashSet moreExcludedSSLProtocols = Sets.newHashSet((Iterable)Splitter.on((String)",").trimResults().omitEmptyStrings().split((CharSequence)Strings.nullToEmpty((String)conf.get("sentry.ssl.protocol.blacklist"))));
            sslContextFactory.addExcludeProtocols(moreExcludedSSLProtocols.toArray(new String[moreExcludedSSLProtocols.size()]));
            HttpConfiguration httpConfiguration = new HttpConfiguration();
            httpConfiguration.setSecurePort(port);
            httpConfiguration.setSecureScheme("https");
            httpConfiguration.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
            connector = new ServerConnector(this.server, new ConnectionFactory[]{new SslConnectionFactory(sslContextFactory, "http/1.1"), new HttpConnectionFactory(httpConfiguration)});
            LOGGER.info("Now using SSL mode.");
        } else {
            connector = new ServerConnector(this.server, new ConnectionFactory[]{new HttpConnectionFactory()});
        }
        connector.setPort(port);
        this.server.setConnectors(new Connector[]{connector});
        ServletContextHandler servletContextHandler = new ServletContextHandler();
        ServletHolder servletHolder = new ServletHolder(AdminServlet.class);
        servletContextHandler.addServlet(servletHolder, "/*");
        for (EventListener listener : listeners) {
            servletContextHandler.addEventListener(listener);
        }
        servletContextHandler.addServlet(new ServletHolder(ConfServlet.class), "/conf");
        if (conf.getBoolean("sentry.web.admin.servlet.enabled", false)) {
            servletContextHandler.addServlet(new ServletHolder(SentryAdminServlet.class), "/admin/*");
        }
        servletContextHandler.getServletContext().setAttribute("sentry.conf", (Object)conf);
        servletContextHandler.addServlet(new ServletHolder(LogLevelServlet.class), "/admin/logLevel");
        if (conf.getBoolean("sentry.web.pubsub.servlet.enabled", false)) {
            servletContextHandler.addServlet(new ServletHolder(PubSubServlet.class), "/admin/publishMessage");
        }
        ResourceHandler resourceHandler = new ResourceHandler();
        resourceHandler.setDirectoriesListed(true);
        URL url = this.getClass().getResource(RESOURCE_DIR);
        try {
            resourceHandler.setBaseResource(Resource.newResource((String)url.toString()));
        }
        catch (IOException e) {
            LOGGER.error("Got exception while setBaseResource for Sentry Service web UI", (Throwable)e);
        }
        resourceHandler.setWelcomeFiles(new String[]{WELCOME_PAGE});
        ContextHandler contextHandler = new ContextHandler();
        contextHandler.setHandler((Handler)resourceHandler);
        ContextHandlerCollection contextHandlerCollection = new ContextHandlerCollection();
        contextHandlerCollection.setHandlers(new Handler[]{contextHandler, servletContextHandler});
        String authMethod = conf.get("sentry.service.web.authentication.type");
        if (!"NONE".equalsIgnoreCase(authMethod)) {
            FilterHolder filterHolder = servletContextHandler.addFilter(SentryAuthFilter.class, "/*", EnumSet.of(DispatcherType.REQUEST));
            filterHolder.setInitParameters(SentryWebServer.loadWebAuthenticationConf(conf));
        }
        this.server.setHandler(this.disableTraceMethod((Handler)contextHandlerCollection));
    }

    private Handler disableTraceMethod(Handler handler) {
        Constraint disableTraceConstraint = new Constraint();
        disableTraceConstraint.setName("Disable TRACE");
        disableTraceConstraint.setAuthenticate(true);
        ConstraintMapping mapping = new ConstraintMapping();
        mapping.setConstraint(disableTraceConstraint);
        mapping.setMethod("TRACE");
        mapping.setPathSpec("/");
        ConstraintSecurityHandler constraintSecurityHandler = new ConstraintSecurityHandler();
        constraintSecurityHandler.addConstraintMapping(mapping);
        constraintSecurityHandler.setHandler(handler);
        return constraintSecurityHandler;
    }

    public void start() throws Exception {
        this.server.start();
    }

    public void stop() throws Exception {
        this.server.stop();
    }

    public boolean isAlive() {
        return this.server != null && this.server.isStarted();
    }

    private static Map<String, String> loadWebAuthenticationConf(Configuration conf) {
        HashMap<String, String> prop = new HashMap<String, String>();
        prop.put("config.prefix", "sentry.service.web.authentication");
        String allowUsers = conf.get("sentry.service.web.authentication.allow.connect.users");
        if (allowUsers == null || allowUsers.equals("")) {
            allowUsers = conf.get("sentry.service.allow.connect");
            conf.set("sentry.service.web.authentication.allow.connect.users", allowUsers);
        }
        SentryWebServer.validateConf(conf);
        for (Map.Entry entry : conf) {
            String name = (String)entry.getKey();
            if (!name.startsWith("sentry.service.web.authentication")) continue;
            String value = conf.get(name);
            prop.put(name, value);
        }
        return prop;
    }

    private static void validateConf(Configuration conf) {
        String authHandlerName = conf.get("sentry.service.web.authentication.type");
        Preconditions.checkNotNull((Object)authHandlerName, (Object)"Web authHandler should not be null.");
        String allowUsers = conf.get("sentry.service.web.authentication.allow.connect.users");
        Preconditions.checkNotNull((Object)allowUsers, (Object)"Allow connect user(s) should not be null.");
        if ("KERBEROS".equalsIgnoreCase(authHandlerName)) {
            String principal = conf.get("sentry.service.web.authentication.kerberos.principal");
            Preconditions.checkNotNull((Object)principal, (Object)"Kerberos principal should not be null.");
            Preconditions.checkArgument((principal.length() != 0 ? 1 : 0) != 0, (Object)"Kerberos principal is not right.");
            String keytabFile = conf.get("sentry.service.web.authentication.kerberos.keytab");
            Preconditions.checkNotNull((Object)keytabFile, (Object)"Keytab File should not be null.");
            Preconditions.checkArgument((keytabFile.length() != 0 ? 1 : 0) != 0, (Object)"Keytab File is not right.");
            try {
                UserGroupInformation.setConfiguration((Configuration)conf);
                String hostPrincipal = SecurityUtil.getServerPrincipal((String)principal, (String)"0.0.0.0");
                UserGroupInformation.loginUserFromKeytab((String)hostPrincipal, (String)keytabFile);
            }
            catch (IOException ex) {
                throw new IllegalArgumentException("Can't use Kerberos authentication, principal [" + principal + "] keytab [" + keytabFile + "]", ex);
            }
            LOGGER.info("Using Kerberos authentication, principal [{}] keytab [{}]", (Object)principal, (Object)keytabFile);
        }
    }
}

