/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.provider.db.service.thrift;

import com.google.gson.Gson;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.conf.Configuration;
import org.apache.sentry.provider.db.service.persistent.SentryStore;
import org.apache.sentry.provider.db.service.thrift.TSentryPrivilege;

public class SentryAdminServlet
extends HttpServlet {
    private static final String SHOW_ALL = "/showAll";
    private static final String TEMPLATE = "<!DOCTYPE HTML>\n<html lang=\"en\">\n<head>\n    <meta charset=\"utf-8\">\n    <title>Sentry Service Admin</title>\n    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">\n    <meta name=\"description\" content=\"\">\n    <link href=\"css/bootstrap.min.css\" rel=\"stylesheet\">\n    <link href=\"css/bootstrap-theme.min.css\" rel=\"stylesheet\">\n    <link href=\"css/sentry.css\" rel=\"stylesheet\">\n</head>\n<body>\n<nav class=\"navbar navbar-default navbar-fixed-top\">\n    <div class=\"container\">\n        <div class=\"navbar-header\">\n            <a class=\"navbar-brand\" href=\"#\"><img src=\"sentry.png\" alt=\"Sentry Logo\"/></a>\n        </div>\n        <div class=\"collapse navbar-collapse\">\n            <ul class=\"nav navbar-nav\">\n                <li class=\"active\"><a href=\"#\">Admin</a></li>\n                <li><a href=\"/metrics?pretty=true\">Metrics</a></li>\n                <li><a href=\"/threads\">Threads</a></li>\n                <li><a href=\"/conf\">Configuration</a></li>\n                <li><a href=\"/admin/showAll\">ShowAllRoles</a></li>\n            </ul>\n        </div>\n    </div>\n</nav>\n<div class=\"container\">\n    <ul>\n        <li><a href=\"/metrics?pretty=true\">Metrics</a></li>\n        <li><a href=\"/threads\">Threads</a></li>\n        <li><a href=\"/conf\">Configuration</a></li>\n        <li><a href=\"/admin/showAll\">ShowAllRoles</a></li>\n    </ul>\n</div>\n</body>\n</html>";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String uri = request.getPathInfo();
        if (uri != null && !uri.equals("/")) {
            if (uri.equals(SHOW_ALL)) {
                this.showAll(response);
            } else {
                response.sendError(404);
            }
        } else {
            response.setStatus(200);
            response.setHeader("Cache-Control", "must-revalidate,no-cache,no-store");
            response.setHeader("Pragma", "no-cache");
            response.setDateHeader("Expires", 0L);
            response.setContentType("text/html");
            try (PrintWriter writer = response.getWriter();){
                writer.println(TEMPLATE);
            }
        }
    }

    private void showAll(HttpServletResponse response) throws ServletException, IOException {
        Configuration conf = (Configuration)this.getServletContext().getAttribute("sentry.conf");
        assert (conf != null);
        PrintWriter out = response.getWriter();
        try {
            SentryStore sentrystore = new SentryStore(conf);
            HashMap<String, Set<TSentryPrivilege>> roleMap = new HashMap<String, Set<TSentryPrivilege>>();
            Set<String> roleSet = sentrystore.getAllRoleNames();
            for (String roleName : roleSet) {
                roleMap.put(roleName, sentrystore.getAllTSentryPrivilegesByRoleName(roleName));
            }
            String json = new Gson().toJson(roleMap);
            response.setContentType("application/json");
            response.setCharacterEncoding("UTF-8");
            ((Writer)out).write(json);
        }
        catch (Exception e) {
            response.sendError(400, e.getMessage());
        }
        ((Writer)out).close();
    }
}

