/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.provider.db.service.thrift;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.sentry.provider.db.service.thrift.NotificationHandler;
import org.apache.sentry.provider.db.service.thrift.TAlterSentryRoleAddGroupsRequest;
import org.apache.sentry.provider.db.service.thrift.TAlterSentryRoleAddGroupsResponse;
import org.apache.sentry.provider.db.service.thrift.TAlterSentryRoleAddUsersRequest;
import org.apache.sentry.provider.db.service.thrift.TAlterSentryRoleAddUsersResponse;
import org.apache.sentry.provider.db.service.thrift.TAlterSentryRoleDeleteGroupsRequest;
import org.apache.sentry.provider.db.service.thrift.TAlterSentryRoleDeleteGroupsResponse;
import org.apache.sentry.provider.db.service.thrift.TAlterSentryRoleDeleteUsersRequest;
import org.apache.sentry.provider.db.service.thrift.TAlterSentryRoleDeleteUsersResponse;
import org.apache.sentry.provider.db.service.thrift.TAlterSentryRoleGrantPrivilegeRequest;
import org.apache.sentry.provider.db.service.thrift.TAlterSentryRoleGrantPrivilegeResponse;
import org.apache.sentry.provider.db.service.thrift.TAlterSentryRoleRevokePrivilegeRequest;
import org.apache.sentry.provider.db.service.thrift.TAlterSentryRoleRevokePrivilegeResponse;
import org.apache.sentry.provider.db.service.thrift.TCreateSentryRoleRequest;
import org.apache.sentry.provider.db.service.thrift.TCreateSentryRoleResponse;
import org.apache.sentry.provider.db.service.thrift.TDropSentryRoleRequest;
import org.apache.sentry.provider.db.service.thrift.TDropSentryRoleResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotificationHandlerInvoker
extends NotificationHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(NotificationHandlerInvoker.class);
    private final ImmutableList<NotificationHandler> handlers;

    public NotificationHandlerInvoker(Configuration conf, List<NotificationHandler> handlers) throws Exception {
        super(conf);
        this.handlers = ImmutableList.copyOf(handlers);
    }

    @Override
    public void create_sentry_role(TCreateSentryRoleRequest request, TCreateSentryRoleResponse response) {
        for (NotificationHandler handler : this.handlers) {
            try {
                LOGGER.debug("Calling " + handler);
                handler.create_sentry_role(new TCreateSentryRoleRequest(request), new TCreateSentryRoleResponse(response));
            }
            catch (Exception ex) {
                LOGGER.error("Unexpected error in " + handler + ". Request: " + request + ", Response: " + response, (Throwable)ex);
            }
        }
    }

    @Override
    public void drop_sentry_role(TDropSentryRoleRequest request, TDropSentryRoleResponse response) {
        for (NotificationHandler handler : this.handlers) {
            try {
                LOGGER.debug("Calling " + handler);
                handler.drop_sentry_role(new TDropSentryRoleRequest(request), new TDropSentryRoleResponse(response));
            }
            catch (Exception ex) {
                LOGGER.error("Unexpected error in " + handler + ". Request: " + request + ", Response: " + response, (Throwable)ex);
            }
        }
    }

    @Override
    public void alter_sentry_role_grant_privilege(TAlterSentryRoleGrantPrivilegeRequest request, TAlterSentryRoleGrantPrivilegeResponse response) {
        for (NotificationHandler handler : this.handlers) {
            try {
                LOGGER.debug("Calling " + handler);
                handler.alter_sentry_role_grant_privilege(new TAlterSentryRoleGrantPrivilegeRequest(request), new TAlterSentryRoleGrantPrivilegeResponse(response));
            }
            catch (Exception ex) {
                LOGGER.error("Unexpected error in " + handler + ". Request: " + request + ", Response: " + response, (Throwable)ex);
            }
        }
    }

    @Override
    public void alter_sentry_role_revoke_privilege(TAlterSentryRoleRevokePrivilegeRequest request, TAlterSentryRoleRevokePrivilegeResponse response) {
        for (NotificationHandler handler : this.handlers) {
            try {
                LOGGER.debug("Calling " + handler);
                handler.alter_sentry_role_revoke_privilege(new TAlterSentryRoleRevokePrivilegeRequest(request), new TAlterSentryRoleRevokePrivilegeResponse(response));
            }
            catch (Exception ex) {
                LOGGER.error("Unexpected error in " + handler + ". Request: " + request + ", Response: " + response, (Throwable)ex);
            }
        }
    }

    @Override
    public void alter_sentry_role_add_groups(TAlterSentryRoleAddGroupsRequest request, TAlterSentryRoleAddGroupsResponse response) {
        for (NotificationHandler handler : this.handlers) {
            try {
                LOGGER.debug("Calling " + handler);
                handler.alter_sentry_role_add_groups(new TAlterSentryRoleAddGroupsRequest(request), new TAlterSentryRoleAddGroupsResponse(response));
            }
            catch (Exception ex) {
                LOGGER.error("Unexpected error in " + handler + ". Request: " + request + ", Response: " + response, (Throwable)ex);
            }
        }
    }

    @Override
    public void alter_sentry_role_delete_groups(TAlterSentryRoleDeleteGroupsRequest request, TAlterSentryRoleDeleteGroupsResponse response) {
        for (NotificationHandler handler : this.handlers) {
            try {
                LOGGER.debug("Calling " + handler);
                handler.alter_sentry_role_delete_groups(new TAlterSentryRoleDeleteGroupsRequest(request), new TAlterSentryRoleDeleteGroupsResponse(response));
            }
            catch (Exception ex) {
                LOGGER.error("Unexpected error in " + handler + ". Request: " + request + ", Response: " + response, (Throwable)ex);
            }
        }
    }

    @Override
    public void alter_sentry_role_add_users(TAlterSentryRoleAddUsersRequest request, TAlterSentryRoleAddUsersResponse response) {
        for (NotificationHandler handler : this.handlers) {
            try {
                LOGGER.debug("Calling " + handler);
                handler.alter_sentry_role_add_users(new TAlterSentryRoleAddUsersRequest(request), new TAlterSentryRoleAddUsersResponse(response));
            }
            catch (Exception ex) {
                LOGGER.error("Unexpected error in " + handler + ". Request: " + request + ", Response: " + response, (Throwable)ex);
            }
        }
    }

    @Override
    public void alter_sentry_role_delete_users(TAlterSentryRoleDeleteUsersRequest request, TAlterSentryRoleDeleteUsersResponse response) {
        for (NotificationHandler handler : this.handlers) {
            try {
                LOGGER.debug("Calling " + handler);
                handler.alter_sentry_role_delete_users(new TAlterSentryRoleDeleteUsersRequest(request), new TAlterSentryRoleDeleteUsersResponse(response));
            }
            catch (Exception ex) {
                LOGGER.error("Unexpected error in " + handler + ". Request: " + request + ", Response: " + response, (Throwable)ex);
            }
        }
    }
}

