/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.provider.db.service.thrift;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class LogLevelServlet
extends HttpServlet {
    private static final String LF = "\n";
    private static final String BR = "<br />";
    private static final String B_BR = "<b>%s</b><br />";
    private static final String FORMS_HEAD = "<h1>Log Level</h1>\n<br /><hr /><h3>Results</h3>\n Submitted Log Name: <b>%s</b><br />";
    private static final String FORMS_CONTENT_GET = "\n Effective level: <b>%s</b><br />";
    private static final String FORMS_CONTENT_SET = "\n Submitted Level: <b>%s</b><br />\n Setting Level to %s<br />\n Effective level: <b>%s</b><br />";
    private static final String FORMS_END = "\n<br /><hr /><h3>Get / Set</h3>\n<form>Log: <input type='text' size='50' name='log' /> <input type='submit' value='Get Log Level' /></form>\n<form>Log: <input type='text' size='50' name='log' /> Level: <input type='text' name='level' /> <input type='submit' value='Set Log Level' /></form>";
    private static final String FORMS_GET = "<h1>Log Level</h1>\n<br /><hr /><h3>Results</h3>\n Submitted Log Name: <b>%s</b><br />\n Effective level: <b>%s</b><br />";
    private static final String FORMS_SET = "<h1>Log Level</h1>\n<br /><hr /><h3>Results</h3>\n Submitted Log Name: <b>%s</b><br />\n Submitted Level: <b>%s</b><br />\n Setting Level to %s<br />\n Effective level: <b>%s</b><br />";

    private String getParameter(ServletRequest request, String name) {
        String s = request.getParameter(name);
        if (s == null) {
            return null;
        }
        return (s = s.trim()).length() == 0 ? null : s;
    }

    private boolean isLogLevelValid(String level) {
        return level.equals(Level.toLevel((String)level).toString());
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String logName = this.getParameter((ServletRequest)request, "log");
        String level = this.getParameter((ServletRequest)request, "level");
        response.setContentType("text/html;charset=utf-8");
        response.setStatus(200);
        PrintWriter out = response.getWriter();
        if (logName != null) {
            Logger logInstance = LogManager.getLogger((String)logName);
            if (level == null) {
                out.write(String.format(FORMS_GET, StringEscapeUtils.escapeHtml((String)logName), logInstance.getEffectiveLevel().toString()));
            } else if (this.isLogLevelValid(level)) {
                logInstance.setLevel(Level.toLevel((String)level));
                out.write(String.format(FORMS_SET, StringEscapeUtils.escapeHtml((String)logName), level, level, logInstance.getEffectiveLevel().toString()));
            } else {
                response.sendError(400, "Invalid log level: " + level);
                return;
            }
        }
        out.write(FORMS_END);
        out.close();
        response.flushBuffer();
    }
}

