/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.provider.db.service.persistent;

import com.codahale.metrics.Counter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import java.util.Random;
import java.util.concurrent.Callable;
import javax.jdo.PersistenceManagerFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.sentry.core.common.exception.SentryUserException;
import org.apache.sentry.provider.db.service.persistent.TransactionBlock;
import org.apache.sentry.provider.db.service.thrift.SentryMetrics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TransactionManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(TransactionManager.class);
    private static final Random random = new Random();
    private final PersistenceManagerFactory pmf;
    private final int transactionRetryMax;
    private final int retryWaitTimeMills;
    private static final String TRANSACTIONS = "transactions";
    private final Timer transactionTimer = SentryMetrics.getInstance().getTimer(MetricRegistry.name(TransactionManager.class, (String[])new String[]{"transactions"}));
    private final Counter failedTransactionsCount = SentryMetrics.getInstance().getCounter(MetricRegistry.name(TransactionManager.class, (String[])new String[]{"transactions", "failed"}));
    private final Counter retryCount = SentryMetrics.getInstance().getCounter(MetricRegistry.name(TransactionManager.class, (String[])new String[]{"transactions", "retry"}));

    TransactionManager(PersistenceManagerFactory pmf, Configuration conf) {
        this.pmf = pmf;
        this.transactionRetryMax = conf.getInt("sentry.store.transaction.retry", 10);
        this.retryWaitTimeMills = conf.getInt("sentry.store.transaction.retry.wait.time.millis", 250);
    }

    /*
     * Exception decompiling
     */
    public <T> T executeTransaction(TransactionBlock<T> tb) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private <T> T executeTransaction(Iterable<TransactionBlock<T>> tbs) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public <T> T executeTransactionWithRetry(final TransactionBlock<T> tb) throws Exception {
        return new ExponentialBackoff().execute(new Callable<T>(){

            @Override
            public T call() throws Exception {
                return TransactionManager.this.executeTransaction(tb);
            }
        });
    }

    <T> void executeTransactionBlocksWithRetry(final Iterable<TransactionBlock<T>> tbs) throws Exception {
        new ExponentialBackoff().execute(new Callable<T>(){

            @Override
            public T call() throws Exception {
                return TransactionManager.this.executeTransaction(tbs);
            }
        });
    }

    private class ExponentialBackoff {
        private ExponentialBackoff() {
        }

        <T> T execute(Callable<T> arg) throws Exception {
            Exception ex = null;
            long sleepTime = TransactionManager.this.retryWaitTimeMills;
            for (int retryNum = 1; retryNum <= TransactionManager.this.transactionRetryMax; ++retryNum) {
                try {
                    return arg.call();
                }
                catch (SentryUserException e) {
                    LOGGER.warn("Transaction manager encountered non-retriable exception", (Throwable)e);
                    throw e;
                }
                catch (Exception e) {
                    ex = e;
                    TransactionManager.this.retryCount.inc();
                    LOGGER.warn("Transaction execution encountered exception", (Throwable)e);
                    LOGGER.warn("Retrying transaction {}/{} times", (Object)retryNum, (Object)TransactionManager.this.transactionRetryMax);
                    LOGGER.warn("Sleeping for {} milliseconds before retrying", (Object)sleepTime);
                    Thread.sleep(sleepTime);
                    int fuzz = random.nextInt((int)sleepTime / 2);
                    sleepTime *= 3L;
                    sleepTime /= 2L;
                    sleepTime += (long)fuzz;
                    continue;
                }
            }
            assert (ex != null);
            String message = "The transaction has reached max retry number, " + ex.getMessage();
            LOGGER.error(message, (Throwable)ex);
            throw new Exception(message, ex);
        }
    }
}

