/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.provider.db.service.persistent;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.sentry.core.common.exception.SentryUserException;

public class SentryStoreSchemaInfo {
    private static final String SQL_FILE_EXTENSION = ".sql";
    private static final String UPGRADE_FILE_PREFIX = "upgrade-";
    private static final String INIT_FILE_PREFIX = "sentry-";
    private static final String VERSION_UPGRADE_LIST = "upgrade.order";
    private final String dbType;
    private final String[] sentrySchemaVersions;
    private final String sentryScriptDir;
    private static final String SENTRY_VERSION = "2.0.0";

    public SentryStoreSchemaInfo(String sentryScriptDir, String dbType) throws SentryUserException {
        this.sentryScriptDir = sentryScriptDir;
        this.dbType = dbType;
        ArrayList<String> upgradeOrderList = new ArrayList<String>();
        String upgradeListFile = this.getSentryStoreScriptDir() + File.separator + VERSION_UPGRADE_LIST + "." + dbType;
        try (BufferedReader bfReader = new BufferedReader(new FileReader(upgradeListFile));){
            String currSchemaVersion;
            while ((currSchemaVersion = bfReader.readLine()) != null) {
                upgradeOrderList.add(currSchemaVersion.trim());
            }
        }
        catch (FileNotFoundException e) {
            throw new SentryUserException("File " + upgradeListFile + " not found ", (Throwable)e);
        }
        catch (IOException e) {
            throw new SentryUserException("Error reading " + upgradeListFile, (Throwable)e);
        }
        this.sentrySchemaVersions = upgradeOrderList.toArray(new String[0]);
    }

    public String getSentrySchemaVersion() {
        return SENTRY_VERSION;
    }

    public List<String> getUpgradeScripts(String fromSchemaVer) throws SentryUserException {
        int i;
        ArrayList<String> upgradeScriptList = new ArrayList<String>();
        if (SentryStoreSchemaInfo.getSentryVersion().equals(fromSchemaVer)) {
            return upgradeScriptList;
        }
        int firstScript = this.sentrySchemaVersions.length;
        for (i = 0; i < this.sentrySchemaVersions.length; ++i) {
            String fromVersion = this.sentrySchemaVersions[i].split("-to-")[0];
            if (!fromVersion.equals(fromSchemaVer)) continue;
            firstScript = i;
            break;
        }
        if (firstScript == this.sentrySchemaVersions.length) {
            throw new SentryUserException("Unknown version specified for upgrade " + fromSchemaVer + " Metastore schema may be too old or newer");
        }
        for (i = firstScript; i < this.sentrySchemaVersions.length; ++i) {
            String scriptFile = this.generateUpgradeFileName(this.sentrySchemaVersions[i]);
            upgradeScriptList.add(scriptFile);
        }
        return upgradeScriptList;
    }

    public String generateInitFileName(String toVersion) throws SentryUserException {
        String version = toVersion;
        if (version == null) {
            version = SentryStoreSchemaInfo.getSentryVersion();
        }
        String initScriptName = INIT_FILE_PREFIX + this.dbType + "-" + version + SQL_FILE_EXTENSION;
        if (!new File(this.getSentryStoreScriptDir() + File.separatorChar + initScriptName).exists()) {
            throw new SentryUserException("Unknown version specified for initialization: " + version);
        }
        return initScriptName;
    }

    public String getSentryStoreScriptDir() {
        return this.sentryScriptDir;
    }

    private String generateUpgradeFileName(String fileVersion) {
        return "sentry-upgrade-" + this.dbType + "-" + fileVersion + SQL_FILE_EXTENSION;
    }

    public static String getSentryVersion() {
        return SENTRY_VERSION;
    }
}

