/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.provider.db.service.persistent;

import com.codahale.metrics.Gauge;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import javax.jdo.FetchGroup;
import javax.jdo.JDODataStoreException;
import javax.jdo.JDOHelper;
import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;
import javax.jdo.Query;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.sentry.core.common.exception.SentryAccessDeniedException;
import org.apache.sentry.core.common.exception.SentryAlreadyExistsException;
import org.apache.sentry.core.common.exception.SentryGrantDeniedException;
import org.apache.sentry.core.common.exception.SentryInvalidInputException;
import org.apache.sentry.core.common.exception.SentryNoSuchObjectException;
import org.apache.sentry.core.common.exception.SentrySiteConfigurationException;
import org.apache.sentry.core.common.exception.SentryUserException;
import org.apache.sentry.core.common.utils.PathUtils;
import org.apache.sentry.core.common.utils.SentryConstants;
import org.apache.sentry.core.model.db.DBModelAuthorizable;
import org.apache.sentry.hdfs.PathsUpdate;
import org.apache.sentry.hdfs.UniquePathsUpdate;
import org.apache.sentry.hdfs.Updateable;
import org.apache.sentry.hdfs.UpdateableAuthzPaths;
import org.apache.sentry.provider.db.service.model.MAuthzPathsMapping;
import org.apache.sentry.provider.db.service.model.MAuthzPathsSnapshotId;
import org.apache.sentry.provider.db.service.model.MPath;
import org.apache.sentry.provider.db.service.model.MSentryChange;
import org.apache.sentry.provider.db.service.model.MSentryGroup;
import org.apache.sentry.provider.db.service.model.MSentryHmsNotification;
import org.apache.sentry.provider.db.service.model.MSentryPathChange;
import org.apache.sentry.provider.db.service.model.MSentryPermChange;
import org.apache.sentry.provider.db.service.model.MSentryPrivilege;
import org.apache.sentry.provider.db.service.model.MSentryRole;
import org.apache.sentry.provider.db.service.model.MSentryUser;
import org.apache.sentry.provider.db.service.model.MSentryUtil;
import org.apache.sentry.provider.db.service.model.MSentryVersion;
import org.apache.sentry.provider.db.service.persistent.DeltaTransactionBlock;
import org.apache.sentry.provider.db.service.persistent.PathsImage;
import org.apache.sentry.provider.db.service.persistent.PermissionsImage;
import org.apache.sentry.provider.db.service.persistent.QueryParamBuilder;
import org.apache.sentry.provider.db.service.persistent.SentryStoreSchemaInfo;
import org.apache.sentry.provider.db.service.persistent.TransactionBlock;
import org.apache.sentry.provider.db.service.persistent.TransactionManager;
import org.apache.sentry.provider.db.service.thrift.SentryPolicyStoreProcessor;
import org.apache.sentry.provider.db.service.thrift.TSentryActiveRoleSet;
import org.apache.sentry.provider.db.service.thrift.TSentryAuthorizable;
import org.apache.sentry.provider.db.service.thrift.TSentryGrantOption;
import org.apache.sentry.provider.db.service.thrift.TSentryGroup;
import org.apache.sentry.provider.db.service.thrift.TSentryMappingData;
import org.apache.sentry.provider.db.service.thrift.TSentryPrivilege;
import org.apache.sentry.provider.db.service.thrift.TSentryPrivilegeMap;
import org.apache.sentry.provider.db.service.thrift.TSentryRole;
import org.apache.sentry.service.thrift.CounterWait;
import org.apache.sentry.service.thrift.ServiceConstants;
import org.datanucleus.store.rdbms.exceptions.MissingTableException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SentryStore {
    private static final Logger LOGGER = LoggerFactory.getLogger(SentryStore.class);
    public static final String NULL_COL = "__NULL__";
    public static final int INDEX_GROUP_ROLES_MAP = 0;
    public static final int INDEX_USER_ROLES_MAP = 1;
    public static final String SERVER_NAME = "serverName";
    public static final String DB_NAME = "dbName";
    public static final String TABLE_NAME = "tableName";
    public static final String COLUMN_NAME = "columnName";
    public static final String ACTION = "action";
    public static final String URI = "URI";
    public static final String GRANT_OPTION = "grantOption";
    public static final String ROLE_NAME = "roleName";
    public static final long INIT_CHANGE_ID = 1L;
    private static final long EMPTY_CHANGE_ID = 0L;
    public static final long EMPTY_NOTIFICATION_ID = 0L;
    public static final long EMPTY_PATHS_SNAPSHOT_ID = 0L;
    private static final long COUNT_VALUE_UNKNOWN = -1L;
    private static final long NOTIFICATION_UNKNOWN = -1L;
    private static final String EMPTY_GRANTOR_PRINCIPAL = "--";
    private static final Set<String> ALL_ACTIONS = Sets.newHashSet((Object[])new String[]{"*", "select", "insert", "alter", "create", "drop", "index", "lock"});
    private static final Set<String> PARTIAL_REVOKE_ACTIONS = Sets.newHashSet((Object[])new String[]{"*", "ALL".toLowerCase(), "select", "insert"});
    private static final String LOAD_RESULTS_AT_COMMIT = "datanucleus.query.loadResultsAtCommit";
    private final PersistenceManagerFactory pmf;
    private Configuration conf;
    private final TransactionManager tm;
    private boolean persistUpdateDeltas;
    private final CounterWait counterWait;

    public static Properties getDataNucleusProperties(Configuration conf) throws SentrySiteConfigurationException, IOException {
        String[] parts;
        Properties prop = new Properties();
        prop.putAll((Map<?, ?>)ServiceConstants.ServerConfig.SENTRY_STORE_DEFAULTS);
        String jdbcUrl = conf.get("sentry.store.jdbc.url", "").trim();
        Preconditions.checkArgument((!jdbcUrl.isEmpty() ? 1 : 0) != 0, (Object)"Required parameter sentry.store.jdbc.url is missed");
        String user = conf.get("sentry.store.jdbc.user", "Sentry").trim();
        char[] passTmp = conf.getPassword("sentry.store.jdbc.password");
        if (passTmp == null) {
            throw new SentrySiteConfigurationException("Error reading sentry.store.jdbc.password");
        }
        String pass = new String(passTmp);
        String driverName = conf.get("sentry.store.jdbc.driver", "org.apache.derby.jdbc.EmbeddedDriver");
        prop.setProperty("javax.jdo.option.ConnectionURL", jdbcUrl);
        prop.setProperty("javax.jdo.option.ConnectionUserName", user);
        prop.setProperty("javax.jdo.option.ConnectionPassword", pass);
        prop.setProperty("javax.jdo.option.ConnectionDriverName", driverName);
        String oracleDb = "oracle";
        if (prop.getProperty("datanucleus.transactionIsolation", "").equals("repeatable-read") && jdbcUrl.contains("oracle") && (parts = jdbcUrl.split(":")).length > 1 && parts[1].equals("oracle")) {
            prop.setProperty("datanucleus.transactionIsolation", "read-committed");
        }
        for (Map.Entry entry : conf) {
            String key = (String)entry.getKey();
            if (!key.startsWith("sentry.javax.jdo") && !key.startsWith("sentry.datanucleus")) continue;
            key = StringUtils.removeStart((String)key, (String)"sentry.");
            prop.setProperty(key, (String)entry.getValue());
        }
        prop.setProperty("datanucleus.NontransactionalRead", "false");
        prop.setProperty("datanucleus.NontransactionalWrite", "false");
        return prop;
    }

    public SentryStore(Configuration conf) throws Exception {
        this.conf = conf;
        Properties prop = SentryStore.getDataNucleusProperties(conf);
        boolean checkSchemaVersion = conf.get("sentry.verify.schema.version", "true").equalsIgnoreCase("true");
        if (!checkSchemaVersion) {
            prop.setProperty("datanucleus.schema.autoCreateAll", "true");
            prop.setProperty("datanucleus.autoCreateSchema", "true");
            prop.setProperty("datanucleus.fixedDatastore", "false");
        }
        this.pmf = JDOHelper.getPersistenceManagerFactory((Map)prop);
        this.tm = new TransactionManager(this.pmf, conf);
        this.verifySentryStoreSchema(checkSchemaVersion);
        long notificationTimeout = conf.getInt("sentry.notification.sync.timeout.ms", 200000);
        this.counterWait = new CounterWait(notificationTimeout, TimeUnit.MILLISECONDS);
    }

    public void setPersistUpdateDeltas(boolean persistUpdateDeltas) {
        this.persistUpdateDeltas = persistUpdateDeltas;
    }

    public TransactionManager getTransactionManager() {
        return this.tm;
    }

    public CounterWait getCounterWait() {
        return this.counterWait;
    }

    void verifySentryStoreSchema(boolean checkVersion) throws Exception {
        if (!checkVersion) {
            this.setSentryVersion(SentryStoreSchemaInfo.getSentryVersion(), "Schema version set implicitly");
        } else {
            String currentVersion = this.getSentryVersion();
            if (!SentryStoreSchemaInfo.getSentryVersion().equals(currentVersion)) {
                throw new SentryAccessDeniedException("The Sentry store schema version " + currentVersion + " is different from distribution version " + SentryStoreSchemaInfo.getSentryVersion());
            }
        }
    }

    public synchronized void stop() {
        if (this.pmf != null) {
            this.pmf.close();
        }
    }

    public MSentryRole getRole(PersistenceManager pm, String roleName) {
        Query query = pm.newQuery(MSentryRole.class);
        query.addExtension(LOAD_RESULTS_AT_COMMIT, (Object)"false");
        query.setFilter("this.roleName == :roleName");
        query.setUnique(true);
        return (MSentryRole)query.execute((Object)roleName);
    }

    private List<MSentryRole> getAllRoles(PersistenceManager pm) {
        Query query = pm.newQuery(MSentryRole.class);
        query.addExtension(LOAD_RESULTS_AT_COMMIT, (Object)"false");
        return (List)query.execute();
    }

    private String trimAndLower(String input) {
        return input.trim().toLowerCase();
    }

    public void createSentryRole(final String roleName) throws Exception {
        this.tm.executeTransactionWithRetry(new TransactionBlock<Object>(){

            @Override
            public Object execute(PersistenceManager pm) throws Exception {
                pm.setDetachAllOnCommit(false);
                String trimmedRoleName = SentryStore.this.trimAndLower(roleName);
                if (SentryStore.this.getRole(pm, trimmedRoleName) != null) {
                    throw new SentryAlreadyExistsException("Role: " + trimmedRoleName);
                }
                pm.makePersistent((Object)new MSentryRole(trimmedRoleName));
                return null;
            }
        });
    }

    private <T> Long getCount(final Class<T> tClass) {
        try {
            return this.tm.executeTransaction(new TransactionBlock<Long>(){

                @Override
                public Long execute(PersistenceManager pm) throws Exception {
                    pm.setDetachAllOnCommit(false);
                    Query query = pm.newQuery();
                    query.addExtension(SentryStore.LOAD_RESULTS_AT_COMMIT, (Object)"false");
                    query.setClass(tClass);
                    query.setResult("count(this)");
                    Long result = (Long)query.execute();
                    return result;
                }
            });
        }
        catch (Exception e) {
            return -1L;
        }
    }

    public Gauge<Long> getRoleCountGauge() {
        return new Gauge<Long>(){

            public Long getValue() {
                return SentryStore.this.getCount(MSentryRole.class);
            }
        };
    }

    public Gauge<Long> getPrivilegeCountGauge() {
        return new Gauge<Long>(){

            public Long getValue() {
                return SentryStore.this.getCount(MSentryPrivilege.class);
            }
        };
    }

    public Gauge<Long> getGroupCountGauge() {
        return new Gauge<Long>(){

            public Long getValue() {
                return SentryStore.this.getCount(MSentryGroup.class);
            }
        };
    }

    Gauge<Long> getUserCountGauge() {
        return new Gauge<Long>(){

            public Long getValue() {
                return SentryStore.this.getCount(MSentryUser.class);
            }
        };
    }

    public Gauge<Integer> getHMSWaitersCountGauge() {
        return new Gauge<Integer>(){

            public Integer getValue() {
                return SentryStore.this.counterWait.waitersCount();
            }
        };
    }

    public Gauge<Long> getLastNotificationIdGauge() {
        return new Gauge<Long>(){

            public Long getValue() {
                try {
                    return SentryStore.this.getLastProcessedNotificationID();
                }
                catch (Exception e) {
                    LOGGER.error("Can not read current notificationId", (Throwable)e);
                    return -1L;
                }
            }
        };
    }

    public Gauge<Long> getLastPathsSnapshotIdGauge() {
        return new Gauge<Long>(){

            public Long getValue() {
                try {
                    return SentryStore.this.getCurrentAuthzPathsSnapshotID();
                }
                catch (Exception e) {
                    LOGGER.error("Can not read current paths snapshot ID", (Throwable)e);
                    return -1L;
                }
            }
        };
    }

    public Gauge<Long> getPermChangeIdGauge() {
        return new Gauge<Long>(){

            public Long getValue() {
                try {
                    return SentryStore.this.tm.executeTransaction(new TransactionBlock<Long>(){

                        @Override
                        public Long execute(PersistenceManager pm) throws Exception {
                            return SentryStore.getLastProcessedChangeIDCore(pm, MSentryPermChange.class);
                        }
                    });
                }
                catch (Exception e) {
                    LOGGER.error("Can not read current permissions change ID", (Throwable)e);
                    return -1L;
                }
            }
        };
    }

    public Gauge<Long> getPathChangeIdGauge() {
        return new Gauge<Long>(){

            public Long getValue() {
                try {
                    return SentryStore.this.tm.executeTransaction(new TransactionBlock<Long>(){

                        @Override
                        public Long execute(PersistenceManager pm) throws Exception {
                            return SentryStore.getLastProcessedChangeIDCore(pm, MSentryPathChange.class);
                        }
                    });
                }
                catch (Exception e) {
                    LOGGER.error("Can not read current path change ID", (Throwable)e);
                    return -1L;
                }
            }
        };
    }

    @VisibleForTesting
    long countMSentryPrivileges() {
        return this.getCount(MSentryPrivilege.class);
    }

    @VisibleForTesting
    void clearAllTables() {
        try {
            this.tm.executeTransaction(new TransactionBlock<Object>(){

                @Override
                public Object execute(PersistenceManager pm) throws Exception {
                    pm.newQuery(MSentryRole.class).deletePersistentAll();
                    pm.newQuery(MSentryGroup.class).deletePersistentAll();
                    pm.newQuery(MSentryUser.class).deletePersistentAll();
                    pm.newQuery(MSentryPrivilege.class).deletePersistentAll();
                    pm.newQuery(MSentryPermChange.class).deletePersistentAll();
                    pm.newQuery(MSentryPathChange.class).deletePersistentAll();
                    pm.newQuery(MAuthzPathsMapping.class).deletePersistentAll();
                    pm.newQuery(MPath.class).deletePersistentAll();
                    pm.newQuery(MSentryHmsNotification.class).deletePersistentAll();
                    pm.newQuery(MAuthzPathsSnapshotId.class).deletePersistentAll();
                    return null;
                }
            });
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    @VisibleForTesting
    <T extends MSentryChange> void purgeDeltaChangeTableCore(Class<T> cls, PersistenceManager pm, long changesToKeep) {
        Preconditions.checkArgument((changesToKeep >= 0L ? 1 : 0) != 0, (Object)"changes to keep must be a non-negative number");
        long lastChangedID = SentryStore.getLastProcessedChangeIDCore(pm, cls);
        long maxIDDeleted = lastChangedID - changesToKeep;
        Query query = pm.newQuery(cls);
        query.addExtension(LOAD_RESULTS_AT_COMMIT, (Object)"false");
        query.setFilter("changeID <= maxChangedIdDeleted");
        query.declareParameters("long maxChangedIdDeleted");
        long numDeleted = query.deletePersistentAll(new Object[]{maxIDDeleted});
        if (numDeleted > 0L) {
            LOGGER.info(String.format("Purged %d of %s to changeID=%d", numDeleted, cls.getSimpleName(), maxIDDeleted));
        }
    }

    @VisibleForTesting
    protected void purgeNotificationIdTableCore(PersistenceManager pm, long changesToKeep) {
        Preconditions.checkArgument((changesToKeep > 0L ? 1 : 0) != 0, (Object)"You need to keep at least one entry in SENTRY_HMS_NOTIFICATION_ID table");
        long lastNotificationID = SentryStore.getLastProcessedNotificationIDCore(pm);
        Query query = pm.newQuery(MSentryHmsNotification.class);
        query.addExtension(LOAD_RESULTS_AT_COMMIT, (Object)"false");
        query.setFilter("notificationId <= maxNotificationIdDeleted");
        query.declareParameters("long maxNotificationIdDeleted");
        long numDeleted = query.deletePersistentAll(new Object[]{lastNotificationID - changesToKeep});
        if (numDeleted > 0L) {
            LOGGER.info("Purged {} of {}", (Object)numDeleted, (Object)MSentryHmsNotification.class.getSimpleName());
        }
    }

    public void purgeDeltaChangeTables() {
        final int changesToKeep = this.conf.getInt("sentry.server.delta.keep.count", 200);
        LOGGER.info("Purging MSentryPathUpdate and MSentyPermUpdate tables, leaving {} entries", (Object)changesToKeep);
        try {
            this.tm.executeTransaction(new TransactionBlock<Object>(){

                @Override
                public Object execute(PersistenceManager pm) throws Exception {
                    pm.setDetachAllOnCommit(false);
                    SentryStore.this.purgeDeltaChangeTableCore(MSentryPermChange.class, pm, changesToKeep);
                    LOGGER.info("MSentryPermChange table has been purged.");
                    SentryStore.this.purgeDeltaChangeTableCore(MSentryPathChange.class, pm, changesToKeep);
                    LOGGER.info("MSentryPathUpdate table has been purged.");
                    return null;
                }
            });
        }
        catch (Exception e) {
            LOGGER.error("Delta change cleaning process encountered an error", (Throwable)e);
        }
    }

    public void purgeNotificationIdTable() {
        final int changesToKeep = this.conf.getInt("sentry.server.delta.keep.count", 100);
        LOGGER.debug("Purging MSentryHmsNotification table, leaving {} entries", (Object)changesToKeep);
        try {
            this.tm.executeTransaction(new TransactionBlock<Object>(){

                @Override
                public Object execute(PersistenceManager pm) throws Exception {
                    pm.setDetachAllOnCommit(false);
                    SentryStore.this.purgeNotificationIdTableCore(pm, changesToKeep);
                    return null;
                }
            });
        }
        catch (Exception e) {
            LOGGER.error("MSentryHmsNotification cleaning process encountered an error", (Throwable)e);
        }
    }

    void alterSentryRoleGrantPrivilege(final String grantorPrincipal, final String roleName, final TSentryPrivilege privilege) throws Exception {
        this.tm.executeTransactionWithRetry(new TransactionBlock<Object>(){

            @Override
            public Object execute(PersistenceManager pm) throws Exception {
                pm.setDetachAllOnCommit(false);
                String trimmedRoleName = SentryStore.this.trimAndLower(roleName);
                SentryStore.this.grantOptionCheck(pm, grantorPrincipal, privilege);
                MSentryPrivilege mPrivilege = SentryStore.this.alterSentryRoleGrantPrivilegeCore(pm, trimmedRoleName, privilege);
                if (mPrivilege != null) {
                    SentryStore.this.convertToTSentryPrivilege(mPrivilege, privilege);
                }
                return null;
            }
        });
    }

    public void alterSentryRoleGrantPrivileges(String grantorPrincipal, String roleName, Set<TSentryPrivilege> privileges) throws Exception {
        for (TSentryPrivilege privilege : privileges) {
            this.alterSentryRoleGrantPrivilege(grantorPrincipal, roleName, privilege);
        }
    }

    synchronized void alterSentryRoleGrantPrivilege(final String grantorPrincipal, final String roleName, final TSentryPrivilege privilege, Updateable.Update update) throws Exception {
        this.execute(update, new TransactionBlock<Object>(){

            @Override
            public Object execute(PersistenceManager pm) throws Exception {
                pm.setDetachAllOnCommit(false);
                String trimmedRoleName = SentryStore.this.trimAndLower(roleName);
                SentryStore.this.grantOptionCheck(pm, grantorPrincipal, privilege);
                MSentryPrivilege mPrivilege = SentryStore.this.alterSentryRoleGrantPrivilegeCore(pm, trimmedRoleName, privilege);
                if (mPrivilege != null) {
                    SentryStore.this.convertToTSentryPrivilege(mPrivilege, privilege);
                }
                return null;
            }
        });
    }

    public void alterSentryRoleGrantPrivileges(String grantorPrincipal, String roleName, Set<TSentryPrivilege> privileges, Map<TSentryPrivilege, Updateable.Update> privilegesUpdateMap) throws Exception {
        Preconditions.checkNotNull(privilegesUpdateMap);
        for (TSentryPrivilege privilege : privileges) {
            Updateable.Update update = privilegesUpdateMap.get(privilege);
            if (update != null) {
                this.alterSentryRoleGrantPrivilege(grantorPrincipal, roleName, privilege, update);
                continue;
            }
            this.alterSentryRoleGrantPrivilege(grantorPrincipal, roleName, privilege);
        }
    }

    private MSentryPrivilege alterSentryRoleGrantPrivilegeCore(PersistenceManager pm, String roleName, TSentryPrivilege privilege) throws SentryNoSuchObjectException, SentryInvalidInputException {
        MSentryPrivilege mPrivilege = null;
        MSentryRole mRole = this.getRole(pm, roleName);
        if (mRole == null) {
            throw SentryStore.noSuchRole(roleName);
        }
        if (!(SentryStore.isNULL(privilege.getColumnName()) && SentryStore.isNULL(privilege.getTableName()) && SentryStore.isNULL(privilege.getDbName()))) {
            if ("*".equalsIgnoreCase(privilege.getAction()) || "ALL".equalsIgnoreCase(privilege.getAction())) {
                TSentryPrivilege tNotAll = new TSentryPrivilege(privilege);
                tNotAll.setAction("select");
                MSentryPrivilege mSelect = this.getMSentryPrivilege(tNotAll, pm);
                tNotAll.setAction("insert");
                MSentryPrivilege mInsert = this.getMSentryPrivilege(tNotAll, pm);
                if (mSelect != null && mRole.getPrivileges().contains(mSelect)) {
                    mSelect.removeRole(mRole);
                    pm.makePersistent((Object)mSelect);
                }
                if (mInsert != null && mRole.getPrivileges().contains(mInsert)) {
                    mInsert.removeRole(mRole);
                    pm.makePersistent((Object)mInsert);
                }
            } else {
                TSentryPrivilege tAll = new TSentryPrivilege(privilege);
                tAll.setAction("*");
                MSentryPrivilege mAll1 = this.getMSentryPrivilege(tAll, pm);
                tAll.setAction("ALL");
                MSentryPrivilege mAll2 = this.getMSentryPrivilege(tAll, pm);
                if (mAll1 != null && mRole.getPrivileges().contains(mAll1)) {
                    return null;
                }
                if (mAll2 != null && mRole.getPrivileges().contains(mAll2)) {
                    return null;
                }
            }
        }
        if ((mPrivilege = this.getMSentryPrivilege(privilege, pm)) == null) {
            mPrivilege = this.convertToMSentryPrivilege(privilege);
        }
        mPrivilege.appendRole(mRole);
        pm.makePersistent((Object)mPrivilege);
        return mPrivilege;
    }

    void alterSentryRoleRevokePrivilege(final String grantorPrincipal, final String roleName, final TSentryPrivilege tPrivilege) throws Exception {
        this.tm.executeTransactionWithRetry(new TransactionBlock<Object>(){

            @Override
            public Object execute(PersistenceManager pm) throws Exception {
                pm.setDetachAllOnCommit(false);
                String trimmedRoleName = SentryStore.safeTrimLower(roleName);
                SentryStore.this.grantOptionCheck(pm, grantorPrincipal, tPrivilege);
                SentryStore.this.alterSentryRoleRevokePrivilegeCore(pm, trimmedRoleName, tPrivilege);
                return null;
            }
        });
    }

    public void alterSentryRoleRevokePrivileges(String grantorPrincipal, String roleName, Set<TSentryPrivilege> tPrivileges) throws Exception {
        for (TSentryPrivilege tPrivilege : tPrivileges) {
            this.alterSentryRoleRevokePrivilege(grantorPrincipal, roleName, tPrivilege);
        }
    }

    private synchronized void alterSentryRoleRevokePrivilege(final String grantorPrincipal, final String roleName, final TSentryPrivilege tPrivilege, Updateable.Update update) throws Exception {
        this.execute(update, new TransactionBlock<Object>(){

            @Override
            public Object execute(PersistenceManager pm) throws Exception {
                pm.setDetachAllOnCommit(false);
                String trimmedRoleName = SentryStore.safeTrimLower(roleName);
                SentryStore.this.grantOptionCheck(pm, grantorPrincipal, tPrivilege);
                SentryStore.this.alterSentryRoleRevokePrivilegeCore(pm, trimmedRoleName, tPrivilege);
                return null;
            }
        });
    }

    public void alterSentryRoleRevokePrivileges(String grantorPrincipal, String roleName, Set<TSentryPrivilege> tPrivileges, Map<TSentryPrivilege, Updateable.Update> privilegesUpdateMap) throws Exception {
        Preconditions.checkNotNull(privilegesUpdateMap);
        for (TSentryPrivilege tPrivilege : tPrivileges) {
            Updateable.Update update = privilegesUpdateMap.get(tPrivilege);
            if (update != null) {
                this.alterSentryRoleRevokePrivilege(grantorPrincipal, roleName, tPrivilege, update);
                continue;
            }
            this.alterSentryRoleRevokePrivilege(grantorPrincipal, roleName, tPrivilege);
        }
    }

    private void alterSentryRoleRevokePrivilegeCore(PersistenceManager pm, String roleName, TSentryPrivilege tPrivilege) throws SentryNoSuchObjectException, SentryInvalidInputException {
        MSentryRole mRole = this.getRole(pm, roleName);
        if (mRole == null) {
            throw SentryStore.noSuchRole(roleName);
        }
        MSentryPrivilege mPrivilege = this.getMSentryPrivilege(tPrivilege, pm);
        mPrivilege = mPrivilege == null ? this.convertToMSentryPrivilege(tPrivilege) : (MSentryPrivilege)pm.detachCopy((Object)mPrivilege);
        HashSet<MSentryPrivilege> privilegeGraph = new HashSet<MSentryPrivilege>();
        if (mPrivilege.getGrantOption() != null) {
            privilegeGraph.add(mPrivilege);
        } else {
            MSentryPrivilege mTure = new MSentryPrivilege(mPrivilege);
            mTure.setGrantOption(true);
            privilegeGraph.add(mTure);
            MSentryPrivilege mFalse = new MSentryPrivilege(mPrivilege);
            mFalse.setGrantOption(false);
            privilegeGraph.add(mFalse);
        }
        this.populateChildren(pm, Sets.newHashSet((Object[])new String[]{roleName}), mPrivilege, privilegeGraph);
        for (MSentryPrivilege childPriv : privilegeGraph) {
            this.revokePrivilegeFromRole(pm, tPrivilege, mRole, childPriv);
        }
        pm.makePersistent((Object)mRole);
    }

    private void revokePartial(PersistenceManager pm, TSentryPrivilege requestedPrivToRevoke, MSentryRole mRole, MSentryPrivilege currentPrivilege) throws SentryInvalidInputException {
        MSentryPrivilege persistedPriv = this.getMSentryPrivilege(this.convertToTSentryPrivilege(currentPrivilege), pm);
        if (persistedPriv == null) {
            persistedPriv = this.convertToMSentryPrivilege(this.convertToTSentryPrivilege(currentPrivilege));
        }
        if (requestedPrivToRevoke.getAction().equalsIgnoreCase("ALL") || requestedPrivToRevoke.getAction().equalsIgnoreCase("*")) {
            if (!persistedPriv.getRoles().isEmpty()) {
                persistedPriv.removeRole(mRole);
                if (persistedPriv.getRoles().isEmpty()) {
                    pm.deletePersistent((Object)persistedPriv);
                } else {
                    pm.makePersistent((Object)persistedPriv);
                }
            }
        } else if (requestedPrivToRevoke.getAction().equalsIgnoreCase("select") && !currentPrivilege.getAction().equalsIgnoreCase("insert")) {
            this.revokeRolePartial(pm, mRole, currentPrivilege, persistedPriv, "insert");
        } else if (requestedPrivToRevoke.getAction().equalsIgnoreCase("insert") && !currentPrivilege.getAction().equalsIgnoreCase("select")) {
            this.revokeRolePartial(pm, mRole, currentPrivilege, persistedPriv, "select");
        }
    }

    private void revokeRolePartial(PersistenceManager pm, MSentryRole mRole, MSentryPrivilege currentPrivilege, MSentryPrivilege persistedPriv, String addAction) throws SentryInvalidInputException {
        if ((persistedPriv = this.getMSentryPrivilege(this.convertToTSentryPrivilege(persistedPriv), pm)) != null && !persistedPriv.getRoles().isEmpty()) {
            persistedPriv.removeRole(mRole);
            if (persistedPriv.getRoles().isEmpty()) {
                pm.deletePersistent((Object)persistedPriv);
            } else {
                pm.makePersistent((Object)persistedPriv);
            }
        }
        currentPrivilege.setAction("*");
        persistedPriv = this.getMSentryPrivilege(this.convertToTSentryPrivilege(currentPrivilege), pm);
        if (persistedPriv != null && mRole.getPrivileges().contains(persistedPriv)) {
            persistedPriv.removeRole(mRole);
            if (persistedPriv.getRoles().isEmpty()) {
                pm.deletePersistent((Object)persistedPriv);
            } else {
                pm.makePersistent((Object)persistedPriv);
            }
            currentPrivilege.setAction(addAction);
            persistedPriv = this.getMSentryPrivilege(this.convertToTSentryPrivilege(currentPrivilege), pm);
            if (persistedPriv == null) {
                persistedPriv = this.convertToMSentryPrivilege(this.convertToTSentryPrivilege(currentPrivilege));
                mRole.appendPrivilege(persistedPriv);
            }
            persistedPriv.appendRole(mRole);
            pm.makePersistent((Object)persistedPriv);
        }
    }

    private void revokePrivilegeFromRole(PersistenceManager pm, TSentryPrivilege tPrivilege, MSentryRole mRole, MSentryPrivilege mPrivilege) throws SentryInvalidInputException {
        if (PARTIAL_REVOKE_ACTIONS.contains(mPrivilege.getAction())) {
            this.revokePartial(pm, tPrivilege, mRole, mPrivilege);
        } else {
            MSentryPrivilege persistedPriv = this.getMSentryPrivilege(this.convertToTSentryPrivilege(mPrivilege), pm);
            if (persistedPriv != null && !persistedPriv.getRoles().isEmpty()) {
                persistedPriv.removeRole(mRole);
                if (persistedPriv.getRoles().isEmpty()) {
                    pm.deletePersistent((Object)persistedPriv);
                } else {
                    pm.makePersistent((Object)persistedPriv);
                }
            }
        }
    }

    private void populateChildren(PersistenceManager pm, Set<String> roleNames, MSentryPrivilege priv, Collection<MSentryPrivilege> children) throws SentryInvalidInputException {
        Preconditions.checkNotNull((Object)pm);
        if (!(SentryStore.isNULL(priv.getServerName()) && SentryStore.isNULL(priv.getDbName()) && SentryStore.isNULL(priv.getTableName()))) {
            Set<MSentryPrivilege> childPrivs = this.getChildPrivileges(pm, roleNames, priv);
            for (MSentryPrivilege childPriv : childPrivs) {
                if (!(SentryStore.isNULL(childPriv.getDbName()) || SentryStore.isNULL(childPriv.getTableName()) || SentryStore.isNULL(childPriv.getColumnName()))) {
                    this.populateChildren(pm, roleNames, childPriv, children);
                }
                if (!priv.isActionALL()) {
                    if (childPriv.isActionALL()) {
                        childPriv.setAction(priv.getAction());
                    }
                    if (!priv.implies(childPriv)) continue;
                }
                children.add(childPriv);
            }
        }
    }

    private Set<MSentryPrivilege> getChildPrivileges(PersistenceManager pm, Set<String> roleNames, MSentryPrivilege parent) throws SentryInvalidInputException {
        if (!SentryStore.isNULL(parent.getColumnName()) || !SentryStore.isNULL(parent.getURI())) {
            return Collections.emptySet();
        }
        Query query = pm.newQuery(MSentryPrivilege.class);
        QueryParamBuilder paramBuilder = QueryParamBuilder.addRolesFilter(query, null, roleNames).add(SERVER_NAME, parent.getServerName());
        if (!SentryStore.isNULL(parent.getDbName())) {
            paramBuilder.add(DB_NAME, parent.getDbName());
            if (!SentryStore.isNULL(parent.getTableName())) {
                paramBuilder.add(TABLE_NAME, parent.getTableName()).addNotNull(COLUMN_NAME);
            } else {
                paramBuilder.addNotNull(TABLE_NAME);
            }
        } else {
            paramBuilder.newChild().addNotNull(DB_NAME).addNotNull(URI);
        }
        query.setFilter(paramBuilder.toString());
        query.setResult("privilegeScope, serverName, dbName, tableName, columnName, URI, action, grantOption");
        List privObjects = (List)query.executeWithMap(paramBuilder.getArguments());
        HashSet<MSentryPrivilege> privileges = new HashSet<MSentryPrivilege>(privObjects.size());
        for (Object[] privObj : privObjects) {
            String scope = (String)privObj[0];
            String serverName = (String)privObj[1];
            String dbName = (String)privObj[2];
            String tableName = (String)privObj[3];
            String columnName = (String)privObj[4];
            String URI2 = (String)privObj[5];
            String action = (String)privObj[6];
            Boolean grantOption = (Boolean)privObj[7];
            MSentryPrivilege priv = new MSentryPrivilege(scope, serverName, dbName, tableName, columnName, URI2, action, grantOption);
            privileges.add(priv);
        }
        return privileges;
    }

    private List<MSentryPrivilege> getMSentryPrivileges(TSentryPrivilege tPriv, PersistenceManager pm) {
        Query query = pm.newQuery(MSentryPrivilege.class);
        QueryParamBuilder paramBuilder = QueryParamBuilder.newQueryParamBuilder();
        paramBuilder.add(SERVER_NAME, tPriv.getServerName()).add(ACTION, tPriv.getAction());
        if (!SentryStore.isNULL(tPriv.getDbName())) {
            paramBuilder.add(DB_NAME, tPriv.getDbName());
            if (!SentryStore.isNULL(tPriv.getTableName())) {
                paramBuilder.add(TABLE_NAME, tPriv.getTableName());
                if (!SentryStore.isNULL(tPriv.getColumnName())) {
                    paramBuilder.add(COLUMN_NAME, tPriv.getColumnName());
                }
            }
        } else if (!SentryStore.isNULL(tPriv.getURI())) {
            paramBuilder.add(URI, tPriv.getURI(), true);
        }
        query.setFilter(paramBuilder.toString());
        return (List)query.executeWithMap(paramBuilder.getArguments());
    }

    private MSentryPrivilege getMSentryPrivilege(TSentryPrivilege tPriv, PersistenceManager pm) {
        Boolean grantOption = null;
        if (tPriv.getGrantOption().equals((Object)TSentryGrantOption.TRUE)) {
            grantOption = true;
        } else if (tPriv.getGrantOption().equals((Object)TSentryGrantOption.FALSE)) {
            grantOption = false;
        }
        QueryParamBuilder paramBuilder = QueryParamBuilder.newQueryParamBuilder();
        paramBuilder.add(SERVER_NAME, tPriv.getServerName()).add(DB_NAME, tPriv.getDbName()).add(TABLE_NAME, tPriv.getTableName()).add(COLUMN_NAME, tPriv.getColumnName()).add(URI, tPriv.getURI(), true).addObject(GRANT_OPTION, grantOption).add(ACTION, tPriv.getAction());
        Query query = pm.newQuery(MSentryPrivilege.class);
        query.setUnique(true);
        query.setFilter(paramBuilder.toString());
        return (MSentryPrivilege)query.executeWithMap(paramBuilder.getArguments());
    }

    public void dropSentryRole(final String roleName) throws Exception {
        this.tm.executeTransactionWithRetry(new TransactionBlock<Object>(){

            @Override
            public Object execute(PersistenceManager pm) throws Exception {
                pm.setDetachAllOnCommit(false);
                SentryStore.this.dropSentryRoleCore(pm, roleName);
                return null;
            }
        });
    }

    public synchronized void dropSentryRole(final String roleName, Updateable.Update update) throws Exception {
        this.execute(update, new TransactionBlock<Object>(){

            @Override
            public Object execute(PersistenceManager pm) throws Exception {
                pm.setDetachAllOnCommit(false);
                SentryStore.this.dropSentryRoleCore(pm, roleName);
                return null;
            }
        });
    }

    private void dropSentryRoleCore(PersistenceManager pm, String roleName) throws SentryNoSuchObjectException {
        String lRoleName = this.trimAndLower(roleName);
        MSentryRole sentryRole = this.getRole(pm, lRoleName);
        if (sentryRole == null) {
            throw SentryStore.noSuchRole(lRoleName);
        }
        this.removePrivileges(pm, sentryRole);
        pm.deletePersistent((Object)sentryRole);
    }

    private void removePrivileges(PersistenceManager pm, MSentryRole sentryRole) {
        ArrayList<MSentryPrivilege> privilegesCopy = new ArrayList<MSentryPrivilege>(sentryRole.getPrivileges());
        ArrayList<MSentryPrivilege> stalePrivileges = new ArrayList<MSentryPrivilege>(0);
        sentryRole.removePrivileges();
        sentryRole.removeGMPrivileges();
        for (MSentryPrivilege privilege : privilegesCopy) {
            if (!privilege.getRoles().isEmpty()) continue;
            stalePrivileges.add(privilege);
        }
        if (!stalePrivileges.isEmpty()) {
            pm.deletePersistentAll(stalePrivileges);
        }
    }

    public void alterSentryRoleAddGroups(String grantorPrincipal, final String roleName, final Set<TSentryGroup> groupNames) throws Exception {
        this.tm.executeTransactionWithRetry(new TransactionBlock<Object>(){

            @Override
            public Object execute(PersistenceManager pm) throws Exception {
                pm.setDetachAllOnCommit(false);
                SentryStore.this.alterSentryRoleAddGroupsCore(pm, roleName, groupNames);
                return null;
            }
        });
    }

    public synchronized void alterSentryRoleAddGroups(String grantorPrincipal, final String roleName, final Set<TSentryGroup> groupNames, Updateable.Update update) throws Exception {
        this.execute(update, new TransactionBlock<Object>(){

            @Override
            public Object execute(PersistenceManager pm) throws Exception {
                pm.setDetachAllOnCommit(false);
                SentryStore.this.alterSentryRoleAddGroupsCore(pm, roleName, groupNames);
                return null;
            }
        });
    }

    private void alterSentryRoleAddGroupsCore(PersistenceManager pm, String roleName, Set<TSentryGroup> groupNames) throws SentryNoSuchObjectException {
        String lRoleName = this.trimAndLower(roleName);
        MSentryRole role = this.getRole(pm, lRoleName);
        if (role == null) {
            throw SentryStore.noSuchRole(lRoleName);
        }
        Query query = pm.newQuery(MSentryGroup.class);
        query.setFilter("this.groupName == :groupName");
        query.setUnique(true);
        ArrayList groups = Lists.newArrayList();
        for (TSentryGroup tGroup : groupNames) {
            String groupName = tGroup.getGroupName().trim();
            MSentryGroup group = (MSentryGroup)query.execute((Object)groupName);
            if (group == null) {
                group = new MSentryGroup(groupName, System.currentTimeMillis(), Sets.newHashSet((Object[])new MSentryRole[]{role}));
            }
            group.appendRole(role);
            groups.add(group);
        }
        pm.makePersistentAll((Collection)groups);
    }

    public void alterSentryRoleAddUsers(final String roleName, final Set<String> userNames) throws Exception {
        this.tm.executeTransactionWithRetry(new TransactionBlock<Object>(){

            @Override
            public Object execute(PersistenceManager pm) throws Exception {
                pm.setDetachAllOnCommit(false);
                SentryStore.this.alterSentryRoleAddUsersCore(pm, roleName, userNames);
                return null;
            }
        });
    }

    private void alterSentryRoleAddUsersCore(PersistenceManager pm, String roleName, Set<String> userNames) throws SentryNoSuchObjectException {
        String trimmedRoleName = this.trimAndLower(roleName);
        MSentryRole role = this.getRole(pm, trimmedRoleName);
        if (role == null) {
            throw SentryStore.noSuchRole(trimmedRoleName);
        }
        Query query = pm.newQuery(MSentryUser.class);
        query.setFilter("this.userName == :userName");
        query.setUnique(true);
        ArrayList users = Lists.newArrayList();
        for (String userName : userNames) {
            MSentryUser user = (MSentryUser)query.execute((Object)(userName = userName.trim()));
            if (user == null) {
                user = new MSentryUser(userName, System.currentTimeMillis(), Sets.newHashSet((Object[])new MSentryRole[]{role}));
            }
            user.appendRole(role);
            users.add(user);
        }
        pm.makePersistentAll((Collection)users);
    }

    public void alterSentryRoleDeleteUsers(final String roleName, final Set<String> userNames) throws Exception {
        this.tm.executeTransactionWithRetry(new TransactionBlock<Object>(){

            @Override
            public Object execute(PersistenceManager pm) throws Exception {
                pm.setDetachAllOnCommit(false);
                String trimmedRoleName = SentryStore.this.trimAndLower(roleName);
                MSentryRole role = SentryStore.this.getRole(pm, trimmedRoleName);
                if (role == null) {
                    throw SentryStore.noSuchRole(trimmedRoleName);
                }
                Query query = pm.newQuery(MSentryUser.class);
                query.setFilter("this.userName == :userName");
                query.setUnique(true);
                ArrayList users = Lists.newArrayList();
                for (String userName : userNames) {
                    MSentryUser user = (MSentryUser)query.execute((Object)(userName = userName.trim()));
                    if (user == null) continue;
                    user.removeRole(role);
                    users.add(user);
                }
                pm.makePersistentAll((Collection)users);
                return null;
            }
        });
    }

    public void alterSentryRoleDeleteGroups(final String roleName, final Set<TSentryGroup> groupNames) throws Exception {
        this.tm.executeTransactionWithRetry(new TransactionBlock<Object>(){

            @Override
            public Object execute(PersistenceManager pm) throws Exception {
                pm.setDetachAllOnCommit(false);
                String trimmedRoleName = SentryStore.this.trimAndLower(roleName);
                MSentryRole role = SentryStore.this.getRole(pm, trimmedRoleName);
                if (role == null) {
                    throw SentryStore.noSuchRole(trimmedRoleName);
                }
                Query query = pm.newQuery(MSentryGroup.class);
                query.setFilter("this.groupName == :groupName");
                query.setUnique(true);
                ArrayList groups = Lists.newArrayList();
                for (TSentryGroup tGroup : groupNames) {
                    String groupName = tGroup.getGroupName().trim();
                    MSentryGroup group = (MSentryGroup)query.execute((Object)groupName);
                    if (group == null) continue;
                    group.removeRole(role);
                    groups.add(group);
                }
                pm.makePersistentAll((Collection)groups);
                return null;
            }
        });
    }

    public synchronized void alterSentryRoleDeleteGroups(final String roleName, final Set<TSentryGroup> groupNames, Updateable.Update update) throws Exception {
        this.execute(update, new TransactionBlock<Object>(){

            @Override
            public Object execute(PersistenceManager pm) throws Exception {
                pm.setDetachAllOnCommit(false);
                String trimmedRoleName = SentryStore.this.trimAndLower(roleName);
                MSentryRole role = SentryStore.this.getRole(pm, trimmedRoleName);
                if (role == null) {
                    throw SentryStore.noSuchRole(trimmedRoleName);
                }
                Query query = pm.newQuery(MSentryGroup.class);
                query.setFilter("this.groupName == :groupName");
                query.setUnique(true);
                ArrayList groups = Lists.newArrayList();
                for (TSentryGroup tGroup : groupNames) {
                    String groupName = tGroup.getGroupName().trim();
                    MSentryGroup group = (MSentryGroup)query.execute((Object)groupName);
                    if (group == null) continue;
                    group.removeRole(role);
                    groups.add(group);
                }
                pm.makePersistentAll((Collection)groups);
                return null;
            }
        });
    }

    @VisibleForTesting
    public MSentryRole getMSentryRoleByName(final String roleName) throws Exception {
        return this.tm.executeTransaction(new TransactionBlock<MSentryRole>(){

            @Override
            public MSentryRole execute(PersistenceManager pm) throws Exception {
                String trimmedRoleName = SentryStore.this.trimAndLower(roleName);
                MSentryRole sentryRole = SentryStore.this.getRole(pm, trimmedRoleName);
                if (sentryRole == null) {
                    throw SentryStore.noSuchRole(trimmedRoleName);
                }
                return sentryRole;
            }
        });
    }

    @VisibleForTesting
    MSentryPrivilege findMSentryPrivilegeFromTSentryPrivilege(final TSentryPrivilege tPrivilege) throws Exception {
        return this.tm.executeTransaction(new TransactionBlock<MSentryPrivilege>(){

            @Override
            public MSentryPrivilege execute(PersistenceManager pm) throws Exception {
                return SentryStore.this.getMSentryPrivilege(tPrivilege, pm);
            }
        });
    }

    @VisibleForTesting
    List<MSentryPrivilege> getAllMSentryPrivileges() throws Exception {
        return this.tm.executeTransaction(new TransactionBlock<List<MSentryPrivilege>>(){

            @Override
            public List<MSentryPrivilege> execute(PersistenceManager pm) throws Exception {
                return SentryStore.this.getAllMSentryPrivilegesCore(pm);
            }
        });
    }

    private List<MSentryPrivilege> getAllMSentryPrivilegesCore(PersistenceManager pm) {
        Query query = pm.newQuery(MSentryPrivilege.class);
        return (List)query.execute();
    }

    private boolean hasAnyServerPrivileges(final Set<String> roleNames, final String serverName) throws Exception {
        if (roleNames == null || roleNames.isEmpty()) {
            return false;
        }
        return this.tm.executeTransaction(new TransactionBlock<Boolean>(){

            @Override
            public Boolean execute(PersistenceManager pm) throws Exception {
                pm.setDetachAllOnCommit(false);
                Query query = pm.newQuery(MSentryPrivilege.class);
                query.addExtension(SentryStore.LOAD_RESULTS_AT_COMMIT, (Object)"false");
                QueryParamBuilder paramBuilder = QueryParamBuilder.addRolesFilter(query, null, roleNames);
                paramBuilder.add(SentryStore.SERVER_NAME, serverName);
                query.setFilter(paramBuilder.toString());
                query.setResult("count(this)");
                Long numPrivs = (Long)query.executeWithMap(paramBuilder.getArguments());
                return numPrivs > 0L;
            }
        });
    }

    private List<MSentryPrivilege> getMSentryPrivileges(final Set<String> roleNames, final TSentryAuthorizable authHierarchy) throws Exception {
        if (roleNames == null || roleNames.isEmpty()) {
            return Collections.emptyList();
        }
        return this.tm.executeTransaction(new TransactionBlock<List<MSentryPrivilege>>(){

            @Override
            public List<MSentryPrivilege> execute(PersistenceManager pm) throws Exception {
                Query query = pm.newQuery(MSentryPrivilege.class);
                QueryParamBuilder paramBuilder = QueryParamBuilder.addRolesFilter(query, null, roleNames);
                if (authHierarchy != null && authHierarchy.getServer() != null) {
                    paramBuilder.add(SentryStore.SERVER_NAME, authHierarchy.getServer());
                    if (authHierarchy.getDb() != null) {
                        paramBuilder.addNull(SentryStore.URI).newChild().add(SentryStore.DB_NAME, authHierarchy.getDb()).addNull(SentryStore.DB_NAME);
                        if (authHierarchy.getTable() != null && !"*".equalsIgnoreCase(authHierarchy.getTable())) {
                            if (!"+".equalsIgnoreCase(authHierarchy.getTable())) {
                                paramBuilder.addNull(SentryStore.URI).newChild().add(SentryStore.TABLE_NAME, authHierarchy.getTable()).addNull(SentryStore.TABLE_NAME);
                            }
                            if (authHierarchy.getColumn() != null && !"*".equalsIgnoreCase(authHierarchy.getColumn()) && !"+".equalsIgnoreCase(authHierarchy.getColumn())) {
                                paramBuilder.addNull(SentryStore.URI).newChild().add(SentryStore.COLUMN_NAME, authHierarchy.getColumn()).addNull(SentryStore.COLUMN_NAME);
                            }
                        }
                    }
                    if (authHierarchy.getUri() != null) {
                        paramBuilder.addNull(SentryStore.DB_NAME).newChild().addNull(SentryStore.URI).newChild().addNotNull(SentryStore.URI).addCustomParam("\"" + authHierarchy.getUri() + "\".startsWith(:URI)", SentryStore.URI, authHierarchy.getUri());
                    }
                }
                query.setFilter(paramBuilder.toString());
                List result = (List)query.executeWithMap(paramBuilder.getArguments());
                return result;
            }
        });
    }

    private List<MSentryPrivilege> getMSentryPrivilegesByAuth(final Set<String> roleNames, final TSentryAuthorizable authHierarchy) throws Exception {
        return this.tm.executeTransaction(new TransactionBlock<List<MSentryPrivilege>>(){

            @Override
            public List<MSentryPrivilege> execute(PersistenceManager pm) throws Exception {
                Query query = pm.newQuery(MSentryPrivilege.class);
                QueryParamBuilder paramBuilder = QueryParamBuilder.newQueryParamBuilder();
                if (roleNames == null || roleNames.isEmpty()) {
                    paramBuilder.addString("!roles.isEmpty()");
                } else {
                    QueryParamBuilder.addRolesFilter(query, paramBuilder, roleNames);
                }
                if (authHierarchy.getServer() != null) {
                    paramBuilder.add(SentryStore.SERVER_NAME, authHierarchy.getServer());
                    if (authHierarchy.getDb() != null) {
                        paramBuilder.add(SentryStore.DB_NAME, authHierarchy.getDb()).addNull(SentryStore.URI);
                        if (authHierarchy.getTable() != null) {
                            paramBuilder.add(SentryStore.TABLE_NAME, authHierarchy.getTable());
                        } else {
                            paramBuilder.addNull(SentryStore.TABLE_NAME);
                        }
                    } else if (authHierarchy.getUri() != null) {
                        paramBuilder.addNotNull(SentryStore.URI).addNull(SentryStore.DB_NAME).addCustomParam("(:authURI.startsWith(URI))", "authURI", authHierarchy.getUri());
                    } else {
                        paramBuilder.addNull(SentryStore.DB_NAME).addNull(SentryStore.URI);
                    }
                } else {
                    return Collections.emptyList();
                }
                FetchGroup grp = pm.getFetchGroup(MSentryPrivilege.class, "fetchRole");
                grp.addMember("roles");
                pm.getFetchPlan().addGroup("fetchRole");
                query.setFilter(paramBuilder.toString());
                List result = (List)query.executeWithMap(paramBuilder.getArguments());
                return result;
            }
        });
    }

    public TSentryPrivilegeMap listSentryPrivilegesByAuthorizable(Set<String> groups, TSentryActiveRoleSet activeRoles, TSentryAuthorizable authHierarchy, boolean isAdmin) throws Exception {
        TreeMap resultPrivilegeMap = Maps.newTreeMap();
        Set<String> roles = this.getRolesToQuery(groups, null, new TSentryActiveRoleSet(true, null));
        if (activeRoles != null && !activeRoles.isAll()) {
            for (String aRole : activeRoles.getRoles()) {
                roles.add(aRole.toLowerCase());
            }
        }
        if (isAdmin || !roles.isEmpty()) {
            List<MSentryPrivilege> mSentryPrivileges = this.getMSentryPrivilegesByAuth(roles, authHierarchy);
            for (MSentryPrivilege priv : mSentryPrivileges) {
                for (MSentryRole role : priv.getRoles()) {
                    TSentryPrivilege tPriv = this.convertToTSentryPrivilege(priv);
                    if (resultPrivilegeMap.containsKey(role.getRoleName())) {
                        ((Set)resultPrivilegeMap.get(role.getRoleName())).add(tPriv);
                        continue;
                    }
                    TreeSet tPrivSet = Sets.newTreeSet();
                    tPrivSet.add(tPriv);
                    resultPrivilegeMap.put(role.getRoleName(), tPrivSet);
                }
            }
        }
        return new TSentryPrivilegeMap(resultPrivilegeMap);
    }

    private Set<MSentryPrivilege> getMSentryPrivilegesByRoleName(String roleName) throws Exception {
        MSentryRole mSentryRole = this.getMSentryRoleByName(roleName);
        return mSentryRole.getPrivileges();
    }

    public Set<TSentryPrivilege> getAllTSentryPrivilegesByRoleName(String roleName) throws Exception {
        return this.convertToTSentryPrivileges(this.getMSentryPrivilegesByRoleName(roleName));
    }

    public Set<TSentryPrivilege> getTSentryPrivileges(Set<String> roleNames, TSentryAuthorizable authHierarchy) throws Exception {
        if (authHierarchy.getServer() == null) {
            throw new SentryInvalidInputException("serverName cannot be null !!");
        }
        if (authHierarchy.getTable() != null && authHierarchy.getDb() == null) {
            throw new SentryInvalidInputException("dbName cannot be null when tableName is present !!");
        }
        if (authHierarchy.getColumn() != null && authHierarchy.getTable() == null) {
            throw new SentryInvalidInputException("tableName cannot be null when columnName is present !!");
        }
        if (authHierarchy.getUri() == null && authHierarchy.getDb() == null) {
            throw new SentryInvalidInputException("One of uri or dbName must not be null !!");
        }
        return this.convertToTSentryPrivileges(this.getMSentryPrivileges(roleNames, authHierarchy));
    }

    public Set<TSentryRole> getTSentryRolesByGroupName(final Set<String> groupNames, final boolean checkAllGroups) throws Exception {
        if (groupNames.isEmpty()) {
            return Collections.emptySet();
        }
        return this.tm.executeTransaction(new TransactionBlock<Set<TSentryRole>>(){

            @Override
            public Set<TSentryRole> execute(PersistenceManager pm) throws Exception {
                pm.setDetachAllOnCommit(false);
                HashSet<String> roleNames = new HashSet<String>(1024);
                HashSet<TSentryRole> result = new HashSet<TSentryRole>(1024);
                for (String group : groupNames) {
                    if (group == null) {
                        List roles = SentryStore.this.getAllRoles(pm);
                        for (MSentryRole role : roles) {
                            result.add(SentryStore.this.convertToTSentryRole(role));
                        }
                        return result;
                    }
                    String trimmedGroup = group.trim();
                    Query query = pm.newQuery(MSentryGroup.class);
                    query.setFilter("this.groupName == :groupName");
                    query.setUnique(true);
                    MSentryGroup mGroup = (MSentryGroup)query.execute((Object)trimmedGroup);
                    if (mGroup != null) {
                        for (MSentryRole role : mGroup.getRoles()) {
                            String roleName = role.getRoleName();
                            if (!roleNames.add(roleName)) continue;
                            result.add(SentryStore.this.convertToTSentryRole(role));
                        }
                    } else if (!checkAllGroups) {
                        throw SentryStore.noSuchGroup(trimmedGroup);
                    }
                    query.closeAll();
                }
                return result;
            }
        });
    }

    public Set<String> getRoleNamesForGroups(final Set<String> groups) throws Exception {
        if (groups == null || groups.isEmpty()) {
            return ImmutableSet.of();
        }
        return this.tm.executeTransaction(new TransactionBlock<Set<String>>(){

            @Override
            public Set<String> execute(PersistenceManager pm) throws Exception {
                pm.setDetachAllOnCommit(false);
                return SentryStore.this.getRoleNamesForGroupsCore(pm, groups);
            }
        });
    }

    private Set<String> getRoleNamesForGroupsCore(PersistenceManager pm, Set<String> groups) {
        return this.convertToRoleNameSet(this.getRolesForGroups(pm, groups));
    }

    public Set<String> getRoleNamesForUsers(final Set<String> users) throws Exception {
        if (users == null || users.isEmpty()) {
            return ImmutableSet.of();
        }
        return this.tm.executeTransaction(new TransactionBlock<Set<String>>(){

            @Override
            public Set<String> execute(PersistenceManager pm) throws Exception {
                pm.setDetachAllOnCommit(false);
                return SentryStore.this.getRoleNamesForUsersCore(pm, users);
            }
        });
    }

    private Set<String> getRoleNamesForUsersCore(PersistenceManager pm, Set<String> users) {
        return this.convertToRoleNameSet(this.getRolesForUsers(pm, users));
    }

    public Set<TSentryRole> getTSentryRolesByUserNames(final Set<String> users) throws Exception {
        return this.tm.executeTransaction(new TransactionBlock<Set<TSentryRole>>(){

            @Override
            public Set<TSentryRole> execute(PersistenceManager pm) throws Exception {
                pm.setDetachAllOnCommit(false);
                Set mSentryRoles = SentryStore.this.getRolesForUsers(pm, users);
                return SentryStore.this.convertToTSentryRoles(mSentryRoles);
            }
        });
    }

    public Set<MSentryRole> getRolesForGroups(PersistenceManager pm, Set<String> groups) {
        HashSet result = Sets.newHashSet();
        if (groups != null) {
            Query query = pm.newQuery(MSentryGroup.class);
            query.addExtension(LOAD_RESULTS_AT_COMMIT, (Object)"false");
            query.setFilter(":p1.contains(this.groupName)");
            List sentryGroups = (List)query.execute((Object)groups.toArray());
            if (sentryGroups != null) {
                for (MSentryGroup sentryGroup : sentryGroups) {
                    result.addAll(sentryGroup.getRoles());
                }
            }
        }
        return result;
    }

    private Set<MSentryRole> getRolesForUsers(PersistenceManager pm, Set<String> users) {
        HashSet result = Sets.newHashSet();
        if (users != null) {
            Query query = pm.newQuery(MSentryUser.class);
            query.addExtension(LOAD_RESULTS_AT_COMMIT, (Object)"false");
            query.setFilter(":p1.contains(this.userName)");
            List sentryUsers = (List)query.execute((Object)users.toArray());
            if (sentryUsers != null) {
                for (MSentryUser sentryUser : sentryUsers) {
                    result.addAll(sentryUser.getRoles());
                }
            }
        }
        return result;
    }

    Set<String> listAllSentryPrivilegesForProvider(Set<String> groups, Set<String> users, TSentryActiveRoleSet roleSet) throws Exception {
        return this.listSentryPrivilegesForProvider(groups, users, roleSet, null);
    }

    public Set<String> listSentryPrivilegesForProvider(Set<String> groups, Set<String> users, TSentryActiveRoleSet roleSet, TSentryAuthorizable authHierarchy) throws Exception {
        HashSet result = Sets.newHashSet();
        Set<String> rolesToQuery = this.getRolesToQuery(groups, users, roleSet);
        List<MSentryPrivilege> mSentryPrivileges = this.getMSentryPrivileges(rolesToQuery, authHierarchy);
        for (MSentryPrivilege priv : mSentryPrivileges) {
            result.add(SentryStore.toAuthorizable(priv));
        }
        return result;
    }

    public boolean hasAnyServerPrivileges(Set<String> groups, Set<String> users, TSentryActiveRoleSet roleSet, String server) throws Exception {
        Set<String> rolesToQuery = this.getRolesToQuery(groups, users, roleSet);
        return this.hasAnyServerPrivileges(rolesToQuery, server);
    }

    private Set<String> getRolesToQuery(final Set<String> groups, final Set<String> users, final TSentryActiveRoleSet roleSet) throws Exception {
        return this.tm.executeTransaction(new TransactionBlock<Set<String>>(){

            @Override
            public Set<String> execute(PersistenceManager pm) throws Exception {
                pm.setDetachAllOnCommit(false);
                Set<String> activeRoleNames = SentryStore.toTrimedLower(roleSet.getRoles());
                HashSet roleNames = Sets.newHashSet();
                roleNames.addAll(SentryStore.toTrimedLower(SentryStore.this.getRoleNamesForGroupsCore(pm, groups)));
                roleNames.addAll(SentryStore.toTrimedLower(SentryStore.this.getRoleNamesForUsersCore(pm, users)));
                return roleSet.isAll() ? roleNames : Sets.intersection(activeRoleNames, (Set)roleNames);
            }
        });
    }

    @VisibleForTesting
    static String toAuthorizable(MSentryPrivilege privilege) {
        ArrayList<String> authorizable = new ArrayList<String>(4);
        authorizable.add(SentryConstants.KV_JOINER.join((Object)DBModelAuthorizable.AuthorizableType.Server.name().toLowerCase(), (Object)privilege.getServerName(), new Object[0]));
        if (SentryStore.isNULL(privilege.getURI())) {
            if (!SentryStore.isNULL(privilege.getDbName())) {
                authorizable.add(SentryConstants.KV_JOINER.join((Object)DBModelAuthorizable.AuthorizableType.Db.name().toLowerCase(), (Object)privilege.getDbName(), new Object[0]));
                if (!SentryStore.isNULL(privilege.getTableName())) {
                    authorizable.add(SentryConstants.KV_JOINER.join((Object)DBModelAuthorizable.AuthorizableType.Table.name().toLowerCase(), (Object)privilege.getTableName(), new Object[0]));
                    if (!SentryStore.isNULL(privilege.getColumnName())) {
                        authorizable.add(SentryConstants.KV_JOINER.join((Object)DBModelAuthorizable.AuthorizableType.Column.name().toLowerCase(), (Object)privilege.getColumnName(), new Object[0]));
                    }
                }
            }
        } else {
            authorizable.add(SentryConstants.KV_JOINER.join((Object)DBModelAuthorizable.AuthorizableType.URI.name().toLowerCase(), (Object)privilege.getURI(), new Object[0]));
        }
        if (!SentryStore.isNULL(privilege.getAction()) && !privilege.getAction().equalsIgnoreCase("*")) {
            authorizable.add(SentryConstants.KV_JOINER.join((Object)ACTION.toLowerCase(), (Object)privilege.getAction(), new Object[0]));
        }
        return SentryConstants.AUTHORIZABLE_JOINER.join(authorizable);
    }

    @VisibleForTesting
    public static Set<String> toTrimedLower(Set<String> s) {
        if (s == null || s.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet result = Sets.newHashSet();
        for (String v : s) {
            result.add(v.trim().toLowerCase());
        }
        return result;
    }

    private Set<TSentryPrivilege> convertToTSentryPrivileges(Collection<MSentryPrivilege> mSentryPrivileges) {
        if (mSentryPrivileges.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<TSentryPrivilege> privileges = new HashSet<TSentryPrivilege>(mSentryPrivileges.size());
        for (MSentryPrivilege mSentryPrivilege : mSentryPrivileges) {
            privileges.add(this.convertToTSentryPrivilege(mSentryPrivilege));
        }
        return privileges;
    }

    private Set<TSentryRole> convertToTSentryRoles(Set<MSentryRole> mSentryRoles) {
        if (mSentryRoles.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<TSentryRole> roles = new HashSet<TSentryRole>(mSentryRoles.size());
        for (MSentryRole mSentryRole : mSentryRoles) {
            roles.add(this.convertToTSentryRole(mSentryRole));
        }
        return roles;
    }

    private Set<String> convertToRoleNameSet(Set<MSentryRole> mSentryRoles) {
        if (mSentryRoles.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<String> roleNameSet = new HashSet<String>(mSentryRoles.size());
        for (MSentryRole role : mSentryRoles) {
            roleNameSet.add(role.getRoleName());
        }
        return roleNameSet;
    }

    private TSentryRole convertToTSentryRole(MSentryRole mSentryRole) {
        String roleName = mSentryRole.getRoleName().intern();
        Set<MSentryGroup> groups = mSentryRole.getGroups();
        HashSet<TSentryGroup> sentryGroups = new HashSet<TSentryGroup>(groups.size());
        for (MSentryGroup mSentryGroup : groups) {
            TSentryGroup group = this.convertToTSentryGroup(mSentryGroup);
            sentryGroups.add(group);
        }
        return new TSentryRole(roleName, sentryGroups, EMPTY_GRANTOR_PRINCIPAL);
    }

    private TSentryGroup convertToTSentryGroup(MSentryGroup mSentryGroup) {
        return new TSentryGroup(mSentryGroup.getGroupName().intern());
    }

    TSentryPrivilege convertToTSentryPrivilege(MSentryPrivilege mSentryPrivilege) {
        TSentryPrivilege privilege = new TSentryPrivilege();
        this.convertToTSentryPrivilege(mSentryPrivilege, privilege);
        return privilege;
    }

    private void convertToTSentryPrivilege(MSentryPrivilege mSentryPrivilege, TSentryPrivilege privilege) {
        privilege.setCreateTime(mSentryPrivilege.getCreateTime());
        privilege.setAction(SentryStore.fromNULLCol(mSentryPrivilege.getAction()));
        privilege.setPrivilegeScope(mSentryPrivilege.getPrivilegeScope());
        privilege.setServerName(SentryStore.fromNULLCol(mSentryPrivilege.getServerName()));
        privilege.setDbName(SentryStore.fromNULLCol(mSentryPrivilege.getDbName()));
        privilege.setTableName(SentryStore.fromNULLCol(mSentryPrivilege.getTableName()));
        privilege.setColumnName(SentryStore.fromNULLCol(mSentryPrivilege.getColumnName()));
        privilege.setURI(SentryStore.fromNULLCol(mSentryPrivilege.getURI()));
        if (mSentryPrivilege.getGrantOption() != null) {
            privilege.setGrantOption(TSentryGrantOption.valueOf(mSentryPrivilege.getGrantOption().toString().toUpperCase()));
        } else {
            privilege.setGrantOption(TSentryGrantOption.UNSET);
        }
    }

    private MSentryPrivilege convertToMSentryPrivilege(TSentryPrivilege privilege) throws SentryInvalidInputException {
        MSentryPrivilege mSentryPrivilege = new MSentryPrivilege();
        mSentryPrivilege.setServerName(SentryStore.toNULLCol(SentryStore.safeTrimLower(privilege.getServerName())));
        mSentryPrivilege.setDbName(SentryStore.toNULLCol(SentryStore.safeTrimLower(privilege.getDbName())));
        mSentryPrivilege.setTableName(SentryStore.toNULLCol(SentryStore.safeTrimLower(privilege.getTableName())));
        mSentryPrivilege.setColumnName(SentryStore.toNULLCol(SentryStore.safeTrimLower(privilege.getColumnName())));
        mSentryPrivilege.setPrivilegeScope(SentryStore.safeTrim(privilege.getPrivilegeScope()));
        mSentryPrivilege.setAction(SentryStore.toNULLCol(SentryStore.safeTrimLower(privilege.getAction())));
        mSentryPrivilege.setCreateTime(System.currentTimeMillis());
        mSentryPrivilege.setURI(SentryStore.toNULLCol(SentryStore.safeTrim(privilege.getURI())));
        if (!privilege.getGrantOption().equals((Object)TSentryGrantOption.UNSET)) {
            mSentryPrivilege.setGrantOption(Boolean.valueOf(privilege.getGrantOption().toString()));
        } else {
            mSentryPrivilege.setGrantOption(null);
        }
        return mSentryPrivilege;
    }

    static String safeTrim(String s) {
        if (s == null) {
            return null;
        }
        return s.trim();
    }

    static String safeTrimLower(String s) {
        if (s == null) {
            return null;
        }
        return s.trim().toLowerCase();
    }

    String getSentryVersion() throws Exception {
        MSentryVersion mVersion = this.getMSentryVersion();
        return mVersion.getSchemaVersion();
    }

    void setSentryVersion(final String newVersion, final String verComment) throws Exception {
        this.tm.executeTransaction(new TransactionBlock<Object>(){

            @Override
            public Object execute(PersistenceManager pm) throws Exception {
                MSentryVersion mVersion;
                try {
                    mVersion = SentryStore.this.getMSentryVersion();
                    if (newVersion.equals(mVersion.getSchemaVersion())) {
                        return null;
                    }
                }
                catch (SentryNoSuchObjectException e) {
                    mVersion = new MSentryVersion();
                }
                mVersion.setSchemaVersion(newVersion);
                mVersion.setVersionComment(verComment);
                pm.makePersistent((Object)mVersion);
                return null;
            }
        });
    }

    private MSentryVersion getMSentryVersion() throws Exception {
        return this.tm.executeTransaction(new TransactionBlock<MSentryVersion>(){

            @Override
            public MSentryVersion execute(PersistenceManager pm) throws Exception {
                try {
                    Query query = pm.newQuery(MSentryVersion.class);
                    List mSentryVersions = (List)query.execute();
                    pm.retrieveAll((Collection)mSentryVersions);
                    if (mSentryVersions.isEmpty()) {
                        throw new SentryNoSuchObjectException("Matching Version");
                    }
                    if (mSentryVersions.size() > 1) {
                        throw new SentryAccessDeniedException("Metastore contains multiple versions");
                    }
                    return (MSentryVersion)mSentryVersions.get(0);
                }
                catch (JDODataStoreException e) {
                    if (e.getCause() instanceof MissingTableException) {
                        throw new SentryAccessDeniedException("Version table not found. The sentry store is not set or corrupt ");
                    }
                    throw e;
                }
            }
        });
    }

    public void dropPrivilege(final TSentryAuthorizable tAuthorizable) throws Exception {
        this.tm.executeTransactionWithRetry(new TransactionBlock<Object>(){

            @Override
            public Object execute(PersistenceManager pm) throws Exception {
                pm.setDetachAllOnCommit(false);
                TSentryPrivilege tPrivilege = SentryStore.this.toSentryPrivilege(tAuthorizable);
                try {
                    if (SentryStore.this.isMultiActionsSupported(tPrivilege)) {
                        for (String privilegeAction : ALL_ACTIONS) {
                            tPrivilege.setAction(privilegeAction);
                            SentryStore.this.dropPrivilegeForAllRoles(pm, new TSentryPrivilege(tPrivilege));
                        }
                    } else {
                        SentryStore.this.dropPrivilegeForAllRoles(pm, new TSentryPrivilege(tPrivilege));
                    }
                }
                catch (JDODataStoreException e) {
                    throw new SentryInvalidInputException("Failed to get privileges: " + e.getMessage());
                }
                return null;
            }
        });
    }

    public synchronized void dropPrivilege(final TSentryAuthorizable tAuthorizable, Updateable.Update update) throws Exception {
        this.execute(update, new TransactionBlock<Object>(){

            @Override
            public Object execute(PersistenceManager pm) throws Exception {
                pm.setDetachAllOnCommit(false);
                TSentryPrivilege tPrivilege = SentryStore.this.toSentryPrivilege(tAuthorizable);
                try {
                    if (SentryStore.this.isMultiActionsSupported(tPrivilege)) {
                        for (String privilegeAction : ALL_ACTIONS) {
                            tPrivilege.setAction(privilegeAction);
                            SentryStore.this.dropPrivilegeForAllRoles(pm, new TSentryPrivilege(tPrivilege));
                        }
                    } else {
                        SentryStore.this.dropPrivilegeForAllRoles(pm, new TSentryPrivilege(tPrivilege));
                    }
                }
                catch (JDODataStoreException e) {
                    throw new SentryInvalidInputException("Failed to get privileges: " + e.getMessage());
                }
                return null;
            }
        });
    }

    public void renamePrivilege(final TSentryAuthorizable oldTAuthorizable, final TSentryAuthorizable newTAuthorizable) throws Exception {
        this.tm.executeTransactionWithRetry(new TransactionBlock<Object>(){

            @Override
            public Object execute(PersistenceManager pm) throws Exception {
                pm.setDetachAllOnCommit(false);
                TSentryPrivilege tPrivilege = SentryStore.this.toSentryPrivilege(oldTAuthorizable);
                TSentryPrivilege newPrivilege = SentryStore.this.toSentryPrivilege(newTAuthorizable);
                try {
                    if (SentryStore.this.isMultiActionsSupported(tPrivilege)) {
                        for (String privilegeAction : ALL_ACTIONS) {
                            tPrivilege.setAction(privilegeAction);
                            newPrivilege.setAction(privilegeAction);
                            SentryStore.this.renamePrivilegeForAllRoles(pm, tPrivilege, newPrivilege);
                        }
                    } else {
                        SentryStore.this.renamePrivilegeForAllRoles(pm, tPrivilege, newPrivilege);
                    }
                }
                catch (JDODataStoreException e) {
                    throw new SentryInvalidInputException("Failed to get privileges: " + e.getMessage());
                }
                return null;
            }
        });
    }

    public synchronized void renamePrivilege(final TSentryAuthorizable oldTAuthorizable, final TSentryAuthorizable newTAuthorizable, Updateable.Update update) throws Exception {
        this.execute(update, new TransactionBlock<Object>(){

            @Override
            public Object execute(PersistenceManager pm) throws Exception {
                pm.setDetachAllOnCommit(false);
                TSentryPrivilege tPrivilege = SentryStore.this.toSentryPrivilege(oldTAuthorizable);
                TSentryPrivilege newPrivilege = SentryStore.this.toSentryPrivilege(newTAuthorizable);
                try {
                    if (SentryStore.this.isMultiActionsSupported(tPrivilege)) {
                        for (String privilegeAction : ALL_ACTIONS) {
                            tPrivilege.setAction(privilegeAction);
                            newPrivilege.setAction(privilegeAction);
                            SentryStore.this.renamePrivilegeForAllRoles(pm, tPrivilege, newPrivilege);
                        }
                    } else {
                        SentryStore.this.renamePrivilegeForAllRoles(pm, tPrivilege, newPrivilege);
                    }
                }
                catch (JDODataStoreException e) {
                    throw new SentryInvalidInputException("Failed to get privileges: " + e.getMessage());
                }
                return null;
            }
        });
    }

    private boolean isMultiActionsSupported(TSentryPrivilege tPrivilege) {
        return tPrivilege.getDbName() != null;
    }

    private void renamePrivilegeForAllRoles(PersistenceManager pm, TSentryPrivilege tPrivilege, TSentryPrivilege newPrivilege) throws SentryNoSuchObjectException, SentryInvalidInputException {
        this.dropOrRenamePrivilegeForAllRoles(pm, tPrivilege, newPrivilege);
    }

    private void dropPrivilegeForAllRoles(PersistenceManager pm, TSentryPrivilege tPrivilege) throws SentryNoSuchObjectException, SentryInvalidInputException {
        this.dropOrRenamePrivilegeForAllRoles(pm, tPrivilege, null);
    }

    private void dropOrRenamePrivilegeForAllRoles(PersistenceManager pm, TSentryPrivilege tPrivilege, TSentryPrivilege newTPrivilege) throws SentryNoSuchObjectException, SentryInvalidInputException {
        HashSet roleSet = new HashSet();
        List<MSentryPrivilege> mPrivileges = this.getMSentryPrivileges(tPrivilege, pm);
        for (MSentryPrivilege mPrivilege : mPrivileges) {
            roleSet.addAll(ImmutableSet.copyOf(mPrivilege.getRoles()));
        }
        if (newTPrivilege == null) {
            for (MSentryRole role : roleSet) {
                this.alterSentryRoleRevokePrivilegeCore(pm, role.getRoleName(), tPrivilege);
            }
            return;
        }
        MSentryPrivilege parent = this.getMSentryPrivilege(tPrivilege, pm);
        if (parent != null) {
            parent = (MSentryPrivilege)pm.detachCopy((Object)parent);
        }
        for (MSentryRole role : roleSet) {
            HashSet<MSentryPrivilege> privilegeGraph = new HashSet<MSentryPrivilege>();
            if (parent != null) {
                privilegeGraph.add(parent);
                this.populateChildren(pm, Sets.newHashSet((Object[])new String[]{role.getRoleName()}), parent, privilegeGraph);
            } else {
                this.populateChildren(pm, Sets.newHashSet((Object[])new String[]{role.getRoleName()}), this.convertToMSentryPrivilege(tPrivilege), privilegeGraph);
            }
            this.alterSentryRoleRevokePrivilegeCore(pm, role.getRoleName(), tPrivilege);
            for (MSentryPrivilege mPriv : privilegeGraph) {
                TSentryPrivilege tPriv = this.convertToTSentryPrivilege(mPriv);
                if (newTPrivilege.getPrivilegeScope().equals(ServiceConstants.PrivilegeScope.DATABASE.name())) {
                    tPriv.setDbName(newTPrivilege.getDbName());
                } else if (newTPrivilege.getPrivilegeScope().equals(ServiceConstants.PrivilegeScope.TABLE.name())) {
                    tPriv.setTableName(newTPrivilege.getTableName());
                }
                this.alterSentryRoleGrantPrivilegeCore(pm, role.getRoleName(), tPriv);
            }
        }
    }

    private TSentryPrivilege toSentryPrivilege(TSentryAuthorizable tAuthorizable) throws SentryInvalidInputException {
        TSentryPrivilege tSentryPrivilege = new TSentryPrivilege();
        tSentryPrivilege.setDbName(SentryStore.fromNULLCol(tAuthorizable.getDb()));
        tSentryPrivilege.setServerName(SentryStore.fromNULLCol(tAuthorizable.getServer()));
        tSentryPrivilege.setTableName(SentryStore.fromNULLCol(tAuthorizable.getTable()));
        tSentryPrivilege.setColumnName(SentryStore.fromNULLCol(tAuthorizable.getColumn()));
        tSentryPrivilege.setURI(SentryStore.fromNULLCol(tAuthorizable.getUri()));
        ServiceConstants.PrivilegeScope scope = !SentryStore.isNULL(tSentryPrivilege.getColumnName()) ? ServiceConstants.PrivilegeScope.COLUMN : (!SentryStore.isNULL(tSentryPrivilege.getTableName()) ? ServiceConstants.PrivilegeScope.TABLE : (!SentryStore.isNULL(tSentryPrivilege.getDbName()) ? ServiceConstants.PrivilegeScope.DATABASE : (!SentryStore.isNULL(tSentryPrivilege.getURI()) ? ServiceConstants.PrivilegeScope.URI : ServiceConstants.PrivilegeScope.SERVER)));
        tSentryPrivilege.setPrivilegeScope(scope.name());
        tSentryPrivilege.setAction("*");
        return tSentryPrivilege;
    }

    public static String toNULLCol(String s) {
        return Strings.isNullOrEmpty((String)s) ? NULL_COL : s;
    }

    private static String fromNULLCol(String s) {
        return SentryStore.isNULL(s) ? "" : s;
    }

    public static boolean isNULL(String s) {
        return Strings.isNullOrEmpty((String)s) || s.equals(NULL_COL);
    }

    private void grantOptionCheck(PersistenceManager pm, String grantorPrincipal, TSentryPrivilege privilege) throws SentryUserException {
        MSentryPrivilege mPrivilege = this.convertToMSentryPrivilege(privilege);
        if (grantorPrincipal == null) {
            throw new SentryInvalidInputException("grantorPrincipal should not be null");
        }
        Set<String> groups = SentryPolicyStoreProcessor.getGroupsFromUserName(this.conf, grantorPrincipal);
        Set<String> admins = this.getAdminGroups();
        boolean isAdminGroup = false;
        if (groups != null && !admins.isEmpty()) {
            for (String g : groups) {
                if (!admins.contains(g)) continue;
                isAdminGroup = true;
                break;
            }
        }
        if (!isAdminGroup) {
            boolean hasGrant = false;
            Set<MSentryRole> roles = this.getRolesForGroups(pm, groups);
            roles.addAll(this.getRolesForUsers(pm, Sets.newHashSet((Object[])new String[]{grantorPrincipal})));
            block1: for (MSentryRole role : roles) {
                Set<MSentryPrivilege> privilegeSet = role.getPrivileges();
                if (privilegeSet == null || privilegeSet.isEmpty()) continue;
                for (MSentryPrivilege p : privilegeSet) {
                    if (!p.getGrantOption().booleanValue() || !p.implies(mPrivilege)) continue;
                    hasGrant = true;
                    continue block1;
                }
            }
            if (!hasGrant) {
                throw new SentryGrantDeniedException(grantorPrincipal + " has no grant!");
            }
        }
    }

    private Set<String> getAdminGroups() {
        return Sets.newHashSet((Object[])this.conf.getStrings("sentry.service.admin.group", new String[0]));
    }

    public PermissionsImage retrieveFullPermssionsImage() throws Exception {
        return this.tm.executeTransaction(new TransactionBlock<PermissionsImage>(){

            @Override
            public PermissionsImage execute(PersistenceManager pm) throws Exception {
                pm.setDetachAllOnCommit(false);
                long curChangeID = SentryStore.getLastProcessedChangeIDCore(pm, MSentryPermChange.class);
                Map roleImage = SentryStore.this.retrieveFullRoleImageCore(pm);
                Map privilegeMap = SentryStore.this.retrieveFullPrivilegeImageCore(pm);
                return new PermissionsImage(roleImage, privilegeMap, curChangeID);
            }
        });
    }

    private Map<String, Map<String, String>> retrieveFullPrivilegeImageCore(PersistenceManager pm) throws Exception {
        pm.setDetachAllOnCommit(false);
        HashMap<String, Map<String, String>> retVal = new HashMap<String, Map<String, String>>();
        Query query = pm.newQuery(MSentryPrivilege.class);
        query.addExtension(LOAD_RESULTS_AT_COMMIT, (Object)"false");
        QueryParamBuilder paramBuilder = QueryParamBuilder.newQueryParamBuilder();
        paramBuilder.addNotNull(SERVER_NAME).addNotNull(DB_NAME).addNull(URI);
        query.setFilter(paramBuilder.toString());
        query.setOrdering("serverName ascending, dbName ascending, tableName ascending");
        List privileges = (List)query.executeWithMap(paramBuilder.getArguments());
        for (MSentryPrivilege mPriv : privileges) {
            HashMap<String, String> pUpdate;
            String authzObj = mPriv.getDbName();
            if (!SentryStore.isNULL(mPriv.getTableName())) {
                authzObj = authzObj + "." + mPriv.getTableName();
            }
            if ((pUpdate = (HashMap<String, String>)retVal.get(authzObj)) == null) {
                pUpdate = new HashMap<String, String>();
                retVal.put(authzObj, pUpdate);
            }
            for (MSentryRole mRole : mPriv.getRoles()) {
                String existingPriv = (String)pUpdate.get(mRole.getRoleName());
                if (existingPriv == null) {
                    pUpdate.put(mRole.getRoleName(), mPriv.getAction().toUpperCase());
                    continue;
                }
                pUpdate.put(mRole.getRoleName(), existingPriv + "," + mPriv.getAction().toUpperCase());
            }
        }
        query.closeAll();
        return retVal;
    }

    private Map<String, List<String>> retrieveFullRoleImageCore(PersistenceManager pm) throws Exception {
        pm.setDetachAllOnCommit(false);
        Query query = pm.newQuery(MSentryGroup.class);
        query.addExtension(LOAD_RESULTS_AT_COMMIT, (Object)"false");
        List groups = (List)query.execute();
        if (groups.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, List<String>> retVal = new HashMap<String, List<String>>();
        for (MSentryGroup mGroup : groups) {
            for (MSentryRole role : mGroup.getRoles()) {
                ArrayList<String> rUpdate = (ArrayList<String>)retVal.get(role.getRoleName());
                if (rUpdate == null) {
                    rUpdate = new ArrayList<String>();
                    retVal.put(role.getRoleName(), rUpdate);
                }
                rUpdate.add(mGroup.getGroupName());
            }
        }
        query.closeAll();
        return retVal;
    }

    public PathsImage retrieveFullPathsImage() throws Exception {
        return (PathsImage)this.tm.executeTransaction(new TransactionBlock(){

            public Object execute(PersistenceManager pm) throws Exception {
                pm.setDetachAllOnCommit(false);
                long curChangeID = SentryStore.getLastProcessedChangeIDCore(pm, MSentryPathChange.class);
                long curImageID = SentryStore.getCurrentAuthzPathsSnapshotID(pm);
                Map pathImage = SentryStore.this.retrieveFullPathsImageCore(pm, curImageID);
                return new PathsImage(pathImage, curChangeID, curImageID);
            }
        });
    }

    public PathsUpdate retrieveFullPathsImageUpdate(final String[] prefixes) throws Exception {
        return this.tm.executeTransaction(new TransactionBlock<PathsUpdate>(){

            @Override
            public PathsUpdate execute(PersistenceManager pm) throws Exception {
                pm.setDetachAllOnCommit(false);
                long curImageID = SentryStore.getCurrentAuthzPathsSnapshotID(pm);
                long curChangeID = SentryStore.getLastProcessedChangeIDCore(pm, MSentryPathChange.class);
                PathsUpdate pathUpdate = new PathsUpdate(curChangeID, curImageID, true);
                UpdateableAuthzPaths authzPaths = new UpdateableAuthzPaths(prefixes);
                SentryStore.this.retrieveFullPathsImageCore(pm, curImageID, authzPaths);
                pathUpdate.toThrift().setPathsDump(authzPaths.getPathsDump().createPathsDump(true));
                return pathUpdate;
            }
        });
    }

    private Map<String, Collection<String>> retrieveFullPathsImageCore(PersistenceManager pm, long currentSnapshotID) {
        if (currentSnapshotID <= 0L) {
            return Collections.emptyMap();
        }
        Query query = pm.newQuery(MAuthzPathsMapping.class);
        query.setFilter("this.authzSnapshotID == currentSnapshotID");
        query.declareParameters("long currentSnapshotID");
        Collection authzToPathsMappings = (Collection)query.execute((Object)currentSnapshotID);
        if (authzToPathsMappings.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, Collection<String>> retVal = new HashMap<String, Collection<String>>(authzToPathsMappings.size());
        for (MAuthzPathsMapping authzToPaths : authzToPathsMappings) {
            retVal.put(authzToPaths.getAuthzObjName(), authzToPaths.getPathStrings());
        }
        return retVal;
    }

    private void retrieveFullPathsImageCore(PersistenceManager pm, long currentSnapshotID, UpdateableAuthzPaths pathUpdate) {
        Query query = pm.newQuery(MAuthzPathsMapping.class);
        query.addExtension(LOAD_RESULTS_AT_COMMIT, (Object)"false");
        query.setFilter("this.authzSnapshotID == currentSnapshotID");
        query.declareParameters("long currentSnapshotID");
        Collection authzToPathsMappings = (Collection)query.execute((Object)currentSnapshotID);
        for (MAuthzPathsMapping authzToPaths : authzToPathsMappings) {
            String objName = authzToPaths.getAuthzObjName();
            for (String path : authzToPaths.getPathStrings()) {
                String[] pathComponents = PathUtils.splitPath((String)path);
                ArrayList paths = new ArrayList(pathComponents.length);
                Collections.addAll(paths, pathComponents);
                pathUpdate.applyAddChanges(objName, Collections.singletonList(paths));
            }
        }
    }

    private void deleteNotificationsSince(PersistenceManager pm, long id) {
        Query query = pm.newQuery(MSentryHmsNotification.class);
        query.addExtension(LOAD_RESULTS_AT_COMMIT, (Object)"false");
        query.setFilter("notificationId >= currentNotificationId");
        query.declareParameters("long currentNotificationId");
        long numDeleted = query.deletePersistentAll(new Object[]{id});
        if (numDeleted > 0L) {
            LOGGER.info("Purged {} notification entries starting from {}", (Object)numDeleted, (Object)id);
        }
    }

    public void persistFullPathsImage(final Map<String, Collection<String>> authzPaths, final long notificationID) throws Exception {
        this.tm.executeTransactionWithRetry(new TransactionBlock(){

            public Object execute(PersistenceManager pm) throws Exception {
                pm.setDetachAllOnCommit(false);
                SentryStore.this.deleteNotificationsSince(pm, notificationID + 1L);
                pm.makePersistent((Object)new MSentryHmsNotification(notificationID));
                long snapshotID = SentryStore.getCurrentAuthzPathsSnapshotID(pm);
                long nextSnapshotID = snapshotID + 1L;
                pm.makePersistent((Object)new MAuthzPathsSnapshotId(nextSnapshotID));
                for (Map.Entry authzPath : authzPaths.entrySet()) {
                    pm.makePersistent((Object)new MAuthzPathsMapping(nextSnapshotID, (String)authzPath.getKey(), (Collection)authzPath.getValue()));
                }
                return null;
            }
        });
    }

    private static long getCurrentAuthzPathsSnapshotID(PersistenceManager pm) {
        return SentryStore.getMaxPersistedIDCore(pm, MAuthzPathsSnapshotId.class, "authzSnapshotID", 0L);
    }

    private long getCurrentAuthzPathsSnapshotID() throws Exception {
        return this.tm.executeTransaction(new TransactionBlock<Long>(){

            @Override
            public Long execute(PersistenceManager pm) throws Exception {
                return SentryStore.getCurrentAuthzPathsSnapshotID(pm);
            }
        });
    }

    public void addAuthzPathsMapping(final String authzObj, final Collection<String> paths, UniquePathsUpdate update) throws Exception {
        this.execute((Updateable.Update)update, new TransactionBlock<Object>(){

            @Override
            public Object execute(PersistenceManager pm) throws Exception {
                pm.setDetachAllOnCommit(false);
                SentryStore.this.addAuthzPathsMappingCore(pm, authzObj, paths);
                return null;
            }
        });
    }

    private void addAuthzPathsMappingCore(PersistenceManager pm, String authzObj, Collection<String> paths) {
        MAuthzPathsMapping mAuthzPathsMapping;
        long currentSnapshotID = SentryStore.getCurrentAuthzPathsSnapshotID(pm);
        if (currentSnapshotID <= 0L) {
            LOGGER.error("AuthzObj: {} cannot be persisted if an paths snapshot ID does not exist yet.");
        }
        if ((mAuthzPathsMapping = this.getMAuthzPathsMappingCore(pm, currentSnapshotID, authzObj)) == null) {
            mAuthzPathsMapping = new MAuthzPathsMapping(currentSnapshotID, authzObj, paths);
        } else {
            for (String path : paths) {
                mAuthzPathsMapping.addPath(new MPath(path));
            }
        }
        pm.makePersistent((Object)mAuthzPathsMapping);
    }

    public void deleteAuthzPathsMapping(final String authzObj, final Iterable<String> paths, UniquePathsUpdate update) throws Exception {
        this.execute((Updateable.Update)update, new TransactionBlock<Object>(){

            @Override
            public Object execute(PersistenceManager pm) throws Exception {
                pm.setDetachAllOnCommit(false);
                SentryStore.this.deleteAuthzPathsMappingCore(pm, authzObj, paths);
                return null;
            }
        });
    }

    private void deleteAuthzPathsMappingCore(PersistenceManager pm, String authzObj, Iterable<String> paths) {
        MAuthzPathsMapping mAuthzPathsMapping;
        long currentSnapshotID = SentryStore.getCurrentAuthzPathsSnapshotID(pm);
        if (currentSnapshotID <= 0L) {
            LOGGER.error("No paths snapshot ID is found. Cannot delete authzoObj: {}", (Object)authzObj);
        }
        if ((mAuthzPathsMapping = this.getMAuthzPathsMappingCore(pm, currentSnapshotID, authzObj)) != null) {
            for (String path : paths) {
                MPath mPath = mAuthzPathsMapping.getPath(path);
                if (mPath == null) {
                    LOGGER.error("nonexistent path: {}", (Object)path);
                    continue;
                }
                mAuthzPathsMapping.removePath(mPath);
                pm.deletePersistent((Object)mPath);
            }
            pm.makePersistent((Object)mAuthzPathsMapping);
        } else {
            LOGGER.error("nonexistent authzObj: {} on current paths snapshot ID #{}", (Object)authzObj, (Object)currentSnapshotID);
        }
    }

    public void deleteAllAuthzPathsMapping(final String authzObj, UniquePathsUpdate update) throws Exception {
        this.execute((Updateable.Update)update, new TransactionBlock<Object>(){

            @Override
            public Object execute(PersistenceManager pm) throws Exception {
                pm.setDetachAllOnCommit(false);
                SentryStore.this.deleteAllAuthzPathsMappingCore(pm, authzObj);
                return null;
            }
        });
    }

    private void deleteAllAuthzPathsMappingCore(PersistenceManager pm, String authzObj) {
        MAuthzPathsMapping mAuthzPathsMapping;
        long currentSnapshotID = SentryStore.getCurrentAuthzPathsSnapshotID(pm);
        if (currentSnapshotID <= 0L) {
            LOGGER.error("No paths snapshot ID is found. Cannot delete authzoObj: {}", (Object)authzObj);
        }
        if ((mAuthzPathsMapping = this.getMAuthzPathsMappingCore(pm, currentSnapshotID, authzObj)) != null) {
            for (MPath mPath : mAuthzPathsMapping.getPaths()) {
                mAuthzPathsMapping.removePath(mPath);
                pm.deletePersistent((Object)mPath);
            }
            pm.deletePersistent((Object)mAuthzPathsMapping);
        } else {
            LOGGER.error("nonexistent authzObj: {} on current paths snapshot ID #{}", (Object)authzObj, (Object)currentSnapshotID);
        }
    }

    public void renameAuthzPathsMapping(final String oldObj, final String newObj, final String oldPath, final String newPath, UniquePathsUpdate update) throws Exception {
        this.execute((Updateable.Update)update, new TransactionBlock<Object>(){

            @Override
            public Object execute(PersistenceManager pm) throws Exception {
                pm.setDetachAllOnCommit(false);
                SentryStore.this.renameAuthzPathsMappingCore(pm, oldObj, newObj, oldPath, newPath);
                return null;
            }
        });
    }

    private void renameAuthzPathsMappingCore(PersistenceManager pm, String oldObj, String newObj, String oldPath, String newPath) {
        MAuthzPathsMapping mAuthzPathsMapping;
        long currentSnapshotID = SentryStore.getCurrentAuthzPathsSnapshotID(pm);
        if (currentSnapshotID <= 0L) {
            LOGGER.error("No paths snapshot ID is found. Cannot rename authzoObj: {}", (Object)oldObj);
        }
        if ((mAuthzPathsMapping = this.getMAuthzPathsMappingCore(pm, currentSnapshotID, oldObj)) != null) {
            MPath mOldPath = mAuthzPathsMapping.getPath(oldPath);
            if (mOldPath == null) {
                LOGGER.error("nonexistent path: {}", (Object)oldPath);
            } else {
                mAuthzPathsMapping.removePath(mOldPath);
                pm.deletePersistent((Object)mOldPath);
            }
            mAuthzPathsMapping.addPath(new MPath(newPath));
            mAuthzPathsMapping.setAuthzObjName(newObj);
            pm.makePersistent((Object)mAuthzPathsMapping);
        } else {
            LOGGER.error("nonexistent authzObj: {} on current paths snapshot ID #{}", (Object)oldObj, (Object)currentSnapshotID);
        }
    }

    public void renameAuthzObj(final String oldObj, final String newObj, UniquePathsUpdate update) throws Exception {
        this.execute((Updateable.Update)update, new TransactionBlock<Object>(){

            @Override
            public Object execute(PersistenceManager pm) throws Exception {
                pm.setDetachAllOnCommit(false);
                SentryStore.this.renameAuthzObjCore(pm, oldObj, newObj);
                return null;
            }
        });
    }

    private void renameAuthzObjCore(PersistenceManager pm, String oldObj, String newObj) {
        MAuthzPathsMapping mAuthzPathsMapping;
        long currentSnapshotID = SentryStore.getCurrentAuthzPathsSnapshotID(pm);
        if (currentSnapshotID <= 0L) {
            LOGGER.error("No paths snapshot ID is found. Cannot rename authzoObj: {}", (Object)oldObj);
        }
        if ((mAuthzPathsMapping = this.getMAuthzPathsMappingCore(pm, currentSnapshotID, oldObj)) != null) {
            mAuthzPathsMapping.setAuthzObjName(newObj);
            pm.makePersistent((Object)mAuthzPathsMapping);
        } else {
            LOGGER.error("nonexistent authzObj: {} on current paths snapshot ID #{}", (Object)oldObj, (Object)currentSnapshotID);
        }
    }

    public boolean isAuthzPathsMappingEmpty() throws Exception {
        return this.tm.executeTransactionWithRetry(new TransactionBlock<Boolean>(){

            @Override
            public Boolean execute(PersistenceManager pm) throws Exception {
                pm.setDetachAllOnCommit(false);
                return SentryStore.this.isTableEmptyCore(pm, MAuthzPathsMapping.class);
            }
        });
    }

    public boolean isHmsNotificationEmpty() throws Exception {
        return this.tm.executeTransactionWithRetry(new TransactionBlock<Boolean>(){

            @Override
            public Boolean execute(PersistenceManager pm) throws Exception {
                pm.setDetachAllOnCommit(false);
                return SentryStore.this.isTableEmptyCore(pm, MSentryHmsNotification.class);
            }
        });
    }

    public boolean isAuthzPathsSnapshotEmpty() throws Exception {
        return this.tm.executeTransactionWithRetry(new TransactionBlock<Boolean>(){

            @Override
            public Boolean execute(PersistenceManager pm) throws Exception {
                pm.setDetachAllOnCommit(false);
                return SentryStore.this.isTableEmptyCore(pm, MAuthzPathsSnapshotId.class);
            }
        });
    }

    public void updateAuthzPathsMapping(final String authzObj, final String oldPath, final String newPath, UniquePathsUpdate update) throws Exception {
        this.execute((Updateable.Update)update, new TransactionBlock<Object>(){

            @Override
            public Object execute(PersistenceManager pm) throws Exception {
                pm.setDetachAllOnCommit(false);
                SentryStore.this.updateAuthzPathsMappingCore(pm, authzObj, oldPath, newPath);
                return null;
            }
        });
    }

    private void updateAuthzPathsMappingCore(PersistenceManager pm, String authzObj, String oldPath, String newPath) {
        MAuthzPathsMapping mAuthzPathsMapping;
        long currentSnapshotID = SentryStore.getCurrentAuthzPathsSnapshotID(pm);
        if (currentSnapshotID <= 0L) {
            LOGGER.error("No paths snapshot ID is found. Cannot update authzoObj: {}", (Object)authzObj);
        }
        if ((mAuthzPathsMapping = this.getMAuthzPathsMappingCore(pm, currentSnapshotID, authzObj)) == null) {
            mAuthzPathsMapping = new MAuthzPathsMapping(currentSnapshotID, authzObj, Sets.newHashSet((Object[])new String[]{newPath}));
        } else {
            MPath mOldPath = mAuthzPathsMapping.getPath(oldPath);
            if (mOldPath == null) {
                LOGGER.error("nonexistent path: {}", (Object)oldPath);
            } else {
                mAuthzPathsMapping.removePath(mOldPath);
                pm.deletePersistent((Object)mOldPath);
            }
            MPath mNewPath = new MPath(newPath);
            mAuthzPathsMapping.addPath(mNewPath);
        }
        pm.makePersistent((Object)mAuthzPathsMapping);
    }

    private MAuthzPathsMapping getMAuthzPathsMappingCore(PersistenceManager pm, long authzSnapshotID, String authzObj) {
        Query query = pm.newQuery(MAuthzPathsMapping.class);
        query.setFilter("this.authzSnapshotID == authzSnapshotID && this.authzObjName == authzObjName");
        query.declareParameters("long authzSnapshotID, java.lang.String authzObjName");
        query.setUnique(true);
        return (MAuthzPathsMapping)query.execute((Object)authzSnapshotID, (Object)authzObj);
    }

    private boolean isTableEmptyCore(PersistenceManager pm, Class clazz) {
        Query query = pm.newQuery(clazz);
        query.addExtension(LOAD_RESULTS_AT_COMMIT, (Object)"false");
        query.setRange(0L, 1L);
        return ((List)query.execute()).isEmpty();
    }

    private static long getMaxPersistedIDCore(PersistenceManager pm, Class clazz, String columnName, long defaultValue) {
        Query query = pm.newQuery(clazz);
        query.addExtension(LOAD_RESULTS_AT_COMMIT, (Object)"false");
        query.setResult(String.format("max(%s)", columnName));
        Long maxValue = (Long)query.execute();
        return maxValue != null ? maxValue : defaultValue;
    }

    @VisibleForTesting
    List<MPath> getMPaths() throws Exception {
        return this.tm.executeTransaction(new TransactionBlock<List<MPath>>(){

            @Override
            public List<MPath> execute(PersistenceManager pm) throws Exception {
                long currentSnapshotID = SentryStore.getCurrentAuthzPathsSnapshotID(pm);
                Query query = pm.newQuery("SQL", (Object)"SELECT p.PATH_NAME FROM AUTHZ_PATH p JOIN AUTHZ_PATHS_MAPPING a ON a.AUTHZ_OBJ_ID = p.AUTHZ_OBJ_ID WHERE a.AUTHZ_SNAPSHOT_ID = ?");
                query.setResultClass(MPath.class);
                return (List)query.execute((Object)currentSnapshotID);
            }
        });
    }

    @VisibleForTesting
    Boolean findOrphanedPrivileges() throws Exception {
        return this.tm.executeTransaction(new TransactionBlock<Boolean>(){

            @Override
            public Boolean execute(PersistenceManager pm) throws Exception {
                return SentryStore.this.findOrphanedPrivilegesCore(pm);
            }
        });
    }

    Boolean findOrphanedPrivilegesCore(PersistenceManager pm) {
        List<MSentryPrivilege> results = this.getAllMSentryPrivilegesCore(pm);
        ArrayList<Object> idList = new ArrayList<Object>(results.size());
        for (MSentryPrivilege mSentryPrivilege : results) {
            idList.add(pm.getObjectId((Object)mSentryPrivilege));
        }
        if (idList.isEmpty()) {
            return false;
        }
        pm.refreshAll();
        for (MSentryPrivilege mSentryPrivilege : idList) {
            MSentryPrivilege priv = (MSentryPrivilege)pm.getObjectById((Object)mSentryPrivilege);
            if (!priv.getRoles().isEmpty()) continue;
            return true;
        }
        return false;
    }

    public List<Map<String, Set<String>>> getGroupUserRoleMapList(final Collection<String> roleNames) throws Exception {
        return this.tm.executeTransaction(new TransactionBlock<List<Map<String, Set<String>>>>(){

            @Override
            public List<Map<String, Set<String>>> execute(PersistenceManager pm) throws Exception {
                List mSentryRoles;
                pm.setDetachAllOnCommit(false);
                Query query = pm.newQuery(MSentryRole.class);
                query.addExtension(SentryStore.LOAD_RESULTS_AT_COMMIT, (Object)"false");
                if (roleNames == null || roleNames.isEmpty()) {
                    mSentryRoles = (List)query.execute();
                } else {
                    QueryParamBuilder paramBuilder = QueryParamBuilder.newQueryParamBuilder(QueryParamBuilder.Op.OR);
                    paramBuilder.addSet("roleName == ", roleNames);
                    query.setFilter(paramBuilder.toString());
                    mSentryRoles = (List)query.executeWithMap(paramBuilder.getArguments());
                }
                Map groupRolesMap = SentryStore.this.getGroupRolesMap(mSentryRoles);
                Map userRolesMap = SentryStore.this.getUserRolesMap(mSentryRoles);
                ArrayList<Map<String, Set<String>>> mapsList = new ArrayList<Map<String, Set<String>>>();
                mapsList.add(0, groupRolesMap);
                mapsList.add(1, userRolesMap);
                return mapsList;
            }
        });
    }

    private Map<String, Set<String>> getGroupRolesMap(Collection<MSentryRole> mSentryRoles) {
        if (mSentryRoles.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, Set<String>> groupRolesMap = new HashMap<String, Set<String>>();
        for (MSentryRole mSentryRole : mSentryRoles) {
            Set<MSentryGroup> groups = mSentryRole.getGroups();
            for (MSentryGroup group : groups) {
                String groupName = group.getGroupName();
                HashSet<String> rNames = (HashSet<String>)groupRolesMap.get(groupName);
                if (rNames == null) {
                    rNames = new HashSet<String>();
                }
                rNames.add(mSentryRole.getRoleName());
                groupRolesMap.put(groupName, rNames);
            }
        }
        return groupRolesMap;
    }

    private Map<String, Set<String>> getUserRolesMap(Collection<MSentryRole> mSentryRoles) {
        if (mSentryRoles.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, Set<String>> userRolesMap = new HashMap<String, Set<String>>();
        for (MSentryRole mSentryRole : mSentryRoles) {
            Set<MSentryUser> users = mSentryRole.getUsers();
            for (MSentryUser user : users) {
                String userName = user.getUserName();
                HashSet<String> rNames = (HashSet<String>)userRolesMap.get(userName);
                if (rNames == null) {
                    rNames = new HashSet<String>();
                }
                rNames.add(mSentryRole.getRoleName());
                userRolesMap.put(userName, rNames);
            }
        }
        return userRolesMap;
    }

    Map<String, Set<TSentryPrivilege>> getRoleNameTPrivilegesMap() throws Exception {
        return this.getRoleNameTPrivilegesMap(null, null);
    }

    public Map<String, Set<TSentryPrivilege>> getRoleNameTPrivilegesMap(final String dbName, final String tableName) throws Exception {
        return this.tm.executeTransaction(new TransactionBlock<Map<String, Set<TSentryPrivilege>>>(){

            @Override
            public Map<String, Set<TSentryPrivilege>> execute(PersistenceManager pm) throws Exception {
                pm.setDetachAllOnCommit(false);
                Query query = pm.newQuery(MSentryPrivilege.class);
                query.addExtension(SentryStore.LOAD_RESULTS_AT_COMMIT, (Object)"false");
                QueryParamBuilder paramBuilder = QueryParamBuilder.newQueryParamBuilder();
                if (!StringUtils.isEmpty((String)dbName)) {
                    paramBuilder.add(SentryStore.DB_NAME, dbName);
                }
                if (!StringUtils.isEmpty((String)tableName)) {
                    paramBuilder.add(SentryStore.TABLE_NAME, tableName);
                }
                query.setFilter(paramBuilder.toString());
                List mSentryPrivileges = (List)query.executeWithMap(paramBuilder.getArguments());
                return SentryStore.this.getRolePrivilegesMap(mSentryPrivileges);
            }
        });
    }

    private Map<String, Set<TSentryPrivilege>> getRolePrivilegesMap(Collection<MSentryPrivilege> mSentryPrivileges) {
        if (mSentryPrivileges.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, Set<TSentryPrivilege>> rolePrivilegesMap = new HashMap<String, Set<TSentryPrivilege>>();
        for (MSentryPrivilege mSentryPrivilege : mSentryPrivileges) {
            TSentryPrivilege privilege = this.convertToTSentryPrivilege(mSentryPrivilege);
            for (MSentryRole mSentryRole : mSentryPrivilege.getRoles()) {
                String roleName = mSentryRole.getRoleName();
                HashSet<TSentryPrivilege> privileges = (HashSet<TSentryPrivilege>)rolePrivilegesMap.get(roleName);
                if (privileges == null) {
                    privileges = new HashSet<TSentryPrivilege>();
                }
                privileges.add(privilege);
                rolePrivilegesMap.put(roleName, privileges);
            }
        }
        return rolePrivilegesMap;
    }

    public Set<String> getAllRoleNames() throws Exception {
        return this.tm.executeTransaction(new TransactionBlock<Set<String>>(){

            @Override
            public Set<String> execute(PersistenceManager pm) throws Exception {
                pm.setDetachAllOnCommit(false);
                return SentryStore.this.getAllRoleNamesCore(pm);
            }
        });
    }

    private Set<String> getAllRoleNamesCore(PersistenceManager pm) {
        List<MSentryRole> mSentryRoles = this.getAllRoles(pm);
        if (mSentryRoles.isEmpty()) {
            return Collections.emptySet();
        }
        return SentryStore.rolesToRoleNames(mSentryRoles);
    }

    private Map<String, MSentryGroup> getGroupNameTGroupMap(PersistenceManager pm) {
        Query query = pm.newQuery(MSentryGroup.class);
        List mSentryGroups = (List)query.execute();
        if (mSentryGroups.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, MSentryGroup> existGroupsMap = new HashMap<String, MSentryGroup>(mSentryGroups.size());
        for (MSentryGroup mSentryGroup : mSentryGroups) {
            existGroupsMap.put(mSentryGroup.getGroupName(), mSentryGroup);
        }
        return existGroupsMap;
    }

    private Map<String, MSentryUser> getUserNameToUserMap(PersistenceManager pm) {
        Query query = pm.newQuery(MSentryUser.class);
        List users = (List)query.execute();
        if (users.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, MSentryUser> existUsersMap = new HashMap<String, MSentryUser>(users.size());
        for (MSentryUser user : users) {
            existUsersMap.put(user.getUserName(), user);
        }
        return existUsersMap;
    }

    @VisibleForTesting
    Map<String, MSentryRole> getRolesMap() throws Exception {
        return this.tm.executeTransaction(new TransactionBlock<Map<String, MSentryRole>>(){

            @Override
            public Map<String, MSentryRole> execute(PersistenceManager pm) throws Exception {
                pm.setDetachAllOnCommit(false);
                List mSentryRoles = SentryStore.this.getAllRoles(pm);
                if (mSentryRoles.isEmpty()) {
                    return Collections.emptyMap();
                }
                HashMap<String, MSentryRole> existRolesMap = new HashMap<String, MSentryRole>(mSentryRoles.size());
                for (MSentryRole mSentryRole : mSentryRoles) {
                    existRolesMap.put(mSentryRole.getRoleName(), mSentryRole);
                }
                return existRolesMap;
            }
        });
    }

    @VisibleForTesting
    Map<String, MSentryGroup> getGroupNameToGroupMap() throws Exception {
        return this.tm.executeTransaction(new TransactionBlock<Map<String, MSentryGroup>>(){

            @Override
            public Map<String, MSentryGroup> execute(PersistenceManager pm) throws Exception {
                return SentryStore.this.getGroupNameTGroupMap(pm);
            }
        });
    }

    @VisibleForTesting
    Map<String, MSentryUser> getUserNameToUserMap() throws Exception {
        return this.tm.executeTransaction(new TransactionBlock<Map<String, MSentryUser>>(){

            @Override
            public Map<String, MSentryUser> execute(PersistenceManager pm) throws Exception {
                return SentryStore.this.getUserNameToUserMap(pm);
            }
        });
    }

    @VisibleForTesting
    List<MSentryPrivilege> getPrivilegesList() throws Exception {
        return this.tm.executeTransaction(new TransactionBlock<List<MSentryPrivilege>>(){

            @Override
            public List<MSentryPrivilege> execute(PersistenceManager pm) throws Exception {
                Query query = pm.newQuery(MSentryPrivilege.class);
                return (List)query.execute();
            }
        });
    }

    public void importSentryMetaData(final TSentryMappingData tSentryMappingData, final boolean isOverwriteForRole) throws Exception {
        this.tm.executeTransaction(new TransactionBlock<Object>(){

            @Override
            public Object execute(PersistenceManager pm) throws Exception {
                pm.setDetachAllOnCommit(false);
                TSentryMappingData mappingData = SentryStore.this.lowercaseRoleName(tSentryMappingData);
                Set roleNames = SentryStore.this.getAllRoleNamesCore(pm);
                Map importedRoleGroupsMap = SentryStore.this.covertToRoleNameTGroupsMap(mappingData.getGroupRolesMap());
                Map importedRoleUsersMap = SentryStore.this.covertToRoleUsersMap(mappingData.getUserRolesMap());
                Set importedRoleNames = importedRoleGroupsMap.keySet();
                if (isOverwriteForRole) {
                    SentryStore.this.dropDuplicatedRoleForImport(pm, roleNames, importedRoleNames);
                    roleNames = SentryStore.this.getAllRoleNamesCore(pm);
                }
                if (roleNames.isEmpty()) {
                    roleNames = new HashSet();
                }
                SentryStore.this.importRolePrivilegeMapping(pm, roleNames, mappingData.getRolePrivilegesMap());
                SentryStore.this.importRoleGroupMapping(pm, roleNames, importedRoleGroupsMap);
                SentryStore.this.importRoleUserMapping(pm, roleNames, importedRoleUsersMap);
                return null;
            }
        });
    }

    private Map<String, Set<TSentryGroup>> covertToRoleNameTGroupsMap(Map<String, Set<String>> groupRolesMap) {
        if (groupRolesMap == null || groupRolesMap.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap roleGroupsMap = Maps.newHashMap();
        for (Map.Entry<String, Set<String>> entry : groupRolesMap.entrySet()) {
            Set<String> roleNames = entry.getValue();
            if (roleNames == null) continue;
            for (String roleName : roleNames) {
                HashSet<TSentryGroup> tSentryGroups = (HashSet<TSentryGroup>)roleGroupsMap.get(roleName);
                if (tSentryGroups == null) {
                    tSentryGroups = new HashSet<TSentryGroup>();
                }
                tSentryGroups.add(new TSentryGroup(entry.getKey()));
                roleGroupsMap.put(roleName, tSentryGroups);
            }
        }
        return roleGroupsMap;
    }

    private Map<String, Set<String>> covertToRoleUsersMap(Map<String, Set<String>> userRolesMap) {
        if (userRolesMap == null || userRolesMap.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, Set<String>> roleUsersMap = new HashMap<String, Set<String>>();
        for (Map.Entry<String, Set<String>> entry : userRolesMap.entrySet()) {
            Set<String> roleNames = entry.getValue();
            if (roleNames == null) continue;
            for (String roleName : roleNames) {
                HashSet<String> users = (HashSet<String>)roleUsersMap.get(roleName);
                if (users == null) {
                    users = new HashSet<String>();
                }
                users.add(entry.getKey());
                roleUsersMap.put(roleName, users);
            }
        }
        return roleUsersMap;
    }

    private void importRoleGroupMapping(PersistenceManager pm, Set<String> existRoleNames, Map<String, Set<TSentryGroup>> importedRoleGroupsMap) throws Exception {
        if (importedRoleGroupsMap == null || importedRoleGroupsMap.keySet() == null) {
            return;
        }
        for (Map.Entry<String, Set<TSentryGroup>> entry : importedRoleGroupsMap.entrySet()) {
            this.createRoleIfNotExist(pm, existRoleNames, entry.getKey());
            this.alterSentryRoleAddGroupsCore(pm, entry.getKey(), entry.getValue());
        }
    }

    private void importRoleUserMapping(PersistenceManager pm, Set<String> existRoleNames, Map<String, Set<String>> importedRoleUsersMap) throws Exception {
        if (importedRoleUsersMap == null || importedRoleUsersMap.keySet() == null) {
            return;
        }
        for (Map.Entry<String, Set<String>> entry : importedRoleUsersMap.entrySet()) {
            this.createRoleIfNotExist(pm, existRoleNames, entry.getKey());
            this.alterSentryRoleAddUsersCore(pm, entry.getKey(), entry.getValue());
        }
    }

    private void dropDuplicatedRoleForImport(PersistenceManager pm, Set<String> existRoleNames, Set<String> importedRoleNames) throws Exception {
        Sets.SetView duplicatedRoleNames = Sets.intersection(existRoleNames, importedRoleNames);
        for (String droppedRoleName : duplicatedRoleNames) {
            this.dropSentryRoleCore(pm, droppedRoleName);
        }
    }

    private TSentryMappingData lowercaseRoleName(TSentryMappingData tSentryMappingData) {
        Map<String, Set<String>> sentryGroupRolesMap = tSentryMappingData.getGroupRolesMap();
        Map<String, Set<TSentryPrivilege>> sentryRolePrivilegesMap = tSentryMappingData.getRolePrivilegesMap();
        HashMap<String, Set<String>> newSentryGroupRolesMap = new HashMap<String, Set<String>>();
        HashMap<String, Set<TSentryPrivilege>> newSentryRolePrivilegesMap = new HashMap<String, Set<TSentryPrivilege>>();
        for (Map.Entry<String, Set<String>> entry : sentryGroupRolesMap.entrySet()) {
            Collection lowcaseRoles = Collections2.transform((Collection)entry.getValue(), (Function)new Function<String, String>(){

                public String apply(String input) {
                    return input.toLowerCase();
                }
            });
            newSentryGroupRolesMap.put(entry.getKey(), new HashSet(lowcaseRoles));
        }
        for (Map.Entry<String, Set<Object>> entry : sentryRolePrivilegesMap.entrySet()) {
            newSentryRolePrivilegesMap.put(entry.getKey().toLowerCase(), entry.getValue());
        }
        tSentryMappingData.setGroupRolesMap(newSentryGroupRolesMap);
        tSentryMappingData.setRolePrivilegesMap(newSentryRolePrivilegesMap);
        return tSentryMappingData;
    }

    private void importRolePrivilegeMapping(PersistenceManager pm, Set<String> existRoleNames, Map<String, Set<TSentryPrivilege>> sentryRolePrivilegesMap) throws Exception {
        if (sentryRolePrivilegesMap != null) {
            for (Map.Entry<String, Set<TSentryPrivilege>> entry : sentryRolePrivilegesMap.entrySet()) {
                this.createRoleIfNotExist(pm, existRoleNames, entry.getKey());
                Set<TSentryPrivilege> tSentryPrivileges = entry.getValue();
                for (TSentryPrivilege tSentryPrivilege : tSentryPrivileges) {
                    this.alterSentryRoleGrantPrivilegeCore(pm, entry.getKey(), tSentryPrivilege);
                }
            }
        }
    }

    private void createRoleIfNotExist(PersistenceManager pm, Set<String> existRoleNames, String roleName) throws Exception {
        String lowerRoleName = this.trimAndLower(roleName);
        if (!existRoleNames.contains(lowerRoleName)) {
            existRoleNames.add(lowerRoleName);
            pm.makePersistent((Object)new MSentryRole(this.trimAndLower(roleName)));
        }
    }

    public static Set<String> rolesToRoleNames(Iterable<MSentryRole> roles) {
        HashSet<String> roleNames = new HashSet<String>();
        for (MSentryRole mSentryRole : roles) {
            roleNames.add(mSentryRole.getRoleName());
        }
        return roleNames;
    }

    private static SentryNoSuchObjectException noSuchRole(String roleName) {
        return new SentryNoSuchObjectException("Role " + roleName);
    }

    private static SentryNoSuchObjectException noSuchGroup(String groupName) {
        return new SentryNoSuchObjectException("Group " + groupName);
    }

    private SentryNoSuchObjectException noSuchUpdate(long changeID) {
        return new SentryNoSuchObjectException("nonexistent update + " + changeID);
    }

    static <T extends MSentryChange> Long getLastProcessedChangeIDCore(PersistenceManager pm, Class<T> changeCls) {
        return SentryStore.getMaxPersistedIDCore(pm, changeCls, "changeID", 0L);
    }

    static Long getLastProcessedNotificationIDCore(PersistenceManager pm) {
        return SentryStore.getMaxPersistedIDCore(pm, MSentryHmsNotification.class, "notificationId", 0L);
    }

    public void setLastProcessedNotificationID(final Long notificationId) throws Exception {
        LOGGER.debug("Persisting Last Processed Notification ID {}", (Object)notificationId);
        this.tm.executeTransaction(new TransactionBlock<Object>(){

            @Override
            public Object execute(PersistenceManager pm) throws Exception {
                SentryStore.this.deleteNotificationsSince(pm, notificationId + 1L);
                return pm.makePersistent((Object)new MSentryHmsNotification(notificationId));
            }
        });
    }

    public void persistLastProcessedNotificationID(final Long notificationId) throws Exception {
        LOGGER.debug("Persisting Last Processed Notification ID {}", (Object)notificationId);
        this.tm.executeTransaction(new TransactionBlock<Object>(){

            @Override
            public Object execute(PersistenceManager pm) throws Exception {
                return pm.makePersistent((Object)new MSentryHmsNotification(notificationId));
            }
        });
    }

    public Long getLastProcessedPermChangeID() throws Exception {
        return this.tm.executeTransaction(new TransactionBlock<Long>(){

            @Override
            public Long execute(PersistenceManager pm) throws Exception {
                pm.setDetachAllOnCommit(false);
                return SentryStore.getLastProcessedChangeIDCore(pm, MSentryPermChange.class);
            }
        });
    }

    public Long getLastProcessedPathChangeID() throws Exception {
        return this.tm.executeTransaction(new TransactionBlock<Long>(){

            @Override
            public Long execute(PersistenceManager pm) throws Exception {
                pm.setDetachAllOnCommit(false);
                return SentryStore.getLastProcessedChangeIDCore(pm, MSentryPathChange.class);
            }
        });
    }

    public Long getLastProcessedNotificationID() throws Exception {
        long notificationId = this.tm.executeTransaction(new TransactionBlock<Long>(){

            @Override
            public Long execute(PersistenceManager pm) throws Exception {
                long notificationId = SentryStore.getLastProcessedNotificationIDCore(pm);
                return notificationId;
            }
        });
        LOGGER.debug("Retrieving Last Processed Notification ID {}", (Object)notificationId);
        return notificationId;
    }

    public long getLastProcessedImageID() throws Exception {
        return this.tm.executeTransaction(new TransactionBlock<Long>(){

            @Override
            public Long execute(PersistenceManager pm) throws Exception {
                pm.setDetachAllOnCommit(false);
                return SentryStore.getCurrentAuthzPathsSnapshotID(pm);
            }
        });
    }

    public MSentryPermChange getMSentryPermChangeByID(final long changeID) throws Exception {
        return (MSentryPermChange)this.tm.executeTransaction(new TransactionBlock<Object>(){

            @Override
            public Object execute(PersistenceManager pm) throws Exception {
                Query query = pm.newQuery(MSentryPermChange.class);
                query.setFilter("this.changeID == id");
                query.declareParameters("long id");
                List permChanges = (List)query.execute((Object)changeID);
                if (permChanges == null) {
                    throw SentryStore.this.noSuchUpdate(changeID);
                }
                if (permChanges.size() > 1) {
                    throw new Exception("Inconsistent permission delta: " + permChanges.size() + " permissions for the same id, " + changeID);
                }
                return permChanges.get(0);
            }
        });
    }

    private <T extends MSentryChange> List<T> getMSentryChanges(final Class<T> cls) throws Exception {
        return (List)this.tm.executeTransaction(new TransactionBlock<List<T>>(){

            @Override
            public List<T> execute(PersistenceManager pm) throws Exception {
                Query query = pm.newQuery(cls);
                return (List)query.execute();
            }
        });
    }

    @VisibleForTesting
    List<MSentryPermChange> getMSentryPermChanges() throws Exception {
        return this.getMSentryChanges(MSentryPermChange.class);
    }

    @VisibleForTesting
    List<MSentryHmsNotification> getMSentryHmsNotificationCore() throws Exception {
        return this.tm.executeTransaction(new TransactionBlock<List<MSentryHmsNotification>>(){

            @Override
            public List<MSentryHmsNotification> execute(PersistenceManager pm) throws Exception {
                Query query = pm.newQuery(MSentryHmsNotification.class);
                return (List)query.execute();
            }
        });
    }

    private <T extends MSentryChange> Boolean changeExistsCore(PersistenceManager pm, Class<T> changeCls, long changeID) throws Exception {
        Query query = pm.newQuery(changeCls);
        query.addExtension(LOAD_RESULTS_AT_COMMIT, (Object)"false");
        query.setFilter("this.changeID == id");
        query.declareParameters("long id");
        List changes = (List)query.execute((Object)changeID);
        return !changes.isEmpty();
    }

    public Boolean permChangeExists(final long changeID) throws Exception {
        return this.tm.executeTransaction(new TransactionBlock<Boolean>(){

            @Override
            public Boolean execute(PersistenceManager pm) throws Exception {
                pm.setDetachAllOnCommit(false);
                return SentryStore.this.changeExistsCore(pm, MSentryPermChange.class, changeID);
            }
        });
    }

    public Boolean pathChangeExists(final long changeID) throws Exception {
        return this.tm.executeTransaction(new TransactionBlock<Boolean>(){

            @Override
            public Boolean execute(PersistenceManager pm) throws Exception {
                pm.setDetachAllOnCommit(false);
                return SentryStore.this.changeExistsCore(pm, MSentryPathChange.class, changeID);
            }
        });
    }

    public MSentryPathChange getMSentryPathChangeByID(final long changeID) throws Exception {
        return (MSentryPathChange)this.tm.executeTransaction(new TransactionBlock<Object>(){

            @Override
            public Object execute(PersistenceManager pm) throws Exception {
                Query query = pm.newQuery(MSentryPathChange.class);
                query.setFilter("this.changeID == id");
                query.declareParameters("long id");
                List pathChanges = (List)query.execute((Object)changeID);
                if (pathChanges == null) {
                    throw SentryStore.this.noSuchUpdate(changeID);
                }
                if (pathChanges.size() > 1) {
                    throw new Exception("Inconsistent path delta: " + pathChanges.size() + " paths for the same id, " + changeID);
                }
                return pathChanges.get(0);
            }
        });
    }

    @VisibleForTesting
    List<MSentryPathChange> getMSentryPathChanges() throws Exception {
        return this.getMSentryChanges(MSentryPathChange.class);
    }

    private <T extends MSentryChange> List<T> getMSentryChangesCore(PersistenceManager pm, Class<T> changeCls, long changeID) throws Exception {
        Query query = pm.newQuery(changeCls);
        query.setFilter("this.changeID >= t");
        query.declareParameters("long t");
        query.setOrdering("this.changeID ascending");
        return (List)query.execute((Object)changeID);
    }

    public List<MSentryPathChange> getMSentryPathChanges(final long changeID) throws Exception {
        return this.tm.executeTransaction(new TransactionBlock<List<MSentryPathChange>>(){

            @Override
            public List<MSentryPathChange> execute(PersistenceManager pm) throws Exception {
                List pathChanges = SentryStore.this.getMSentryChangesCore(pm, MSentryPathChange.class, changeID);
                if (SentryStore.this.validateDeltaChanges(changeID, pathChanges)) {
                    return pathChanges;
                }
                return Collections.emptyList();
            }
        });
    }

    public List<MSentryPermChange> getMSentryPermChanges(final long changeID) throws Exception {
        return this.tm.executeTransaction(new TransactionBlock<List<MSentryPermChange>>(){

            @Override
            public List<MSentryPermChange> execute(PersistenceManager pm) throws Exception {
                List permChanges = SentryStore.this.getMSentryChangesCore(pm, MSentryPermChange.class, changeID);
                if (SentryStore.this.validateDeltaChanges(changeID, permChanges)) {
                    return permChanges;
                }
                return Collections.emptyList();
            }
        });
    }

    public <T extends MSentryChange> boolean validateDeltaChanges(long changeID, List<T> changes) {
        if (changes.isEmpty()) {
            return true;
        }
        if (((MSentryChange)changes.get(0)).getChangeID() != changeID) {
            LOGGER.debug(String.format("Starting delta change from %s is off from the requested id. Requested changeID: %s, Missing delta count: %s", ((MSentryChange)changes.get(0)).getClass().getCanonicalName(), changeID, ((MSentryChange)changes.get(0)).getChangeID() - changeID));
            return false;
        }
        if (!MSentryUtil.isConsecutive(changes)) {
            String pathChangesIds = MSentryUtil.collapseChangeIDsToString(changes);
            LOGGER.error(String.format("Certain delta is missing in %s! The table may get corrupted. Start changeID %s, Current size of elements = %s. path changeID list: %s", ((MSentryChange)changes.get(0)).getClass().getCanonicalName(), changeID, changes.size(), pathChangesIds));
            return false;
        }
        return true;
    }

    private void execute(Updateable.Update update, TransactionBlock<Object> transactionBlock) throws Exception {
        ArrayList tbs = new ArrayList(2);
        if (this.persistUpdateDeltas) {
            tbs.add(new DeltaTransactionBlock(update));
        }
        tbs.add(transactionBlock);
        this.tm.executeTransactionBlocksWithRetry(tbs);
    }

    public boolean isNotificationProcessed(final String hash) throws Exception {
        return this.tm.executeTransactionWithRetry(new TransactionBlock<Boolean>(){

            @Override
            public Boolean execute(PersistenceManager pm) throws Exception {
                pm.setDetachAllOnCommit(false);
                Query query = pm.newQuery(MSentryPathChange.class);
                query.setFilter("this.notificationHash == hash");
                query.setUnique(true);
                query.declareParameters("java.lang.String hash");
                MSentryPathChange changes = (MSentryPathChange)query.execute((Object)hash);
                return changes != null;
            }
        });
    }
}

