/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.provider.db.service.persistent;

import com.google.common.base.Preconditions;
import javax.jdo.PersistenceManager;
import org.apache.sentry.core.common.exception.SentryInvalidInputException;
import org.apache.sentry.hdfs.PathsUpdate;
import org.apache.sentry.hdfs.PermissionsUpdate;
import org.apache.sentry.hdfs.UniquePathsUpdate;
import org.apache.sentry.hdfs.Updateable;
import org.apache.sentry.provider.db.service.model.MSentryHmsNotification;
import org.apache.sentry.provider.db.service.model.MSentryPathChange;
import org.apache.sentry.provider.db.service.model.MSentryPermChange;
import org.apache.sentry.provider.db.service.persistent.SentryStore;
import org.apache.sentry.provider.db.service.persistent.TransactionBlock;

public class DeltaTransactionBlock
implements TransactionBlock<Object> {
    private final Updateable.Update update;

    public DeltaTransactionBlock(Updateable.Update update) {
        this.update = update;
    }

    @Override
    public Object execute(PersistenceManager pm) throws Exception {
        this.persistUpdate(pm, this.update);
        return null;
    }

    private void persistUpdate(PersistenceManager pm, Updateable.Update update) throws Exception {
        pm.setDetachAllOnCommit(false);
        Preconditions.checkNotNull((Object)update);
        if (update.hasFullImage()) {
            throw new SentryInvalidInputException("Update should be not be a full image.\n");
        }
        if (update instanceof PermissionsUpdate) {
            long lastChangeID = SentryStore.getLastProcessedChangeIDCore(pm, MSentryPermChange.class);
            pm.makePersistent((Object)new MSentryPermChange(lastChangeID + 1L, (PermissionsUpdate)update));
        } else if (update instanceof UniquePathsUpdate) {
            long lastChangeID = SentryStore.getLastProcessedChangeIDCore(pm, MSentryPathChange.class);
            String eventHash = ((UniquePathsUpdate)update).getEventHash();
            pm.makePersistent((Object)new MSentryPathChange(lastChangeID + 1L, eventHash, (PathsUpdate)update));
            pm.makePersistent((Object)new MSentryHmsNotification(update.getSeqNum()));
        } else {
            throw new SentryInvalidInputException("Update should be type of either PermissionsUpdate or PathsUpdate.\n");
        }
    }
}

