/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.provider.db.service.model;

import java.util.BitSet;
import java.util.HashSet;
import java.util.Set;
import javax.jdo.JDODetachedFieldAccessException;
import javax.jdo.annotations.PersistenceCapable;
import org.apache.sentry.core.common.utils.PathUtils;
import org.apache.sentry.provider.db.service.model.MSentryRole;
import org.apache.sentry.provider.db.service.model.MSentryUtil;
import org.apache.sentry.provider.db.service.persistent.SentryStore;
import org.datanucleus.enhancement.Detachable;
import org.datanucleus.enhancement.ExecutionContextReference;
import org.datanucleus.enhancement.Persistable;
import org.datanucleus.enhancement.StateManager;
import org.datanucleus.enhancer.EnhancementHelper;

@PersistenceCapable
public class MSentryPrivilege
implements Detachable,
Persistable {
    private String privilegeScope;
    private String serverName = "";
    private String dbName = "";
    private String tableName = "";
    private String columnName = "";
    private String URI = "";
    private String action = "";
    private Boolean grantOption = false;
    private Set<MSentryRole> roles;
    private long createTime;
    protected transient StateManager dnStateManager;
    protected transient byte dnFlags;
    protected Object[] dnDetachedState;
    private static final byte[] dnFieldFlags;
    private static final Class dnPersistableSuperclass;
    private static final Class[] dnFieldTypes;
    private static final String[] dnFieldNames;
    private static final int dnInheritedFieldCount;

    public MSentryPrivilege() {
        this.roles = new HashSet<MSentryRole>();
    }

    public MSentryPrivilege(String privilegeScope, String serverName, String dbName, String tableName, String columnName, String URI2, String action, Boolean grantOption) {
        this.privilegeScope = MSentryUtil.safeIntern(privilegeScope);
        this.serverName = MSentryUtil.safeIntern(serverName);
        this.dbName = SentryStore.toNULLCol(dbName).intern();
        this.tableName = SentryStore.toNULLCol(tableName).intern();
        this.columnName = SentryStore.toNULLCol(columnName).intern();
        this.URI = SentryStore.toNULLCol(URI2).intern();
        this.action = SentryStore.toNULLCol(action).intern();
        this.grantOption = grantOption;
        this.roles = new HashSet<MSentryRole>();
    }

    public MSentryPrivilege(String privilegeScope, String serverName, String dbName, String tableName, String columnName, String URI2, String action) {
        this(privilegeScope, serverName, dbName, tableName, columnName, URI2, action, false);
    }

    public MSentryPrivilege(MSentryPrivilege other) {
        this.privilegeScope = other.privilegeScope;
        this.serverName = other.serverName;
        this.dbName = SentryStore.toNULLCol(other.dbName).intern();
        this.tableName = SentryStore.toNULLCol(other.tableName).intern();
        this.columnName = SentryStore.toNULLCol(other.columnName).intern();
        this.URI = SentryStore.toNULLCol(other.URI).intern();
        this.action = SentryStore.toNULLCol(other.action).intern();
        this.grantOption = other.grantOption;
        this.roles = new HashSet<MSentryRole>();
        this.roles.addAll(other.roles);
    }

    public String getServerName() {
        return MSentryPrivilege.dnGetserverName(this);
    }

    public void setServerName(String serverName) {
        MSentryPrivilege.dnSetserverName(this, serverName == null ? "" : serverName);
    }

    public String getDbName() {
        return MSentryPrivilege.dnGetdbName(this);
    }

    public void setDbName(String dbName) {
        MSentryPrivilege.dnSetdbName(this, dbName == null ? "" : dbName);
    }

    public String getTableName() {
        return MSentryPrivilege.dnGettableName(this);
    }

    public void setTableName(String tableName) {
        MSentryPrivilege.dnSettableName(this, tableName == null ? "" : tableName);
    }

    public String getColumnName() {
        return MSentryPrivilege.dnGetcolumnName(this);
    }

    public void setColumnName(String columnName) {
        MSentryPrivilege.dnSetcolumnName(this, columnName == null ? "" : columnName);
    }

    public String getURI() {
        return MSentryPrivilege.dnGetURI(this);
    }

    public void setURI(String uRI) {
        MSentryPrivilege.dnSetURI(this, uRI == null ? "" : uRI);
    }

    public String getAction() {
        return MSentryPrivilege.dnGetaction(this);
    }

    public void setAction(String action) {
        MSentryPrivilege.dnSetaction(this, action == null ? "" : action);
    }

    public long getCreateTime() {
        return MSentryPrivilege.dnGetcreateTime(this);
    }

    public void setCreateTime(long createTime) {
        MSentryPrivilege.dnSetcreateTime(this, createTime);
    }

    public String getPrivilegeScope() {
        return MSentryPrivilege.dnGetprivilegeScope(this);
    }

    public void setPrivilegeScope(String privilegeScope) {
        MSentryPrivilege.dnSetprivilegeScope(this, privilegeScope);
    }

    public Boolean getGrantOption() {
        return MSentryPrivilege.dnGetgrantOption(this);
    }

    public void setGrantOption(Boolean grantOption) {
        MSentryPrivilege.dnSetgrantOption(this, grantOption);
    }

    public void appendRole(MSentryRole role) {
        MSentryPrivilege.dnGetroles(this).add(role);
    }

    public Set<MSentryRole> getRoles() {
        return MSentryPrivilege.dnGetroles(this);
    }

    public void removeRole(MSentryRole role) {
        MSentryPrivilege.dnGetroles(this).remove(role);
        role.removePrivilege(this);
    }

    public String toString() {
        return "MSentryPrivilege [privilegeScope=" + MSentryPrivilege.dnGetprivilegeScope(this) + ", serverName=" + MSentryPrivilege.dnGetserverName(this) + ", dbName=" + MSentryPrivilege.dnGetdbName(this) + ", tableName=" + MSentryPrivilege.dnGettableName(this) + ", columnName=" + MSentryPrivilege.dnGetcolumnName(this) + ", URI=" + MSentryPrivilege.dnGetURI(this) + ", action=" + MSentryPrivilege.dnGetaction(this) + ", roles=[...], createTime=" + MSentryPrivilege.dnGetcreateTime(this) + ", grantOption=" + MSentryPrivilege.dnGetgrantOption(this) + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (MSentryPrivilege.dnGetURI(this) == null ? 0 : MSentryPrivilege.dnGetURI(this).hashCode());
        result = 31 * result + (MSentryPrivilege.dnGetaction(this) == null ? 0 : MSentryPrivilege.dnGetaction(this).hashCode());
        result = 31 * result + (MSentryPrivilege.dnGetdbName(this) == null ? 0 : MSentryPrivilege.dnGetdbName(this).hashCode());
        result = 31 * result + (MSentryPrivilege.dnGetserverName(this) == null ? 0 : MSentryPrivilege.dnGetserverName(this).hashCode());
        result = 31 * result + (MSentryPrivilege.dnGettableName(this) == null ? 0 : MSentryPrivilege.dnGettableName(this).hashCode());
        result = 31 * result + (MSentryPrivilege.dnGetcolumnName(this) == null ? 0 : MSentryPrivilege.dnGetcolumnName(this).hashCode());
        result = 31 * result + (MSentryPrivilege.dnGetgrantOption(this) == null ? 0 : MSentryPrivilege.dnGetgrantOption(this).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MSentryPrivilege other = (MSentryPrivilege)obj;
        if (MSentryPrivilege.dnGetURI(this) == null ? MSentryPrivilege.dnGetURI(other) != null : !MSentryPrivilege.dnGetURI(this).equals(MSentryPrivilege.dnGetURI(other))) {
            return false;
        }
        if (MSentryPrivilege.dnGetaction(this) == null ? MSentryPrivilege.dnGetaction(other) != null : !MSentryPrivilege.dnGetaction(this).equals(MSentryPrivilege.dnGetaction(other))) {
            return false;
        }
        if (MSentryPrivilege.dnGetdbName(this) == null ? MSentryPrivilege.dnGetdbName(other) != null : !MSentryPrivilege.dnGetdbName(this).equals(MSentryPrivilege.dnGetdbName(other))) {
            return false;
        }
        if (MSentryPrivilege.dnGetserverName(this) == null ? MSentryPrivilege.dnGetserverName(other) != null : !MSentryPrivilege.dnGetserverName(this).equals(MSentryPrivilege.dnGetserverName(other))) {
            return false;
        }
        if (MSentryPrivilege.dnGettableName(this) == null ? MSentryPrivilege.dnGettableName(other) != null : !MSentryPrivilege.dnGettableName(this).equals(MSentryPrivilege.dnGettableName(other))) {
            return false;
        }
        if (MSentryPrivilege.dnGetcolumnName(this) == null ? MSentryPrivilege.dnGetcolumnName(other) != null : !MSentryPrivilege.dnGetcolumnName(this).equals(MSentryPrivilege.dnGetcolumnName(other))) {
            return false;
        }
        return !(MSentryPrivilege.dnGetgrantOption(this) == null ? MSentryPrivilege.dnGetgrantOption(other) != null : !MSentryPrivilege.dnGetgrantOption(this).equals(MSentryPrivilege.dnGetgrantOption(other)));
    }

    public boolean implies(MSentryPrivilege other) {
        if (this.isNULL(MSentryPrivilege.dnGetserverName(this)) || this.isNULL(MSentryPrivilege.dnGetserverName(other))) {
            return false;
        }
        if (!MSentryPrivilege.dnGetserverName(this).equals(MSentryPrivilege.dnGetserverName(other))) {
            return false;
        }
        if (!this.isNULL(MSentryPrivilege.dnGetURI(this)) && !this.isNULL(MSentryPrivilege.dnGetURI(other))) {
            if (!PathUtils.impliesURI((String)MSentryPrivilege.dnGetURI(this), (String)MSentryPrivilege.dnGetURI(other))) {
                return false;
            }
        } else if (this.isNULL(MSentryPrivilege.dnGetURI(this)) && this.isNULL(MSentryPrivilege.dnGetURI(other))) {
            if (!this.isNULL(MSentryPrivilege.dnGetdbName(this))) {
                if (this.isNULL(MSentryPrivilege.dnGetdbName(other))) {
                    return false;
                }
                if (!MSentryPrivilege.dnGetdbName(this).equals(MSentryPrivilege.dnGetdbName(other))) {
                    return false;
                }
            }
            if (!this.isNULL(MSentryPrivilege.dnGettableName(this))) {
                if (this.isNULL(MSentryPrivilege.dnGettableName(other))) {
                    return false;
                }
                if (!MSentryPrivilege.dnGettableName(this).equals(MSentryPrivilege.dnGettableName(other))) {
                    return false;
                }
            }
            if (!this.isNULL(MSentryPrivilege.dnGetcolumnName(this))) {
                if (this.isNULL(MSentryPrivilege.dnGetcolumnName(other))) {
                    return false;
                }
                if (!MSentryPrivilege.dnGetcolumnName(this).equals(MSentryPrivilege.dnGetcolumnName(other))) {
                    return false;
                }
            }
        } else if (!this.isNULL(MSentryPrivilege.dnGetURI(this)) && this.isNULL(MSentryPrivilege.dnGetURI(other))) {
            return false;
        }
        return MSentryPrivilege.dnGetaction(this).equalsIgnoreCase("*") || MSentryPrivilege.dnGetaction(this).equalsIgnoreCase(MSentryPrivilege.dnGetaction(other)) || MSentryPrivilege.dnGetaction(this).equalsIgnoreCase("ALL");
    }

    private boolean isNULL(String s) {
        return SentryStore.isNULL(s);
    }

    public boolean isActionALL() {
        return "ALL".equalsIgnoreCase(MSentryPrivilege.dnGetaction(this)) || "*".equals(MSentryPrivilege.dnGetaction(this));
    }

    static {
        dnFieldNames = MSentryPrivilege.__dnFieldNamesInit();
        dnFieldTypes = MSentryPrivilege.__dnFieldTypesInit();
        dnFieldFlags = MSentryPrivilege.__dnFieldFlagsInit();
        dnInheritedFieldCount = MSentryPrivilege.__dnGetInheritedFieldCount();
        dnPersistableSuperclass = MSentryPrivilege.__dnPersistableSuperclassInit();
        EnhancementHelper.registerClass((Class)MSentryPrivilege.___dn$loadClass("org.apache.sentry.provider.db.service.model.MSentryPrivilege"), (String[])dnFieldNames, (Class[])dnFieldTypes, (byte[])dnFieldFlags, (Class)dnPersistableSuperclass, (Persistable)new MSentryPrivilege());
    }

    public void dnCopyKeyFieldsFromObjectId(Persistable.ObjectIdFieldConsumer fc, Object oid) {
    }

    protected void dnCopyKeyFieldsFromObjectId(Object oid) {
    }

    public void dnCopyKeyFieldsToObjectId(Object oid) {
    }

    public void dnCopyKeyFieldsToObjectId(Persistable.ObjectIdFieldSupplier fs, Object oid) {
    }

    public final Object dnGetObjectId() {
        if (this.dnStateManager != null) {
            return this.dnStateManager.getObjectId((Persistable)this);
        }
        if (!this.dnIsDetached()) {
            return null;
        }
        return this.dnDetachedState[0];
    }

    public final Object dnGetVersion() {
        if (this.dnStateManager != null) {
            return this.dnStateManager.getVersion((Persistable)this);
        }
        if (!this.dnIsDetached()) {
            return null;
        }
        return this.dnDetachedState[1];
    }

    protected final void dnPreSerialize() {
        if (this.dnStateManager != null) {
            this.dnStateManager.preSerialize((Persistable)this);
        }
    }

    public final ExecutionContextReference dnGetExecutionContext() {
        return this.dnStateManager != null ? this.dnStateManager.getExecutionContext((Persistable)this) : null;
    }

    public final Object dnGetTransactionalObjectId() {
        return this.dnStateManager != null ? this.dnStateManager.getTransactionalObjectId((Persistable)this) : null;
    }

    public final boolean dnIsDeleted() {
        return this.dnStateManager != null ? this.dnStateManager.isDeleted((Persistable)this) : false;
    }

    public final boolean dnIsDirty() {
        if (this.dnStateManager != null) {
            return this.dnStateManager.isDirty((Persistable)this);
        }
        if (!this.dnIsDetached()) {
            return false;
        }
        return ((BitSet)this.dnDetachedState[3]).length() > 0;
    }

    public final boolean dnIsNew() {
        return this.dnStateManager != null ? this.dnStateManager.isNew((Persistable)this) : false;
    }

    public final boolean dnIsPersistent() {
        return this.dnStateManager != null ? this.dnStateManager.isPersistent((Persistable)this) : false;
    }

    public final boolean dnIsTransactional() {
        return this.dnStateManager != null ? this.dnStateManager.isTransactional((Persistable)this) : false;
    }

    public void dnMakeDirty(String fieldName) {
        if (this.dnStateManager != null) {
            this.dnStateManager.makeDirty((Persistable)this, fieldName);
        }
        if (this.dnIsDetached() && fieldName != null) {
            String fldName = null;
            fldName = fieldName.indexOf(46) >= 0 ? fieldName.substring(fieldName.lastIndexOf(46) + 1) : fieldName;
            int i = 0;
            while (i < dnFieldNames.length) {
                if (dnFieldNames[i].equals(fldName)) {
                    if (((BitSet)this.dnDetachedState[2]).get(i + dnInheritedFieldCount)) {
                        ((BitSet)this.dnDetachedState[3]).set(i + dnInheritedFieldCount);
                        return;
                    }
                    throw new JDODetachedFieldAccessException("You have just attempted to access a field/property that hasn't been detached. Please detach it first before performing this operation");
                }
                ++i;
            }
        }
    }

    public Object dnNewObjectIdInstance() {
        return null;
    }

    public Object dnNewObjectIdInstance(Object key) {
        return null;
    }

    public final void dnProvideFields(int[] indices) {
        if (indices == null) {
            throw new IllegalArgumentException("argment is null");
        }
        int i = indices.length - 1;
        if (i >= 0) {
            do {
                this.dnProvideField(indices[i]);
            } while (--i >= 0);
        }
    }

    public final void dnReplaceFields(int[] indices) {
        if (indices == null) {
            throw new IllegalArgumentException("argument is null");
        }
        int i = indices.length;
        if (i > 0) {
            int j = 0;
            do {
                this.dnReplaceField(indices[j]);
            } while (++j < i);
        }
    }

    public final void dnReplaceFlags() {
        if (this.dnStateManager != null) {
            this.dnFlags = this.dnStateManager.replacingFlags((Persistable)this);
        }
    }

    public final synchronized void dnReplaceStateManager(StateManager sm) {
        if (this.dnStateManager != null) {
            this.dnStateManager = this.dnStateManager.replacingStateManager((Persistable)this, sm);
        } else {
            EnhancementHelper.checkAuthorizedStateManager((StateManager)sm);
            this.dnStateManager = sm;
            this.dnFlags = 1;
        }
    }

    public final synchronized void dnReplaceDetachedState() {
        if (this.dnStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        this.dnDetachedState = this.dnStateManager.replacingDetachedState((Detachable)this, this.dnDetachedState);
    }

    public boolean dnIsDetached() {
        return this.dnStateManager == null && this.dnDetachedState != null;
    }

    public Persistable dnNewInstance(StateManager sm) {
        MSentryPrivilege result = new MSentryPrivilege();
        result.dnFlags = 1;
        result.dnStateManager = sm;
        return result;
    }

    public Persistable dnNewInstance(StateManager sm, Object obj) {
        MSentryPrivilege result = new MSentryPrivilege();
        result.dnFlags = 1;
        result.dnStateManager = sm;
        result.dnCopyKeyFieldsFromObjectId(obj);
        return result;
    }

    public void dnReplaceField(int index) {
        if (this.dnStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (index) {
            case 0: {
                this.URI = this.dnStateManager.replacingStringField((Persistable)this, index);
                break;
            }
            case 1: {
                this.action = this.dnStateManager.replacingStringField((Persistable)this, index);
                break;
            }
            case 2: {
                this.columnName = this.dnStateManager.replacingStringField((Persistable)this, index);
                break;
            }
            case 3: {
                this.createTime = this.dnStateManager.replacingLongField((Persistable)this, index);
                break;
            }
            case 4: {
                this.dbName = this.dnStateManager.replacingStringField((Persistable)this, index);
                break;
            }
            case 5: {
                this.grantOption = (Boolean)this.dnStateManager.replacingObjectField((Persistable)this, index);
                break;
            }
            case 6: {
                this.privilegeScope = this.dnStateManager.replacingStringField((Persistable)this, index);
                break;
            }
            case 7: {
                this.roles = (Set)this.dnStateManager.replacingObjectField((Persistable)this, index);
                break;
            }
            case 8: {
                this.serverName = this.dnStateManager.replacingStringField((Persistable)this, index);
                break;
            }
            case 9: {
                this.tableName = this.dnStateManager.replacingStringField((Persistable)this, index);
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    public void dnProvideField(int index) {
        if (this.dnStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (index) {
            case 0: {
                this.dnStateManager.providedStringField((Persistable)this, index, this.URI);
                break;
            }
            case 1: {
                this.dnStateManager.providedStringField((Persistable)this, index, this.action);
                break;
            }
            case 2: {
                this.dnStateManager.providedStringField((Persistable)this, index, this.columnName);
                break;
            }
            case 3: {
                this.dnStateManager.providedLongField((Persistable)this, index, this.createTime);
                break;
            }
            case 4: {
                this.dnStateManager.providedStringField((Persistable)this, index, this.dbName);
                break;
            }
            case 5: {
                this.dnStateManager.providedObjectField((Persistable)this, index, (Object)this.grantOption);
                break;
            }
            case 6: {
                this.dnStateManager.providedStringField((Persistable)this, index, this.privilegeScope);
                break;
            }
            case 7: {
                this.dnStateManager.providedObjectField((Persistable)this, index, this.roles);
                break;
            }
            case 8: {
                this.dnStateManager.providedStringField((Persistable)this, index, this.serverName);
                break;
            }
            case 9: {
                this.dnStateManager.providedStringField((Persistable)this, index, this.tableName);
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    protected final void dnCopyField(MSentryPrivilege obj, int index) {
        switch (index) {
            case 0: {
                this.URI = obj.URI;
                break;
            }
            case 1: {
                this.action = obj.action;
                break;
            }
            case 2: {
                this.columnName = obj.columnName;
                break;
            }
            case 3: {
                this.createTime = obj.createTime;
                break;
            }
            case 4: {
                this.dbName = obj.dbName;
                break;
            }
            case 5: {
                this.grantOption = obj.grantOption;
                break;
            }
            case 6: {
                this.privilegeScope = obj.privilegeScope;
                break;
            }
            case 7: {
                this.roles = obj.roles;
                break;
            }
            case 8: {
                this.serverName = obj.serverName;
                break;
            }
            case 9: {
                this.tableName = obj.tableName;
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    public void dnCopyFields(Object obj, int[] indices) {
        if (this.dnStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        if (indices == null) {
            throw new IllegalStateException("fieldNumbers is null");
        }
        if (!(obj instanceof MSentryPrivilege)) {
            throw new IllegalArgumentException("object is not an object of type org.apache.sentry.provider.db.service.model.MSentryPrivilege");
        }
        MSentryPrivilege other = (MSentryPrivilege)obj;
        if (this.dnStateManager != other.dnStateManager) {
            throw new IllegalArgumentException("state managers do not match");
        }
        int i = indices.length - 1;
        if (i >= 0) {
            do {
                this.dnCopyField(other, indices[i]);
            } while (--i >= 0);
        }
    }

    private static final String[] __dnFieldNamesInit() {
        return new String[]{"URI", "action", "columnName", "createTime", "dbName", "grantOption", "privilegeScope", "roles", "serverName", "tableName"};
    }

    private static final Class[] __dnFieldTypesInit() {
        return new Class[]{MSentryPrivilege.___dn$loadClass("java.lang.String"), MSentryPrivilege.___dn$loadClass("java.lang.String"), MSentryPrivilege.___dn$loadClass("java.lang.String"), Long.TYPE, MSentryPrivilege.___dn$loadClass("java.lang.String"), MSentryPrivilege.___dn$loadClass("java.lang.Boolean"), MSentryPrivilege.___dn$loadClass("java.lang.String"), MSentryPrivilege.___dn$loadClass("java.util.Set"), MSentryPrivilege.___dn$loadClass("java.lang.String"), MSentryPrivilege.___dn$loadClass("java.lang.String")};
    }

    private static final byte[] __dnFieldFlagsInit() {
        return new byte[]{21, 21, 21, 21, 21, 21, 21, 10, 21, 21};
    }

    protected static int __dnGetInheritedFieldCount() {
        return 0;
    }

    protected static int dnGetManagedFieldCount() {
        return 10;
    }

    private static Class __dnPersistableSuperclassInit() {
        return null;
    }

    public static Class ___dn$loadClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
    }

    private Object dnSuperClone() throws CloneNotSupportedException {
        MSentryPrivilege o = (MSentryPrivilege)super.clone();
        o.dnFlags = 0;
        o.dnStateManager = null;
        return o;
    }

    private static String dnGetURI(MSentryPrivilege objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 0)) {
            return objPC.dnStateManager.getStringField((Persistable)objPC, 0, objPC.URI);
        }
        if (objPC.dnIsDetached() && !((BitSet)objPC.dnDetachedState[2]).get(0)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"URI\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.URI;
    }

    private static void dnSetURI(MSentryPrivilege objPC, String val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setStringField((Persistable)objPC, 0, objPC.URI, val);
        } else {
            objPC.URI = val;
            if (objPC.dnIsDetached()) {
                ((BitSet)objPC.dnDetachedState[3]).set(0);
            }
        }
    }

    private static String dnGetaction(MSentryPrivilege objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 1)) {
            return objPC.dnStateManager.getStringField((Persistable)objPC, 1, objPC.action);
        }
        if (objPC.dnIsDetached() && !((BitSet)objPC.dnDetachedState[2]).get(1)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"action\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.action;
    }

    private static void dnSetaction(MSentryPrivilege objPC, String val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setStringField((Persistable)objPC, 1, objPC.action, val);
        } else {
            objPC.action = val;
            if (objPC.dnIsDetached()) {
                ((BitSet)objPC.dnDetachedState[3]).set(1);
            }
        }
    }

    private static String dnGetcolumnName(MSentryPrivilege objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 2)) {
            return objPC.dnStateManager.getStringField((Persistable)objPC, 2, objPC.columnName);
        }
        if (objPC.dnIsDetached() && !((BitSet)objPC.dnDetachedState[2]).get(2)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"columnName\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.columnName;
    }

    private static void dnSetcolumnName(MSentryPrivilege objPC, String val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setStringField((Persistable)objPC, 2, objPC.columnName, val);
        } else {
            objPC.columnName = val;
            if (objPC.dnIsDetached()) {
                ((BitSet)objPC.dnDetachedState[3]).set(2);
            }
        }
    }

    private static long dnGetcreateTime(MSentryPrivilege objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 3)) {
            return objPC.dnStateManager.getLongField((Persistable)objPC, 3, objPC.createTime);
        }
        if (objPC.dnIsDetached() && !((BitSet)objPC.dnDetachedState[2]).get(3)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"createTime\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.createTime;
    }

    private static void dnSetcreateTime(MSentryPrivilege objPC, long val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setLongField((Persistable)objPC, 3, objPC.createTime, val);
        } else {
            objPC.createTime = val;
            if (objPC.dnIsDetached()) {
                ((BitSet)objPC.dnDetachedState[3]).set(3);
            }
        }
    }

    private static String dnGetdbName(MSentryPrivilege objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 4)) {
            return objPC.dnStateManager.getStringField((Persistable)objPC, 4, objPC.dbName);
        }
        if (objPC.dnIsDetached() && !((BitSet)objPC.dnDetachedState[2]).get(4)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"dbName\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.dbName;
    }

    private static void dnSetdbName(MSentryPrivilege objPC, String val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setStringField((Persistable)objPC, 4, objPC.dbName, val);
        } else {
            objPC.dbName = val;
            if (objPC.dnIsDetached()) {
                ((BitSet)objPC.dnDetachedState[3]).set(4);
            }
        }
    }

    private static Boolean dnGetgrantOption(MSentryPrivilege objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 5)) {
            return (Boolean)objPC.dnStateManager.getObjectField((Persistable)objPC, 5, (Object)objPC.grantOption);
        }
        if (objPC.dnIsDetached() && !((BitSet)objPC.dnDetachedState[2]).get(5)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"grantOption\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.grantOption;
    }

    private static void dnSetgrantOption(MSentryPrivilege objPC, Boolean val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 5, (Object)objPC.grantOption, (Object)val);
        } else {
            objPC.grantOption = val;
            if (objPC.dnIsDetached()) {
                ((BitSet)objPC.dnDetachedState[3]).set(5);
            }
        }
    }

    private static String dnGetprivilegeScope(MSentryPrivilege objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 6)) {
            return objPC.dnStateManager.getStringField((Persistable)objPC, 6, objPC.privilegeScope);
        }
        if (objPC.dnIsDetached() && !((BitSet)objPC.dnDetachedState[2]).get(6)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"privilegeScope\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.privilegeScope;
    }

    private static void dnSetprivilegeScope(MSentryPrivilege objPC, String val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setStringField((Persistable)objPC, 6, objPC.privilegeScope, val);
        } else {
            objPC.privilegeScope = val;
            if (objPC.dnIsDetached()) {
                ((BitSet)objPC.dnDetachedState[3]).set(6);
            }
        }
    }

    private static Set dnGetroles(MSentryPrivilege objPC) {
        if (objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 7)) {
            return (Set)objPC.dnStateManager.getObjectField((Persistable)objPC, 7, objPC.roles);
        }
        if (objPC.dnIsDetached() && !((BitSet)objPC.dnDetachedState[2]).get(7) && !((BitSet)objPC.dnDetachedState[3]).get(7)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"roles\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.roles;
    }

    private static void dnSetroles(MSentryPrivilege objPC, Set val) {
        if (objPC.dnStateManager == null) {
            objPC.roles = val;
        } else {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 7, objPC.roles, (Object)val);
        }
        if (objPC.dnIsDetached()) {
            ((BitSet)objPC.dnDetachedState[3]).set(7);
        }
    }

    private static String dnGetserverName(MSentryPrivilege objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 8)) {
            return objPC.dnStateManager.getStringField((Persistable)objPC, 8, objPC.serverName);
        }
        if (objPC.dnIsDetached() && !((BitSet)objPC.dnDetachedState[2]).get(8)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"serverName\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.serverName;
    }

    private static void dnSetserverName(MSentryPrivilege objPC, String val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setStringField((Persistable)objPC, 8, objPC.serverName, val);
        } else {
            objPC.serverName = val;
            if (objPC.dnIsDetached()) {
                ((BitSet)objPC.dnDetachedState[3]).set(8);
            }
        }
    }

    private static String dnGettableName(MSentryPrivilege objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 9)) {
            return objPC.dnStateManager.getStringField((Persistable)objPC, 9, objPC.tableName);
        }
        if (objPC.dnIsDetached() && !((BitSet)objPC.dnDetachedState[2]).get(9)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"tableName\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.tableName;
    }

    private static void dnSettableName(MSentryPrivilege objPC, String val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setStringField((Persistable)objPC, 9, objPC.tableName, val);
        } else {
            objPC.tableName = val;
            if (objPC.dnIsDetached()) {
                ((BitSet)objPC.dnDetachedState[3]).set(9);
            }
        }
    }
}

