/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.provider.db.service.model;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.jdo.JDODetachedFieldAccessException;
import javax.jdo.annotations.PersistenceCapable;
import org.apache.sentry.core.common.Authorizable;
import org.apache.sentry.core.common.utils.SentryConstants;
import org.apache.sentry.provider.db.service.model.MSentryRole;
import org.apache.sentry.provider.db.service.model.MSentryUtil;
import org.datanucleus.enhancement.Detachable;
import org.datanucleus.enhancement.ExecutionContextReference;
import org.datanucleus.enhancement.Persistable;
import org.datanucleus.enhancement.StateManager;
import org.datanucleus.enhancer.EnhancementHelper;

@PersistenceCapable
public class MSentryGMPrivilege
implements Detachable,
Persistable {
    public static final String PREFIX_RESOURCE_NAME = "resourceName";
    public static final String PREFIX_RESOURCE_TYPE = "resourceType";
    public static final int AUTHORIZABLE_LEVEL = 4;
    private static final String NULL_COL = "__NULL__";
    private static final String SERVICE_SCOPE = "Server";
    private String resourceName0 = "__NULL__";
    private String resourceType0 = "__NULL__";
    private String resourceName1 = "__NULL__";
    private String resourceType1 = "__NULL__";
    private String resourceName2 = "__NULL__";
    private String resourceType2 = "__NULL__";
    private String resourceName3 = "__NULL__";
    private String resourceType3 = "__NULL__";
    private String serviceName;
    private String componentName;
    private String action;
    private String scope;
    private Boolean grantOption = false;
    private Set<MSentryRole> roles;
    private long createTime;
    protected transient StateManager dnStateManager;
    protected transient byte dnFlags;
    protected Object[] dnDetachedState;
    private static final byte[] dnFieldFlags;
    private static final Class dnPersistableSuperclass;
    private static final Class[] dnFieldTypes;
    private static final String[] dnFieldNames;
    private static final int dnInheritedFieldCount;

    public MSentryGMPrivilege() {
        this.roles = new HashSet<MSentryRole>();
    }

    public MSentryGMPrivilege(String componentName, String serviceName, List<? extends Authorizable> authorizables, String action, Boolean grantOption) {
        this.componentName = MSentryUtil.safeIntern(componentName);
        this.serviceName = MSentryUtil.safeIntern(serviceName);
        this.action = MSentryUtil.safeIntern(action);
        this.grantOption = grantOption;
        this.roles = new HashSet<MSentryRole>();
        this.createTime = System.currentTimeMillis();
        this.setAuthorizables(authorizables);
    }

    public MSentryGMPrivilege(MSentryGMPrivilege copy) {
        this.action = copy.action;
        this.componentName = copy.componentName;
        this.serviceName = copy.serviceName;
        this.grantOption = copy.grantOption;
        this.scope = copy.scope;
        this.createTime = copy.createTime;
        this.setAuthorizables(copy.getAuthorizables());
        this.roles = new HashSet<MSentryRole>();
        this.roles.addAll(copy.roles);
    }

    public String getServiceName() {
        return MSentryGMPrivilege.dnGetserviceName(this);
    }

    public void setServiceName(String serviceName) {
        MSentryGMPrivilege.dnSetserviceName(this, serviceName);
    }

    public String getComponentName() {
        return MSentryGMPrivilege.dnGetcomponentName(this);
    }

    public void setComponentName(String componentName) {
        MSentryGMPrivilege.dnSetcomponentName(this, componentName);
    }

    public String getAction() {
        return MSentryGMPrivilege.dnGetaction(this);
    }

    public void setAction(String action) {
        MSentryGMPrivilege.dnSetaction(this, action);
    }

    public Boolean getGrantOption() {
        return MSentryGMPrivilege.dnGetgrantOption(this);
    }

    public void setGrantOption(Boolean grantOption) {
        MSentryGMPrivilege.dnSetgrantOption(this, grantOption);
    }

    public Set<MSentryRole> getRoles() {
        return MSentryGMPrivilege.dnGetroles(this);
    }

    public void setRoles(Set<MSentryRole> roles) {
        MSentryGMPrivilege.dnSetroles(this, roles);
    }

    public long getCreateTime() {
        return MSentryGMPrivilege.dnGetcreateTime(this);
    }

    public void setCreateTime(long createTime) {
        MSentryGMPrivilege.dnSetcreateTime(this, createTime);
    }

    public String getScope() {
        return MSentryGMPrivilege.dnGetscope(this);
    }

    public List<? extends Authorizable> getAuthorizables() {
        ArrayList authorizables = Lists.newArrayList();
        for (int i = 0; i < 4; ++i) {
            final String resourceName = (String)MSentryGMPrivilege.getField(this, PREFIX_RESOURCE_NAME + String.valueOf(i));
            final String resourceTYpe = (String)MSentryGMPrivilege.getField(this, PREFIX_RESOURCE_TYPE + String.valueOf(i));
            if (!MSentryGMPrivilege.notNULL(resourceName) || !MSentryGMPrivilege.notNULL(resourceTYpe)) continue;
            authorizables.add(new Authorizable(){

                public String getTypeName() {
                    return resourceTYpe;
                }

                public String getName() {
                    return resourceName;
                }
            });
        }
        return authorizables;
    }

    public void setAuthorizables(List<? extends Authorizable> authorizables) {
        if (authorizables == null || authorizables.isEmpty()) {
            MSentryGMPrivilege.dnSetscope(this, SERVICE_SCOPE);
            return;
        }
        if (authorizables.size() > 4) {
            throw new IllegalStateException("This generic privilege model only supports maximum 4 level.");
        }
        for (int i = 0; i < authorizables.size(); ++i) {
            Authorizable authorizable = authorizables.get(i);
            if (authorizable == null) {
                String msg = String.format("The authorizable can't be null. Please check authorizables[%d]:", i);
                throw new IllegalStateException(msg);
            }
            String resourceName = authorizable.getName();
            String resourceTYpe = authorizable.getTypeName();
            if (MSentryGMPrivilege.isNULL(resourceName) || MSentryGMPrivilege.isNULL(resourceTYpe)) {
                String msg = String.format("The name and type of authorizable can't be empty or null.Please check authorizables[%d]", i);
                throw new IllegalStateException(msg);
            }
            MSentryGMPrivilege.setField(this, PREFIX_RESOURCE_NAME + String.valueOf(i), MSentryGMPrivilege.toNULLCol(resourceName));
            MSentryGMPrivilege.setField(this, PREFIX_RESOURCE_TYPE + String.valueOf(i), MSentryGMPrivilege.toNULLCol(resourceTYpe));
            MSentryGMPrivilege.dnSetscope(this, resourceTYpe);
        }
    }

    public void appendRole(MSentryRole role) {
        if (MSentryGMPrivilege.dnGetroles(this).add(role)) {
            role.appendGMPrivilege(this);
        }
    }

    public void removeRole(MSentryRole role) {
        if (MSentryGMPrivilege.dnGetroles(this).remove(role)) {
            role.removeGMPrivilege(this);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (MSentryGMPrivilege.dnGetaction(this) == null ? 0 : MSentryGMPrivilege.dnGetaction(this).hashCode());
        result = 31 * result + (MSentryGMPrivilege.dnGetcomponentName(this) == null ? 0 : MSentryGMPrivilege.dnGetcomponentName(this).hashCode());
        result = 31 * result + (MSentryGMPrivilege.dnGetserviceName(this) == null ? 0 : MSentryGMPrivilege.dnGetserviceName(this).hashCode());
        result = 31 * result + (MSentryGMPrivilege.dnGetgrantOption(this) == null ? 0 : MSentryGMPrivilege.dnGetgrantOption(this).hashCode());
        result = 31 * result + (MSentryGMPrivilege.dnGetscope(this) == null ? 0 : MSentryGMPrivilege.dnGetscope(this).hashCode());
        for (Authorizable authorizable : this.getAuthorizables()) {
            result = 31 * result + authorizable.getName().hashCode();
            result = 31 * result + authorizable.getTypeName().hashCode();
        }
        return result;
    }

    public String toString() {
        ArrayList unifiedNames = Lists.newArrayList();
        for (Authorizable authorizable : this.getAuthorizables()) {
            unifiedNames.add(SentryConstants.KV_JOINER.join((Object)authorizable.getTypeName(), (Object)authorizable.getName(), new Object[0]));
        }
        return "MSentryGMPrivilege [serverName=" + MSentryGMPrivilege.dnGetserviceName(this) + ", componentName=" + MSentryGMPrivilege.dnGetcomponentName(this) + ", authorizables=" + SentryConstants.AUTHORIZABLE_JOINER.join((Iterable)unifiedNames) + ", scope=" + MSentryGMPrivilege.dnGetscope(this) + ", action=" + MSentryGMPrivilege.dnGetaction(this) + ", roles=[...], createTime=" + MSentryGMPrivilege.dnGetcreateTime(this) + ", grantOption=" + MSentryGMPrivilege.dnGetgrantOption(this) + "]";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MSentryGMPrivilege other = (MSentryGMPrivilege)obj;
        if (MSentryGMPrivilege.dnGetaction(this) == null ? MSentryGMPrivilege.dnGetaction(other) != null : !MSentryGMPrivilege.dnGetaction(this).equalsIgnoreCase(MSentryGMPrivilege.dnGetaction(other))) {
            return false;
        }
        if (MSentryGMPrivilege.dnGetscope(this) == null ? MSentryGMPrivilege.dnGetscope(other) != null : !MSentryGMPrivilege.dnGetscope(this).equals(MSentryGMPrivilege.dnGetscope(other))) {
            return false;
        }
        if (MSentryGMPrivilege.dnGetserviceName(this) == null ? MSentryGMPrivilege.dnGetserviceName(other) != null : !MSentryGMPrivilege.dnGetserviceName(this).equals(MSentryGMPrivilege.dnGetserviceName(other))) {
            return false;
        }
        if (MSentryGMPrivilege.dnGetcomponentName(this) == null ? MSentryGMPrivilege.dnGetcomponentName(other) != null : !MSentryGMPrivilege.dnGetcomponentName(this).equals(MSentryGMPrivilege.dnGetcomponentName(other))) {
            return false;
        }
        if (MSentryGMPrivilege.dnGetgrantOption(this) == null ? MSentryGMPrivilege.dnGetgrantOption(other) != null : !MSentryGMPrivilege.dnGetgrantOption(this).equals(MSentryGMPrivilege.dnGetgrantOption(other))) {
            return false;
        }
        List<? extends Authorizable> authorizables = this.getAuthorizables();
        List<? extends Authorizable> otherAuthorizables = other.getAuthorizables();
        if (authorizables.size() != otherAuthorizables.size()) {
            return false;
        }
        for (int i = 0; i < authorizables.size(); ++i) {
            String o2;
            String o1 = SentryConstants.KV_JOINER.join((Object)authorizables.get(i).getTypeName(), (Object)authorizables.get(i).getName(), new Object[0]);
            if (o1.equals(o2 = SentryConstants.KV_JOINER.join((Object)otherAuthorizables.get(i).getTypeName(), (Object)otherAuthorizables.get(i).getName(), new Object[0]))) continue;
            return false;
        }
        return true;
    }

    public boolean implies(MSentryGMPrivilege request) {
        if (!MSentryGMPrivilege.dnGetcomponentName(this).equals(request.getComponentName())) {
            return false;
        }
        if (!MSentryGMPrivilege.dnGetserviceName(this).equals(request.getServiceName())) {
            return false;
        }
        if (!(MSentryGMPrivilege.dnGetaction(this).equalsIgnoreCase("*") || MSentryGMPrivilege.dnGetaction(this).equalsIgnoreCase(request.getAction()) || MSentryGMPrivilege.dnGetaction(this).equalsIgnoreCase("ALL"))) {
            return false;
        }
        Iterator<? extends Authorizable> existIterator = this.getAuthorizables().iterator();
        Iterator<? extends Authorizable> requestIterator = request.getAuthorizables().iterator();
        while (existIterator.hasNext() && requestIterator.hasNext()) {
            Authorizable existAuth = existIterator.next();
            Authorizable requestAuth = requestIterator.next();
            if (!existAuth.getTypeName().equals(requestAuth.getTypeName())) {
                return false;
            }
            if (existAuth.getName().equals(requestAuth.getName()) || existAuth.getName().equalsIgnoreCase("ALL") || existAuth.getName().equalsIgnoreCase("*")) continue;
            return false;
        }
        if (!existIterator.hasNext() && !requestIterator.hasNext()) {
            return true;
        }
        if (existIterator.hasNext()) {
            while (existIterator.hasNext()) {
                Authorizable existAuthorizable = existIterator.next();
                if (existAuthorizable.getName().equalsIgnoreCase("*") || existAuthorizable.getName().equalsIgnoreCase("ALL")) continue;
                return false;
            }
        } else {
            return true;
        }
        return true;
    }

    public static String toNULLCol(String col) {
        return Strings.isNullOrEmpty((String)col) ? NULL_COL : col;
    }

    public static boolean notNULL(String s) {
        return !Strings.isNullOrEmpty((String)s) && !NULL_COL.equals(s);
    }

    public static boolean isNULL(String s) {
        return !MSentryGMPrivilege.notNULL(s);
    }

    public static <T> void setField(Object obj, String fieldName, T fieldValue) {
        try {
            Class<?> clazz = obj.getClass();
            Field field = clazz.getDeclaredField(fieldName);
            field.setAccessible(true);
            field.set(obj, fieldValue);
        }
        catch (Exception e) {
            throw new RuntimeException("setField error: " + e.getMessage(), e);
        }
    }

    public static <T> T getField(Object obj, String fieldName) {
        try {
            Class<?> clazz = obj.getClass();
            Field field = clazz.getDeclaredField(fieldName);
            field.setAccessible(true);
            return (T)field.get(obj);
        }
        catch (Exception e) {
            throw new RuntimeException("getField error: " + e.getMessage(), e);
        }
    }

    static {
        dnFieldNames = MSentryGMPrivilege.__dnFieldNamesInit();
        dnFieldTypes = MSentryGMPrivilege.__dnFieldTypesInit();
        dnFieldFlags = MSentryGMPrivilege.__dnFieldFlagsInit();
        dnInheritedFieldCount = MSentryGMPrivilege.__dnGetInheritedFieldCount();
        dnPersistableSuperclass = MSentryGMPrivilege.__dnPersistableSuperclassInit();
        EnhancementHelper.registerClass((Class)MSentryGMPrivilege.___dn$loadClass("org.apache.sentry.provider.db.service.model.MSentryGMPrivilege"), (String[])dnFieldNames, (Class[])dnFieldTypes, (byte[])dnFieldFlags, (Class)dnPersistableSuperclass, (Persistable)new MSentryGMPrivilege());
    }

    public void dnCopyKeyFieldsFromObjectId(Persistable.ObjectIdFieldConsumer fc, Object oid) {
    }

    protected void dnCopyKeyFieldsFromObjectId(Object oid) {
    }

    public void dnCopyKeyFieldsToObjectId(Object oid) {
    }

    public void dnCopyKeyFieldsToObjectId(Persistable.ObjectIdFieldSupplier fs, Object oid) {
    }

    public final Object dnGetObjectId() {
        if (this.dnStateManager != null) {
            return this.dnStateManager.getObjectId((Persistable)this);
        }
        if (!this.dnIsDetached()) {
            return null;
        }
        return this.dnDetachedState[0];
    }

    public final Object dnGetVersion() {
        if (this.dnStateManager != null) {
            return this.dnStateManager.getVersion((Persistable)this);
        }
        if (!this.dnIsDetached()) {
            return null;
        }
        return this.dnDetachedState[1];
    }

    protected final void dnPreSerialize() {
        if (this.dnStateManager != null) {
            this.dnStateManager.preSerialize((Persistable)this);
        }
    }

    public final ExecutionContextReference dnGetExecutionContext() {
        return this.dnStateManager != null ? this.dnStateManager.getExecutionContext((Persistable)this) : null;
    }

    public final Object dnGetTransactionalObjectId() {
        return this.dnStateManager != null ? this.dnStateManager.getTransactionalObjectId((Persistable)this) : null;
    }

    public final boolean dnIsDeleted() {
        return this.dnStateManager != null ? this.dnStateManager.isDeleted((Persistable)this) : false;
    }

    public final boolean dnIsDirty() {
        if (this.dnStateManager != null) {
            return this.dnStateManager.isDirty((Persistable)this);
        }
        if (!this.dnIsDetached()) {
            return false;
        }
        return ((BitSet)this.dnDetachedState[3]).length() > 0;
    }

    public final boolean dnIsNew() {
        return this.dnStateManager != null ? this.dnStateManager.isNew((Persistable)this) : false;
    }

    public final boolean dnIsPersistent() {
        return this.dnStateManager != null ? this.dnStateManager.isPersistent((Persistable)this) : false;
    }

    public final boolean dnIsTransactional() {
        return this.dnStateManager != null ? this.dnStateManager.isTransactional((Persistable)this) : false;
    }

    public void dnMakeDirty(String fieldName) {
        if (this.dnStateManager != null) {
            this.dnStateManager.makeDirty((Persistable)this, fieldName);
        }
        if (this.dnIsDetached() && fieldName != null) {
            String fldName = null;
            fldName = fieldName.indexOf(46) >= 0 ? fieldName.substring(fieldName.lastIndexOf(46) + 1) : fieldName;
            int i = 0;
            while (i < dnFieldNames.length) {
                if (dnFieldNames[i].equals(fldName)) {
                    if (((BitSet)this.dnDetachedState[2]).get(i + dnInheritedFieldCount)) {
                        ((BitSet)this.dnDetachedState[3]).set(i + dnInheritedFieldCount);
                        return;
                    }
                    throw new JDODetachedFieldAccessException("You have just attempted to access a field/property that hasn't been detached. Please detach it first before performing this operation");
                }
                ++i;
            }
        }
    }

    public Object dnNewObjectIdInstance() {
        return null;
    }

    public Object dnNewObjectIdInstance(Object key) {
        return null;
    }

    public final void dnProvideFields(int[] indices) {
        if (indices == null) {
            throw new IllegalArgumentException("argment is null");
        }
        int i = indices.length - 1;
        if (i >= 0) {
            do {
                this.dnProvideField(indices[i]);
            } while (--i >= 0);
        }
    }

    public final void dnReplaceFields(int[] indices) {
        if (indices == null) {
            throw new IllegalArgumentException("argument is null");
        }
        int i = indices.length;
        if (i > 0) {
            int j = 0;
            do {
                this.dnReplaceField(indices[j]);
            } while (++j < i);
        }
    }

    public final void dnReplaceFlags() {
        if (this.dnStateManager != null) {
            this.dnFlags = this.dnStateManager.replacingFlags((Persistable)this);
        }
    }

    public final synchronized void dnReplaceStateManager(StateManager sm) {
        if (this.dnStateManager != null) {
            this.dnStateManager = this.dnStateManager.replacingStateManager((Persistable)this, sm);
        } else {
            EnhancementHelper.checkAuthorizedStateManager((StateManager)sm);
            this.dnStateManager = sm;
            this.dnFlags = 1;
        }
    }

    public final synchronized void dnReplaceDetachedState() {
        if (this.dnStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        this.dnDetachedState = this.dnStateManager.replacingDetachedState((Detachable)this, this.dnDetachedState);
    }

    public boolean dnIsDetached() {
        return this.dnStateManager == null && this.dnDetachedState != null;
    }

    public Persistable dnNewInstance(StateManager sm) {
        MSentryGMPrivilege result = new MSentryGMPrivilege();
        result.dnFlags = 1;
        result.dnStateManager = sm;
        return result;
    }

    public Persistable dnNewInstance(StateManager sm, Object obj) {
        MSentryGMPrivilege result = new MSentryGMPrivilege();
        result.dnFlags = 1;
        result.dnStateManager = sm;
        result.dnCopyKeyFieldsFromObjectId(obj);
        return result;
    }

    public void dnReplaceField(int index) {
        if (this.dnStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (index) {
            case 0: {
                this.action = this.dnStateManager.replacingStringField((Persistable)this, index);
                break;
            }
            case 1: {
                this.componentName = this.dnStateManager.replacingStringField((Persistable)this, index);
                break;
            }
            case 2: {
                this.createTime = this.dnStateManager.replacingLongField((Persistable)this, index);
                break;
            }
            case 3: {
                this.grantOption = (Boolean)this.dnStateManager.replacingObjectField((Persistable)this, index);
                break;
            }
            case 4: {
                this.resourceName0 = this.dnStateManager.replacingStringField((Persistable)this, index);
                break;
            }
            case 5: {
                this.resourceName1 = this.dnStateManager.replacingStringField((Persistable)this, index);
                break;
            }
            case 6: {
                this.resourceName2 = this.dnStateManager.replacingStringField((Persistable)this, index);
                break;
            }
            case 7: {
                this.resourceName3 = this.dnStateManager.replacingStringField((Persistable)this, index);
                break;
            }
            case 8: {
                this.resourceType0 = this.dnStateManager.replacingStringField((Persistable)this, index);
                break;
            }
            case 9: {
                this.resourceType1 = this.dnStateManager.replacingStringField((Persistable)this, index);
                break;
            }
            case 10: {
                this.resourceType2 = this.dnStateManager.replacingStringField((Persistable)this, index);
                break;
            }
            case 11: {
                this.resourceType3 = this.dnStateManager.replacingStringField((Persistable)this, index);
                break;
            }
            case 12: {
                this.roles = (Set)this.dnStateManager.replacingObjectField((Persistable)this, index);
                break;
            }
            case 13: {
                this.scope = this.dnStateManager.replacingStringField((Persistable)this, index);
                break;
            }
            case 14: {
                this.serviceName = this.dnStateManager.replacingStringField((Persistable)this, index);
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    public void dnProvideField(int index) {
        if (this.dnStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (index) {
            case 0: {
                this.dnStateManager.providedStringField((Persistable)this, index, this.action);
                break;
            }
            case 1: {
                this.dnStateManager.providedStringField((Persistable)this, index, this.componentName);
                break;
            }
            case 2: {
                this.dnStateManager.providedLongField((Persistable)this, index, this.createTime);
                break;
            }
            case 3: {
                this.dnStateManager.providedObjectField((Persistable)this, index, (Object)this.grantOption);
                break;
            }
            case 4: {
                this.dnStateManager.providedStringField((Persistable)this, index, this.resourceName0);
                break;
            }
            case 5: {
                this.dnStateManager.providedStringField((Persistable)this, index, this.resourceName1);
                break;
            }
            case 6: {
                this.dnStateManager.providedStringField((Persistable)this, index, this.resourceName2);
                break;
            }
            case 7: {
                this.dnStateManager.providedStringField((Persistable)this, index, this.resourceName3);
                break;
            }
            case 8: {
                this.dnStateManager.providedStringField((Persistable)this, index, this.resourceType0);
                break;
            }
            case 9: {
                this.dnStateManager.providedStringField((Persistable)this, index, this.resourceType1);
                break;
            }
            case 10: {
                this.dnStateManager.providedStringField((Persistable)this, index, this.resourceType2);
                break;
            }
            case 11: {
                this.dnStateManager.providedStringField((Persistable)this, index, this.resourceType3);
                break;
            }
            case 12: {
                this.dnStateManager.providedObjectField((Persistable)this, index, this.roles);
                break;
            }
            case 13: {
                this.dnStateManager.providedStringField((Persistable)this, index, this.scope);
                break;
            }
            case 14: {
                this.dnStateManager.providedStringField((Persistable)this, index, this.serviceName);
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    protected final void dnCopyField(MSentryGMPrivilege obj, int index) {
        switch (index) {
            case 0: {
                this.action = obj.action;
                break;
            }
            case 1: {
                this.componentName = obj.componentName;
                break;
            }
            case 2: {
                this.createTime = obj.createTime;
                break;
            }
            case 3: {
                this.grantOption = obj.grantOption;
                break;
            }
            case 4: {
                this.resourceName0 = obj.resourceName0;
                break;
            }
            case 5: {
                this.resourceName1 = obj.resourceName1;
                break;
            }
            case 6: {
                this.resourceName2 = obj.resourceName2;
                break;
            }
            case 7: {
                this.resourceName3 = obj.resourceName3;
                break;
            }
            case 8: {
                this.resourceType0 = obj.resourceType0;
                break;
            }
            case 9: {
                this.resourceType1 = obj.resourceType1;
                break;
            }
            case 10: {
                this.resourceType2 = obj.resourceType2;
                break;
            }
            case 11: {
                this.resourceType3 = obj.resourceType3;
                break;
            }
            case 12: {
                this.roles = obj.roles;
                break;
            }
            case 13: {
                this.scope = obj.scope;
                break;
            }
            case 14: {
                this.serviceName = obj.serviceName;
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    public void dnCopyFields(Object obj, int[] indices) {
        if (this.dnStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        if (indices == null) {
            throw new IllegalStateException("fieldNumbers is null");
        }
        if (!(obj instanceof MSentryGMPrivilege)) {
            throw new IllegalArgumentException("object is not an object of type org.apache.sentry.provider.db.service.model.MSentryGMPrivilege");
        }
        MSentryGMPrivilege other = (MSentryGMPrivilege)obj;
        if (this.dnStateManager != other.dnStateManager) {
            throw new IllegalArgumentException("state managers do not match");
        }
        int i = indices.length - 1;
        if (i >= 0) {
            do {
                this.dnCopyField(other, indices[i]);
            } while (--i >= 0);
        }
    }

    private static final String[] __dnFieldNamesInit() {
        return new String[]{"action", "componentName", "createTime", "grantOption", "resourceName0", "resourceName1", "resourceName2", "resourceName3", "resourceType0", "resourceType1", "resourceType2", "resourceType3", "roles", "scope", "serviceName"};
    }

    private static final Class[] __dnFieldTypesInit() {
        return new Class[]{MSentryGMPrivilege.___dn$loadClass("java.lang.String"), MSentryGMPrivilege.___dn$loadClass("java.lang.String"), Long.TYPE, MSentryGMPrivilege.___dn$loadClass("java.lang.Boolean"), MSentryGMPrivilege.___dn$loadClass("java.lang.String"), MSentryGMPrivilege.___dn$loadClass("java.lang.String"), MSentryGMPrivilege.___dn$loadClass("java.lang.String"), MSentryGMPrivilege.___dn$loadClass("java.lang.String"), MSentryGMPrivilege.___dn$loadClass("java.lang.String"), MSentryGMPrivilege.___dn$loadClass("java.lang.String"), MSentryGMPrivilege.___dn$loadClass("java.lang.String"), MSentryGMPrivilege.___dn$loadClass("java.lang.String"), MSentryGMPrivilege.___dn$loadClass("java.util.Set"), MSentryGMPrivilege.___dn$loadClass("java.lang.String"), MSentryGMPrivilege.___dn$loadClass("java.lang.String")};
    }

    private static final byte[] __dnFieldFlagsInit() {
        return new byte[]{21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 10, 21, 21};
    }

    protected static int __dnGetInheritedFieldCount() {
        return 0;
    }

    protected static int dnGetManagedFieldCount() {
        return 15;
    }

    private static Class __dnPersistableSuperclassInit() {
        return null;
    }

    public static Class ___dn$loadClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
    }

    private Object dnSuperClone() throws CloneNotSupportedException {
        MSentryGMPrivilege o = (MSentryGMPrivilege)super.clone();
        o.dnFlags = 0;
        o.dnStateManager = null;
        return o;
    }

    private static String dnGetaction(MSentryGMPrivilege objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 0)) {
            return objPC.dnStateManager.getStringField((Persistable)objPC, 0, objPC.action);
        }
        if (objPC.dnIsDetached() && !((BitSet)objPC.dnDetachedState[2]).get(0)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"action\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.action;
    }

    private static void dnSetaction(MSentryGMPrivilege objPC, String val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setStringField((Persistable)objPC, 0, objPC.action, val);
        } else {
            objPC.action = val;
            if (objPC.dnIsDetached()) {
                ((BitSet)objPC.dnDetachedState[3]).set(0);
            }
        }
    }

    private static String dnGetcomponentName(MSentryGMPrivilege objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 1)) {
            return objPC.dnStateManager.getStringField((Persistable)objPC, 1, objPC.componentName);
        }
        if (objPC.dnIsDetached() && !((BitSet)objPC.dnDetachedState[2]).get(1)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"componentName\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.componentName;
    }

    private static void dnSetcomponentName(MSentryGMPrivilege objPC, String val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setStringField((Persistable)objPC, 1, objPC.componentName, val);
        } else {
            objPC.componentName = val;
            if (objPC.dnIsDetached()) {
                ((BitSet)objPC.dnDetachedState[3]).set(1);
            }
        }
    }

    private static long dnGetcreateTime(MSentryGMPrivilege objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 2)) {
            return objPC.dnStateManager.getLongField((Persistable)objPC, 2, objPC.createTime);
        }
        if (objPC.dnIsDetached() && !((BitSet)objPC.dnDetachedState[2]).get(2)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"createTime\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.createTime;
    }

    private static void dnSetcreateTime(MSentryGMPrivilege objPC, long val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setLongField((Persistable)objPC, 2, objPC.createTime, val);
        } else {
            objPC.createTime = val;
            if (objPC.dnIsDetached()) {
                ((BitSet)objPC.dnDetachedState[3]).set(2);
            }
        }
    }

    private static Boolean dnGetgrantOption(MSentryGMPrivilege objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 3)) {
            return (Boolean)objPC.dnStateManager.getObjectField((Persistable)objPC, 3, (Object)objPC.grantOption);
        }
        if (objPC.dnIsDetached() && !((BitSet)objPC.dnDetachedState[2]).get(3)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"grantOption\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.grantOption;
    }

    private static void dnSetgrantOption(MSentryGMPrivilege objPC, Boolean val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 3, (Object)objPC.grantOption, (Object)val);
        } else {
            objPC.grantOption = val;
            if (objPC.dnIsDetached()) {
                ((BitSet)objPC.dnDetachedState[3]).set(3);
            }
        }
    }

    private static String dnGetresourceName0(MSentryGMPrivilege objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 4)) {
            return objPC.dnStateManager.getStringField((Persistable)objPC, 4, objPC.resourceName0);
        }
        if (objPC.dnIsDetached() && !((BitSet)objPC.dnDetachedState[2]).get(4)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"resourceName0\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.resourceName0;
    }

    private static void dnSetresourceName0(MSentryGMPrivilege objPC, String val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setStringField((Persistable)objPC, 4, objPC.resourceName0, val);
        } else {
            objPC.resourceName0 = val;
            if (objPC.dnIsDetached()) {
                ((BitSet)objPC.dnDetachedState[3]).set(4);
            }
        }
    }

    private static String dnGetresourceName1(MSentryGMPrivilege objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 5)) {
            return objPC.dnStateManager.getStringField((Persistable)objPC, 5, objPC.resourceName1);
        }
        if (objPC.dnIsDetached() && !((BitSet)objPC.dnDetachedState[2]).get(5)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"resourceName1\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.resourceName1;
    }

    private static void dnSetresourceName1(MSentryGMPrivilege objPC, String val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setStringField((Persistable)objPC, 5, objPC.resourceName1, val);
        } else {
            objPC.resourceName1 = val;
            if (objPC.dnIsDetached()) {
                ((BitSet)objPC.dnDetachedState[3]).set(5);
            }
        }
    }

    private static String dnGetresourceName2(MSentryGMPrivilege objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 6)) {
            return objPC.dnStateManager.getStringField((Persistable)objPC, 6, objPC.resourceName2);
        }
        if (objPC.dnIsDetached() && !((BitSet)objPC.dnDetachedState[2]).get(6)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"resourceName2\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.resourceName2;
    }

    private static void dnSetresourceName2(MSentryGMPrivilege objPC, String val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setStringField((Persistable)objPC, 6, objPC.resourceName2, val);
        } else {
            objPC.resourceName2 = val;
            if (objPC.dnIsDetached()) {
                ((BitSet)objPC.dnDetachedState[3]).set(6);
            }
        }
    }

    private static String dnGetresourceName3(MSentryGMPrivilege objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 7)) {
            return objPC.dnStateManager.getStringField((Persistable)objPC, 7, objPC.resourceName3);
        }
        if (objPC.dnIsDetached() && !((BitSet)objPC.dnDetachedState[2]).get(7)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"resourceName3\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.resourceName3;
    }

    private static void dnSetresourceName3(MSentryGMPrivilege objPC, String val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setStringField((Persistable)objPC, 7, objPC.resourceName3, val);
        } else {
            objPC.resourceName3 = val;
            if (objPC.dnIsDetached()) {
                ((BitSet)objPC.dnDetachedState[3]).set(7);
            }
        }
    }

    private static String dnGetresourceType0(MSentryGMPrivilege objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 8)) {
            return objPC.dnStateManager.getStringField((Persistable)objPC, 8, objPC.resourceType0);
        }
        if (objPC.dnIsDetached() && !((BitSet)objPC.dnDetachedState[2]).get(8)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"resourceType0\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.resourceType0;
    }

    private static void dnSetresourceType0(MSentryGMPrivilege objPC, String val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setStringField((Persistable)objPC, 8, objPC.resourceType0, val);
        } else {
            objPC.resourceType0 = val;
            if (objPC.dnIsDetached()) {
                ((BitSet)objPC.dnDetachedState[3]).set(8);
            }
        }
    }

    private static String dnGetresourceType1(MSentryGMPrivilege objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 9)) {
            return objPC.dnStateManager.getStringField((Persistable)objPC, 9, objPC.resourceType1);
        }
        if (objPC.dnIsDetached() && !((BitSet)objPC.dnDetachedState[2]).get(9)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"resourceType1\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.resourceType1;
    }

    private static void dnSetresourceType1(MSentryGMPrivilege objPC, String val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setStringField((Persistable)objPC, 9, objPC.resourceType1, val);
        } else {
            objPC.resourceType1 = val;
            if (objPC.dnIsDetached()) {
                ((BitSet)objPC.dnDetachedState[3]).set(9);
            }
        }
    }

    private static String dnGetresourceType2(MSentryGMPrivilege objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 10)) {
            return objPC.dnStateManager.getStringField((Persistable)objPC, 10, objPC.resourceType2);
        }
        if (objPC.dnIsDetached() && !((BitSet)objPC.dnDetachedState[2]).get(10)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"resourceType2\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.resourceType2;
    }

    private static void dnSetresourceType2(MSentryGMPrivilege objPC, String val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setStringField((Persistable)objPC, 10, objPC.resourceType2, val);
        } else {
            objPC.resourceType2 = val;
            if (objPC.dnIsDetached()) {
                ((BitSet)objPC.dnDetachedState[3]).set(10);
            }
        }
    }

    private static String dnGetresourceType3(MSentryGMPrivilege objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 11)) {
            return objPC.dnStateManager.getStringField((Persistable)objPC, 11, objPC.resourceType3);
        }
        if (objPC.dnIsDetached() && !((BitSet)objPC.dnDetachedState[2]).get(11)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"resourceType3\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.resourceType3;
    }

    private static void dnSetresourceType3(MSentryGMPrivilege objPC, String val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setStringField((Persistable)objPC, 11, objPC.resourceType3, val);
        } else {
            objPC.resourceType3 = val;
            if (objPC.dnIsDetached()) {
                ((BitSet)objPC.dnDetachedState[3]).set(11);
            }
        }
    }

    private static Set dnGetroles(MSentryGMPrivilege objPC) {
        if (objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 12)) {
            return (Set)objPC.dnStateManager.getObjectField((Persistable)objPC, 12, objPC.roles);
        }
        if (objPC.dnIsDetached() && !((BitSet)objPC.dnDetachedState[2]).get(12) && !((BitSet)objPC.dnDetachedState[3]).get(12)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"roles\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.roles;
    }

    private static void dnSetroles(MSentryGMPrivilege objPC, Set val) {
        if (objPC.dnStateManager == null) {
            objPC.roles = val;
        } else {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 12, objPC.roles, (Object)val);
        }
        if (objPC.dnIsDetached()) {
            ((BitSet)objPC.dnDetachedState[3]).set(12);
        }
    }

    private static String dnGetscope(MSentryGMPrivilege objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 13)) {
            return objPC.dnStateManager.getStringField((Persistable)objPC, 13, objPC.scope);
        }
        if (objPC.dnIsDetached() && !((BitSet)objPC.dnDetachedState[2]).get(13)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"scope\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.scope;
    }

    private static void dnSetscope(MSentryGMPrivilege objPC, String val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setStringField((Persistable)objPC, 13, objPC.scope, val);
        } else {
            objPC.scope = val;
            if (objPC.dnIsDetached()) {
                ((BitSet)objPC.dnDetachedState[3]).set(13);
            }
        }
    }

    private static String dnGetserviceName(MSentryGMPrivilege objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 14)) {
            return objPC.dnStateManager.getStringField((Persistable)objPC, 14, objPC.serviceName);
        }
        if (objPC.dnIsDetached() && !((BitSet)objPC.dnDetachedState[2]).get(14)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"serviceName\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.serviceName;
    }

    private static void dnSetserviceName(MSentryGMPrivilege objPC, String val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setStringField((Persistable)objPC, 14, objPC.serviceName, val);
        } else {
            objPC.serviceName = val;
            if (objPC.dnIsDetached()) {
                ((BitSet)objPC.dnDetachedState[3]).set(14);
            }
        }
    }
}

