/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.provider.db.log.util;

import com.google.common.annotations.VisibleForTesting;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import org.apache.sentry.provider.db.generic.service.thrift.TAlterSentryRoleRevokePrivilegeRequest;
import org.apache.sentry.provider.db.generic.service.thrift.TAuthorizable;
import org.apache.sentry.provider.db.generic.service.thrift.TSentryGrantOption;
import org.apache.sentry.provider.db.service.thrift.TAlterSentryRoleGrantPrivilegeRequest;
import org.apache.sentry.provider.db.service.thrift.TSentryPrivilege;
import org.apache.sentry.service.thrift.ServiceConstants;
import org.datanucleus.util.StringUtils;

public final class CommandUtil {
    public static String createCmdForCreateOrDropRole(String roleName, boolean isCreate) {
        if (isCreate) {
            return "CREATE ROLE " + roleName;
        }
        return "DROP ROLE " + roleName;
    }

    public static String createCmdForRoleAddGroup(String roleName, String groups) {
        return CommandUtil.createCmdForRoleGrant(roleName, groups, true, true);
    }

    public static String createCmdForRoleDeleteGroup(String roleName, String groups) {
        return CommandUtil.createCmdForRoleGrant(roleName, groups, false, true);
    }

    private static String createCmdForRoleGrant(String roleName, String principals, boolean isGrant, boolean isGroup) {
        String principalType;
        StringBuilder sb = new StringBuilder();
        if (isGrant) {
            sb.append("GRANT ROLE ");
        } else {
            sb.append("REVOKE ROLE ");
        }
        sb.append(roleName);
        if (isGrant) {
            sb.append(" TO ");
        } else {
            sb.append(" FROM ");
        }
        String string = principalType = isGroup ? "GROUP" : "USER";
        if (!StringUtils.isEmpty((String)principals)) {
            sb.append(principalType).append(" ").append(principals);
        } else {
            sb = new StringBuilder("Missing " + principalType + " information.");
        }
        return sb.toString();
    }

    public static String createCmdForRoleAddUser(String roleName, String users) {
        return CommandUtil.createCmdForRoleGrant(roleName, users, true, false);
    }

    public static String createCmdForRoleDeleteUser(String roleName, String users) {
        return CommandUtil.createCmdForRoleGrant(roleName, users, false, false);
    }

    public static String createCmdForGrantPrivilege(TAlterSentryRoleGrantPrivilegeRequest request) {
        return CommandUtil.createCmdForGrantOrRevokePrivileges(request.getRoleName(), request.getPrivileges(), true);
    }

    public static String createCmdForRevokePrivilege(org.apache.sentry.provider.db.service.thrift.TAlterSentryRoleRevokePrivilegeRequest request) {
        return CommandUtil.createCmdForGrantOrRevokePrivileges(request.getRoleName(), request.getPrivileges(), false);
    }

    private static String createCmdForGrantOrRevokePrivileges(String roleName, Set<TSentryPrivilege> privileges, boolean isGrant) {
        StringBuilder sb = new StringBuilder();
        if (privileges != null) {
            for (TSentryPrivilege privilege : privileges) {
                sb.append(CommandUtil.createCmdForGrantOrRevokePrivilege(roleName, privilege, isGrant));
            }
        }
        return sb.toString();
    }

    private static String createCmdForGrantOrRevokePrivilege(String roleName, TSentryPrivilege privilege, boolean isGrant) {
        StringBuilder sb = new StringBuilder();
        if (isGrant) {
            sb.append("GRANT ");
        } else {
            sb.append("REVOKE ");
        }
        String action = privilege.getAction();
        String privilegeScope = privilege.getPrivilegeScope();
        if ("*".equalsIgnoreCase(action)) {
            sb.append("ALL");
        } else {
            if (action != null) {
                action = action.toUpperCase();
            }
            sb.append(action);
        }
        sb.append(" ON ").append(privilege.getPrivilegeScope()).append(" ");
        if (ServiceConstants.PrivilegeScope.DATABASE.name().equalsIgnoreCase(privilegeScope)) {
            sb.append(privilege.getDbName());
        } else if (ServiceConstants.PrivilegeScope.TABLE.name().equalsIgnoreCase(privilegeScope)) {
            sb.append(privilege.getTableName());
        } else if (ServiceConstants.PrivilegeScope.SERVER.name().equalsIgnoreCase(privilegeScope)) {
            sb.append(privilege.getServerName());
        } else if (ServiceConstants.PrivilegeScope.URI.name().equalsIgnoreCase(privilegeScope)) {
            sb.append(privilege.getURI());
        }
        if (isGrant) {
            sb.append(" TO ROLE ");
        } else {
            sb.append(" FROM ROLE ");
        }
        sb.append(roleName);
        if (privilege.getGrantOption() == org.apache.sentry.provider.db.service.thrift.TSentryGrantOption.TRUE) {
            sb.append(" WITH GRANT OPTION");
        }
        return sb.toString();
    }

    public static String createCmdForGrantGMPrivilege(org.apache.sentry.provider.db.generic.service.thrift.TAlterSentryRoleGrantPrivilegeRequest request) {
        return CommandUtil.createCmdForGrantOrRevokeGMPrivilege(request.getRoleName(), request.getPrivilege(), true);
    }

    public static String createCmdForRevokeGMPrivilege(TAlterSentryRoleRevokePrivilegeRequest request) {
        return CommandUtil.createCmdForGrantOrRevokeGMPrivilege(request.getRoleName(), request.getPrivilege(), false);
    }

    private static String createCmdForGrantOrRevokeGMPrivilege(String roleName, org.apache.sentry.provider.db.generic.service.thrift.TSentryPrivilege privilege, boolean isGrant) {
        StringBuilder sb = new StringBuilder();
        if (isGrant) {
            sb.append("GRANT ");
        } else {
            sb.append("REVOKE ");
        }
        String action = privilege.getAction();
        if ("*".equalsIgnoreCase(action)) {
            sb.append("ALL");
        } else {
            if (action != null) {
                action = action.toUpperCase();
            }
            sb.append(action);
        }
        sb.append(" ON");
        List<TAuthorizable> authorizables = privilege.getAuthorizables();
        if (authorizables != null) {
            for (TAuthorizable authorizable : authorizables) {
                sb.append(" ").append(authorizable.getType()).append(" ").append(authorizable.getName());
            }
        }
        if (isGrant) {
            sb.append(" TO ROLE ");
        } else {
            sb.append(" FROM ROLE ");
        }
        sb.append(roleName);
        if (privilege.getGrantOption() == TSentryGrantOption.TRUE) {
            sb.append(" WITH GRANT OPTION");
        }
        return sb.toString();
    }

    @VisibleForTesting
    public static boolean assertIPInAuditLog(String ipInAuditLog) throws Exception {
        if (ipInAuditLog == null) {
            return false;
        }
        Enumeration<NetworkInterface> netInterfaces = NetworkInterface.getNetworkInterfaces();
        while (netInterfaces.hasMoreElements()) {
            NetworkInterface ni = netInterfaces.nextElement();
            Enumeration<InetAddress> ips = ni.getInetAddresses();
            while (ips.hasMoreElements()) {
                if (ipInAuditLog.indexOf(ips.nextElement().getHostAddress()) == -1) continue;
                return true;
            }
        }
        return false;
    }
}

