/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.provider.db.log.entity;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.sentry.core.common.utils.ThriftUtil;
import org.apache.sentry.provider.db.generic.service.thrift.TAlterSentryRoleAddGroupsRequest;
import org.apache.sentry.provider.db.generic.service.thrift.TAlterSentryRoleAddGroupsResponse;
import org.apache.sentry.provider.db.generic.service.thrift.TAlterSentryRoleDeleteGroupsRequest;
import org.apache.sentry.provider.db.generic.service.thrift.TAlterSentryRoleGrantPrivilegeResponse;
import org.apache.sentry.provider.db.generic.service.thrift.TAlterSentryRoleRevokePrivilegeRequest;
import org.apache.sentry.provider.db.generic.service.thrift.TAuthorizable;
import org.apache.sentry.provider.db.generic.service.thrift.TCreateSentryRoleResponse;
import org.apache.sentry.provider.db.generic.service.thrift.TDropSentryRoleResponse;
import org.apache.sentry.provider.db.log.entity.AuditMetadataLogEntity;
import org.apache.sentry.provider.db.log.entity.DBAuditMetadataLogEntity;
import org.apache.sentry.provider.db.log.entity.GMAuditMetadataLogEntity;
import org.apache.sentry.provider.db.log.entity.JsonLogEntity;
import org.apache.sentry.provider.db.log.util.CommandUtil;
import org.apache.sentry.provider.db.log.util.Constants;
import org.apache.sentry.provider.db.service.thrift.TAlterSentryRoleAddUsersRequest;
import org.apache.sentry.provider.db.service.thrift.TAlterSentryRoleAddUsersResponse;
import org.apache.sentry.provider.db.service.thrift.TAlterSentryRoleDeleteGroupsResponse;
import org.apache.sentry.provider.db.service.thrift.TAlterSentryRoleDeleteUsersRequest;
import org.apache.sentry.provider.db.service.thrift.TAlterSentryRoleDeleteUsersResponse;
import org.apache.sentry.provider.db.service.thrift.TAlterSentryRoleGrantPrivilegeRequest;
import org.apache.sentry.provider.db.service.thrift.TAlterSentryRoleRevokePrivilegeResponse;
import org.apache.sentry.provider.db.service.thrift.TCreateSentryRoleRequest;
import org.apache.sentry.provider.db.service.thrift.TDropSentryRoleRequest;
import org.apache.sentry.provider.db.service.thrift.TSentryGroup;
import org.apache.sentry.provider.db.service.thrift.TSentryPrivilege;
import org.apache.sentry.service.thrift.Status;
import org.apache.sentry.service.thrift.TSentryResponseStatus;

public final class JsonLogEntityFactory {
    private static JsonLogEntityFactory factory = new JsonLogEntityFactory();

    private JsonLogEntityFactory() {
    }

    public static JsonLogEntityFactory getInstance() {
        return factory;
    }

    public JsonLogEntity createJsonLogEntity(TCreateSentryRoleRequest request, org.apache.sentry.provider.db.service.thrift.TCreateSentryRoleResponse response, Configuration conf) {
        DBAuditMetadataLogEntity hamle = this.createCommonHAMLE(conf, response.getStatus(), request.getRequestorUserName(), request.getClass().getName());
        hamle.setOperationText(CommandUtil.createCmdForCreateOrDropRole(request.getRoleName(), true));
        return hamle;
    }

    public JsonLogEntity createJsonLogEntity(TDropSentryRoleRequest request, org.apache.sentry.provider.db.service.thrift.TDropSentryRoleResponse response, Configuration conf) {
        DBAuditMetadataLogEntity hamle = this.createCommonHAMLE(conf, response.getStatus(), request.getRequestorUserName(), request.getClass().getName());
        hamle.setOperationText(CommandUtil.createCmdForCreateOrDropRole(request.getRoleName(), false));
        return hamle;
    }

    public Set<JsonLogEntity> createJsonLogEntitys(TAlterSentryRoleGrantPrivilegeRequest request, org.apache.sentry.provider.db.service.thrift.TAlterSentryRoleGrantPrivilegeResponse response, Configuration conf) {
        ImmutableSet.Builder setBuilder = ImmutableSet.builder();
        if (request.isSetPrivileges()) {
            for (TSentryPrivilege privilege : request.getPrivileges()) {
                JsonLogEntity logEntity = this.createJsonLogEntity(request, privilege, response, conf);
                setBuilder.add((Object)logEntity);
            }
        }
        return setBuilder.build();
    }

    private JsonLogEntity createJsonLogEntity(TAlterSentryRoleGrantPrivilegeRequest request, TSentryPrivilege privilege, org.apache.sentry.provider.db.service.thrift.TAlterSentryRoleGrantPrivilegeResponse response, Configuration conf) {
        DBAuditMetadataLogEntity hamle = this.createCommonHAMLE(conf, response.getStatus(), request.getRequestorUserName(), request.getClass().getName());
        hamle.setOperationText(CommandUtil.createCmdForGrantPrivilege(request));
        hamle.setDatabaseName(privilege.getDbName());
        hamle.setTableName(privilege.getTableName());
        hamle.setResourcePath(privilege.getURI());
        return hamle;
    }

    public Set<JsonLogEntity> createJsonLogEntitys(org.apache.sentry.provider.db.service.thrift.TAlterSentryRoleRevokePrivilegeRequest request, TAlterSentryRoleRevokePrivilegeResponse response, Configuration conf) {
        ImmutableSet.Builder setBuilder = ImmutableSet.builder();
        if (request.isSetPrivileges()) {
            for (TSentryPrivilege privilege : request.getPrivileges()) {
                JsonLogEntity logEntity = this.createJsonLogEntity(request, privilege, response, conf);
                setBuilder.add((Object)logEntity);
            }
        }
        return setBuilder.build();
    }

    private JsonLogEntity createJsonLogEntity(org.apache.sentry.provider.db.service.thrift.TAlterSentryRoleRevokePrivilegeRequest request, TSentryPrivilege privilege, TAlterSentryRoleRevokePrivilegeResponse response, Configuration conf) {
        DBAuditMetadataLogEntity hamle = this.createCommonHAMLE(conf, response.getStatus(), request.getRequestorUserName(), request.getClass().getName());
        hamle.setOperationText(CommandUtil.createCmdForRevokePrivilege(request));
        hamle.setDatabaseName(privilege.getDbName());
        hamle.setTableName(privilege.getTableName());
        hamle.setResourcePath(privilege.getURI());
        return hamle;
    }

    public JsonLogEntity createJsonLogEntity(org.apache.sentry.provider.db.service.thrift.TAlterSentryRoleAddGroupsRequest request, org.apache.sentry.provider.db.service.thrift.TAlterSentryRoleAddGroupsResponse response, Configuration conf) {
        DBAuditMetadataLogEntity hamle = this.createCommonHAMLE(conf, response.getStatus(), request.getRequestorUserName(), request.getClass().getName());
        String groups = this.getGroupsStr(request.getGroupsIterator());
        hamle.setOperationText(CommandUtil.createCmdForRoleAddGroup(request.getRoleName(), groups));
        return hamle;
    }

    public JsonLogEntity createJsonLogEntity(org.apache.sentry.provider.db.service.thrift.TAlterSentryRoleDeleteGroupsRequest request, TAlterSentryRoleDeleteGroupsResponse response, Configuration conf) {
        DBAuditMetadataLogEntity hamle = this.createCommonHAMLE(conf, response.getStatus(), request.getRequestorUserName(), request.getClass().getName());
        String groups = this.getGroupsStr(request.getGroupsIterator());
        hamle.setOperationText(CommandUtil.createCmdForRoleDeleteGroup(request.getRoleName(), groups));
        return hamle;
    }

    private String getGroupsStr(Iterator<TSentryGroup> iter) {
        StringBuilder groups = new StringBuilder("");
        if (iter != null) {
            boolean commaFlg = false;
            while (iter.hasNext()) {
                if (commaFlg) {
                    groups.append(", ");
                } else {
                    commaFlg = true;
                }
                groups.append(iter.next().getGroupName());
            }
        }
        return groups.toString();
    }

    public JsonLogEntity createJsonLogEntity(TAlterSentryRoleAddUsersRequest request, TAlterSentryRoleAddUsersResponse response, Configuration conf) {
        DBAuditMetadataLogEntity amle = this.createCommonHAMLE(conf, response.getStatus(), request.getRequestorUserName(), request.getClass().getName());
        String users = this.getUsersStr(request.getUsersIterator());
        amle.setOperationText(CommandUtil.createCmdForRoleAddUser(request.getRoleName(), users));
        return amle;
    }

    public JsonLogEntity createJsonLogEntity(TAlterSentryRoleDeleteUsersRequest request, TAlterSentryRoleDeleteUsersResponse response, Configuration conf) {
        DBAuditMetadataLogEntity amle = this.createCommonHAMLE(conf, response.getStatus(), request.getRequestorUserName(), request.getClass().getName());
        String users = this.getUsersStr(request.getUsersIterator());
        amle.setOperationText(CommandUtil.createCmdForRoleDeleteUser(request.getRoleName(), users));
        return amle;
    }

    private String getUsersStr(Iterator<String> iter) {
        StringBuilder users = new StringBuilder("");
        if (iter != null) {
            boolean commaFlg = false;
            while (iter.hasNext()) {
                if (commaFlg) {
                    users.append(", ");
                } else {
                    commaFlg = true;
                }
                users.append(iter.next());
            }
        }
        return users.toString();
    }

    public String isAllowed(TSentryResponseStatus status) {
        if (status.equals(Status.OK())) {
            return "true";
        }
        return "false";
    }

    public JsonLogEntity createJsonLogEntity(org.apache.sentry.provider.db.generic.service.thrift.TCreateSentryRoleRequest request, TCreateSentryRoleResponse response, Configuration conf) {
        GMAuditMetadataLogEntity gmamle = this.createCommonGMAMLE(conf, response.getStatus(), request.getRequestorUserName(), request.getClass().getName(), request.getComponent());
        gmamle.setOperationText(CommandUtil.createCmdForCreateOrDropRole(request.getRoleName(), true));
        return gmamle;
    }

    public JsonLogEntity createJsonLogEntity(org.apache.sentry.provider.db.generic.service.thrift.TDropSentryRoleRequest request, TDropSentryRoleResponse response, Configuration conf) {
        GMAuditMetadataLogEntity gmamle = this.createCommonGMAMLE(conf, response.getStatus(), request.getRequestorUserName(), request.getClass().getName(), request.getComponent());
        gmamle.setOperationText(CommandUtil.createCmdForCreateOrDropRole(request.getRoleName(), false));
        return gmamle;
    }

    public JsonLogEntity createJsonLogEntity(org.apache.sentry.provider.db.generic.service.thrift.TAlterSentryRoleGrantPrivilegeRequest request, TAlterSentryRoleGrantPrivilegeResponse response, Configuration conf) {
        GMAuditMetadataLogEntity gmamle = this.createCommonGMAMLE(conf, response.getStatus(), request.getRequestorUserName(), request.getClass().getName(), request.getComponent());
        if (request.getPrivilege() != null) {
            List<TAuthorizable> authorizables = request.getPrivilege().getAuthorizables();
            LinkedHashMap<String, String> privilegesMap = new LinkedHashMap<String, String>();
            if (authorizables != null) {
                for (TAuthorizable authorizable : authorizables) {
                    privilegesMap.put(authorizable.getType(), authorizable.getName());
                }
            }
            gmamle.setPrivilegesMap(privilegesMap);
        }
        gmamle.setOperationText(CommandUtil.createCmdForGrantGMPrivilege(request));
        return gmamle;
    }

    public JsonLogEntity createJsonLogEntity(TAlterSentryRoleRevokePrivilegeRequest request, org.apache.sentry.provider.db.generic.service.thrift.TAlterSentryRoleRevokePrivilegeResponse response, Configuration conf) {
        GMAuditMetadataLogEntity gmamle = this.createCommonGMAMLE(conf, response.getStatus(), request.getRequestorUserName(), request.getClass().getName(), request.getComponent());
        if (request.getPrivilege() != null) {
            List<TAuthorizable> authorizables = request.getPrivilege().getAuthorizables();
            LinkedHashMap<String, String> privilegesMap = new LinkedHashMap<String, String>();
            if (authorizables != null) {
                for (TAuthorizable authorizable : authorizables) {
                    privilegesMap.put(authorizable.getType(), authorizable.getName());
                }
            }
            gmamle.setPrivilegesMap(privilegesMap);
        }
        gmamle.setOperationText(CommandUtil.createCmdForRevokeGMPrivilege(request));
        return gmamle;
    }

    public JsonLogEntity createJsonLogEntity(TAlterSentryRoleAddGroupsRequest request, TAlterSentryRoleAddGroupsResponse response, Configuration conf) {
        GMAuditMetadataLogEntity gmamle = this.createCommonGMAMLE(conf, response.getStatus(), request.getRequestorUserName(), request.getClass().getName(), request.getComponent());
        Joiner joiner = Joiner.on((String)",");
        String groups = joiner.join(request.getGroupsIterator());
        gmamle.setOperationText(CommandUtil.createCmdForRoleAddGroup(request.getRoleName(), groups));
        return gmamle;
    }

    public JsonLogEntity createJsonLogEntity(TAlterSentryRoleDeleteGroupsRequest request, org.apache.sentry.provider.db.generic.service.thrift.TAlterSentryRoleDeleteGroupsResponse response, Configuration conf) {
        GMAuditMetadataLogEntity gmamle = this.createCommonGMAMLE(conf, response.getStatus(), request.getRequestorUserName(), request.getClass().getName(), request.getComponent());
        Joiner joiner = Joiner.on((String)",");
        String groups = joiner.join(request.getGroupsIterator());
        gmamle.setOperationText(CommandUtil.createCmdForRoleDeleteGroup(request.getRoleName(), groups));
        return gmamle;
    }

    private DBAuditMetadataLogEntity createCommonHAMLE(Configuration conf, TSentryResponseStatus responseStatus, String userName, String requestClassName) {
        DBAuditMetadataLogEntity hamle = new DBAuditMetadataLogEntity();
        this.setCommAttrForAMLE(hamle, conf, responseStatus, userName, requestClassName);
        return hamle;
    }

    private GMAuditMetadataLogEntity createCommonGMAMLE(Configuration conf, TSentryResponseStatus responseStatus, String userName, String requestClassName, String component) {
        GMAuditMetadataLogEntity gmamle = new GMAuditMetadataLogEntity();
        this.setCommAttrForAMLE(gmamle, conf, responseStatus, userName, requestClassName);
        gmamle.setComponent(component);
        return gmamle;
    }

    private void setCommAttrForAMLE(AuditMetadataLogEntity amle, Configuration conf, TSentryResponseStatus responseStatus, String userName, String requestClassName) {
        amle.setUserName(userName);
        amle.setServiceName(conf.get("sentry.service.name", "Sentry-Service").trim());
        amle.setImpersonator(ThriftUtil.getImpersonator());
        amle.setIpAddress(ThriftUtil.getIpAddress());
        amle.setOperation(Constants.requestTypeToOperationMap.get(requestClassName));
        amle.setEventTime(Long.toString(System.currentTimeMillis()));
        amle.setAllowed(this.isAllowed(responseStatus));
        amle.setObjectType(Constants.requestTypeToObjectTypeMap.get(requestClassName));
    }
}

