/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.provider.db.log.entity;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.sentry.provider.db.log.entity.AuditMetadataLogEntity;
import org.codehaus.jackson.JsonGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBAuditMetadataLogEntity
extends AuditMetadataLogEntity {
    private static final Logger LOGGER = LoggerFactory.getLogger(DBAuditMetadataLogEntity.class);
    private String databaseName;
    private String tableName;
    private String columnName;
    private String resourcePath;

    public DBAuditMetadataLogEntity() {
    }

    public DBAuditMetadataLogEntity(String serviceName, String userName, String impersonator, String ipAddress, String operation, String eventTime, String operationText, String allowed, String objectType, String component, String databaseName, String tableName, String columnName, String resourcePath) {
        this.setCommonAttr(serviceName, userName, impersonator, ipAddress, operation, eventTime, operationText, allowed, objectType, component);
        this.databaseName = databaseName;
        this.tableName = tableName;
        this.columnName = columnName;
        this.resourcePath = resourcePath;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    public String getResourcePath() {
        return this.resourcePath;
    }

    public void setResourcePath(String resourcePath) {
        this.resourcePath = resourcePath;
    }

    @Override
    public String toJsonFormatLog() throws Exception {
        StringWriter stringWriter = new StringWriter();
        JsonGenerator json = null;
        try {
            json = factory.createJsonGenerator((Writer)stringWriter);
            json.writeStartObject();
            json.writeStringField("serviceName", this.getServiceName());
            json.writeStringField("userName", this.getUserName());
            json.writeStringField("impersonator", this.getImpersonator());
            json.writeStringField("ipAddress", this.getIpAddress());
            json.writeStringField("operation", this.getOperation());
            json.writeStringField("eventTime", this.getEventTime());
            json.writeStringField("operationText", this.getOperationText());
            json.writeStringField("allowed", this.getAllowed());
            json.writeStringField("databaseName", this.databaseName);
            json.writeStringField("tableName", this.tableName);
            json.writeStringField("column", this.columnName);
            json.writeStringField("resourcePath", this.resourcePath);
            json.writeStringField("objectType", this.getObjectType());
            json.writeEndObject();
            json.flush();
        }
        catch (IOException e) {
            String msg = "Error creating audit log in json format: " + e.getMessage();
            LOGGER.error(msg, (Throwable)e);
            throw e;
        }
        finally {
            try {
                if (json != null) {
                    json.close();
                }
            }
            catch (IOException e) {
                String msg = "Error when close json object: " + e.getMessage();
                LOGGER.error(msg, (Throwable)e);
                throw e;
            }
        }
        return stringWriter.toString();
    }
}

