/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.provider.db.generic.tools.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.sentry.core.common.exception.SentryUserException;
import org.apache.sentry.provider.db.generic.service.thrift.SentryGenericServiceClient;
import org.apache.sentry.provider.db.generic.service.thrift.TSentryPrivilege;
import org.apache.sentry.provider.db.generic.service.thrift.TSentryRole;
import org.apache.sentry.provider.db.generic.tools.command.TSentryPrivilegeConverter;
import org.apache.sentry.provider.db.tools.ShellCommand;

public class GenericShellCommand
implements ShellCommand {
    private final SentryGenericServiceClient client;
    private final String component;
    private final TSentryPrivilegeConverter converter;
    private final String serviceName;

    public GenericShellCommand(SentryGenericServiceClient client, String component, String serviceName, TSentryPrivilegeConverter converter) {
        this.client = client;
        this.component = component;
        this.serviceName = serviceName;
        this.converter = converter;
    }

    @Override
    public void createRole(String requestorName, String roleName) throws SentryUserException {
        this.client.createRole(requestorName, roleName, this.component);
    }

    @Override
    public void dropRole(String requestorName, String roleName) throws SentryUserException {
        this.client.dropRole(requestorName, roleName, this.component);
    }

    @Override
    public void grantPrivilegeToRole(String requestorName, String roleName, String privilege) throws SentryUserException {
        TSentryPrivilege sentryPrivilege = this.converter.fromString(privilege);
        this.client.grantPrivilege(requestorName, roleName, this.component, sentryPrivilege);
    }

    @Override
    public void grantRoleToGroups(String requestorName, String roleName, Set<String> groups) throws SentryUserException {
        this.client.grantRoleToGroups(requestorName, roleName, this.component, groups);
    }

    @Override
    public void revokePrivilegeFromRole(String requestorName, String roleName, String privilege) throws SentryUserException {
        TSentryPrivilege sentryPrivilege = this.converter.fromString(privilege);
        this.client.revokePrivilege(requestorName, roleName, this.component, sentryPrivilege);
    }

    @Override
    public void revokeRoleFromGroups(String requestorName, String roleName, Set<String> groups) throws SentryUserException {
        this.client.revokeRoleFromGroups(requestorName, roleName, this.component, groups);
    }

    @Override
    public List<String> listRoles(String requestorName, String group) throws SentryUserException {
        Set<TSentryRole> roles = StringUtils.isEmpty((String)group) ? this.client.listAllRoles(requestorName, this.component) : this.client.listRolesByGroupName(requestorName, group, this.component);
        ArrayList<String> result = new ArrayList<String>();
        if (roles != null) {
            for (TSentryRole role : roles) {
                result.add(role.getRoleName());
            }
        }
        return result;
    }

    @Override
    public List<String> listPrivileges(String requestorName, String roleName) throws SentryUserException {
        Set<TSentryPrivilege> privileges = this.client.listAllPrivilegesByRoleName(requestorName, roleName, this.component, this.serviceName);
        ArrayList<String> result = new ArrayList<String>();
        if (privileges != null) {
            for (TSentryPrivilege privilege : privileges) {
                String privilegeStr = this.converter.toString(privilege);
                result.add(privilegeStr);
            }
        }
        return result;
    }

    @Override
    public List<String> listGroupRoles(String requestorName) throws SentryUserException {
        Set<TSentryRole> roles = this.client.listAllRoles(requestorName, this.component);
        if (roles == null || roles.isEmpty()) {
            return Collections.emptyList();
        }
        HashSet<String> groupNames = new HashSet<String>();
        HashMap<String, HashSet<String>> groupInfo = new HashMap<String, HashSet<String>>();
        for (TSentryRole role : roles) {
            for (String group : role.getGroups()) {
                groupNames.add(group);
                HashSet<String> groupRoles = (HashSet<String>)groupInfo.get(group);
                if (groupRoles != null) {
                    groupRoles.add(role.getRoleName());
                    continue;
                }
                groupRoles = new HashSet<String>();
                groupRoles.add(role.getRoleName());
                groupInfo.put(group, groupRoles);
            }
        }
        ArrayList groups = new ArrayList(groupNames);
        LinkedList<String> result = new LinkedList<String>();
        for (String groupName : groups) {
            result.add(groupName + " = " + StringUtils.join((Collection)((Collection)groupInfo.get(groupName)), (String)", "));
        }
        return result;
    }
}

