/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.provider.db.generic.tools;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.sentry.core.common.ActiveRoleSet;
import org.apache.sentry.core.common.utils.PolicyFiles;
import org.apache.sentry.core.common.utils.Version;
import org.apache.sentry.policy.common.PrivilegeUtils;
import org.apache.sentry.provider.common.ProviderBackendContext;
import org.apache.sentry.provider.db.generic.service.thrift.SentryGenericServiceClient;
import org.apache.sentry.provider.db.generic.service.thrift.SentryGenericServiceClientFactory;
import org.apache.sentry.provider.db.generic.service.thrift.TSentryPrivilege;
import org.apache.sentry.provider.db.generic.service.thrift.TSentryRole;
import org.apache.sentry.provider.db.generic.tools.GenericPrivilegeConverter;
import org.apache.sentry.provider.file.SimpleFileProviderBackend;
import org.apache.shiro.config.Ini;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PermissionsMigrationToolCommon {
    private static final Logger LOGGER = LoggerFactory.getLogger(PermissionsMigrationToolCommon.class);
    public static final String SOLR_SERVICE_NAME = "sentry.service.client.solr.service.name";
    private Version sourceVersion;
    private Optional<String> confPath = Optional.empty();
    private Optional<String> policyFile = Optional.empty();
    private Optional<String> outputFile = Optional.empty();
    private boolean dryRun = false;

    public final Version getSourceVersion() {
        return this.sourceVersion;
    }

    protected abstract String getComponent(Configuration var1);

    protected abstract String getServiceName(Configuration var1);

    protected abstract Collection<String> transformPrivileges(Collection<String> var1);

    protected boolean parseArgs(String[] args) {
        Options options = new Options();
        Option sourceVersionOpt = new Option("s", "source", true, "Source Sentry version");
        sourceVersionOpt.setRequired(true);
        options.addOption(sourceVersionOpt);
        Option sentryConfPathOpt = new Option("c", "sentry_conf", true, "sentry-site.xml file path (only required in case of Sentry service)");
        sentryConfPathOpt.setRequired(false);
        options.addOption(sentryConfPathOpt);
        Option sentryPolicyFileOpt = new Option("p", "policy_file", true, "sentry (source) policy file path (only in case of file based Sentry configuration)");
        sentryPolicyFileOpt.setRequired(false);
        options.addOption(sentryPolicyFileOpt);
        Option sentryOutputFileOpt = new Option("o", "output", true, "sentry (target) policy file path (only in case of file based Sentry configuration)");
        sentryOutputFileOpt.setRequired(false);
        options.addOption(sentryOutputFileOpt);
        Option dryRunOpt = new Option("d", "dry_run", false, "provides the output the migration for inspection without making actual configuration changes");
        dryRunOpt.setRequired(false);
        options.addOption(dryRunOpt);
        Option helpOpt = new Option("h", "help", false, "Shell usage");
        helpOpt.setRequired(false);
        options.addOption(helpOpt);
        Options helpOptions = new Options();
        helpOptions.addOption(helpOpt);
        try {
            GnuParser parser = new GnuParser();
            CommandLine cmd = parser.parse(helpOptions, args, true);
            for (Option opt : cmd.getOptions()) {
                if (!opt.getOpt().equals("h")) continue;
                this.usage(options);
                return false;
            }
            cmd = parser.parse(options, args);
            String sourceVersionStr = null;
            for (Option opt : cmd.getOptions()) {
                if (opt.getOpt().equals("s")) {
                    sourceVersionStr = opt.getValue();
                    continue;
                }
                if (opt.getOpt().equals("c")) {
                    this.confPath = Optional.of(opt.getValue());
                    continue;
                }
                if (opt.getOpt().equals("p")) {
                    this.policyFile = Optional.of(opt.getValue());
                    continue;
                }
                if (opt.getOpt().equals("o")) {
                    this.outputFile = Optional.of(opt.getValue());
                    continue;
                }
                if (!opt.getOpt().equals("d")) continue;
                this.dryRun = true;
            }
            this.sourceVersion = Version.parse(sourceVersionStr);
            if (!this.confPath.isPresent() && !this.policyFile.isPresent()) {
                System.out.println("Please select either file-based Sentry configuration (-p and -o flags) or Sentry service (-c flag) for migration.");
                this.usage(options);
                return false;
            }
            if (this.confPath.isPresent() && (this.policyFile.isPresent() || this.outputFile.isPresent())) {
                System.out.println("In order to migrate service based Sentry configuration, do not specify either -p or -o parameters");
                this.usage(options);
                return false;
            }
            if (!this.confPath.isPresent() && this.policyFile.isPresent() ^ this.outputFile.isPresent()) {
                System.out.println("In order to migrate file based Sentry configuration, please make sure to specify both -p and -o parameters.");
                this.usage(options);
                return false;
            }
        }
        catch (java.text.ParseException | ParseException pe) {
            System.out.println(pe.getMessage());
            this.usage(options);
            return false;
        }
        return true;
    }

    private void usage(Options sentryOptions) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("sentryMigrationTool", sentryOptions);
    }

    public void run() throws Exception {
        if (this.policyFile.isPresent()) {
            this.migratePolicyFile();
        } else {
            this.migrateSentryServiceConfig();
        }
    }

    private void migrateSentryServiceConfig() throws Exception {
        Configuration conf = this.getSentryConf();
        String component = this.getComponent(conf);
        String serviceName = this.getServiceName(conf);
        GenericPrivilegeConverter converter = new GenericPrivilegeConverter(component, serviceName, false);
        try (SentryGenericServiceClient client = SentryGenericServiceClientFactory.create(this.getSentryConf());){
            UserGroupInformation ugi = UserGroupInformation.getLoginUser();
            String requestorName = ugi.getShortUserName();
            for (TSentryRole r : client.listAllRoles(requestorName, component)) {
                for (TSentryPrivilege p : client.listAllPrivilegesByRoleName(requestorName, r.getRoleName(), component, serviceName)) {
                    Set<String> privileges = Collections.singleton(converter.toString(p));
                    Collection<String> migrated = this.transformPrivileges(privileges);
                    if (migrated.isEmpty()) continue;
                    LOGGER.info("{} For role {} migrating privileges from {} to {}", new Object[]{this.getDryRunMessage(), r.getRoleName(), privileges, migrated});
                    if (this.dryRun) continue;
                    ArrayList<TSentryPrivilege> tmp = new ArrayList<TSentryPrivilege>();
                    for (String perm : migrated) {
                        tmp.add(converter.fromString(perm));
                    }
                    for (TSentryPrivilege x : tmp) {
                        client.grantPrivilege(requestorName, r.getRoleName(), component, x);
                    }
                    if (tmp.contains(p)) continue;
                    client.revokePrivilege(requestorName, r.getRoleName(), component, p);
                }
            }
        }
    }

    private void migratePolicyFile() throws Exception {
        Configuration conf = this.getSentryConf();
        Path sourceFile = new Path(this.policyFile.get());
        SimpleFileProviderBackend policyFileBackend = new SimpleFileProviderBackend(conf, sourceFile);
        ProviderBackendContext ctx = new ProviderBackendContext();
        policyFileBackend.initialize(ctx);
        HashSet roles = Sets.newHashSet();
        Table groupRolePrivilegeTable = policyFileBackend.getGroupRolePrivilegeTable();
        Ini output = PolicyFiles.loadFromPath((FileSystem)sourceFile.getFileSystem(conf), (Path)sourceFile);
        Ini.Section rolesSection = output.get((Object)"roles");
        for (String groupName : groupRolePrivilegeTable.rowKeySet()) {
            for (String roleName : policyFileBackend.getRoles(Collections.singleton(groupName), ActiveRoleSet.ALL)) {
                if (roles.contains(roleName)) continue;
                Set privileges = (Set)groupRolePrivilegeTable.get((Object)groupName, (Object)roleName);
                Collection<String> migrated = this.transformPrivileges(privileges);
                if (!migrated.isEmpty()) {
                    LOGGER.info("{} For role {} migrating privileges from {} to {}", new Object[]{this.getDryRunMessage(), roleName, privileges, migrated});
                    if (!this.dryRun) {
                        rolesSection.put(roleName, PrivilegeUtils.fromPrivilegeStrings(migrated));
                    }
                }
                roles.add(roleName);
            }
        }
        if (!this.dryRun) {
            Path targetFile = new Path(this.outputFile.get());
            PolicyFiles.writeToPath((Ini)output, (FileSystem)targetFile.getFileSystem(conf), (Path)targetFile);
            LOGGER.info("Successfully saved migrated Sentry policy file at {}", (Object)this.outputFile.get());
        }
    }

    private String getDryRunMessage() {
        return this.dryRun ? "[Dry Run]" : "";
    }

    private Configuration getSentryConf() {
        Configuration conf = new Configuration();
        if (this.confPath.isPresent()) {
            conf.addResource(new Path(this.confPath.get()));
        }
        return conf;
    }

    @VisibleForTesting
    public boolean executeConfigTool(String[] args) throws Exception {
        boolean result = true;
        if (this.parseArgs(args)) {
            this.run();
        } else {
            result = false;
        }
        return result;
    }
}

