/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.provider.db.generic.service.thrift;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.sentry.core.common.ActiveRoleSet;
import org.apache.sentry.core.common.Authorizable;
import org.apache.sentry.core.common.exception.SentryUserException;
import org.apache.sentry.core.common.transport.SentryConnection;
import org.apache.sentry.core.common.transport.SentryTransportPool;
import org.apache.sentry.core.common.transport.TTransportWrapper;
import org.apache.sentry.provider.db.generic.service.thrift.SentryGenericPolicyService;
import org.apache.sentry.provider.db.generic.service.thrift.SentryGenericServiceClient;
import org.apache.sentry.provider.db.generic.service.thrift.TAlterSentryRoleAddGroupsRequest;
import org.apache.sentry.provider.db.generic.service.thrift.TAlterSentryRoleAddGroupsResponse;
import org.apache.sentry.provider.db.generic.service.thrift.TAlterSentryRoleDeleteGroupsRequest;
import org.apache.sentry.provider.db.generic.service.thrift.TAlterSentryRoleDeleteGroupsResponse;
import org.apache.sentry.provider.db.generic.service.thrift.TAlterSentryRoleGrantPrivilegeRequest;
import org.apache.sentry.provider.db.generic.service.thrift.TAlterSentryRoleGrantPrivilegeResponse;
import org.apache.sentry.provider.db.generic.service.thrift.TAlterSentryRoleRevokePrivilegeRequest;
import org.apache.sentry.provider.db.generic.service.thrift.TAlterSentryRoleRevokePrivilegeResponse;
import org.apache.sentry.provider.db.generic.service.thrift.TAuthorizable;
import org.apache.sentry.provider.db.generic.service.thrift.TCreateSentryRoleRequest;
import org.apache.sentry.provider.db.generic.service.thrift.TCreateSentryRoleResponse;
import org.apache.sentry.provider.db.generic.service.thrift.TDropPrivilegesRequest;
import org.apache.sentry.provider.db.generic.service.thrift.TDropPrivilegesResponse;
import org.apache.sentry.provider.db.generic.service.thrift.TDropSentryRoleRequest;
import org.apache.sentry.provider.db.generic.service.thrift.TDropSentryRoleResponse;
import org.apache.sentry.provider.db.generic.service.thrift.TListSentryPrivilegesByAuthRequest;
import org.apache.sentry.provider.db.generic.service.thrift.TListSentryPrivilegesByAuthResponse;
import org.apache.sentry.provider.db.generic.service.thrift.TListSentryPrivilegesForProviderRequest;
import org.apache.sentry.provider.db.generic.service.thrift.TListSentryPrivilegesForProviderResponse;
import org.apache.sentry.provider.db.generic.service.thrift.TListSentryPrivilegesRequest;
import org.apache.sentry.provider.db.generic.service.thrift.TListSentryPrivilegesResponse;
import org.apache.sentry.provider.db.generic.service.thrift.TListSentryRolesRequest;
import org.apache.sentry.provider.db.generic.service.thrift.TListSentryRolesResponse;
import org.apache.sentry.provider.db.generic.service.thrift.TRenamePrivilegesRequest;
import org.apache.sentry.provider.db.generic.service.thrift.TRenamePrivilegesResponse;
import org.apache.sentry.provider.db.generic.service.thrift.TSentryActiveRoleSet;
import org.apache.sentry.provider.db.generic.service.thrift.TSentryPrivilege;
import org.apache.sentry.provider.db.generic.service.thrift.TSentryPrivilegeMap;
import org.apache.sentry.provider.db.generic.service.thrift.TSentryRole;
import org.apache.sentry.service.thrift.Status;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TMultiplexedProtocol;
import org.apache.thrift.protocol.TProtocol;

public class SentryGenericServiceClientDefaultImpl
implements SentryGenericServiceClient,
SentryConnection {
    private SentryGenericPolicyService.Client client;
    private final SentryTransportPool transportPool;
    private TTransportWrapper transport;
    private static final String THRIFT_EXCEPTION_MESSAGE = "Thrift exception occured ";
    private final long maxMessageSize;

    SentryGenericServiceClientDefaultImpl(Configuration conf, SentryTransportPool transportPool) {
        this.maxMessageSize = conf.getLong("sentry.policy.client.thrift.max.message.size", 0x6400000L);
        this.transportPool = transportPool;
    }

    public void connect() throws Exception {
        if (this.transport != null && this.transport.isOpen()) {
            return;
        }
        this.transport = this.transportPool.getTransport();
        TMultiplexedProtocol protocol = new TMultiplexedProtocol((TProtocol)new TBinaryProtocol(this.transport.getTTransport(), this.maxMessageSize, this.maxMessageSize, true, true), "SentryGenericPolicyService");
        this.client = new SentryGenericPolicyService.Client((TProtocol)protocol);
    }

    @Override
    public void createRole(String requestorUserName, String roleName, String component) throws SentryUserException {
        TCreateSentryRoleRequest request = new TCreateSentryRoleRequest();
        request.setProtocol_version(2);
        request.setRequestorUserName(requestorUserName);
        request.setRoleName(roleName);
        request.setComponent(component);
        try {
            TCreateSentryRoleResponse response = this.client.create_sentry_role(request);
            Status.throwIfNotOk(response.getStatus());
        }
        catch (TException e) {
            throw new SentryUserException(THRIFT_EXCEPTION_MESSAGE, (Throwable)e);
        }
    }

    @Override
    public void createRoleIfNotExist(String requestorUserName, String roleName, String component) throws SentryUserException {
        TCreateSentryRoleRequest request = new TCreateSentryRoleRequest();
        request.setProtocol_version(2);
        request.setRequestorUserName(requestorUserName);
        request.setRoleName(roleName);
        request.setComponent(component);
        try {
            TCreateSentryRoleResponse response = this.client.create_sentry_role(request);
            Status status = Status.fromCode(response.getStatus().getValue());
            if (status == Status.ALREADY_EXISTS) {
                return;
            }
            Status.throwIfNotOk(response.getStatus());
        }
        catch (TException e) {
            throw new SentryUserException(THRIFT_EXCEPTION_MESSAGE, (Throwable)e);
        }
    }

    @Override
    public void dropRole(String requestorUserName, String roleName, String component) throws SentryUserException {
        this.dropRole(requestorUserName, roleName, component, false);
    }

    @Override
    public void dropRoleIfExists(String requestorUserName, String roleName, String component) throws SentryUserException {
        this.dropRole(requestorUserName, roleName, component, true);
    }

    private void dropRole(String requestorUserName, String roleName, String component, boolean ifExists) throws SentryUserException {
        TDropSentryRoleRequest request = new TDropSentryRoleRequest();
        request.setProtocol_version(2);
        request.setRequestorUserName(requestorUserName);
        request.setRoleName(roleName);
        request.setComponent(component);
        try {
            TDropSentryRoleResponse response = this.client.drop_sentry_role(request);
            Status status = Status.fromCode(response.getStatus().getValue());
            if (ifExists && status == Status.NO_SUCH_OBJECT) {
                return;
            }
            Status.throwIfNotOk(response.getStatus());
        }
        catch (TException e) {
            throw new SentryUserException(THRIFT_EXCEPTION_MESSAGE, (Throwable)e);
        }
    }

    @Override
    public void grantRoleToGroups(String requestorUserName, String roleName, String component, Set<String> groups) throws SentryUserException {
        TAlterSentryRoleAddGroupsRequest request = new TAlterSentryRoleAddGroupsRequest();
        request.setProtocol_version(2);
        request.setRequestorUserName(requestorUserName);
        request.setRoleName(roleName);
        request.setGroups(groups);
        request.setComponent(component);
        try {
            TAlterSentryRoleAddGroupsResponse response = this.client.alter_sentry_role_add_groups(request);
            Status.throwIfNotOk(response.getStatus());
        }
        catch (TException e) {
            throw new SentryUserException(THRIFT_EXCEPTION_MESSAGE, (Throwable)e);
        }
    }

    @Override
    public void revokeRoleFromGroups(String requestorUserName, String roleName, String component, Set<String> groups) throws SentryUserException {
        TAlterSentryRoleDeleteGroupsRequest request = new TAlterSentryRoleDeleteGroupsRequest();
        request.setProtocol_version(2);
        request.setRequestorUserName(requestorUserName);
        request.setRoleName(roleName);
        request.setGroups(groups);
        request.setComponent(component);
        try {
            TAlterSentryRoleDeleteGroupsResponse response = this.client.alter_sentry_role_delete_groups(request);
            Status.throwIfNotOk(response.getStatus());
        }
        catch (TException e) {
            throw new SentryUserException(THRIFT_EXCEPTION_MESSAGE, (Throwable)e);
        }
    }

    @Override
    public void grantPrivilege(String requestorUserName, String roleName, String component, TSentryPrivilege privilege) throws SentryUserException {
        TAlterSentryRoleGrantPrivilegeRequest request = new TAlterSentryRoleGrantPrivilegeRequest();
        request.setProtocol_version(2);
        request.setComponent(component);
        request.setRoleName(roleName);
        request.setRequestorUserName(requestorUserName);
        request.setPrivilege(privilege);
        try {
            TAlterSentryRoleGrantPrivilegeResponse response = this.client.alter_sentry_role_grant_privilege(request);
            Status.throwIfNotOk(response.getStatus());
        }
        catch (TException e) {
            throw new SentryUserException(THRIFT_EXCEPTION_MESSAGE, (Throwable)e);
        }
    }

    @Override
    public void revokePrivilege(String requestorUserName, String roleName, String component, TSentryPrivilege privilege) throws SentryUserException {
        TAlterSentryRoleRevokePrivilegeRequest request = new TAlterSentryRoleRevokePrivilegeRequest();
        request.setProtocol_version(2);
        request.setComponent(component);
        request.setRequestorUserName(requestorUserName);
        request.setRoleName(roleName);
        request.setPrivilege(privilege);
        try {
            TAlterSentryRoleRevokePrivilegeResponse response = this.client.alter_sentry_role_revoke_privilege(request);
            Status.throwIfNotOk(response.getStatus());
        }
        catch (TException e) {
            throw new SentryUserException(THRIFT_EXCEPTION_MESSAGE, (Throwable)e);
        }
    }

    @Override
    public void dropPrivilege(String requestorUserName, String component, TSentryPrivilege privilege) throws SentryUserException {
        TDropPrivilegesRequest request = new TDropPrivilegesRequest();
        request.setProtocol_version(2);
        request.setComponent(component);
        request.setRequestorUserName(requestorUserName);
        request.setPrivilege(privilege);
        try {
            TDropPrivilegesResponse response = this.client.drop_sentry_privilege(request);
            Status.throwIfNotOk(response.getStatus());
        }
        catch (TException e) {
            throw new SentryUserException(THRIFT_EXCEPTION_MESSAGE, (Throwable)e);
        }
    }

    @Override
    public void renamePrivilege(String requestorUserName, String component, String serviceName, List<? extends Authorizable> oldAuthorizables, List<? extends Authorizable> newAuthorizables) throws SentryUserException {
        if (oldAuthorizables == null || oldAuthorizables.isEmpty() || newAuthorizables == null || newAuthorizables.isEmpty()) {
            throw new SentryUserException("oldAuthorizables or newAuthorizables can not be null or empty");
        }
        TRenamePrivilegesRequest request = new TRenamePrivilegesRequest();
        request.setProtocol_version(2);
        request.setComponent(component);
        request.setRequestorUserName(requestorUserName);
        request.setServiceName(serviceName);
        ArrayList oldTAuthorizables = Lists.newArrayList();
        ArrayList newTAuthorizables = Lists.newArrayList();
        for (Authorizable authorizable : oldAuthorizables) {
            oldTAuthorizables.add(new TAuthorizable(authorizable.getTypeName(), authorizable.getName()));
            request.setOldAuthorizables(oldTAuthorizables);
        }
        for (Authorizable authorizable : newAuthorizables) {
            newTAuthorizables.add(new TAuthorizable(authorizable.getTypeName(), authorizable.getName()));
            request.setNewAuthorizables(newTAuthorizables);
        }
        try {
            TRenamePrivilegesResponse response = this.client.rename_sentry_privilege(request);
            Status.throwIfNotOk(response.getStatus());
        }
        catch (TException e) {
            throw new SentryUserException(THRIFT_EXCEPTION_MESSAGE, (Throwable)e);
        }
    }

    @Override
    public Set<TSentryRole> listRolesByGroupName(String requestorUserName, String groupName, String component) throws SentryUserException {
        TListSentryRolesRequest request = new TListSentryRolesRequest();
        request.setProtocol_version(2);
        request.setRequestorUserName(requestorUserName);
        request.setGroupName(groupName);
        request.setComponent(component);
        try {
            TListSentryRolesResponse response = this.client.list_sentry_roles_by_group(request);
            Status.throwIfNotOk(response.getStatus());
            return response.getRoles();
        }
        catch (TException e) {
            throw new SentryUserException(THRIFT_EXCEPTION_MESSAGE, (Throwable)e);
        }
    }

    @Override
    public Set<TSentryRole> listUserRoles(String requestorUserName, String component) throws SentryUserException {
        return this.listRolesByGroupName(requestorUserName, "*", component);
    }

    @Override
    public Set<TSentryRole> listAllRoles(String requestorUserName, String component) throws SentryUserException {
        return this.listRolesByGroupName(requestorUserName, null, component);
    }

    @Override
    public Set<TSentryPrivilege> listPrivilegesByRoleName(String requestorUserName, String roleName, String component, String serviceName, List<? extends Authorizable> authorizables) throws SentryUserException {
        TListSentryPrivilegesResponse response;
        TListSentryPrivilegesRequest request = new TListSentryPrivilegesRequest();
        request.setProtocol_version(2);
        request.setComponent(component);
        request.setServiceName(serviceName);
        request.setRequestorUserName(requestorUserName);
        request.setRoleName(roleName);
        if (authorizables != null && !authorizables.isEmpty()) {
            ArrayList tAuthorizables = Lists.newArrayList();
            for (Authorizable authorizable : authorizables) {
                tAuthorizables.add(new TAuthorizable(authorizable.getTypeName(), authorizable.getName()));
            }
            request.setAuthorizables(tAuthorizables);
        }
        try {
            response = this.client.list_sentry_privileges_by_role(request);
            Status.throwIfNotOk(response.getStatus());
        }
        catch (TException e) {
            throw new SentryUserException(THRIFT_EXCEPTION_MESSAGE, (Throwable)e);
        }
        return response.getPrivileges();
    }

    @Override
    public Set<TSentryPrivilege> listAllPrivilegesByRoleName(String requestorUserName, String roleName, String component, String serviceName) throws SentryUserException {
        return this.listPrivilegesByRoleName(requestorUserName, roleName, component, serviceName, null);
    }

    @Override
    public Set<String> listPrivilegesForProvider(String component, String serviceName, ActiveRoleSet roleSet, Set<String> groups, List<? extends Authorizable> authorizables) throws SentryUserException {
        TSentryActiveRoleSet thriftRoleSet = new TSentryActiveRoleSet(roleSet.isAll(), roleSet.getRoles());
        TListSentryPrivilegesForProviderRequest request = new TListSentryPrivilegesForProviderRequest();
        request.setProtocol_version(2);
        request.setComponent(component);
        request.setServiceName(serviceName);
        request.setRoleSet(thriftRoleSet);
        if (groups == null) {
            request.setGroups(new HashSet<String>());
        } else {
            request.setGroups(groups);
        }
        ArrayList tAuthoriables = Lists.newArrayList();
        if (authorizables != null && !authorizables.isEmpty()) {
            for (Authorizable authorizable : authorizables) {
                tAuthoriables.add(new TAuthorizable(authorizable.getTypeName(), authorizable.getName()));
            }
            request.setAuthorizables(tAuthoriables);
        }
        try {
            TListSentryPrivilegesForProviderResponse response = this.client.list_sentry_privileges_for_provider(request);
            Status.throwIfNotOk(response.getStatus());
            return response.getPrivileges();
        }
        catch (TException e) {
            throw new SentryUserException(THRIFT_EXCEPTION_MESSAGE, (Throwable)e);
        }
    }

    @Override
    public Map<String, TSentryPrivilegeMap> listPrivilegesbyAuthorizable(String component, String serviceName, String requestorUserName, Set<String> authorizablesSet, Set<String> groups, ActiveRoleSet roleSet) throws SentryUserException {
        TListSentryPrivilegesByAuthRequest request = new TListSentryPrivilegesByAuthRequest();
        request.setProtocol_version(2);
        request.setComponent(component);
        request.setServiceName(serviceName);
        request.setRequestorUserName(requestorUserName);
        request.setAuthorizablesSet(authorizablesSet);
        if (groups == null) {
            request.setGroups(new HashSet<String>());
        } else {
            request.setGroups(groups);
        }
        if (roleSet != null) {
            request.setRoleSet(new TSentryActiveRoleSet(roleSet.isAll(), roleSet.getRoles()));
        }
        try {
            TListSentryPrivilegesByAuthResponse response = this.client.list_sentry_privileges_by_authorizable(request);
            Status.throwIfNotOk(response.getStatus());
            return response.getPrivilegesMapByAuth();
        }
        catch (TException e) {
            throw new SentryUserException(THRIFT_EXCEPTION_MESSAGE, (Throwable)e);
        }
    }

    @Override
    public void close() {
        this.done();
    }

    public void done() {
        if (this.transport != null) {
            this.transportPool.returnTransport(this.transport);
            this.transport = null;
        }
    }

    public void invalidate() {
        if (this.transport != null) {
            this.transportPool.invalidateTransport(this.transport);
            this.transport = null;
        }
    }
}

