/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.provider.db.generic.service.persistent;

import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jdo.PersistenceManager;
import javax.jdo.Query;
import org.apache.hadoop.conf.Configuration;
import org.apache.sentry.core.common.Authorizable;
import org.apache.sentry.core.common.BitFieldAction;
import org.apache.sentry.core.common.BitFieldActionFactory;
import org.apache.sentry.core.common.exception.SentryUserException;
import org.apache.sentry.core.model.kafka.KafkaActionFactory;
import org.apache.sentry.core.model.solr.SolrActionFactory;
import org.apache.sentry.core.model.sqoop.SqoopActionFactory;
import org.apache.sentry.provider.db.generic.service.persistent.PrivilegeObject;
import org.apache.sentry.provider.db.service.model.MSentryGMPrivilege;
import org.apache.sentry.provider.db.service.model.MSentryRole;
import org.apache.sentry.provider.db.service.persistent.QueryParamBuilder;
import org.apache.sentry.provider.db.service.persistent.SentryStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrivilegeOperatePersistence {
    private static final String SERVICE_NAME = "serviceName";
    private static final String COMPONENT_NAME = "componentName";
    private static final String SCOPE = "scope";
    private static final String ACTION = "action";
    private static final Logger LOGGER = LoggerFactory.getLogger(PrivilegeOperatePersistence.class);
    private static final Map<String, BitFieldActionFactory> actionFactories = Maps.newHashMap();
    private final Configuration conf;

    PrivilegeOperatePersistence(Configuration conf) {
        this.conf = conf;
    }

    private static QueryParamBuilder toQueryParam(MSentryGMPrivilege privilege) {
        QueryParamBuilder paramBuilder = QueryParamBuilder.newQueryParamBuilder();
        paramBuilder.add(SERVICE_NAME, SentryStore.toNULLCol(privilege.getServiceName()), true).add(COMPONENT_NAME, SentryStore.toNULLCol(privilege.getComponentName()), true).add(SCOPE, SentryStore.toNULLCol(privilege.getScope()), true).add(ACTION, SentryStore.toNULLCol(privilege.getAction()), true);
        Boolean grantOption = privilege.getGrantOption();
        paramBuilder.addObject("grantOption", grantOption);
        List<? extends Authorizable> authorizables = privilege.getAuthorizables();
        int nAuthorizables = authorizables.size();
        for (int i = 0; i < 4; ++i) {
            String resourceName = "resourceName" + String.valueOf(i);
            String resourceType = "resourceType" + String.valueOf(i);
            if (i >= nAuthorizables) {
                paramBuilder.addNull(resourceName);
                paramBuilder.addNull(resourceType);
                continue;
            }
            paramBuilder.add(resourceName, authorizables.get(i).getName(), true);
            paramBuilder.add(resourceType, authorizables.get(i).getTypeName(), true);
        }
        return paramBuilder;
    }

    private static QueryParamBuilder populateIncludePrivilegesParams(MSentryGMPrivilege privilege) {
        QueryParamBuilder paramBuilder = QueryParamBuilder.newQueryParamBuilder();
        paramBuilder.add(SERVICE_NAME, SentryStore.toNULLCol(privilege.getServiceName()), true);
        paramBuilder.add(COMPONENT_NAME, SentryStore.toNULLCol(privilege.getComponentName()), true);
        List<? extends Authorizable> authorizables = privilege.getAuthorizables();
        int i = 0;
        for (Authorizable authorizable : authorizables) {
            String resourceName = "resourceName" + String.valueOf(i);
            String resourceType = "resourceType" + String.valueOf(i);
            paramBuilder.add(resourceName, authorizable.getName(), true);
            paramBuilder.add(resourceType, authorizable.getTypeName(), true);
            ++i;
        }
        return paramBuilder;
    }

    boolean checkPrivilegeOption(Set<MSentryRole> roles, PrivilegeObject privilege, PersistenceManager pm) {
        MSentryGMPrivilege requestPrivilege = this.convertToPrivilege(privilege);
        if (roles.isEmpty()) {
            return false;
        }
        Query query = pm.newQuery(MSentryGMPrivilege.class);
        QueryParamBuilder paramBuilder = QueryParamBuilder.addRolesFilter(query, null, SentryStore.rolesToRoleNames(roles));
        query.setFilter(paramBuilder.toString());
        List tPrivileges = (List)query.executeWithMap(paramBuilder.getArguments());
        for (MSentryGMPrivilege tPrivilege : tPrivileges) {
            if (!tPrivilege.getGrantOption().booleanValue() || !tPrivilege.implies(requestPrivilege)) continue;
            return true;
        }
        return false;
    }

    public void grantPrivilege(PrivilegeObject privilege, MSentryRole role, PersistenceManager pm) throws SentryUserException {
        MSentryGMPrivilege mPrivilege = this.convertToPrivilege(privilege);
        this.grantRolePartial(mPrivilege, role, pm);
    }

    private void grantRolePartial(MSentryGMPrivilege grantPrivilege, MSentryRole role, PersistenceManager pm) throws SentryUserException {
        BitFieldAction allAction;
        String component = grantPrivilege.getComponentName();
        BitFieldAction action = this.getAction(component, grantPrivilege.getAction());
        if (action.implies(allAction = this.getAction(component, "*"))) {
            List actions = this.getActionFactory(component).getActionsByCode(allAction.getActionCode());
            for (BitFieldAction ac : actions) {
                grantPrivilege.setAction(ac.getValue());
                MSentryGMPrivilege existPriv = this.getPrivilege(grantPrivilege, pm);
                if (existPriv == null || !role.getGmPrivileges().contains(existPriv)) continue;
                pm.retrieve((Object)existPriv);
                existPriv.removeRole(role);
                pm.makePersistent((Object)existPriv);
            }
        } else {
            grantPrivilege.setAction(allAction.getValue());
            MSentryGMPrivilege allPrivilege = this.getPrivilege(grantPrivilege, pm);
            if (allPrivilege != null && role.getGmPrivileges().contains(allPrivilege)) {
                return;
            }
        }
        grantPrivilege.setAction(action.getValue());
        MSentryGMPrivilege mPrivilege = this.getPrivilege(grantPrivilege, pm);
        if (mPrivilege == null) {
            mPrivilege = grantPrivilege;
        }
        mPrivilege.appendRole(role);
        pm.makePersistent((Object)mPrivilege);
    }

    public void revokePrivilege(PrivilegeObject privilege, MSentryRole role, PersistenceManager pm) throws SentryUserException {
        MSentryGMPrivilege mPrivilege = this.getPrivilege(this.convertToPrivilege(privilege), pm);
        mPrivilege = mPrivilege == null ? this.convertToPrivilege(privilege) : (MSentryGMPrivilege)pm.detachCopy((Object)mPrivilege);
        HashSet privilegeGraph = Sets.newHashSet();
        privilegeGraph.addAll(this.populateIncludePrivileges(Sets.newHashSet((Object[])new MSentryRole[]{role}), mPrivilege, pm));
        for (MSentryGMPrivilege persistedPriv : privilegeGraph) {
            this.revokeRolePartial(mPrivilege, persistedPriv, role, pm);
        }
        pm.makePersistent((Object)role);
    }

    private Set<MSentryGMPrivilege> populateIncludePrivileges(Set<MSentryRole> roles, MSentryGMPrivilege parent, PersistenceManager pm) {
        HashSet childrens = Sets.newHashSet();
        Query query = pm.newQuery(MSentryGMPrivilege.class);
        QueryParamBuilder paramBuilder = PrivilegeOperatePersistence.populateIncludePrivilegesParams(parent);
        if (roles != null && !roles.isEmpty()) {
            QueryParamBuilder.addRolesFilter(query, paramBuilder, SentryStore.rolesToRoleNames(roles));
        }
        query.setFilter(paramBuilder.toString());
        List privileges = (List)query.executeWithMap(paramBuilder.getArguments());
        childrens.addAll(privileges);
        return childrens;
    }

    private void revokeRolePartial(MSentryGMPrivilege revokePrivilege, MSentryGMPrivilege persistedPriv, MSentryRole role, PersistenceManager pm) throws SentryUserException {
        String component = revokePrivilege.getComponentName();
        BitFieldAction revokeaction = this.getAction(component, revokePrivilege.getAction());
        BitFieldAction persistedAction = this.getAction(component, persistedPriv.getAction());
        BitFieldAction allAction = this.getAction(component, "*");
        if (revokeaction.implies(allAction)) {
            persistedPriv.removeRole(role);
            pm.makePersistent((Object)persistedPriv);
        } else if (persistedAction.implies(allAction)) {
            persistedPriv.removeRole(role);
            pm.makePersistent((Object)persistedPriv);
            List actions = this.getActionFactory(component).getActionsByCode(allAction.getActionCode());
            for (BitFieldAction ac : actions) {
                if (ac.getActionCode() == revokeaction.getActionCode()) continue;
                MSentryGMPrivilege tmpPriv = new MSentryGMPrivilege(persistedPriv);
                tmpPriv.setAction(ac.getValue());
                MSentryGMPrivilege leftPersistedPriv = this.getPrivilege(tmpPriv, pm);
                if (leftPersistedPriv == null) {
                    leftPersistedPriv = tmpPriv;
                    role.appendGMPrivilege(leftPersistedPriv);
                }
                leftPersistedPriv.appendRole(role);
                pm.makePersistent((Object)leftPersistedPriv);
            }
        } else if (revokeaction.implies(persistedAction)) {
            persistedPriv.removeRole(role);
            pm.makePersistent((Object)persistedPriv);
        }
    }

    public void dropPrivilege(PrivilegeObject privilege, PersistenceManager pm) throws SentryUserException {
        MSentryGMPrivilege requestPrivilege = this.convertToPrivilege(privilege);
        if (Strings.isNullOrEmpty((String)privilege.getAction())) {
            requestPrivilege.setAction(this.getAction(privilege.getComponent(), "*").getValue());
        }
        HashSet privilegeGraph = Sets.newHashSet();
        privilegeGraph.addAll(this.populateIncludePrivileges(null, requestPrivilege, pm));
        for (MSentryGMPrivilege mPrivilege : privilegeGraph) {
            pm.retrieve((Object)mPrivilege);
            Set<MSentryRole> roles = mPrivilege.getRoles();
            for (MSentryRole role : roles) {
                this.revokeRolePartial(requestPrivilege, mPrivilege, role, pm);
            }
        }
    }

    private MSentryGMPrivilege convertToPrivilege(PrivilegeObject privilege) {
        return new MSentryGMPrivilege(privilege.getComponent(), privilege.getService(), privilege.getAuthorizables(), privilege.getAction(), privilege.getGrantOption());
    }

    private MSentryGMPrivilege getPrivilege(MSentryGMPrivilege privilege, PersistenceManager pm) {
        Query query = pm.newQuery(MSentryGMPrivilege.class);
        QueryParamBuilder paramBuilder = PrivilegeOperatePersistence.toQueryParam(privilege);
        query.setFilter(paramBuilder.toString());
        query.setUnique(true);
        MSentryGMPrivilege result = (MSentryGMPrivilege)query.executeWithMap(paramBuilder.getArguments());
        return result;
    }

    Set<PrivilegeObject> getPrivilegesByRole(Set<MSentryRole> roles, PersistenceManager pm) {
        if (roles == null || roles.isEmpty()) {
            return Collections.emptySet();
        }
        Query query = pm.newQuery(MSentryGMPrivilege.class);
        QueryParamBuilder paramBuilder = QueryParamBuilder.addRolesFilter(query, null, SentryStore.rolesToRoleNames(roles));
        query.setFilter(paramBuilder.toString());
        List mPrivileges = (List)query.executeWithMap(paramBuilder.getArguments());
        if (mPrivileges.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<PrivilegeObject> privileges = new HashSet<PrivilegeObject>(mPrivileges.size());
        for (MSentryGMPrivilege mPrivilege : mPrivileges) {
            privileges.add(new PrivilegeObject.Builder().setComponent(mPrivilege.getComponentName()).setService(mPrivilege.getServiceName()).setAction(mPrivilege.getAction()).setAuthorizables(mPrivilege.getAuthorizables()).withGrantOption(mPrivilege.getGrantOption()).build());
        }
        return privileges;
    }

    Set<PrivilegeObject> getPrivilegesByProvider(String component, String service, Set<MSentryRole> roles, List<? extends Authorizable> authorizables, PersistenceManager pm) {
        HashSet privileges = Sets.newHashSet();
        if (roles == null || roles.isEmpty()) {
            return privileges;
        }
        MSentryGMPrivilege parentPrivilege = new MSentryGMPrivilege(component, service, authorizables, null, null);
        HashSet privilegeGraph = Sets.newHashSet();
        privilegeGraph.addAll(this.populateIncludePrivileges(roles, parentPrivilege, pm));
        for (MSentryGMPrivilege mPrivilege : privilegeGraph) {
            privileges.add(new PrivilegeObject.Builder().setComponent(mPrivilege.getComponentName()).setService(mPrivilege.getServiceName()).setAction(mPrivilege.getAction()).setAuthorizables(mPrivilege.getAuthorizables()).withGrantOption(mPrivilege.getGrantOption()).build());
        }
        return privileges;
    }

    Set<MSentryGMPrivilege> getPrivilegesByAuthorizable(String component, String service, Set<MSentryRole> roles, List<? extends Authorizable> authorizables, PersistenceManager pm) {
        HashSet privilegeGraph = Sets.newHashSet();
        if (roles == null || roles.isEmpty()) {
            return privilegeGraph;
        }
        MSentryGMPrivilege parentPrivilege = new MSentryGMPrivilege(component, service, authorizables, null, null);
        privilegeGraph.addAll(this.populateIncludePrivileges(roles, parentPrivilege, pm));
        return privilegeGraph;
    }

    public void renamePrivilege(String component, String service, List<? extends Authorizable> oldAuthorizables, List<? extends Authorizable> newAuthorizables, String grantorPrincipal, PersistenceManager pm) throws SentryUserException {
        MSentryGMPrivilege oldPrivilege = new MSentryGMPrivilege(component, service, oldAuthorizables, null, null);
        oldPrivilege.setAction(this.getAction(component, "*").getValue());
        HashSet privilegeGraph = Sets.newHashSet();
        privilegeGraph.addAll(this.populateIncludePrivileges(null, oldPrivilege, pm));
        for (MSentryGMPrivilege dropPrivilege : privilegeGraph) {
            ArrayList<? extends Authorizable> authorizables = new ArrayList<Authorizable>(dropPrivilege.getAuthorizables());
            for (int i = 0; i < newAuthorizables.size(); ++i) {
                authorizables.set(i, (Authorizable)newAuthorizables.get(i));
            }
            MSentryGMPrivilege newPrivilge = new MSentryGMPrivilege(component, service, authorizables, dropPrivilege.getAction(), dropPrivilege.getGrantOption());
            pm.retrieve((Object)dropPrivilege);
            Set<MSentryRole> roles = dropPrivilege.getRoles();
            for (MSentryRole role : roles) {
                this.revokeRolePartial(oldPrivilege, dropPrivilege, role, pm);
                this.grantRolePartial(newPrivilge, role, pm);
            }
        }
    }

    private BitFieldAction getAction(String component, String name) throws SentryUserException {
        BitFieldActionFactory actionFactory = this.getActionFactory(component);
        BitFieldAction action = actionFactory.getActionByName(name);
        if (action == null) {
            throw new SentryUserException("Can not get BitFieldAction for name: " + name);
        }
        return action;
    }

    private BitFieldActionFactory getActionFactory(String component) throws SentryUserException {
        String caseInsensitiveComponent = component.toLowerCase();
        if (actionFactories.containsKey(caseInsensitiveComponent)) {
            return actionFactories.get(caseInsensitiveComponent);
        }
        BitFieldActionFactory actionFactory = this.createActionFactory(caseInsensitiveComponent);
        actionFactories.put(caseInsensitiveComponent, actionFactory);
        LOGGER.info("Action factory for component {} is not found in cache. Loaded it from configuration as {}.", (Object)component, (Object)actionFactory.getClass().getName());
        return actionFactory;
    }

    private BitFieldActionFactory createActionFactory(String component) throws SentryUserException {
        BitFieldActionFactory actionFactory;
        Class<?> actionFactoryClass;
        String actionFactoryClassName = this.conf.get(String.format("sentry.%s.action.factory", component));
        if (actionFactoryClassName == null) {
            throw new SentryUserException("ActionFactory not defined for component " + component + ". Please define the parameter sentry." + component + ".action.factory in configuration");
        }
        try {
            actionFactoryClass = Class.forName(actionFactoryClassName);
        }
        catch (ClassNotFoundException e) {
            throw new SentryUserException("ActionFactory class " + actionFactoryClassName + " not found.");
        }
        if (!BitFieldActionFactory.class.isAssignableFrom(actionFactoryClass)) {
            throw new SentryUserException("ActionFactory class " + actionFactoryClassName + " must extend " + BitFieldActionFactory.class.getName());
        }
        try {
            Constructor<?> actionFactoryConstructor = actionFactoryClass.getDeclaredConstructor(new Class[0]);
            actionFactoryConstructor.setAccessible(true);
            actionFactory = (BitFieldActionFactory)actionFactoryClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException e) {
            throw new SentryUserException("Could not instantiate actionFactory " + actionFactoryClassName + " for component: " + component, (Throwable)e);
        }
        return actionFactory;
    }

    static {
        actionFactories.put("solr", (BitFieldActionFactory)new SolrActionFactory());
        actionFactories.put("sqoop", (BitFieldActionFactory)new SqoopActionFactory());
        actionFactories.put("kafka", (BitFieldActionFactory)KafkaActionFactory.getInstance());
    }
}

