/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.provider.db.generic.service.persistent;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.jdo.PersistenceManager;
import org.apache.hadoop.conf.Configuration;
import org.apache.sentry.core.common.Authorizable;
import org.apache.sentry.core.common.exception.SentryAccessDeniedException;
import org.apache.sentry.core.common.exception.SentryGrantDeniedException;
import org.apache.sentry.core.common.exception.SentryInvalidInputException;
import org.apache.sentry.core.common.exception.SentryNoSuchObjectException;
import org.apache.sentry.core.common.exception.SentryUserException;
import org.apache.sentry.provider.db.generic.service.persistent.PrivilegeObject;
import org.apache.sentry.provider.db.generic.service.persistent.PrivilegeOperatePersistence;
import org.apache.sentry.provider.db.generic.service.persistent.SentryStoreLayer;
import org.apache.sentry.provider.db.service.model.MSentryGMPrivilege;
import org.apache.sentry.provider.db.service.model.MSentryGroup;
import org.apache.sentry.provider.db.service.model.MSentryRole;
import org.apache.sentry.provider.db.service.persistent.SentryStore;
import org.apache.sentry.provider.db.service.persistent.TransactionBlock;
import org.apache.sentry.provider.db.service.thrift.SentryPolicyStoreProcessor;
import org.apache.sentry.provider.db.service.thrift.TSentryGroup;
import org.apache.sentry.provider.db.service.thrift.TSentryRole;

public class DelegateSentryStore
implements SentryStoreLayer {
    private SentryStore delegate;
    private Configuration conf;
    private Set<String> adminGroups;
    private PrivilegeOperatePersistence privilegeOperator;

    public DelegateSentryStore(Configuration conf) throws Exception {
        this.privilegeOperator = new PrivilegeOperatePersistence(conf);
        this.conf = conf;
        this.delegate = new SentryStore(conf);
        this.adminGroups = ImmutableSet.copyOf(DelegateSentryStore.toTrimmed(Sets.newHashSet((Object[])conf.getStrings("sentry.service.admin.group", new String[0]))));
    }

    private MSentryRole getRole(String roleName, PersistenceManager pm) {
        return this.delegate.getRole(pm, roleName);
    }

    @Override
    public Object createRole(String component, String role, String requestor) throws Exception {
        this.delegate.createSentryRole(role);
        return null;
    }

    @Override
    public Object dropRole(String component, String role, String requestor) throws Exception {
        this.delegate.dropSentryRole(DelegateSentryStore.toTrimmedLower(role));
        return null;
    }

    @Override
    public Set<String> getAllRoleNames() throws Exception {
        return this.delegate.getAllRoleNames();
    }

    @Override
    public Object alterRoleAddGroups(String component, String role, Set<String> groups, String requestor) throws Exception {
        this.delegate.alterSentryRoleAddGroups(requestor, role, this.toTSentryGroups(groups));
        return null;
    }

    @Override
    public Object alterRoleDeleteGroups(String component, String role, Set<String> groups, String requestor) throws Exception {
        this.delegate.alterSentryRoleDeleteGroups(role, this.toTSentryGroups(groups));
        return null;
    }

    @Override
    public Object alterRoleGrantPrivilege(String component, final String role, final PrivilegeObject privilege, final String grantorPrincipal) throws Exception {
        this.delegate.getTransactionManager().executeTransactionWithRetry(new TransactionBlock(){

            public Object execute(PersistenceManager pm) throws Exception {
                pm.setDetachAllOnCommit(false);
                String trimmedRole = DelegateSentryStore.toTrimmedLower(role);
                MSentryRole mRole = DelegateSentryStore.this.getRole(trimmedRole, pm);
                if (mRole == null) {
                    throw new SentryNoSuchObjectException("Role: " + trimmedRole);
                }
                DelegateSentryStore.this.grantOptionCheck(privilege, grantorPrincipal, pm);
                DelegateSentryStore.this.privilegeOperator.grantPrivilege(privilege, mRole, pm);
                return null;
            }
        });
        return null;
    }

    @Override
    public Object alterRoleRevokePrivilege(String component, final String role, final PrivilegeObject privilege, final String grantorPrincipal) throws Exception {
        this.delegate.getTransactionManager().executeTransactionWithRetry(new TransactionBlock(){

            public Object execute(PersistenceManager pm) throws Exception {
                pm.setDetachAllOnCommit(false);
                String trimmedRole = DelegateSentryStore.toTrimmedLower(role);
                MSentryRole mRole = DelegateSentryStore.this.getRole(trimmedRole, pm);
                if (mRole == null) {
                    throw new SentryNoSuchObjectException("Role: " + trimmedRole);
                }
                DelegateSentryStore.this.grantOptionCheck(privilege, grantorPrincipal, pm);
                DelegateSentryStore.this.privilegeOperator.revokePrivilege(privilege, mRole, pm);
                return null;
            }
        });
        return null;
    }

    @Override
    public Object renamePrivilege(final String component, final String service, final List<? extends Authorizable> oldAuthorizables, final List<? extends Authorizable> newAuthorizables, final String requestor) throws Exception {
        Preconditions.checkNotNull((Object)component);
        Preconditions.checkNotNull((Object)service);
        Preconditions.checkNotNull(oldAuthorizables);
        Preconditions.checkNotNull(newAuthorizables);
        if (oldAuthorizables.size() != newAuthorizables.size()) {
            throw new SentryAccessDeniedException("rename privilege denied: the size of oldAuthorizables must equals the newAuthorizables oldAuthorizables:" + Arrays.toString(oldAuthorizables.toArray()) + " newAuthorizables:" + Arrays.toString(newAuthorizables.toArray()));
        }
        this.delegate.getTransactionManager().executeTransactionWithRetry(new TransactionBlock(){

            public Object execute(PersistenceManager pm) throws Exception {
                pm.setDetachAllOnCommit(false);
                DelegateSentryStore.this.privilegeOperator.renamePrivilege(DelegateSentryStore.toTrimmedLower(component), DelegateSentryStore.toTrimmedLower(service), oldAuthorizables, newAuthorizables, requestor, pm);
                return null;
            }
        });
        return null;
    }

    @Override
    public Object dropPrivilege(String component, final PrivilegeObject privilege, String requestor) throws Exception {
        Preconditions.checkNotNull((Object)requestor);
        this.delegate.getTransactionManager().executeTransactionWithRetry(new TransactionBlock(){

            public Object execute(PersistenceManager pm) throws Exception {
                pm.setDetachAllOnCommit(false);
                DelegateSentryStore.this.privilegeOperator.dropPrivilege(privilege, pm);
                return null;
            }
        });
        return null;
    }

    private void grantOptionCheck(PrivilegeObject requestPrivilege, String grantorPrincipal, PersistenceManager pm) throws SentryUserException {
        if (Strings.isNullOrEmpty((String)grantorPrincipal)) {
            throw new SentryInvalidInputException("grantorPrincipal should not be null or empty");
        }
        Set<String> groups = this.getRequestorGroups(grantorPrincipal);
        if (groups == null || groups.isEmpty()) {
            throw new SentryGrantDeniedException(grantorPrincipal + " has no grant!");
        }
        if (!Sets.intersection(this.adminGroups, DelegateSentryStore.toTrimmed(groups)).isEmpty()) {
            return;
        }
        Set<MSentryRole> mRoles = this.delegate.getRolesForGroups(pm, groups);
        if (!this.privilegeOperator.checkPrivilegeOption(mRoles, requestPrivilege, pm)) {
            throw new SentryGrantDeniedException(grantorPrincipal + " has no grant!");
        }
    }

    @Override
    public Set<String> getRolesByGroups(String component, Set<String> groups) throws Exception {
        if (groups == null || groups.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet roles = Sets.newHashSet();
        for (TSentryRole tSentryRole : this.delegate.getTSentryRolesByGroupName(groups, true)) {
            roles.add(tSentryRole.getRoleName());
        }
        return roles;
    }

    @Override
    public Set<String> getGroupsByRoles(String component, Set<String> roles) throws Exception {
        if (roles.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<String> groupNames = new HashSet<String>();
        for (String role : roles) {
            MSentryRole sentryRole = null;
            try {
                sentryRole = this.delegate.getMSentryRoleByName(role);
            }
            catch (SentryNoSuchObjectException e) {
                continue;
            }
            for (MSentryGroup group : sentryRole.getGroups()) {
                groupNames.add(group.getGroupName());
            }
        }
        return groupNames;
    }

    @Override
    public Set<PrivilegeObject> getPrivilegesByRole(String component, final Set<String> roles) throws Exception {
        Preconditions.checkNotNull(roles);
        if (roles.isEmpty()) {
            return Collections.emptySet();
        }
        return this.delegate.getTransactionManager().executeTransaction(new TransactionBlock<Set<PrivilegeObject>>(){

            @Override
            public Set<PrivilegeObject> execute(PersistenceManager pm) throws Exception {
                pm.setDetachAllOnCommit(false);
                HashSet<PrivilegeObject> privileges = new HashSet<PrivilegeObject>();
                HashSet<MSentryRole> mRoles = new HashSet<MSentryRole>();
                for (String role : roles) {
                    MSentryRole mRole = DelegateSentryStore.this.getRole(DelegateSentryStore.toTrimmedLower(role), pm);
                    if (mRole == null) continue;
                    mRoles.add(mRole);
                }
                privileges.addAll(DelegateSentryStore.this.privilegeOperator.getPrivilegesByRole(mRoles, pm));
                return privileges;
            }
        });
    }

    @Override
    public Set<PrivilegeObject> getPrivilegesByProvider(final String component, final String service, final Set<String> roles, final Set<String> groups, final List<? extends Authorizable> authorizables) throws Exception {
        Preconditions.checkNotNull((Object)component);
        Preconditions.checkNotNull((Object)service);
        return this.delegate.getTransactionManager().executeTransaction(new TransactionBlock<Set<PrivilegeObject>>(){

            @Override
            public Set<PrivilegeObject> execute(PersistenceManager pm) throws Exception {
                pm.setDetachAllOnCommit(false);
                String trimmedComponent = DelegateSentryStore.toTrimmedLower(component);
                String trimmedService = DelegateSentryStore.toTrimmedLower(service);
                Set<String> trimmedRoles = SentryStore.toTrimedLower(roles);
                if (groups != null) {
                    trimmedRoles.addAll(DelegateSentryStore.this.delegate.getRoleNamesForGroups(groups));
                }
                if (trimmedRoles.isEmpty()) {
                    return Collections.emptySet();
                }
                HashSet<MSentryRole> mRoles = new HashSet<MSentryRole>(trimmedRoles.size());
                for (String role : trimmedRoles) {
                    MSentryRole mRole = DelegateSentryStore.this.getRole(role, pm);
                    if (mRole == null) continue;
                    mRoles.add(mRole);
                }
                HashSet<PrivilegeObject> privileges = new HashSet<PrivilegeObject>();
                privileges.addAll(DelegateSentryStore.this.privilegeOperator.getPrivilegesByProvider(trimmedComponent, trimmedService, mRoles, authorizables, pm));
                return privileges;
            }
        });
    }

    @Override
    public Set<MSentryGMPrivilege> getPrivilegesByAuthorizable(final String component, final String service, final Set<String> validActiveRoles, final List<? extends Authorizable> authorizables) throws Exception {
        if (validActiveRoles == null || validActiveRoles.isEmpty()) {
            return Collections.emptySet();
        }
        Preconditions.checkNotNull((Object)component);
        Preconditions.checkNotNull((Object)service);
        return this.delegate.getTransactionManager().executeTransaction(new TransactionBlock<Set<MSentryGMPrivilege>>(){

            @Override
            public Set<MSentryGMPrivilege> execute(PersistenceManager pm) throws Exception {
                String lComponent = DelegateSentryStore.toTrimmedLower(component);
                String lService = DelegateSentryStore.toTrimmedLower(service);
                HashSet<MSentryRole> mRoles = new HashSet<MSentryRole>(validActiveRoles.size());
                for (String role : validActiveRoles) {
                    MSentryRole mRole = DelegateSentryStore.this.getRole(role, pm);
                    if (mRole == null) continue;
                    mRoles.add(mRole);
                }
                Set<MSentryGMPrivilege> mSentryGMPrivileges = DelegateSentryStore.this.privilegeOperator.getPrivilegesByAuthorizable(lComponent, lService, mRoles, authorizables, pm);
                HashSet<MSentryGMPrivilege> privileges = new HashSet<MSentryGMPrivilege>(mSentryGMPrivileges.size());
                for (MSentryGMPrivilege mSentryGMPrivilege : mSentryGMPrivileges) {
                    pm.retrieve((Object)mSentryGMPrivilege);
                    privileges.add(mSentryGMPrivilege);
                }
                return privileges;
            }
        });
    }

    @Override
    public void close() {
        this.delegate.stop();
    }

    private Set<TSentryGroup> toTSentryGroups(Set<String> groups) {
        if (groups.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<TSentryGroup> tSentryGroups = new HashSet<TSentryGroup>(groups.size());
        for (String group : groups) {
            tSentryGroups.add(new TSentryGroup(group));
        }
        return tSentryGroups;
    }

    private static Set<String> toTrimmed(Set<String> s) {
        if (s.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<String> result = new HashSet<String>(s.size());
        for (String v : s) {
            result.add(v.trim());
        }
        return result;
    }

    private static String toTrimmedLower(String s) {
        if (s == null) {
            return "";
        }
        return s.trim().toLowerCase();
    }

    private Set<String> getRequestorGroups(String userName) throws SentryUserException {
        return SentryPolicyStoreProcessor.getGroupsFromUserName(this.conf, userName);
    }

    @VisibleForTesting
    void clearAllTables() throws Exception {
        this.delegate.getTransactionManager().executeTransaction(new TransactionBlock(){

            public Object execute(PersistenceManager pm) throws Exception {
                pm.newQuery(MSentryRole.class).deletePersistentAll();
                pm.newQuery(MSentryGroup.class).deletePersistentAll();
                pm.newQuery(MSentryGMPrivilege.class).deletePersistentAll();
                return null;
            }
        });
    }
}

