/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.binding.hbaseindexer.conf;

import java.net.URL;
import org.apache.hadoop.conf.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HBaseIndexerAuthzConf
extends Configuration {
    private static final Logger LOG = LoggerFactory.getLogger(HBaseIndexerAuthzConf.class);

    public HBaseIndexerAuthzConf(URL hbaseIndexerAuthzSiteURL) {
        super(true);
        this.addResource(hbaseIndexerAuthzSiteURL, true);
    }

    public String get(String varName) {
        return this.get(varName, AuthzConfVars.getDefault(varName));
    }

    public static enum AuthzConfVars {
        AUTHZ_PROVIDER("sentry.provider", "org.apache.sentry.provider.common.HadoopGroupResourceAuthorizationProvider"),
        AUTHZ_PROVIDER_RESOURCE("sentry.hbaseindexer.provider.resource", ""),
        AUTHZ_PROVIDER_BACKEND("sentry.hbaseindexer.provider.backend", "org.apache.sentry.provider.file.SimpleFileProviderBackend"),
        AUTHZ_POLICY_ENGINE("sentry.hbaseindexer.policy.engine", "org.apache.sentry.policy.engine.common.CommonPolicyEngine"),
        AUTHZ_SERVICE_NAME("sentry.hbaseindexer.service", "KS_INDEXER-1"),
        PRINCIPAL_HOSTNAME("sentry.hbaseindexer.principal.hostname", null);

        private final String varName;
        private final String defaultVal;

        private AuthzConfVars(String varName, String defaultVal) {
            this.varName = varName;
            this.defaultVal = defaultVal;
        }

        public String getVar() {
            return this.varName;
        }

        public String getDefault() {
            return this.defaultVal;
        }

        public static String getDefault(String varName) {
            for (AuthzConfVars oneVar : AuthzConfVars.values()) {
                if (!oneVar.getVar().equalsIgnoreCase(varName)) continue;
                return oneVar.getDefault();
            }
            return null;
        }
    }
}

