/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.flink.transform;

import org.apache.flink.api.java.DataSet;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.table.api.bridge.java.StreamTableEnvironment;
import org.apache.flink.types.Row;
import org.apache.seatunnel.common.config.CheckConfigUtil;
import org.apache.seatunnel.common.config.CheckResult;
import org.apache.seatunnel.flink.FlinkEnvironment;
import org.apache.seatunnel.flink.batch.FlinkBatchTransform;
import org.apache.seatunnel.flink.stream.FlinkStreamTransform;
import org.apache.seatunnel.shade.com.typesafe.config.Config;

public class DataStreamToTable
implements FlinkStreamTransform<Row, Row>,
FlinkBatchTransform<Row, Row> {
    private static final long serialVersionUID = -7861928245025199286L;
    private Config config;

    public DataStream<Row> processStream(FlinkEnvironment env, DataStream<Row> dataStream) {
        StreamTableEnvironment tableEnvironment = env.getStreamTableEnvironment();
        tableEnvironment.registerDataStream(this.config.getString("result_table_name"), dataStream);
        return dataStream;
    }

    public DataSet<Row> processBatch(FlinkEnvironment env, DataSet<Row> data) {
        env.getBatchTableEnvironment().registerDataSet(this.config.getString("result_table_name"), data);
        return data;
    }

    public void setConfig(Config config) {
        this.config = config;
    }

    public Config getConfig() {
        return this.config;
    }

    public CheckResult checkConfig() {
        return CheckConfigUtil.checkAllExists((Config)this.config, (String[])new String[]{"result_table_name"});
    }

    public void prepare(FlinkEnvironment env) {
    }
}

