/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server.task;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import java.io.IOException;
import java.io.Serializable;
import org.apache.seatunnel.engine.server.execution.ProgressState;
import org.apache.seatunnel.engine.server.serializable.TaskDataSerializerHook;

public class Progress
implements IdentifiedDataSerializable,
Serializable {
    private boolean madeProgress = false;
    private boolean isDone = true;

    public void start() {
        this.isDone = false;
        this.madeProgress = false;
    }

    public void makeProgress() {
        this.isDone = false;
        this.madeProgress = true;
    }

    public void done() {
        this.isDone = true;
    }

    public ProgressState toState() {
        return ProgressState.valueOf(this.madeProgress, this.isDone);
    }

    public int getFactoryId() {
        return TaskDataSerializerHook.FACTORY_ID;
    }

    public int getClassId() {
        return 10;
    }

    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeBoolean(this.isDone);
        out.writeBoolean(this.madeProgress);
    }

    public void readData(ObjectDataInput in) throws IOException {
        this.isDone = in.readBoolean();
        this.madeProgress = in.readBoolean();
    }
}

